/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.views;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RadioGroup;
import androidx.core.os.BundleCompat;
import androidx.core.os.BundleKt;
import androidx.core.widget.CompoundButtonCompat;
import com.google.android.material.checkbox.MaterialCheckBox;
import com.google.android.material.radiobutton.MaterialRadioButton;
import com.stripe.android.stripe3ds2.R;
import com.stripe.android.stripe3ds2.databinding.StripeChallengeZoneMultiSelectViewBinding;
import com.stripe.android.stripe3ds2.databinding.StripeChallengeZoneSingleSelectViewBinding;
import com.stripe.android.stripe3ds2.init.ui.ButtonCustomization;
import com.stripe.android.stripe3ds2.init.ui.LabelCustomization;
import com.stripe.android.stripe3ds2.transactions.ChallengeResponseData;
import com.stripe.android.stripe3ds2.views.FormField;
import com.stripe.android.stripe3ds2.views.ThreeDS2TextView;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 <2\u00020\u00012\u00020\u0002:\u0001<B1\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ'\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020$2\b\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b.J \u0010/\u001a\u0002002\u000e\u00101\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010\u001f2\b\u0010+\u001a\u0004\u0018\u00010,J\u001a\u00102\u001a\u0002002\b\u00103\u001a\u0004\u0018\u00010\u001b2\b\u00104\u001a\u0004\u0018\u000105J\u000e\u00106\u001a\u0002002\u0006\u00107\u001a\u00020\bJ\b\u00108\u001a\u000209H\u0014J\u0010\u0010:\u001a\u0002002\u0006\u0010;\u001a\u000209H\u0014R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001b\u0010\u001e\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010 \u0018\u00010\u001f8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u001f8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\"R\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\b0\u001f8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010\"\u00a8\u0006="}, d2={"Lcom/stripe/android/stripe3ds2/views/ChallengeZoneSelectView;", "Landroid/widget/FrameLayout;", "Lcom/stripe/android/stripe3ds2/views/FormField;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "isSingleSelectMode", "", "<init>", "(Landroid/content/Context;Landroid/util/AttributeSet;IZ)V", "()Z", "infoLabel", "Lcom/stripe/android/stripe3ds2/views/ThreeDS2TextView;", "getInfoLabel$3ds2sdk_release", "()Lcom/stripe/android/stripe3ds2/views/ThreeDS2TextView;", "selectGroup", "Landroid/widget/LinearLayout;", "getSelectGroup$3ds2sdk_release", "()Landroid/widget/LinearLayout;", "buttonBottomMargin", "buttonLabelPadding", "buttonOffsetMargin", "buttonMinHeight", "userEntry", "", "getUserEntry", "()Ljava/lang/String;", "checkBoxes", "", "Landroid/widget/CheckBox;", "getCheckBoxes", "()Ljava/util/List;", "selectedOptions", "Lcom/stripe/android/stripe3ds2/transactions/ChallengeResponseData$ChallengeSelectOption;", "getSelectedOptions", "selectedIndexes", "getSelectedIndexes$3ds2sdk_release", "buildButton", "Landroid/widget/CompoundButton;", "option", "buttonCustomization", "Lcom/stripe/android/stripe3ds2/init/ui/ButtonCustomization;", "lastButton", "buildButton$3ds2sdk_release", "setChallengeSelectOptions", "", "options", "setTextEntryLabel", "label", "labelCustomization", "Lcom/stripe/android/stripe3ds2/init/ui/LabelCustomization;", "selectOption", "index", "onSaveInstanceState", "Landroid/os/Parcelable;", "onRestoreInstanceState", "state", "Companion", "3ds2sdk_release"})
@SourceDebugExtension(value={"SMAP\nChallengeZoneSelectView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChallengeZoneSelectView.kt\ncom/stripe/android/stripe3ds2/views/ChallengeZoneSelectView\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,200:1\n1557#2:201\n1628#2,3:202\n1557#2:205\n1628#2,3:206\n1611#2,9:209\n1863#2:218\n1864#2:220\n1620#2:221\n1863#2,2:222\n1863#2,2:224\n1#3:219\n*S KotlinDebug\n*F\n+ 1 ChallengeZoneSelectView.kt\ncom/stripe/android/stripe3ds2/views/ChallengeZoneSelectView\n*L\n51#1:201\n51#1:202,3\n56#1:205\n56#1:206,3\n63#1:209,9\n63#1:218\n63#1:220\n63#1:221\n158#1:222,2\n189#1:224,2\n63#1:219\n*E\n"})
public final class ChallengeZoneSelectView
extends FrameLayout
implements FormField {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final boolean isSingleSelectMode;
    @NotNull
    private final ThreeDS2TextView infoLabel;
    @NotNull
    private final LinearLayout selectGroup;
    private final int buttonBottomMargin;
    private final int buttonLabelPadding;
    private final int buttonOffsetMargin;
    private final int buttonMinHeight;
    @NotNull
    private static final String STATE_SELECTED_INDEXED = "state_selected_indexes";
    @NotNull
    private static final String STATE_SUPER = "state_super";

    @JvmOverloads
    public ChallengeZoneSelectView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, boolean isSingleSelectMode) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.isSingleSelectMode = isSingleSelectMode;
        if (this.getId() == -1) {
            this.setId(R.id.stripe_3ds2_default_challenge_zone_select_view_id);
        }
        this.buttonBottomMargin = context.getResources().getDimensionPixelSize(R.dimen.stripe_3ds2_challenge_zone_select_button_vertical_margin);
        this.buttonLabelPadding = context.getResources().getDimensionPixelSize(R.dimen.stripe_3ds2_challenge_zone_select_button_label_padding);
        this.buttonOffsetMargin = context.getResources().getDimensionPixelSize(R.dimen.stripe_3ds2_challenge_zone_select_button_offset_margin);
        this.buttonMinHeight = context.getResources().getDimensionPixelSize(R.dimen.stripe_3ds2_challenge_zone_select_button_min_height);
        if (this.isSingleSelectMode) {
            StripeChallengeZoneSingleSelectViewBinding stripeChallengeZoneSingleSelectViewBinding = StripeChallengeZoneSingleSelectViewBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this, true);
            Intrinsics.checkNotNullExpressionValue((Object)stripeChallengeZoneSingleSelectViewBinding, (String)"inflate(...)");
            StripeChallengeZoneSingleSelectViewBinding viewBinding = stripeChallengeZoneSingleSelectViewBinding;
            this.infoLabel = viewBinding.label;
            this.selectGroup = (LinearLayout)viewBinding.selectGroup;
        } else {
            StripeChallengeZoneMultiSelectViewBinding stripeChallengeZoneMultiSelectViewBinding = StripeChallengeZoneMultiSelectViewBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this, true);
            Intrinsics.checkNotNullExpressionValue((Object)stripeChallengeZoneMultiSelectViewBinding, (String)"inflate(...)");
            StripeChallengeZoneMultiSelectViewBinding viewBinding = stripeChallengeZoneMultiSelectViewBinding;
            this.infoLabel = viewBinding.label;
            this.selectGroup = viewBinding.selectGroup;
        }
    }

    public /* synthetic */ ChallengeZoneSelectView(Context context, AttributeSet attributeSet, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            bl = false;
        }
        this(context, attributeSet, n, bl);
    }

    public final boolean isSingleSelectMode() {
        return this.isSingleSelectMode;
    }

    @NotNull
    public final ThreeDS2TextView getInfoLabel$3ds2sdk_release() {
        return this.infoLabel;
    }

    @NotNull
    public final LinearLayout getSelectGroup$3ds2sdk_release() {
        return this.selectGroup;
    }

    @Override
    @NotNull
    public String getUserEntry() {
        return CollectionsKt.joinToString$default((Iterable)this.getSelectedOptions(), (CharSequence)",", null, null, (int)0, null, ChallengeZoneSelectView::_get_userEntry_$lambda$0, (int)30, null);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<CheckBox> getCheckBoxes() {
        void $this$mapTo$iv$iv;
        if (this.isSingleSelectMode) {
            return null;
        }
        int count = this.selectGroup.getChildCount();
        Iterable $this$map$iv = (Iterable)RangesKt.until((int)0, (int)count);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            View view = this.selectGroup.getChildAt((int)it);
            Intrinsics.checkNotNull((Object)view, (String)"null cannot be cast to non-null type android.widget.CheckBox");
            collection.add((CheckBox)view);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ChallengeResponseData.ChallengeSelectOption> getSelectedOptions() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getSelectedIndexes$3ds2sdk_release();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Object object = this.selectGroup.getChildAt((int)it).getTag();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.stripe.android.stripe3ds2.transactions.ChallengeResponseData.ChallengeSelectOption");
            collection.add((ChallengeResponseData.ChallengeSelectOption)object);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Integer> getSelectedIndexes$3ds2sdk_release() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = (Iterable)RangesKt.until((int)0, (int)this.selectGroup.getChildCount());
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Integer it$iv$iv;
            int element$iv$iv$iv;
            int element$iv$iv = element$iv$iv$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            int it = element$iv$iv;
            boolean bl2 = false;
            View view = this.selectGroup.getChildAt(it);
            Intrinsics.checkNotNull((Object)view, (String)"null cannot be cast to non-null type android.widget.CompoundButton");
            if ((((CompoundButton)view).isChecked() ? Integer.valueOf(it) : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List checkedButtons = (List)destination$iv$iv;
        return CollectionsKt.take((Iterable)checkedButtons, (int)(this.isSingleSelectMode ? 1 : checkedButtons.size()));
    }

    @NotNull
    public final CompoundButton buildButton$3ds2sdk_release(@NotNull ChallengeResponseData.ChallengeSelectOption option, @Nullable ButtonCustomization buttonCustomization, boolean lastButton) {
        CompoundButton button;
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        CompoundButton compoundButton = button = this.isSingleSelectMode ? (CompoundButton)new MaterialRadioButton(this.getContext()) : (CompoundButton)new MaterialCheckBox(this.getContext());
        if (buttonCustomization != null) {
            CharSequence charSequence = buttonCustomization.getBackgroundColor();
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                CompoundButtonCompat.setButtonTintList((CompoundButton)button, (ColorStateList)ColorStateList.valueOf((int)Color.parseColor((String)buttonCustomization.getBackgroundColor())));
            }
            if (!((charSequence = (CharSequence)buttonCustomization.getTextColor()) == null || StringsKt.isBlank((CharSequence)charSequence))) {
                button.setTextColor(Color.parseColor((String)buttonCustomization.getTextColor()));
            }
        }
        button.setId(View.generateViewId());
        button.setTag((Object)option);
        button.setText((CharSequence)option.getText());
        button.setPadding(this.buttonLabelPadding, button.getPaddingTop(), button.getPaddingRight(), button.getPaddingBottom());
        button.setMinimumHeight(this.buttonMinHeight);
        RadioGroup.LayoutParams layoutParams = new RadioGroup.LayoutParams(-1, -2);
        if (!lastButton) {
            layoutParams.bottomMargin = this.buttonBottomMargin;
        }
        layoutParams.leftMargin = this.buttonOffsetMargin;
        button.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return button;
    }

    public final void setChallengeSelectOptions(@Nullable List<ChallengeResponseData.ChallengeSelectOption> options, @Nullable ButtonCustomization buttonCustomization) {
        List<ChallengeResponseData.ChallengeSelectOption> list = options;
        if (list == null) {
            return;
        }
        int optionsCount = list.size();
        Iterable $this$forEach$iv = (Iterable)RangesKt.until((int)0, (int)optionsCount);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int it = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            ChallengeResponseData.ChallengeSelectOption option = options.get(it);
            boolean last = it == optionsCount - 1;
            this.selectGroup.addView((View)this.buildButton$3ds2sdk_release(option, buttonCustomization, last));
        }
    }

    public final void setTextEntryLabel(@Nullable String label, @Nullable LabelCustomization labelCustomization) {
        CharSequence charSequence = label;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            this.infoLabel.setVisibility(8);
        } else {
            this.infoLabel.setText(label, labelCustomization);
        }
    }

    public final void selectOption(int index) {
        View view = this.selectGroup.getChildAt(index);
        Intrinsics.checkNotNull((Object)view, (String)"null cannot be cast to non-null type android.widget.CompoundButton");
        CompoundButton button = (CompoundButton)view;
        button.setChecked(true);
    }

    @NotNull
    protected Parcelable onSaveInstanceState() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)STATE_SUPER, (Object)super.onSaveInstanceState()), TuplesKt.to((Object)STATE_SELECTED_INDEXED, new ArrayList(this.getSelectedIndexes$3ds2sdk_release()))};
        return (Parcelable)BundleKt.bundleOf((Pair[])pairArray);
    }

    protected void onRestoreInstanceState(@NotNull Parcelable state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (state instanceof Bundle) {
            ArrayList selectedIndexes;
            super.onRestoreInstanceState((Parcelable)BundleCompat.getParcelable((Bundle)((Bundle)state), (String)STATE_SUPER, Parcelable.class));
            ArrayList arrayList = selectedIndexes = ((Bundle)state).getIntegerArrayList(STATE_SELECTED_INDEXED);
            if (arrayList != null) {
                Iterable $this$forEach$iv = arrayList;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Integer it = (Integer)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    this.selectOption(it);
                }
            }
        } else {
            super.onRestoreInstanceState(state);
        }
    }

    @JvmOverloads
    public ChallengeZoneSelectView(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, defStyleAttr, false, 8, null);
    }

    @JvmOverloads
    public ChallengeZoneSelectView(@NotNull Context context, @Nullable AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, attrs, 0, false, 12, null);
    }

    @JvmOverloads
    public ChallengeZoneSelectView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, null, 0, false, 14, null);
    }

    private static final CharSequence _get_userEntry_$lambda$0(ChallengeResponseData.ChallengeSelectOption it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/stripe3ds2/views/ChallengeZoneSelectView$Companion;", "", "<init>", "()V", "STATE_SELECTED_INDEXED", "", "STATE_SUPER", "3ds2sdk_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

