/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.security;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.RSAEncrypter;
import java.security.interfaces.RSAPublicKey;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0005J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0006\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a8\u0006\f"}, d2={"Lcom/stripe/android/stripe3ds2/security/JweRsaEncrypter;", "", "<init>", "()V", "encrypt", "", "payload", "publicKey", "Ljava/security/interfaces/RSAPublicKey;", "keyId", "createJweObject", "Lcom/nimbusds/jose/JWEObject;", "3ds2sdk_release"})
public final class JweRsaEncrypter {
    @NotNull
    public final String encrypt(@NotNull String payload, @NotNull RSAPublicKey publicKey, @Nullable String keyId) throws JOSEException {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        JWEObject jwe = this.createJweObject(payload, keyId);
        jwe.encrypt((JWEEncrypter)new RSAEncrypter(publicKey));
        String string = jwe.serialize();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"serialize(...)");
        return string;
    }

    @NotNull
    public final JWEObject createJweObject(@NotNull String payload, @Nullable String keyId) {
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        return new JWEObject(new JWEHeader.Builder(JWEAlgorithm.RSA_OAEP_256, EncryptionMethod.A128CBC_HS256).keyID(keyId).build(), new Payload(payload));
    }
}

