/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.utils;

import android.graphics.Bitmap;
import android.util.LruCache;
import androidx.annotation.VisibleForTesting;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b`\u0018\u00002\u00020\u0001:\u0001\nJ\b\u0010\u0002\u001a\u00020\u0003H&J\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u00a6\u0002J\u0019\u0010\b\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0005H\u00a6\u0002\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000b\u00c0\u0006\u0001"}, d2={"Lcom/stripe/android/stripe3ds2/utils/ImageCache;", "", "clear", "", "get", "Landroid/graphics/Bitmap;", "key", "", "set", "bitmap", "Default", "3ds2sdk_release"})
public interface ImageCache {
    public void clear();

    @Nullable
    public Bitmap get(@NotNull String var1);

    public void set(@NotNull String var1, @NotNull Bitmap var2);

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0013\u0010\u0010\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\bH\u0096\u0002J\u0019\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\tH\u0096\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R(\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00078\u0000X\u0081\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\n\u0010\u0002\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/stripe/android/stripe3ds2/utils/ImageCache$Default;", "Lcom/stripe/android/stripe3ds2/utils/ImageCache;", "()V", "KB", "", "MAX_SIZE", "cache", "Landroid/util/LruCache;", "", "Landroid/graphics/Bitmap;", "getCache$3ds2sdk_release$annotations", "getCache$3ds2sdk_release", "()Landroid/util/LruCache;", "cacheSize", "clear", "", "get", "key", "set", "bitmap", "3ds2sdk_release"})
    public static final class Default
    implements ImageCache {
        @NotNull
        public static final Default INSTANCE = new Default();
        private static final int KB = 1024;
        private static final int MAX_SIZE = 10240;
        private static final int cacheSize;
        @NotNull
        private static final LruCache<String, Bitmap> cache;

        private Default() {
        }

        @NotNull
        public final LruCache<String, Bitmap> getCache$3ds2sdk_release() {
            return cache;
        }

        @VisibleForTesting
        public static /* synthetic */ void getCache$3ds2sdk_release$annotations() {
        }

        @Override
        @Nullable
        public Bitmap get(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return (Bitmap)cache.get((Object)key);
        }

        @Override
        public void set(@NotNull String key, @NotNull Bitmap bitmap) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
            cache.put((Object)key, (Object)bitmap);
        }

        @Override
        public void clear() {
            cache.evictAll();
        }

        static {
            int n = cacheSize = Math.min((int)(Runtime.getRuntime().maxMemory() / (long)1024 / (long)8), 10240);
            cache = (LruCache)new LruCache<String, Bitmap>(n){

                protected int sizeOf(@NotNull String key, @NotNull Bitmap bitmap) {
                    Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                    Intrinsics.checkNotNullParameter((Object)bitmap, (String)"bitmap");
                    return bitmap.getByteCount() / 1024;
                }
            };
        }
    }
}

