/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.transaction;

import android.app.Application;
import android.content.Context;
import com.stripe.android.stripe3ds2.init.ui.StripeUiCustomization;
import com.stripe.android.stripe3ds2.observability.DefaultErrorReporter;
import com.stripe.android.stripe3ds2.observability.Stripe3ds2ErrorReporterConfig;
import com.stripe.android.stripe3ds2.security.DefaultMessageTransformer;
import com.stripe.android.stripe3ds2.transaction.DefaultAcsDataParser;
import com.stripe.android.stripe3ds2.transaction.DefaultChallengeRequestResultRepository;
import com.stripe.android.stripe3ds2.transaction.DefaultInitChallengeRepository;
import com.stripe.android.stripe3ds2.transaction.DefaultJwsValidator;
import com.stripe.android.stripe3ds2.transaction.InitChallengeRepository;
import com.stripe.android.stripe3ds2.transaction.Logger;
import com.stripe.android.stripe3ds2.transaction.MessageVersionRegistry;
import com.stripe.android.stripe3ds2.transaction.SdkTransactionId;
import com.stripe.android.stripe3ds2.transaction.StripeErrorRequestExecutor;
import java.security.cert.X509Certificate;
import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u0005\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/stripe3ds2/transaction/InitChallengeRepositoryFactory;", "", "application", "Landroid/app/Application;", "isLiveMode", "", "sdkTransactionId", "Lcom/stripe/android/stripe3ds2/transaction/SdkTransactionId;", "uiCustomization", "Lcom/stripe/android/stripe3ds2/init/ui/StripeUiCustomization;", "rootCerts", "", "Ljava/security/cert/X509Certificate;", "enableLogging", "workContext", "Lkotlin/coroutines/CoroutineContext;", "(Landroid/app/Application;ZLcom/stripe/android/stripe3ds2/transaction/SdkTransactionId;Lcom/stripe/android/stripe3ds2/init/ui/StripeUiCustomization;Ljava/util/List;ZLkotlin/coroutines/CoroutineContext;)V", "create", "Lcom/stripe/android/stripe3ds2/transaction/InitChallengeRepository;", "3ds2sdk_release"})
public final class InitChallengeRepositoryFactory {
    @NotNull
    private final Application application;
    private final boolean isLiveMode;
    @NotNull
    private final SdkTransactionId sdkTransactionId;
    @NotNull
    private final StripeUiCustomization uiCustomization;
    @NotNull
    private final List<X509Certificate> rootCerts;
    private final boolean enableLogging;
    @NotNull
    private final CoroutineContext workContext;

    public InitChallengeRepositoryFactory(@NotNull Application application, boolean isLiveMode, @NotNull SdkTransactionId sdkTransactionId, @NotNull StripeUiCustomization uiCustomization, @NotNull List<? extends X509Certificate> rootCerts, boolean enableLogging, @NotNull CoroutineContext workContext) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        Intrinsics.checkNotNullParameter((Object)sdkTransactionId, (String)"sdkTransactionId");
        Intrinsics.checkNotNullParameter((Object)uiCustomization, (String)"uiCustomization");
        Intrinsics.checkNotNullParameter(rootCerts, (String)"rootCerts");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        this.application = application;
        this.isLiveMode = isLiveMode;
        this.sdkTransactionId = sdkTransactionId;
        this.uiCustomization = uiCustomization;
        this.rootCerts = rootCerts;
        this.enableLogging = enableLogging;
        this.workContext = workContext;
    }

    @NotNull
    public final InitChallengeRepository create() {
        Logger logger = Logger.Companion.get(this.enableLogging);
        DefaultErrorReporter errorReporter2 = new DefaultErrorReporter((Context)this.application, new Stripe3ds2ErrorReporterConfig(this.sdkTransactionId), this.workContext, logger, null, null, null, 0, 240, null);
        return new DefaultInitChallengeRepository(this.sdkTransactionId, new MessageVersionRegistry(), new DefaultJwsValidator(this.isLiveMode, this.rootCerts, errorReporter2), new DefaultMessageTransformer(this.isLiveMode), new DefaultAcsDataParser(errorReporter2), new DefaultChallengeRequestResultRepository(errorReporter2, this.workContext), new StripeErrorRequestExecutor.Factory(this.workContext), this.uiCustomization, errorReporter2, logger);
    }
}

