/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.security;

import com.stripe.android.stripe3ds2.exceptions.SDKRuntimeException;
import com.stripe.android.stripe3ds2.observability.ErrorReporter;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/stripe3ds2/security/EcKeyFactory;", "", "errorReporter", "Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;", "(Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;)V", "keyFactory", "Ljava/security/KeyFactory;", "createPrivate", "Ljava/security/interfaces/ECPrivateKey;", "privateKeyEncoded", "", "createPublic", "Ljava/security/interfaces/ECPublicKey;", "publicKeyEncoded", "3ds2sdk_release"})
public final class EcKeyFactory {
    @NotNull
    private final ErrorReporter errorReporter;
    @NotNull
    private final KeyFactory keyFactory;

    /*
     * WARNING - void declaration
     */
    public EcKeyFactory(@NotNull ErrorReporter errorReporter2) {
        Object $this$keyFactory_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)errorReporter2, (String)"errorReporter");
        this.errorReporter = errorReporter2;
        Object object = this;
        EcKeyFactory ecKeyFactory = this;
        try {
            $this$keyFactory_u24lambda_u240 = object;
            boolean bl = false;
            $this$keyFactory_u24lambda_u240 = Result.constructor-impl((Object)KeyFactory.getInstance("EC"));
        }
        catch (Throwable bl) {
            $this$keyFactory_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        EcKeyFactory ecKeyFactory2 = ecKeyFactory;
        object = $this$keyFactory_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            void it;
            Object bl = $this$keyFactory_u24lambda_u240 = throwable;
            ecKeyFactory = ecKeyFactory2;
            boolean bl2 = false;
            this.errorReporter.reportError((Throwable)it);
            ecKeyFactory2 = ecKeyFactory;
        }
        Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
        if (throwable2 != null) {
            Throwable error = throwable2;
            boolean bl = false;
            throw new SDKRuntimeException(error);
        }
        Object object2 = object;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"getOrElse(...)");
        ecKeyFactory2.keyFactory = (KeyFactory)object2;
    }

    @NotNull
    public final ECPublicKey createPublic(@NotNull byte[] publicKeyEncoded) {
        Object $this$createPublic_u24lambda_u243;
        Intrinsics.checkNotNullParameter((Object)publicKeyEncoded, (String)"publicKeyEncoded");
        Object object = this;
        try {
            $this$createPublic_u24lambda_u243 = object;
            boolean bl = false;
            PublicKey publicKey = ((EcKeyFactory)$this$createPublic_u24lambda_u243).keyFactory.generatePublic(new X509EncodedKeySpec(publicKeyEncoded));
            Intrinsics.checkNotNull((Object)publicKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPublicKey");
            $this$createPublic_u24lambda_u243 = Result.constructor-impl((Object)((ECPublicKey)publicKey));
        }
        catch (Throwable bl) {
            $this$createPublic_u24lambda_u243 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$createPublic_u24lambda_u243;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Object it = $this$createPublic_u24lambda_u243 = throwable;
            boolean bl = false;
            this.errorReporter.reportError((Throwable)it);
        }
        Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
        if (throwable2 != null) {
            Throwable it = throwable2;
            boolean bl = false;
            throw new SDKRuntimeException(it);
        }
        return (ECPublicKey)object;
    }

    @NotNull
    public final ECPrivateKey createPrivate(@NotNull byte[] privateKeyEncoded) {
        Object $this$createPrivate_u24lambda_u246;
        Intrinsics.checkNotNullParameter((Object)privateKeyEncoded, (String)"privateKeyEncoded");
        Object object = this;
        try {
            $this$createPrivate_u24lambda_u246 = object;
            boolean bl = false;
            PrivateKey privateKey = ((EcKeyFactory)$this$createPrivate_u24lambda_u246).keyFactory.generatePrivate(new PKCS8EncodedKeySpec(privateKeyEncoded));
            Intrinsics.checkNotNull((Object)privateKey, (String)"null cannot be cast to non-null type java.security.interfaces.ECPrivateKey");
            $this$createPrivate_u24lambda_u246 = Result.constructor-impl((Object)((ECPrivateKey)privateKey));
        }
        catch (Throwable bl) {
            $this$createPrivate_u24lambda_u246 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$createPrivate_u24lambda_u246;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            throw new SDKRuntimeException(it);
        }
        return (ECPrivateKey)object;
    }
}

