/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.init;

import android.content.Context;
import android.os.Build;
import android.util.DisplayMetrics;
import androidx.core.os.LocaleListCompat;
import com.stripe.android.stripe3ds2.init.DeviceDataFactory;
import com.stripe.android.stripe3ds2.init.DeviceParam;
import com.stripe.android.stripe3ds2.init.HardwareId;
import com.stripe.android.stripe3ds2.utils.Supplier;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000bH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/stripe3ds2/init/DeviceDataFactoryImpl;", "Lcom/stripe/android/stripe3ds2/init/DeviceDataFactory;", "context", "Landroid/content/Context;", "hardwareIdSupplier", "Lcom/stripe/android/stripe3ds2/utils/Supplier;", "Lcom/stripe/android/stripe3ds2/init/HardwareId;", "(Landroid/content/Context;Lcom/stripe/android/stripe3ds2/utils/Supplier;)V", "displayMetrics", "Landroid/util/DisplayMetrics;", "create", "", "", "", "3ds2sdk_release"})
public final class DeviceDataFactoryImpl
implements DeviceDataFactory {
    @NotNull
    private final Supplier<HardwareId> hardwareIdSupplier;
    @NotNull
    private final DisplayMetrics displayMetrics;

    public DeviceDataFactoryImpl(@NotNull Context context, @NotNull Supplier<HardwareId> hardwareIdSupplier) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(hardwareIdSupplier, (String)"hardwareIdSupplier");
        this.hardwareIdSupplier = hardwareIdSupplier;
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        Intrinsics.checkNotNullExpressionValue((Object)displayMetrics, (String)"context.resources.displayMetrics");
        this.displayMetrics = displayMetrics;
    }

    @Override
    @NotNull
    public Map<String, Object> create() {
        String hardwareId = this.hardwareIdSupplier.get().getValue();
        Pair[] pairArray = new Pair[7];
        pairArray[0] = TuplesKt.to((Object)DeviceParam.PARAM_PLATFORM.toString(), (Object)"Android");
        pairArray[1] = TuplesKt.to((Object)DeviceParam.PARAM_DEVICE_MODEL.toString(), (Object)Build.MODEL);
        pairArray[2] = TuplesKt.to((Object)DeviceParam.PARAM_OS_NAME.toString(), (Object)Build.VERSION.CODENAME);
        pairArray[3] = TuplesKt.to((Object)DeviceParam.PARAM_OS_VERSION.toString(), (Object)Build.VERSION.RELEASE);
        Locale[] localeArray = new Locale[]{Locale.getDefault()};
        pairArray[4] = TuplesKt.to((Object)DeviceParam.PARAM_LOCALE.toString(), (Object)LocaleListCompat.create((Locale[])localeArray).toLanguageTags());
        pairArray[5] = TuplesKt.to((Object)DeviceParam.PARAM_TIME_ZONE.toString(), (Object)TimeZone.getDefault().getDisplayName());
        String string = DeviceParam.PARAM_SCREEN_RESOLUTION.toString();
        Locale locale = Locale.ROOT;
        String string2 = "%sx%s";
        Object[] objectArray = new Object[]{this.displayMetrics.heightPixels, this.displayMetrics.widthPixels};
        String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(locale, format, *args)");
        pairArray[6] = TuplesKt.to((Object)string, (Object)string3);
        return MapsKt.plus((Map)MapsKt.mapOf((Pair[])pairArray), (Map)(((CharSequence)hardwareId).length() > 0 ? MapsKt.mapOf((Pair)TuplesKt.to((Object)DeviceParam.PARAM_HARDWARE_ID.toString(), (Object)hardwareId)) : MapsKt.emptyMap()));
    }
}

