/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.transaction;

import androidx.annotation.VisibleForTesting;
import com.nimbusds.jose.JOSEException;
import com.stripe.android.stripe3ds2.observability.ErrorReporter;
import com.stripe.android.stripe3ds2.security.MessageTransformer;
import com.stripe.android.stripe3ds2.transaction.ChallengeRequestExecutor;
import com.stripe.android.stripe3ds2.transaction.ChallengeRequestResult;
import com.stripe.android.stripe3ds2.transaction.HttpResponse;
import com.stripe.android.stripe3ds2.transaction.SdkTransactionId;
import com.stripe.android.stripe3ds2.transactions.ChallengeRequestData;
import com.stripe.android.stripe3ds2.transactions.ChallengeResponseData;
import com.stripe.android.stripe3ds2.transactions.ChallengeResponseParseException;
import com.stripe.android.stripe3ds2.transactions.ErrorData;
import com.stripe.android.stripe3ds2.transactions.ProtocolError;
import java.text.ParseException;
import javax.crypto.SecretKey;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b`\u0018\u00002\u00020\u0001:\u0001\tJ!\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\n"}, d2={"Lcom/stripe/android/stripe3ds2/transaction/ChallengeResponseProcessor;", "", "process", "Lcom/stripe/android/stripe3ds2/transaction/ChallengeRequestResult;", "creqData", "Lcom/stripe/android/stripe3ds2/transactions/ChallengeRequestData;", "response", "Lcom/stripe/android/stripe3ds2/transaction/HttpResponse;", "(Lcom/stripe/android/stripe3ds2/transactions/ChallengeRequestData;Lcom/stripe/android/stripe3ds2/transaction/HttpResponse;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Default", "3ds2sdk_release"})
public interface ChallengeResponseProcessor {
    @Nullable
    public Object process(@NotNull ChallengeRequestData var1, @NotNull HttpResponse var2, @NotNull Continuation<? super ChallengeRequestResult> var3);

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B'\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ(\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0012H\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0018\u0010\u001b\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J!\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010 J\u0018\u0010!\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\"\u001a\u00020\u0015H\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006#"}, d2={"Lcom/stripe/android/stripe3ds2/transaction/ChallengeResponseProcessor$Default;", "Lcom/stripe/android/stripe3ds2/transaction/ChallengeResponseProcessor;", "messageTransformer", "Lcom/stripe/android/stripe3ds2/security/MessageTransformer;", "secretKey", "Ljavax/crypto/SecretKey;", "errorReporter", "Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;", "creqExecutorConfig", "Lcom/stripe/android/stripe3ds2/transaction/ChallengeRequestExecutor$Config;", "(Lcom/stripe/android/stripe3ds2/security/MessageTransformer;Ljavax/crypto/SecretKey;Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;Lcom/stripe/android/stripe3ds2/transaction/ChallengeRequestExecutor$Config;)V", "createErrorData", "Lcom/stripe/android/stripe3ds2/transactions/ErrorData;", "creqData", "Lcom/stripe/android/stripe3ds2/transactions/ChallengeRequestData;", "code", "", "description", "", "detail", "getResponsePayload", "Lorg/json/JSONObject;", "responseBody", "isMessageVersionCorrect", "", "cresData", "Lcom/stripe/android/stripe3ds2/transactions/ChallengeResponseData;", "isValidChallengeResponse", "process", "Lcom/stripe/android/stripe3ds2/transaction/ChallengeRequestResult;", "response", "Lcom/stripe/android/stripe3ds2/transaction/HttpResponse;", "(Lcom/stripe/android/stripe3ds2/transactions/ChallengeRequestData;Lcom/stripe/android/stripe3ds2/transaction/HttpResponse;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "processPayload", "payload", "3ds2sdk_release"})
    public static final class Default
    implements ChallengeResponseProcessor {
        @NotNull
        private final MessageTransformer messageTransformer;
        @NotNull
        private final SecretKey secretKey;
        @NotNull
        private final ErrorReporter errorReporter;
        @NotNull
        private final ChallengeRequestExecutor.Config creqExecutorConfig;

        public Default(@NotNull MessageTransformer messageTransformer, @NotNull SecretKey secretKey, @NotNull ErrorReporter errorReporter2, @NotNull ChallengeRequestExecutor.Config creqExecutorConfig) {
            Intrinsics.checkNotNullParameter((Object)messageTransformer, (String)"messageTransformer");
            Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
            Intrinsics.checkNotNullParameter((Object)errorReporter2, (String)"errorReporter");
            Intrinsics.checkNotNullParameter((Object)creqExecutorConfig, (String)"creqExecutorConfig");
            this.messageTransformer = messageTransformer;
            this.secretKey = secretKey;
            this.errorReporter = errorReporter2;
            this.creqExecutorConfig = creqExecutorConfig;
        }

        @Override
        @Nullable
        public Object process(@NotNull ChallengeRequestData creqData, @NotNull HttpResponse response, @NotNull Continuation<? super ChallengeRequestResult> $completion) {
            ChallengeRequestResult challengeRequestResult;
            if (response.isJsonContentType()) {
                JSONObject payload = new JSONObject(response.getContent());
                challengeRequestResult = ErrorData.Companion.isErrorMessage$3ds2sdk_release(payload) ? (ChallengeRequestResult.Failure)new ChallengeRequestResult.ProtocolError(ErrorData.Companion.fromJson$3ds2sdk_release(payload)) : (ChallengeRequestResult.Failure)new ChallengeRequestResult.RuntimeError(new IllegalArgumentException("Received a JSON response that was not an Error message."));
            } else {
                Throwable it;
                Object object;
                Object object2 = this;
                try {
                    Default $this$process_u24lambda_u2d0 = object2;
                    boolean bl = false;
                    object = Result.constructor-impl((Object)$this$process_u24lambda_u2d0.getResponsePayload(response.getContent()));
                }
                catch (Throwable $this$process_u24lambda_u2d0) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$process_u24lambda_u2d0));
                }
                object2 = object;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                if (throwable != null) {
                    Throwable it2 = throwable;
                    boolean bl = false;
                    this.errorReporter.reportError(new RuntimeException(StringsKt.trimIndent((String)("\n                            Failed to process challenge response.\n\n                            CReq = " + creqData.sanitize$3ds2sdk_release() + "\n                            ")), it2));
                }
                Throwable throwable2 = Result.exceptionOrNull-impl((Object)object2);
                if (throwable2 == null) {
                    it = (JSONObject)object2;
                    boolean bl = false;
                    challengeRequestResult = this.processPayload(creqData, (JSONObject)it);
                } else {
                    it = throwable2;
                    boolean bl = false;
                    ProtocolError protocolError = ProtocolError.DataDecryptionFailure;
                    int n = protocolError.getCode();
                    String string = protocolError.getDescription();
                    String string2 = it.getMessage();
                    if (string2 == null) {
                        string2 = "";
                    }
                    challengeRequestResult = new ChallengeRequestResult.ProtocolError(this.createErrorData(creqData, n, string, string2));
                }
            }
            return challengeRequestResult;
        }

        @VisibleForTesting
        @NotNull
        public final ChallengeRequestResult processPayload(@NotNull ChallengeRequestData creqData, @NotNull JSONObject payload) {
            ChallengeRequestResult challengeRequestResult;
            Intrinsics.checkNotNullParameter((Object)creqData, (String)"creqData");
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            if (ErrorData.Companion.isErrorMessage$3ds2sdk_release(payload)) {
                challengeRequestResult = new ChallengeRequestResult.ProtocolError(ErrorData.Companion.fromJson$3ds2sdk_release(payload));
            } else {
                Object object;
                Object object2 = this;
                try {
                    Default $this$processPayload_u24lambda_u2d4 = object2;
                    boolean bl = false;
                    object = Result.constructor-impl((Object)ChallengeResponseData.Companion.fromJson$3ds2sdk_release(payload));
                }
                catch (Throwable $this$processPayload_u24lambda_u2d4) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$processPayload_u24lambda_u2d4));
                }
                object2 = object;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                if (throwable == null) {
                    ChallengeResponseData cresData = (ChallengeResponseData)object2;
                    boolean bl = false;
                    if (!this.isValidChallengeResponse(creqData, cresData)) {
                        ProtocolError protocolError = ProtocolError.InvalidTransactionId;
                        challengeRequestResult = new ChallengeRequestResult.ProtocolError(this.createErrorData(creqData, protocolError.getCode(), protocolError.getDescription(), "The Transaction ID received was invalid."));
                    } else {
                        challengeRequestResult = !this.isMessageVersionCorrect(creqData, cresData) ? (ChallengeRequestResult)new ChallengeRequestResult.ProtocolError(this.createErrorData(creqData, ProtocolError.UnsupportedMessageVersion.getCode(), ProtocolError.UnsupportedMessageVersion.getDescription(), creqData.getMessageVersion())) : (ChallengeRequestResult)new ChallengeRequestResult.Success(creqData, cresData, this.creqExecutorConfig);
                    }
                } else {
                    Throwable throwable2 = throwable;
                    boolean bl = false;
                    challengeRequestResult = throwable2 instanceof ChallengeResponseParseException ? (ChallengeRequestResult.Failure)new ChallengeRequestResult.ProtocolError(this.createErrorData(creqData, ((ChallengeResponseParseException)throwable2).getCode(), ((ChallengeResponseParseException)throwable2).getDescription(), ((ChallengeResponseParseException)throwable2).getDetail())) : (ChallengeRequestResult.Failure)new ChallengeRequestResult.RuntimeError(throwable2);
                }
            }
            return challengeRequestResult;
        }

        private final boolean isValidChallengeResponse(ChallengeRequestData creqData, ChallengeResponseData cresData) {
            return Intrinsics.areEqual((Object)creqData.getSdkTransId(), (Object)cresData.getSdkTransId()) && Intrinsics.areEqual((Object)creqData.getThreeDsServerTransId(), (Object)cresData.getServerTransId()) && Intrinsics.areEqual((Object)creqData.getAcsTransId(), (Object)cresData.getAcsTransId());
        }

        private final boolean isMessageVersionCorrect(ChallengeRequestData creqData, ChallengeResponseData cresData) {
            return Intrinsics.areEqual((Object)creqData.getMessageVersion(), (Object)cresData.getMessageVersion());
        }

        private final JSONObject getResponsePayload(String responseBody) throws ParseException, JOSEException, JSONException, ChallengeResponseParseException {
            return this.messageTransformer.decrypt(responseBody, this.secretKey);
        }

        private final ErrorData createErrorData(ChallengeRequestData creqData, int code, String description, String detail) {
            String string = String.valueOf(code);
            ErrorData.ErrorComponent errorComponent = ErrorData.ErrorComponent.ThreeDsSdk;
            String string2 = creqData.getAcsTransId();
            SdkTransactionId sdkTransactionId = creqData.getSdkTransId();
            String string3 = creqData.getThreeDsServerTransId();
            String string4 = creqData.getMessageVersion();
            return new ErrorData(string3, string2, null, string, errorComponent, description, detail, "CRes", string4, sdkTransactionId, 4, null);
        }
    }
}

