/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.service;

import android.content.Context;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.stripe3ds2.exceptions.InvalidInputException;
import com.stripe.android.stripe3ds2.exceptions.SDKRuntimeException;
import com.stripe.android.stripe3ds2.init.DefaultAppInfoRepository;
import com.stripe.android.stripe3ds2.init.DefaultSecurityChecker;
import com.stripe.android.stripe3ds2.init.DeviceDataFactory;
import com.stripe.android.stripe3ds2.init.DeviceDataFactoryImpl;
import com.stripe.android.stripe3ds2.init.DeviceParamNotAvailableFactory;
import com.stripe.android.stripe3ds2.init.DeviceParamNotAvailableFactoryImpl;
import com.stripe.android.stripe3ds2.init.HardwareIdSupplier;
import com.stripe.android.stripe3ds2.init.SecurityChecker;
import com.stripe.android.stripe3ds2.init.Warning;
import com.stripe.android.stripe3ds2.init.ui.StripeUiCustomization;
import com.stripe.android.stripe3ds2.observability.DefaultErrorReporter;
import com.stripe.android.stripe3ds2.observability.ErrorReporter;
import com.stripe.android.stripe3ds2.security.EphemeralKeyPairGenerator;
import com.stripe.android.stripe3ds2.security.PublicKeyFactory;
import com.stripe.android.stripe3ds2.security.StripeEphemeralKeyPairGenerator;
import com.stripe.android.stripe3ds2.service.StripeThreeDs2Service;
import com.stripe.android.stripe3ds2.transaction.DefaultAuthenticationRequestParametersFactory;
import com.stripe.android.stripe3ds2.transaction.DefaultTransactionFactory;
import com.stripe.android.stripe3ds2.transaction.Logger;
import com.stripe.android.stripe3ds2.transaction.MessageVersionRegistry;
import com.stripe.android.stripe3ds2.transaction.SdkTransactionId;
import com.stripe.android.stripe3ds2.transaction.Transaction;
import com.stripe.android.stripe3ds2.transaction.TransactionFactory;
import com.stripe.android.stripe3ds2.utils.ImageCache;
import com.stripe.android.stripe3ds2.views.Brand;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 82\u00020\u0001:\u00018B!\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bB/\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000eB/\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0011BO\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u001aB=\b\u0001\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u001b\u001a\u00020\u001c\u0012\u0006\u0010\u001d\u001a\u00020\u001e\u0012\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 \u00a2\u0006\u0002\u0010\"J\b\u0010%\u001a\u00020&H\u0016JZ\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\n2\b\u0010,\u001a\u0004\u0018\u00010\n2\u0006\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\n2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002000 2\u0006\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u00010\n2\u0006\u00104\u001a\u000205H\u0016JR\u0010'\u001a\u00020(2\u0006\u0010+\u001a\u00020\n2\b\u0010,\u001a\u0004\u0018\u00010\n2\u0006\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\n2\f\u0010/\u001a\b\u0012\u0004\u0012\u0002000 2\u0006\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u00010\n2\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u00106\u001a\u0002022\u0006\u00107\u001a\u00020\nH\u0016R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u00069"}, d2={"Lcom/stripe/android/stripe3ds2/service/StripeThreeDs2ServiceImpl;", "Lcom/stripe/android/stripe3ds2/service/StripeThreeDs2Service;", "context", "Landroid/content/Context;", "enableLogging", "", "workContext", "Lkotlin/coroutines/CoroutineContext;", "(Landroid/content/Context;ZLkotlin/coroutines/CoroutineContext;)V", "sdkReferenceNumber", "", "(Landroid/content/Context;Ljava/lang/String;ZLkotlin/coroutines/CoroutineContext;)V", "imageCache", "Lcom/stripe/android/stripe3ds2/utils/ImageCache;", "(Landroid/content/Context;Lcom/stripe/android/stripe3ds2/utils/ImageCache;Ljava/lang/String;ZLkotlin/coroutines/CoroutineContext;)V", "errorReporter", "Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;", "(Landroid/content/Context;Lcom/stripe/android/stripe3ds2/utils/ImageCache;Ljava/lang/String;Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;Lkotlin/coroutines/CoroutineContext;)V", "ephemeralKeyPairGenerator", "Lcom/stripe/android/stripe3ds2/security/EphemeralKeyPairGenerator;", "hardwareIdSupplier", "Lcom/stripe/android/stripe3ds2/init/HardwareIdSupplier;", "securityChecker", "Lcom/stripe/android/stripe3ds2/init/SecurityChecker;", "messageVersionRegistry", "Lcom/stripe/android/stripe3ds2/transaction/MessageVersionRegistry;", "(Landroid/content/Context;Lcom/stripe/android/stripe3ds2/utils/ImageCache;Ljava/lang/String;Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;Lcom/stripe/android/stripe3ds2/security/EphemeralKeyPairGenerator;Lcom/stripe/android/stripe3ds2/init/HardwareIdSupplier;Lcom/stripe/android/stripe3ds2/init/SecurityChecker;Lcom/stripe/android/stripe3ds2/transaction/MessageVersionRegistry;Lkotlin/coroutines/CoroutineContext;)V", "transactionFactory", "Lcom/stripe/android/stripe3ds2/transaction/TransactionFactory;", "publicKeyFactory", "Lcom/stripe/android/stripe3ds2/security/PublicKeyFactory;", "warnings", "", "Lcom/stripe/android/stripe3ds2/init/Warning;", "(Lcom/stripe/android/stripe3ds2/transaction/MessageVersionRegistry;Lcom/stripe/android/stripe3ds2/utils/ImageCache;Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;Lcom/stripe/android/stripe3ds2/transaction/TransactionFactory;Lcom/stripe/android/stripe3ds2/security/PublicKeyFactory;Ljava/util/List;)V", "getWarnings", "()Ljava/util/List;", "cleanup", "", "createTransaction", "Lcom/stripe/android/stripe3ds2/transaction/Transaction;", "sdkTransactionId", "Lcom/stripe/android/stripe3ds2/transaction/SdkTransactionId;", "directoryServerID", "messageVersion", "isLiveMode", "directoryServerName", "rootCerts", "Ljava/security/cert/X509Certificate;", "dsPublicKey", "Ljava/security/PublicKey;", "keyId", "uiCustomization", "Lcom/stripe/android/stripe3ds2/init/ui/StripeUiCustomization;", "getPublicKey", "directoryServerId", "Companion", "3ds2sdk_release"})
public final class StripeThreeDs2ServiceImpl
implements StripeThreeDs2Service {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final MessageVersionRegistry messageVersionRegistry;
    @NotNull
    private final ImageCache imageCache;
    @NotNull
    private final ErrorReporter errorReporter;
    @NotNull
    private final TransactionFactory transactionFactory;
    @NotNull
    private final PublicKeyFactory publicKeyFactory;
    @NotNull
    private final List<Warning> warnings;
    @Deprecated
    @NotNull
    private static final String STRIPE_SDK_REFERENCE_NUMBER = "3DS_LOA_SDK_UTSB_020100_00007";

    @VisibleForTesting
    public StripeThreeDs2ServiceImpl(@NotNull MessageVersionRegistry messageVersionRegistry, @NotNull ImageCache imageCache, @NotNull ErrorReporter errorReporter2, @NotNull TransactionFactory transactionFactory, @NotNull PublicKeyFactory publicKeyFactory, @NotNull List<Warning> warnings) {
        Intrinsics.checkNotNullParameter((Object)messageVersionRegistry, (String)"messageVersionRegistry");
        Intrinsics.checkNotNullParameter((Object)imageCache, (String)"imageCache");
        Intrinsics.checkNotNullParameter((Object)errorReporter2, (String)"errorReporter");
        Intrinsics.checkNotNullParameter((Object)transactionFactory, (String)"transactionFactory");
        Intrinsics.checkNotNullParameter((Object)publicKeyFactory, (String)"publicKeyFactory");
        Intrinsics.checkNotNullParameter(warnings, (String)"warnings");
        this.messageVersionRegistry = messageVersionRegistry;
        this.imageCache = imageCache;
        this.errorReporter = errorReporter2;
        this.transactionFactory = transactionFactory;
        this.publicKeyFactory = publicKeyFactory;
        this.warnings = warnings;
    }

    @Override
    @NotNull
    public List<Warning> getWarnings() {
        return this.warnings;
    }

    @JvmOverloads
    public StripeThreeDs2ServiceImpl(@NotNull Context context, boolean enableLogging, @NotNull CoroutineContext workContext) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        this(context, STRIPE_SDK_REFERENCE_NUMBER, enableLogging, workContext);
    }

    public /* synthetic */ StripeThreeDs2ServiceImpl(Context context, boolean bl, CoroutineContext coroutineContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(context, bl, coroutineContext);
    }

    public StripeThreeDs2ServiceImpl(@NotNull Context context, @NotNull String sdkReferenceNumber, boolean enableLogging, @NotNull CoroutineContext workContext) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkReferenceNumber, (String)"sdkReferenceNumber");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        this(context, (ImageCache)ImageCache.Default.INSTANCE, sdkReferenceNumber, enableLogging, workContext);
    }

    public /* synthetic */ StripeThreeDs2ServiceImpl(Context context, String string, boolean bl, CoroutineContext coroutineContext, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(context, string, bl, coroutineContext);
    }

    private StripeThreeDs2ServiceImpl(Context context, ImageCache imageCache, String sdkReferenceNumber, boolean enableLogging, CoroutineContext workContext) {
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        this(context, imageCache, sdkReferenceNumber, new DefaultErrorReporter(context2, null, null, Logger.Companion.get(enableLogging), null, null, null, 0, 246, null), workContext);
    }

    private StripeThreeDs2ServiceImpl(Context context, ImageCache imageCache, String sdkReferenceNumber, ErrorReporter errorReporter2, CoroutineContext workContext) {
        this(context, imageCache, sdkReferenceNumber, errorReporter2, new StripeEphemeralKeyPairGenerator(errorReporter2), new HardwareIdSupplier(context), new DefaultSecurityChecker(null, 1, null), new MessageVersionRegistry(), workContext);
    }

    private StripeThreeDs2ServiceImpl(Context context, ImageCache imageCache, String sdkReferenceNumber, ErrorReporter errorReporter2, EphemeralKeyPairGenerator ephemeralKeyPairGenerator, HardwareIdSupplier hardwareIdSupplier, SecurityChecker securityChecker, MessageVersionRegistry messageVersionRegistry, CoroutineContext workContext) {
        Object object = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"context.applicationContext");
        DefaultTransactionFactory defaultTransactionFactory = new DefaultTransactionFactory(new DefaultAuthenticationRequestParametersFactory((DeviceDataFactory)new DeviceDataFactoryImpl((Context)object, hardwareIdSupplier), (DeviceParamNotAvailableFactory)new DeviceParamNotAvailableFactoryImpl(hardwareIdSupplier), securityChecker, ephemeralKeyPairGenerator, new DefaultAppInfoRepository(context, workContext), messageVersionRegistry, sdkReferenceNumber, errorReporter2, workContext), ephemeralKeyPairGenerator, sdkReferenceNumber);
        object = securityChecker.getWarnings();
        PublicKeyFactory publicKeyFactory = new PublicKeyFactory(context, errorReporter2);
        this(messageVersionRegistry, imageCache, errorReporter2, defaultTransactionFactory, publicKeyFactory, (List<Warning>)object);
    }

    @Override
    @NotNull
    public Transaction createTransaction(@NotNull SdkTransactionId sdkTransactionId, @NotNull String directoryServerID, @Nullable String messageVersion, boolean isLiveMode, @NotNull String directoryServerName, @NotNull List<? extends X509Certificate> rootCerts, @NotNull PublicKey dsPublicKey, @Nullable String keyId, @NotNull StripeUiCustomization uiCustomization) throws InvalidInputException, SDKRuntimeException {
        Intrinsics.checkNotNullParameter((Object)sdkTransactionId, (String)"sdkTransactionId");
        Intrinsics.checkNotNullParameter((Object)directoryServerID, (String)"directoryServerID");
        Intrinsics.checkNotNullParameter((Object)directoryServerName, (String)"directoryServerName");
        Intrinsics.checkNotNullParameter(rootCerts, (String)"rootCerts");
        Intrinsics.checkNotNullParameter((Object)dsPublicKey, (String)"dsPublicKey");
        Intrinsics.checkNotNullParameter((Object)uiCustomization, (String)"uiCustomization");
        return this.createTransaction(directoryServerID, messageVersion, isLiveMode, directoryServerName, rootCerts, dsPublicKey, keyId, sdkTransactionId);
    }

    private final Transaction createTransaction(String directoryServerID, String messageVersion, boolean isLiveMode, String directoryServerName, List<? extends X509Certificate> rootCerts, PublicKey dsPublicKey, String keyId, SdkTransactionId sdkTransactionId) {
        if (!this.messageVersionRegistry.isSupported(messageVersion)) {
            String string = messageVersion;
            if (string == null) {
                string = "";
            }
            throw new InvalidInputException(Intrinsics.stringPlus((String)"Message version is unsupported: ", (Object)string), null, 2, null);
        }
        return this.transactionFactory.create(directoryServerID, rootCerts, dsPublicKey, keyId, sdkTransactionId, isLiveMode, Brand.Companion.lookup$3ds2sdk_release(directoryServerName, this.errorReporter));
    }

    @Override
    public void cleanup() {
        this.imageCache.clear();
    }

    @Override
    @NotNull
    public PublicKey getPublicKey(@NotNull String directoryServerId) {
        Intrinsics.checkNotNullParameter((Object)directoryServerId, (String)"directoryServerId");
        return this.publicKeyFactory.create(directoryServerId);
    }

    @JvmOverloads
    public StripeThreeDs2ServiceImpl(@NotNull Context context, @NotNull CoroutineContext workContext) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        this(context, false, workContext, 2, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/stripe3ds2/service/StripeThreeDs2ServiceImpl$Companion;", "", "()V", "STRIPE_SDK_REFERENCE_NUMBER", "", "3ds2sdk_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

