/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.security;

import android.content.Context;
import android.util.Base64;
import com.stripe.android.stripe3ds2.exceptions.SDKRuntimeException;
import com.stripe.android.stripe3ds2.observability.ErrorReporter;
import com.stripe.android.stripe3ds2.security.Algorithm;
import com.stripe.android.stripe3ds2.security.DirectoryServer;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.X509EncodedKeySpec;
import java.util.Scanner;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0002J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\nH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/stripe/android/stripe3ds2/security/PublicKeyFactory;", "", "context", "Landroid/content/Context;", "errorReporter", "Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;", "(Landroid/content/Context;Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;)V", "create", "Ljava/security/PublicKey;", "directoryServerId", "", "generateCertificate", "Ljava/security/cert/Certificate;", "fileName", "generatePublicKey", "algorithm", "Lcom/stripe/android/stripe3ds2/security/Algorithm;", "readFile", "Ljava/io/InputStream;", "readPublicKeyBytes", "", "keyFile", "3ds2sdk_release"})
public final class PublicKeyFactory {
    @NotNull
    private final ErrorReporter errorReporter;
    @NotNull
    private final Context context;

    public PublicKeyFactory(@NotNull Context context, @NotNull ErrorReporter errorReporter2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)errorReporter2, (String)"errorReporter");
        this.errorReporter = errorReporter2;
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        this.context = context2;
    }

    @NotNull
    public final PublicKey create(@NotNull String directoryServerId) {
        PublicKey publicKey;
        Intrinsics.checkNotNullParameter((Object)directoryServerId, (String)"directoryServerId");
        DirectoryServer directoryServer = DirectoryServer.Companion.lookup(directoryServerId);
        if (directoryServer.isCertificate()) {
            PublicKey publicKey2 = this.generateCertificate(directoryServer.getFileName()).getPublicKey();
            Intrinsics.checkNotNullExpressionValue((Object)publicKey2, (String)"{\n            generateCe\u2026Name).publicKey\n        }");
            publicKey = publicKey2;
        } else {
            publicKey = this.generatePublicKey(directoryServer.getFileName(), directoryServer.getAlgorithm());
        }
        return publicKey;
    }

    private final Certificate generateCertificate(String fileName) {
        Object object;
        Object object2 = this;
        try {
            PublicKeyFactory $this$generateCertificate_u24lambda_u2d0 = object2;
            boolean bl = false;
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            object = Result.constructor-impl((Object)factory.generateCertificate($this$generateCertificate_u24lambda_u2d0.readFile(fileName)));
        }
        catch (Throwable $this$generateCertificate_u24lambda_u2d0) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$generateCertificate_u24lambda_u2d0));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            this.errorReporter.reportError(it);
        }
        Throwable throwable2 = Result.exceptionOrNull-impl((Object)object2);
        if (throwable2 != null) {
            Throwable it = throwable2;
            boolean bl = false;
            throw new SDKRuntimeException(it);
        }
        Object object3 = object2;
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"runCatching {\n          \u2026meException(it)\n        }");
        return (Certificate)object3;
    }

    private final PublicKey generatePublicKey(String fileName, Algorithm algorithm) {
        Object object;
        Object object2 = this;
        try {
            PublicKeyFactory $this$generatePublicKey_u24lambda_u2d3 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)KeyFactory.getInstance(algorithm.toString()).generatePublic(new X509EncodedKeySpec($this$generatePublicKey_u24lambda_u2d3.readPublicKeyBytes(fileName))));
        }
        catch (Throwable $this$generatePublicKey_u24lambda_u2d3) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$generatePublicKey_u24lambda_u2d3));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            this.errorReporter.reportError(it);
        }
        Throwable throwable2 = Result.exceptionOrNull-impl((Object)object2);
        if (throwable2 != null) {
            Throwable it = throwable2;
            boolean bl = false;
            throw new SDKRuntimeException(it);
        }
        Object object3 = object2;
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"runCatching {\n          \u2026meException(it)\n        }");
        return (PublicKey)object3;
    }

    private final byte[] readPublicKeyBytes(String keyFile) {
        Object object;
        Object object2 = this;
        try {
            PublicKeyFactory $this$readPublicKeyBytes_u24lambda_u2d6 = object2;
            boolean bl = false;
            String publicKey = new Scanner($this$readPublicKeyBytes_u24lambda_u2d6.readFile(keyFile)).useDelimiter("\\A").next();
            Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"publicKey");
            String string = publicKey;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            object = Result.constructor-impl((Object)Base64.decode((byte[])byArray, (int)0));
        }
        catch (Throwable $this$readPublicKeyBytes_u24lambda_u2d6) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$readPublicKeyBytes_u24lambda_u2d6));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            this.errorReporter.reportError(it);
        }
        Throwable throwable2 = Result.exceptionOrNull-impl((Object)object2);
        if (throwable2 != null) {
            Throwable it = throwable2;
            boolean bl = false;
            throw new SDKRuntimeException(it);
        }
        Object object3 = object2;
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"runCatching {\n          \u2026meException(it)\n        }");
        return (byte[])object3;
    }

    private final InputStream readFile(String fileName) throws IOException {
        InputStream inputStream = this.context.getAssets().open(fileName);
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"context.assets.open(fileName)");
        return inputStream;
    }
}

