/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.init;

import android.os.Build;
import android.os.Debug;
import android.os.Environment;
import com.stripe.android.stripe3ds2.init.Warning;
import com.stripe.android.stripe3ds2.service.StripeThreeDs2ServiceImpl;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0005\t\n\u000b\f\rB\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0005\u000e\u000f\u0010\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/stripe3ds2/init/SecurityCheck;", "", "warning", "Lcom/stripe/android/stripe3ds2/init/Warning;", "(Lcom/stripe/android/stripe3ds2/init/Warning;)V", "getWarning", "()Lcom/stripe/android/stripe3ds2/init/Warning;", "check", "", "DebuggerAttached", "Emulator", "RootedCheck", "Tampered", "UnsupportedOS", "Lcom/stripe/android/stripe3ds2/init/SecurityCheck$RootedCheck;", "Lcom/stripe/android/stripe3ds2/init/SecurityCheck$Tampered;", "Lcom/stripe/android/stripe3ds2/init/SecurityCheck$Emulator;", "Lcom/stripe/android/stripe3ds2/init/SecurityCheck$DebuggerAttached;", "Lcom/stripe/android/stripe3ds2/init/SecurityCheck$UnsupportedOS;", "3ds2sdk_release"})
public abstract class SecurityCheck {
    @NotNull
    private final Warning warning;

    private SecurityCheck(Warning warning) {
        this.warning = warning;
    }

    @NotNull
    public final Warning getWarning() {
        return this.warning;
    }

    public abstract boolean check();

    public /* synthetic */ SecurityCheck(Warning warning, DefaultConstructorMarker $constructor_marker) {
        this(warning);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0002J\b\u0010\u0006\u001a\u00020\u0004H\u0002\u00a8\u0006\b"}, d2={"Lcom/stripe/android/stripe3ds2/init/SecurityCheck$RootedCheck;", "Lcom/stripe/android/stripe3ds2/init/SecurityCheck;", "()V", "check", "", "findSuBinary", "findSuperuserApk", "Companion", "3ds2sdk_release"})
    public static final class RootedCheck
    extends SecurityCheck {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @Deprecated
        @NotNull
        private static final List<String> BINARY_PATHS;
        @Deprecated
        @NotNull
        private static final Warning WARNING;

        public RootedCheck() {
            super(WARNING, null);
        }

        @Override
        public boolean check() {
            return this.findSuBinary() || this.findSuperuserApk();
        }

        private final boolean findSuBinary() {
            boolean bl;
            block3: {
                Iterable $this$any$iv = BINARY_PATHS;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        if (!new File(Intrinsics.stringPlus((String)it, (Object)"su")).exists()) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final boolean findSuperuserApk() {
            return new File(Intrinsics.stringPlus((String)Environment.getRootDirectory().toString(), (Object)"/Superuser")).isDirectory();
        }

        static {
            Object[] objectArray = new String[]{"/sbin/", "/system/bin/", "/system/xbin/", "/data/local/xbin/", "/data/local/bin/", "/system/sd/xbin/", "/system/bin/failsafe/", "/data/local/"};
            BINARY_PATHS = CollectionsKt.listOf((Object[])objectArray);
            WARNING = new Warning("SW01", "The device is jailbroken.", Warning.Severity.HIGH);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/android/stripe3ds2/init/SecurityCheck$RootedCheck$Companion;", "", "()V", "BINARY_PATHS", "", "", "WARNING", "Lcom/stripe/android/stripe3ds2/init/Warning;", "3ds2sdk_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\b\u0010\u0005\u001a\u00020\u0004H\u0002J\b\u0010\u0006\u001a\u00020\u0004H\u0002\u00a8\u0006\b"}, d2={"Lcom/stripe/android/stripe3ds2/init/SecurityCheck$Tampered;", "Lcom/stripe/android/stripe3ds2/init/SecurityCheck;", "()V", "check", "", "hasValidFields", "hasValidMethods", "Companion", "3ds2sdk_release"})
    public static final class Tampered
    extends SecurityCheck {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @Deprecated
        @NotNull
        private static final Warning WARNING = new Warning("SW02", "The integrity of the SDK has been tampered.", Warning.Severity.HIGH);

        public Tampered() {
            super(WARNING, null);
        }

        @Override
        public boolean check() {
            return !this.hasValidFields() || !this.hasValidMethods();
        }

        private final boolean hasValidFields() {
            int fieldCount = StripeThreeDs2ServiceImpl.class.getDeclaredFields().length;
            return fieldCount == 8;
        }

        private final boolean hasValidMethods() {
            int methodCount = StripeThreeDs2ServiceImpl.class.getDeclaredMethods().length;
            return methodCount == 5;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/stripe3ds2/init/SecurityCheck$Tampered$Companion;", "", "()V", "WARNING", "Lcom/stripe/android/stripe3ds2/init/Warning;", "3ds2sdk_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006\b"}, d2={"Lcom/stripe/android/stripe3ds2/init/SecurityCheck$Emulator;", "Lcom/stripe/android/stripe3ds2/init/SecurityCheck;", "()V", "isEmulator", "", "()Z", "check", "Companion", "3ds2sdk_release"})
    public static final class Emulator
    extends SecurityCheck {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @Deprecated
        @NotNull
        private static final Warning WARNING = new Warning("SW02", "An emulator is being used to run the App.", Warning.Severity.HIGH);

        public Emulator() {
            super(WARNING, null);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isEmulator() {
            String string = Build.FINGERPRINT;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FINGERPRINT");
            if (StringsKt.startsWith$default((String)string, (String)"generic", (boolean)false, (int)2, null)) return true;
            string = Build.FINGERPRINT;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"FINGERPRINT");
            if (StringsKt.startsWith$default((String)string, (String)"unknown", (boolean)false, (int)2, null)) return true;
            string = Build.MODEL;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MODEL");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"Emulator", (boolean)false, (int)2, null)) return true;
            string = Build.MODEL;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MODEL");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"Android SDK built for x86", (boolean)false, (int)2, null)) return true;
            string = Build.MODEL;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MODEL");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"google_sdk", (boolean)false, (int)2, null)) return true;
            string = Build.MANUFACTURER;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MANUFACTURER");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"Genymotion", (boolean)false, (int)2, null)) return true;
            string = Build.BRAND;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"BRAND");
            if (StringsKt.startsWith$default((String)string, (String)"generic", (boolean)false, (int)2, null)) {
                string = Build.DEVICE;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"DEVICE");
                if (StringsKt.startsWith$default((String)string, (String)"generic", (boolean)false, (int)2, null)) return true;
            }
            if (!Intrinsics.areEqual((Object)"google_sdk", (Object)Build.PRODUCT)) return false;
            return true;
        }

        @Override
        public boolean check() {
            return this.isEmulator();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/stripe3ds2/init/SecurityCheck$Emulator$Companion;", "", "()V", "WARNING", "Lcom/stripe/android/stripe3ds2/init/Warning;", "3ds2sdk_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0006\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0005\u00a8\u0006\b"}, d2={"Lcom/stripe/android/stripe3ds2/init/SecurityCheck$DebuggerAttached;", "Lcom/stripe/android/stripe3ds2/init/SecurityCheck;", "isDebuggerConnected", "", "(Z)V", "()Z", "check", "Companion", "3ds2sdk_release"})
    public static final class DebuggerAttached
    extends SecurityCheck {
        @NotNull
        private static final Companion Companion = new Companion(null);
        private final boolean isDebuggerConnected;
        @Deprecated
        @NotNull
        private static final Warning WARNING = new Warning("SW04", "A debugger is attached to the App.", Warning.Severity.MEDIUM);

        public DebuggerAttached(boolean isDebuggerConnected) {
            super(WARNING, null);
            this.isDebuggerConnected = isDebuggerConnected;
        }

        public /* synthetic */ DebuggerAttached(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                bl = Debug.isDebuggerConnected();
            }
            this(bl);
        }

        public final boolean isDebuggerConnected() {
            return this.isDebuggerConnected;
        }

        @Override
        public boolean check() {
            return this.isDebuggerConnected;
        }

        public DebuggerAttached() {
            this(false, 1, null);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/stripe3ds2/init/SecurityCheck$DebuggerAttached$Companion;", "", "()V", "WARNING", "Lcom/stripe/android/stripe3ds2/init/Warning;", "3ds2sdk_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/stripe3ds2/init/SecurityCheck$UnsupportedOS;", "Lcom/stripe/android/stripe3ds2/init/SecurityCheck;", "()V", "check", "", "Companion", "3ds2sdk_release"})
    public static final class UnsupportedOS
    extends SecurityCheck {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @Deprecated
        @NotNull
        private static final Warning WARNING = new Warning("SW05", "The OS or the OS version is not supported.", Warning.Severity.HIGH);

        public UnsupportedOS() {
            super(WARNING, null);
        }

        @Override
        public boolean check() {
            return false;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/stripe/android/stripe3ds2/init/SecurityCheck$UnsupportedOS$Companion;", "", "()V", "WARNING", "Lcom/stripe/android/stripe3ds2/init/Warning;", "3ds2sdk_release"})
        private static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

