/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.transaction;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.util.JSONObjectUtils;
import com.stripe.android.stripe3ds2.observability.ErrorReporter;
import com.stripe.android.stripe3ds2.transaction.AcsData;
import com.stripe.android.stripe3ds2.transaction.AcsDataParser;
import java.security.interfaces.ECPublicKey;
import java.text.ParseException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/stripe3ds2/transaction/DefaultAcsDataParser;", "Lcom/stripe/android/stripe3ds2/transaction/AcsDataParser;", "errorReporter", "Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;", "(Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;)V", "parse", "Lcom/stripe/android/stripe3ds2/transaction/AcsData;", "payloadJson", "Lorg/json/JSONObject;", "parsePublicKey", "Ljava/security/interfaces/ECPublicKey;", "ephemPubkey", "", "Companion", "3ds2sdk_release"})
public final class DefaultAcsDataParser
implements AcsDataParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ErrorReporter errorReporter;
    @NotNull
    public static final String FIELD_ACS_URL = "acsURL";
    @NotNull
    public static final String FIELD_ACS_EPHEM_PUB_KEY = "acsEphemPubKey";
    @NotNull
    public static final String FIELD_SDK_EPHEM_PUB_KEY = "sdkEphemPubKey";

    public DefaultAcsDataParser(@NotNull ErrorReporter errorReporter2) {
        Intrinsics.checkNotNullParameter((Object)errorReporter2, (String)"errorReporter");
        this.errorReporter = errorReporter2;
    }

    @Override
    @NotNull
    public AcsData parse(@NotNull JSONObject payloadJson) throws JSONException, ParseException, JOSEException {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)payloadJson, (String)"payloadJson");
        DefaultAcsDataParser defaultAcsDataParser = this;
        boolean bl = false;
        try {
            object2 = Result.Companion;
            DefaultAcsDataParser $this$parse_u24lambda_u2d0 = defaultAcsDataParser;
            boolean bl2 = false;
            object = JSONObjectUtils.parse((String)payloadJson.toString());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parse(payloadJson.toString())");
            Map payload = MapsKt.toMap((Map)object);
            AcsData acsData = new AcsData(String.valueOf(payload.get(FIELD_ACS_URL)), $this$parse_u24lambda_u2d0.parsePublicKey(payload.get(FIELD_ACS_EPHEM_PUB_KEY)), $this$parse_u24lambda_u2d0.parsePublicKey(payload.get(FIELD_SDK_EPHEM_PUB_KEY)));
            boolean bl3 = false;
            object2 = Result.constructor-impl((Object)acsData);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl4 = false;
            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        defaultAcsDataParser = object2;
        bl = false;
        boolean bl5 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)defaultAcsDataParser);
        if (throwable != null) {
            Throwable throwable2 = throwable;
            boolean bl6 = false;
            boolean bl7 = false;
            object = throwable2;
            boolean bl8 = false;
            Object it = object;
            boolean bl9 = false;
            this.errorReporter.reportError(new IllegalArgumentException(Intrinsics.stringPlus((String)"Failed to parse ACS data: ", (Object)payloadJson), (Throwable)it));
        }
        bl = false;
        ResultKt.throwOnFailure((Object)defaultAcsDataParser);
        return (AcsData)((Object)defaultAcsDataParser);
    }

    private final ECPublicKey parsePublicKey(Object ephemPubkey) {
        ECKey eCKey;
        Object object = ephemPubkey;
        if (object instanceof Map) {
            if (ephemPubkey == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
            }
            eCKey = ECKey.parse((Map)((Map)ephemPubkey));
        } else {
            Object object2 = ephemPubkey;
            object2 = object2 == null ? null : object2.toString();
            boolean bl = false;
            Object object3 = object2;
            if (object3 == null) {
                object3 = "";
            }
            eCKey = ECKey.parse((String)object3);
        }
        ECPublicKey eCPublicKey = eCKey.toECPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)eCPublicKey, (String)"when (ephemPubkey) {\n   \u2026        }.toECPublicKey()");
        return eCPublicKey;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/stripe3ds2/transaction/DefaultAcsDataParser$Companion;", "", "()V", "FIELD_ACS_EPHEM_PUB_KEY", "", "FIELD_ACS_URL", "FIELD_SDK_EPHEM_PUB_KEY", "3ds2sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

