/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.security;

import com.nimbusds.jose.jwk.KeyUse;
import com.stripe.android.stripe3ds2.exceptions.SDKRuntimeException;
import com.stripe.android.stripe3ds2.security.Algorithm;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\f\b\u0080\u0001\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001dB1\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015j\u0002\b\u0016j\u0002\b\u0017j\u0002\b\u0018j\u0002\b\u0019j\u0002\b\u001aj\u0002\b\u001bj\u0002\b\u001c\u00a8\u0006\u001e"}, d2={"Lcom/stripe/android/stripe3ds2/security/DirectoryServer;", "", "ids", "", "", "algorithm", "Lcom/stripe/android/stripe3ds2/security/Algorithm;", "fileName", "keyUse", "Lcom/nimbusds/jose/jwk/KeyUse;", "(Ljava/lang/String;ILjava/util/List;Lcom/stripe/android/stripe3ds2/security/Algorithm;Ljava/lang/String;Lcom/nimbusds/jose/jwk/KeyUse;)V", "getAlgorithm", "()Lcom/stripe/android/stripe3ds2/security/Algorithm;", "getFileName", "()Ljava/lang/String;", "getIds", "()Ljava/util/List;", "isCertificate", "", "()Z", "getKeyUse", "()Lcom/nimbusds/jose/jwk/KeyUse;", "TestRsa", "TestEc", "Visa", "Mastercard", "Amex", "Discover", "CartesBancaires", "Companion", "3ds2sdk_release"})
public final class DirectoryServer
extends Enum<DirectoryServer> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final List<String> ids;
    @NotNull
    private final Algorithm algorithm;
    @NotNull
    private final String fileName;
    @Nullable
    private final KeyUse keyUse;
    @NotNull
    private static final Set<String> CERTIFICATE_EXTENSIONS;
    public static final /* enum */ DirectoryServer TestRsa;
    public static final /* enum */ DirectoryServer TestEc;
    public static final /* enum */ DirectoryServer Visa;
    public static final /* enum */ DirectoryServer Mastercard;
    public static final /* enum */ DirectoryServer Amex;
    public static final /* enum */ DirectoryServer Discover;
    public static final /* enum */ DirectoryServer CartesBancaires;
    private static final /* synthetic */ DirectoryServer[] $VALUES;

    private DirectoryServer(List<String> ids, Algorithm algorithm, String fileName, KeyUse keyUse) {
        this.ids = ids;
        this.algorithm = algorithm;
        this.fileName = fileName;
        this.keyUse = keyUse;
    }

    /* synthetic */ DirectoryServer(String string, int n, List list, Algorithm algorithm, String string2, KeyUse keyUse, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            keyUse = KeyUse.SIGNATURE;
        }
        this(list, algorithm, string2, keyUse);
    }

    @NotNull
    public final List<String> getIds() {
        return this.ids;
    }

    @NotNull
    public final Algorithm getAlgorithm() {
        return this.algorithm;
    }

    @NotNull
    public final String getFileName() {
        return this.fileName;
    }

    @Nullable
    public final KeyUse getKeyUse() {
        return this.keyUse;
    }

    public final boolean isCertificate() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = CERTIFICATE_EXTENSIONS;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.endsWith$default((String)this.getFileName(), (String)it, (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static DirectoryServer[] values() {
        return (DirectoryServer[])$VALUES.clone();
    }

    public static DirectoryServer valueOf(String value) {
        return Enum.valueOf(DirectoryServer.class, value);
    }

    static {
        TestRsa = new DirectoryServer("TestRsa", 0, CollectionsKt.listOf((Object)"F000000000"), Algorithm.RSA, "ds-test-rsa.txt", null, 8, null);
        TestEc = new DirectoryServer("TestEc", 1, CollectionsKt.listOf((Object)"F000000001"), Algorithm.EC, "ds-test-ec.txt", null, 8, null);
        Visa = new DirectoryServer("Visa", 2, CollectionsKt.listOf((Object)"A000000003"), Algorithm.RSA, "ds-visa.crt", null, 8, null);
        Mastercard = new DirectoryServer("Mastercard", 3, CollectionsKt.listOf((Object)"A000000004"), Algorithm.RSA, "ds-mastercard.crt", null, 8, null);
        Amex = new DirectoryServer("Amex", 4, CollectionsKt.listOf((Object)"A000000025"), Algorithm.RSA, "ds-amex.pem", null, 8, null);
        Object[] objectArray = new String[]{"A000000152", "A000000324"};
        Discover = new DirectoryServer(CollectionsKt.listOf((Object[])objectArray), Algorithm.RSA, "ds-discover.cer", null);
        CartesBancaires = new DirectoryServer("CartesBancaires", 6, CollectionsKt.listOf((Object)"A000000042"), Algorithm.RSA, "ds-cartesbancaires.pem", null, 8, null);
        $VALUES = directoryServerArray = new DirectoryServer[]{DirectoryServer.TestRsa, DirectoryServer.TestEc, DirectoryServer.Visa, DirectoryServer.Mastercard, DirectoryServer.Amex, DirectoryServer.Discover, DirectoryServer.CartesBancaires};
        Companion = new Companion(null);
        objectArray = new String[]{".crt", ".cer", ".pem"};
        CERTIFICATE_EXTENSIONS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/stripe/android/stripe3ds2/security/DirectoryServer$Companion;", "", "()V", "CERTIFICATE_EXTENSIONS", "", "", "lookup", "Lcom/stripe/android/stripe3ds2/security/DirectoryServer;", "directoryServerId", "3ds2sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DirectoryServer lookup(@NotNull String directoryServerId) {
            DirectoryServer directoryServer;
            DirectoryServer directoryServer2;
            block2: {
                Intrinsics.checkNotNullParameter((Object)directoryServerId, (String)"directoryServerId");
                DirectoryServer[] $this$firstOrNull$iv = DirectoryServer.values();
                boolean $i$f$firstOrNull = false;
                DirectoryServer[] directoryServerArray = $this$firstOrNull$iv;
                int n = directoryServerArray.length;
                for (int i = 0; i < n; ++i) {
                    DirectoryServer element$iv;
                    DirectoryServer it = element$iv = directoryServerArray[i];
                    boolean bl = false;
                    if (!it.getIds().contains(directoryServerId)) continue;
                    directoryServer2 = element$iv;
                    break block2;
                }
                directoryServer2 = null;
            }
            DirectoryServer directoryServer3 = directoryServer = directoryServer2;
            if (directoryServer3 == null) {
                throw new SDKRuntimeException(new IllegalArgumentException(Intrinsics.stringPlus((String)"Unknown directory server id: ", (Object)directoryServerId)));
            }
            return directoryServer3;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

