/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.init.ui;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.TypedValue;
import androidx.annotation.AttrRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.R;
import androidx.appcompat.view.ContextThemeWrapper;
import androidx.core.content.ContextCompat;
import com.stripe.android.stripe3ds2.exceptions.InvalidInputException;
import com.stripe.android.stripe3ds2.init.ui.ButtonCustomization;
import com.stripe.android.stripe3ds2.init.ui.LabelCustomization;
import com.stripe.android.stripe3ds2.init.ui.StripeButtonCustomization;
import com.stripe.android.stripe3ds2.init.ui.StripeLabelCustomization;
import com.stripe.android.stripe3ds2.init.ui.StripeTextBoxCustomization;
import com.stripe.android.stripe3ds2.init.ui.StripeToolbarCustomization;
import com.stripe.android.stripe3ds2.init.ui.TextBoxCustomization;
import com.stripe.android.stripe3ds2.init.ui.ToolbarCustomization;
import com.stripe.android.stripe3ds2.init.ui.UiCustomization;
import com.stripe.android.stripe3ds2.utils.CustomizeUtils;
import com.stripe.android.stripe3ds2.utils.ObjectUtils;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;

public final class StripeUiCustomization
implements UiCustomization,
Parcelable {
    public static final Parcelable.Creator<StripeUiCustomization> CREATOR = new Parcelable.Creator<StripeUiCustomization>(){

        public StripeUiCustomization createFromParcel(Parcel in) {
            return new StripeUiCustomization(in);
        }

        public StripeUiCustomization[] newArray(int size) {
            return new StripeUiCustomization[size];
        }
    };
    @Nullable
    private ToolbarCustomization mToolbarCustomization;
    @Nullable
    private LabelCustomization mLabelCustomization;
    @Nullable
    private TextBoxCustomization mTextBoxCustomization;
    @NonNull
    private final Map<UiCustomization.ButtonType, ButtonCustomization> mDefaultButtonTypeCustomizations;
    @NonNull
    private final Map<String, ButtonCustomization> mCustomButtonTypeCustomization;
    @Nullable
    private String mAccentColor;

    public StripeUiCustomization() {
        this.mDefaultButtonTypeCustomizations = new EnumMap<UiCustomization.ButtonType, ButtonCustomization>(UiCustomization.ButtonType.class);
        this.mCustomButtonTypeCustomization = new HashMap<String, ButtonCustomization>();
    }

    @NonNull
    public static StripeUiCustomization createWithAppTheme(@NonNull Activity activity) {
        return new StripeUiCustomization(activity);
    }

    private StripeUiCustomization(@NonNull Activity activity) {
        this();
        Context actionBarContext = this.getThemeContext(activity, R.attr.actionBarTheme);
        String colorPrimary = this.getThemeColor((Context)activity, 16843827);
        String colorPrimaryDark = this.getThemeColor((Context)activity, 16843828);
        String textColorPrimary = this.getThemeColor(actionBarContext, 16842806);
        String textColor = this.getThemeColor((Context)activity, 16842904);
        String accentColor = this.getThemeColor((Context)activity, 16843829);
        String hintTextColor = this.getThemeColor((Context)activity, 16842906);
        this.mToolbarCustomization = new StripeToolbarCustomization();
        this.mLabelCustomization = new StripeLabelCustomization();
        this.mTextBoxCustomization = new StripeTextBoxCustomization();
        if (hintTextColor != null) {
            this.mTextBoxCustomization.setHintTextColor(hintTextColor);
        }
        StripeButtonCustomization cancelButtonCustomization = new StripeButtonCustomization();
        StripeButtonCustomization buttonCustomization = new StripeButtonCustomization();
        if (textColorPrimary != null) {
            this.mToolbarCustomization.setTextColor(textColorPrimary);
            cancelButtonCustomization.setTextColor(textColorPrimary);
        }
        if (colorPrimary != null) {
            this.mToolbarCustomization.setBackgroundColor(colorPrimary);
        }
        if (colorPrimaryDark != null) {
            this.mToolbarCustomization.setStatusBarColor(colorPrimaryDark);
        }
        if (textColor != null) {
            this.mLabelCustomization.setTextColor(textColor);
            this.mLabelCustomization.setHeadingTextColor(textColor);
            buttonCustomization.setTextColor(textColor);
            this.mTextBoxCustomization.setTextColor(textColor);
        }
        if (accentColor != null) {
            this.setAccentColor(accentColor);
            StripeButtonCustomization resendButtonCustomization = new StripeButtonCustomization();
            resendButtonCustomization.setTextColor(accentColor);
            this.setButtonCustomization((ButtonCustomization)resendButtonCustomization, UiCustomization.ButtonType.RESEND);
            buttonCustomization.setBackgroundColor(accentColor);
        }
        this.setButtonCustomization((ButtonCustomization)cancelButtonCustomization, UiCustomization.ButtonType.CANCEL);
        this.setButtonCustomization((ButtonCustomization)buttonCustomization, UiCustomization.ButtonType.NEXT);
        this.setButtonCustomization((ButtonCustomization)buttonCustomization, UiCustomization.ButtonType.CONTINUE);
        this.setButtonCustomization((ButtonCustomization)buttonCustomization, UiCustomization.ButtonType.SUBMIT);
        this.setButtonCustomization((ButtonCustomization)buttonCustomization, UiCustomization.ButtonType.SELECT);
    }

    @Nullable
    private String getThemeColor(@NonNull Context context, @AttrRes int colorAttrResId) {
        TypedValue typedValue = new TypedValue();
        if (context.getTheme().resolveAttribute(colorAttrResId, typedValue, true)) {
            int color = typedValue.resourceId != 0 ? ContextCompat.getColor((Context)context, (int)typedValue.resourceId) : typedValue.data;
            return CustomizeUtils.colorIntToHex(color);
        }
        return null;
    }

    @NonNull
    private Context getThemeContext(@NonNull Activity activity, @AttrRes int themeAttrResId) {
        TypedValue typedValue = new TypedValue();
        if (activity.getTheme().resolveAttribute(themeAttrResId, typedValue, true)) {
            return new ContextThemeWrapper((Context)activity, typedValue.resourceId);
        }
        return activity;
    }

    private StripeUiCustomization(Parcel in) {
        this.mAccentColor = in.readString();
        this.mToolbarCustomization = (ToolbarCustomization)in.readParcelable(StripeToolbarCustomization.class.getClassLoader());
        this.mLabelCustomization = (LabelCustomization)in.readParcelable(StripeLabelCustomization.class.getClassLoader());
        this.mTextBoxCustomization = (TextBoxCustomization)in.readParcelable(StripeTextBoxCustomization.class.getClassLoader());
        this.mDefaultButtonTypeCustomizations = new HashMap<UiCustomization.ButtonType, ButtonCustomization>();
        Bundle defaultButtonTypeCustomizationsBundle = in.readBundle(this.getClass().getClassLoader());
        if (defaultButtonTypeCustomizationsBundle != null) {
            for (String key : defaultButtonTypeCustomizationsBundle.keySet()) {
                ButtonCustomization buttonCustomization = (ButtonCustomization)defaultButtonTypeCustomizationsBundle.getParcelable(key);
                if (buttonCustomization == null) continue;
                this.mDefaultButtonTypeCustomizations.put(UiCustomization.ButtonType.valueOf(key), buttonCustomization);
            }
        }
        this.mCustomButtonTypeCustomization = new HashMap<String, ButtonCustomization>();
        Bundle customButtonTypeCustomizationsBundle = in.readBundle(this.getClass().getClassLoader());
        if (customButtonTypeCustomizationsBundle != null) {
            for (String key : customButtonTypeCustomizationsBundle.keySet()) {
                ButtonCustomization buttonCustomization = (ButtonCustomization)customButtonTypeCustomizationsBundle.getParcelable(key);
                if (buttonCustomization == null) continue;
                this.mCustomButtonTypeCustomization.put(key, buttonCustomization);
            }
        }
    }

    @Override
    public void setButtonCustomization(@NonNull ButtonCustomization buttonCustomization, @NonNull UiCustomization.ButtonType buttonType) throws InvalidInputException {
        this.mDefaultButtonTypeCustomizations.put(buttonType, buttonCustomization);
    }

    @Override
    public void setButtonCustomization(@NonNull ButtonCustomization buttonCustomization, @NonNull String buttonType) throws InvalidInputException {
        this.mCustomButtonTypeCustomization.put(buttonType, buttonCustomization);
    }

    @Override
    public void setToolbarCustomization(@NonNull ToolbarCustomization toolbarCustomization) throws InvalidInputException {
        this.mToolbarCustomization = toolbarCustomization;
    }

    @Override
    public void setLabelCustomization(@NonNull LabelCustomization labelCustomization) throws InvalidInputException {
        this.mLabelCustomization = labelCustomization;
    }

    @Override
    public void setTextBoxCustomization(@NonNull TextBoxCustomization textBoxCustomization) throws InvalidInputException {
        this.mTextBoxCustomization = textBoxCustomization;
    }

    @Override
    public void setAccentColor(@NonNull String accentColor) {
        this.mAccentColor = CustomizeUtils.requireValidColor(accentColor);
    }

    @Override
    @Nullable
    public ButtonCustomization getButtonCustomization(@NonNull UiCustomization.ButtonType buttonType) throws InvalidInputException {
        return this.mDefaultButtonTypeCustomizations.get((Object)buttonType);
    }

    @Override
    @Nullable
    public ButtonCustomization getButtonCustomization(@NonNull String buttonType) throws InvalidInputException {
        return this.mCustomButtonTypeCustomization.get(buttonType);
    }

    @Override
    @Nullable
    public ToolbarCustomization getToolbarCustomization() {
        return this.mToolbarCustomization;
    }

    @Override
    @Nullable
    public LabelCustomization getLabelCustomization() {
        return this.mLabelCustomization;
    }

    @Override
    @Nullable
    public TextBoxCustomization getTextBoxCustomization() {
        return this.mTextBoxCustomization;
    }

    @Override
    @Nullable
    public String getAccentColor() {
        return this.mAccentColor;
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj || obj instanceof StripeUiCustomization && this.typedEquals((StripeUiCustomization)obj);
    }

    private boolean typedEquals(@NonNull StripeUiCustomization uiCustomization) {
        return ObjectUtils.equals(this.mToolbarCustomization, uiCustomization.mToolbarCustomization) && ObjectUtils.equals(this.mAccentColor, uiCustomization.mAccentColor) && ObjectUtils.equals(this.mLabelCustomization, uiCustomization.mLabelCustomization) && ObjectUtils.equals(this.mTextBoxCustomization, uiCustomization.mTextBoxCustomization) && ObjectUtils.equals(this.mDefaultButtonTypeCustomizations, uiCustomization.mDefaultButtonTypeCustomizations) && ObjectUtils.equals(this.mCustomButtonTypeCustomization, uiCustomization.mCustomButtonTypeCustomization);
    }

    public int hashCode() {
        return ObjectUtils.hash(this.mToolbarCustomization, this.mAccentColor, this.mLabelCustomization, this.mTextBoxCustomization, this.mDefaultButtonTypeCustomizations, this.mCustomButtonTypeCustomization);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mAccentColor);
        dest.writeParcelable((Parcelable)((StripeToolbarCustomization)this.mToolbarCustomization), 0);
        dest.writeParcelable((Parcelable)((StripeLabelCustomization)this.mLabelCustomization), 0);
        dest.writeParcelable((Parcelable)((StripeTextBoxCustomization)this.mTextBoxCustomization), 0);
        Bundle defaultButtonTypeCustomizationsBundle = new Bundle();
        for (Map.Entry<UiCustomization.ButtonType, ButtonCustomization> entry : this.mDefaultButtonTypeCustomizations.entrySet()) {
            defaultButtonTypeCustomizationsBundle.putParcelable(entry.getKey().name(), (Parcelable)((StripeButtonCustomization)entry.getValue()));
        }
        dest.writeBundle(defaultButtonTypeCustomizationsBundle);
        Bundle customButtonTypeCustomizationsBundle = new Bundle();
        for (Map.Entry<String, ButtonCustomization> entry : this.mCustomButtonTypeCustomization.entrySet()) {
            customButtonTypeCustomizationsBundle.putParcelable(entry.getKey(), (Parcelable)((StripeButtonCustomization)entry.getValue()));
        }
        dest.writeBundle(customButtonTypeCustomizationsBundle);
    }
}

