package com.stripe.android.stripe3ds2.views

import android.os.Bundle
import android.os.Parcelable
import android.view.View
import android.view.ViewGroup
import androidx.core.content.ContextCompat
import androidx.core.os.bundleOf
import androidx.core.view.isVisible
import androidx.core.view.updateLayoutParams
import androidx.fragment.app.Fragment
import com.stripe.android.stripe3ds2.R
import com.stripe.android.stripe3ds2.databinding.StripeProgressViewLayoutBinding
import kotlinx.parcelize.Parcelize

internal class ChallengeProgressFragment : Fragment(R.layout.stripe_progress_view_layout) {

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        val viewBinding = StripeProgressViewLayoutBinding.bind(view)
        val args = arguments.let(Args::fromBundle)

        val brand = args.brand

        viewBinding.brandLogo.let { brandLogo ->
            brandLogo.setImageDrawable(
                activity?.let {
                    ContextCompat.getDrawable(it, brand.drawableResId)
                }
            )
            brandLogo.contentDescription = brand.nameResId?.let { getString(it) }

            if (brand.shouldStretch) {
                brandLogo.updateLayoutParams {
                    width = ViewGroup.LayoutParams.WRAP_CONTENT
                    height = ViewGroup.LayoutParams.WRAP_CONTENT
                }
            }

            brandLogo.isVisible = true
        }

        args.accentColor?.let {
            viewBinding.progressBar.setIndicatorColor(it)
        }
    }

    @Parcelize
    data class Args(
        val brand: Brand,
        val accentColor: Int?
    ) : Parcelable {
        fun toBundle() = bundleOf(EXTRA_ARGS to this)

        internal companion object {
            private const val EXTRA_ARGS = "ChallengeProgressFragmentArgs"

            fun fromBundle(bundle: Bundle?): Args {
                return bundle?.getParcelable(EXTRA_ARGS) ?: Args(
                    Brand.Unknown,
                    null
                )
            }
        }
    }
}
