package com.stripe.android.stripe3ds2.transaction

import android.app.Activity
import android.content.Intent
import com.stripe.android.stripe3ds2.init.ui.StripeUiCustomization
import java.security.KeyPair
import java.security.PublicKey
import java.security.cert.X509Certificate

internal class StripeTransaction(
    private val areqParamsFactory: AuthenticationRequestParametersFactory,
    private val directoryServerId: String,
    private val directoryServerPublicKey: PublicKey,
    private val directoryServerKeyId: String?,
    override val sdkTransactionId: SdkTransactionId,
    private val sdkKeyPair: KeyPair,
    private val sdkReferenceNumber: String,
    private val isLiveMode: Boolean,
    private val uiCustomization: StripeUiCustomization,
    private val rootCerts: List<X509Certificate>,
    private val enableLogging: Boolean,
) : Transaction {
    override suspend fun createAuthenticationRequestParameters(): AuthenticationRequestParameters {
        return areqParamsFactory.create(
            directoryServerId,
            directoryServerPublicKey,
            directoryServerKeyId,
            sdkTransactionId,
            sdkKeyPair.public
        )
    }

    override fun createIntent(
        activity: Activity,
        challengeParameters: ChallengeParameters,
        timeoutMins: Int,
        intentData: IntentData
    ): Intent {
        return TransactionContract().createIntent(
            activity,
            TransactionContract.Args(
                sdkTransactionId,
                sdkReferenceNumber,
                isLiveMode,
                uiCustomization,
                rootCerts,
                sdkKeyPair,
                enableLogging,
                challengeParameters,
                timeoutMins.coerceAtLeast(MIN_TIMEOUT),
                intentData
            )
        )
    }

    internal companion object {
        internal const val MIN_TIMEOUT = 5
    }
}
