package com.stripe.android.stripe3ds2.views

import androidx.fragment.app.Fragment
import androidx.fragment.app.FragmentFactory
import com.stripe.android.stripe3ds2.init.ui.StripeUiCustomization
import com.stripe.android.stripe3ds2.observability.ErrorReporter
import com.stripe.android.stripe3ds2.transaction.ChallengeActionHandler
import com.stripe.android.stripe3ds2.transaction.ChallengeStatusReceiver
import com.stripe.android.stripe3ds2.transaction.ErrorRequestExecutor
import com.stripe.android.stripe3ds2.transaction.SdkTransactionId
import com.stripe.android.stripe3ds2.transaction.TransactionTimer

internal class ChallengeFragmentFactory(
    private val sdkTransactionId: SdkTransactionId,
    private val uiCustomization: StripeUiCustomization,
    private val transactionTimer: TransactionTimer,
    private val challengeStatusReceiver: ChallengeStatusReceiver,
    private val errorRequestExecutor: ErrorRequestExecutor,
    private val errorReporter: ErrorReporter,
    private val challengeActionHandler: ChallengeActionHandler
) : FragmentFactory() {
    override fun instantiate(classLoader: ClassLoader, className: String): Fragment {
        return when (className) {
            ChallengeFragment::class.java.name -> {
                ChallengeFragment(
                    sdkTransactionId,
                    uiCustomization,
                    transactionTimer,
                    challengeStatusReceiver,
                    errorRequestExecutor,
                    errorReporter,
                    challengeActionHandler
                )
            }
            else -> {
                super.instantiate(classLoader, className)
            }
        }
    }
}
