package com.stripe.android.stripe3ds2.transaction

import com.stripe.android.stripe3ds2.observability.ErrorReporter
import com.stripe.android.stripe3ds2.security.MessageTransformer
import com.stripe.android.stripe3ds2.transactions.ChallengeRequestData
import com.stripe.android.stripe3ds2.utils.ObjectUtils
import java.io.Serializable

interface ChallengeRequestExecutor {
    suspend fun execute(creqData: ChallengeRequestData): ChallengeRequestResult

    interface Factory : Serializable {
        fun create(
            config: Config,
            errorReporter: ErrorReporter
        ): ChallengeRequestExecutor
    }

    data class Config(
        internal val messageTransformer: MessageTransformer,
        internal val sdkReferenceId: String,
        internal val sdkPrivateKeyEncoded: ByteArray,
        internal val acsPublicKeyEncoded: ByteArray,
        internal val acsUrl: String,
        internal val creqData: ChallengeRequestData
    ) : Serializable {

        override fun hashCode(): Int {
            return ObjectUtils.hash(
                messageTransformer, sdkReferenceId, sdkPrivateKeyEncoded,
                acsPublicKeyEncoded, acsUrl, creqData
            )
        }

        override fun equals(other: Any?): Boolean {
            return when {
                this === other -> true
                other is Config -> typedEquals(other)
                else -> false
            }
        }

        private fun typedEquals(config: Config): Boolean {
            return ObjectUtils.equals(messageTransformer, config.messageTransformer) &&
                ObjectUtils.equals(sdkReferenceId, config.sdkReferenceId) &&
                ObjectUtils.equals(sdkPrivateKeyEncoded, config.sdkPrivateKeyEncoded) &&
                ObjectUtils.equals(acsPublicKeyEncoded, config.acsPublicKeyEncoded) &&
                ObjectUtils.equals(acsUrl, config.acsUrl) &&
                ObjectUtils.equals(creqData, config.creqData)
        }
    }
}
