/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.transaction;

import androidx.annotation.VisibleForTesting;
import com.nimbusds.jose.JOSEException;
import com.stripe.android.stripe3ds2.observability.ErrorReporter;
import com.stripe.android.stripe3ds2.security.MessageTransformer;
import com.stripe.android.stripe3ds2.transaction.ChallengeRequestResult;
import com.stripe.android.stripe3ds2.transaction.HttpResponse;
import com.stripe.android.stripe3ds2.transaction.SdkTransactionId;
import com.stripe.android.stripe3ds2.transactions.ChallengeRequestData;
import com.stripe.android.stripe3ds2.transactions.ChallengeResponseData;
import com.stripe.android.stripe3ds2.transactions.ChallengeResponseParseException;
import com.stripe.android.stripe3ds2.transactions.ErrorData;
import com.stripe.android.stripe3ds2.transactions.ProtocolError;
import java.text.ParseException;
import javax.crypto.SecretKey;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b`\u0018\u00002\u00020\u0001:\u0001\tJ!\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\n"}, d2={"Lcom/stripe/android/stripe3ds2/transaction/ChallengeResponseProcessor;", "", "process", "Lcom/stripe/android/stripe3ds2/transaction/ChallengeRequestResult;", "creqData", "Lcom/stripe/android/stripe3ds2/transactions/ChallengeRequestData;", "response", "Lcom/stripe/android/stripe3ds2/transaction/HttpResponse;", "(Lcom/stripe/android/stripe3ds2/transactions/ChallengeRequestData;Lcom/stripe/android/stripe3ds2/transaction/HttpResponse;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Default", "3ds2sdk_release"})
public interface ChallengeResponseProcessor {
    @Nullable
    public Object process(@NotNull ChallengeRequestData var1, @NotNull HttpResponse var2, @NotNull Continuation<? super ChallengeRequestResult> var3);

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0018\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J!\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001eJ\u0018\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010 \u001a\u00020\u0013H\u0007R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006!"}, d2={"Lcom/stripe/android/stripe3ds2/transaction/ChallengeResponseProcessor$Default;", "Lcom/stripe/android/stripe3ds2/transaction/ChallengeResponseProcessor;", "messageTransformer", "Lcom/stripe/android/stripe3ds2/security/MessageTransformer;", "secretKey", "Ljavax/crypto/SecretKey;", "errorReporter", "Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;", "(Lcom/stripe/android/stripe3ds2/security/MessageTransformer;Ljavax/crypto/SecretKey;Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;)V", "createErrorData", "Lcom/stripe/android/stripe3ds2/transactions/ErrorData;", "creqData", "Lcom/stripe/android/stripe3ds2/transactions/ChallengeRequestData;", "code", "", "description", "", "detail", "getResponsePayload", "Lorg/json/JSONObject;", "responseBody", "isMessageVersionCorrect", "", "cresData", "Lcom/stripe/android/stripe3ds2/transactions/ChallengeResponseData;", "isValidChallengeResponse", "process", "Lcom/stripe/android/stripe3ds2/transaction/ChallengeRequestResult;", "response", "Lcom/stripe/android/stripe3ds2/transaction/HttpResponse;", "(Lcom/stripe/android/stripe3ds2/transactions/ChallengeRequestData;Lcom/stripe/android/stripe3ds2/transaction/HttpResponse;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "processPayload", "payload", "3ds2sdk_release"})
    public static final class Default
    implements ChallengeResponseProcessor {
        private final MessageTransformer messageTransformer;
        private final SecretKey secretKey;
        private final ErrorReporter errorReporter;

        @Override
        @Nullable
        public Object process(@NotNull ChallengeRequestData creqData, @NotNull HttpResponse response, @NotNull Continuation<? super ChallengeRequestResult> $completion) {
            ChallengeRequestResult challengeRequestResult;
            if (response.isJsonContentType()) {
                JSONObject payload = new JSONObject(response.getContent());
                challengeRequestResult = ErrorData.Companion.isErrorMessage$3ds2sdk_release(payload) ? (ChallengeRequestResult)new ChallengeRequestResult.ProtocolError(ErrorData.Companion.fromJson$3ds2sdk_release(payload)) : (ChallengeRequestResult)new ChallengeRequestResult.RuntimeError(new IllegalArgumentException("Received a JSON response that was not an Error message."));
            } else {
                Object object;
                Default default_ = this;
                boolean bl = false;
                try {
                    object = Result.Companion;
                    Default $this$runCatching = default_;
                    boolean bl2 = false;
                    $this$runCatching = $this$runCatching.getResponsePayload(response.getContent());
                    bl2 = false;
                    object = Result.constructor-impl((Object)$this$runCatching);
                }
                catch (Throwable $this$runCatching) {
                    Result.Companion bl2 = Result.Companion;
                    boolean bl3 = false;
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching));
                }
                default_ = object;
                bl = false;
                boolean bl4 = false;
                Throwable throwable = Result.exceptionOrNull-impl((Object)default_);
                if (throwable != null) {
                    Throwable throwable2 = throwable;
                    boolean $this$runCatching = false;
                    boolean bl2 = false;
                    Throwable throwable3 = throwable2;
                    boolean bl5 = false;
                    Throwable it = throwable3;
                    boolean bl6 = false;
                    this.errorReporter.reportError(new RuntimeException(StringsKt.trimIndent((String)("\n                            Failed to process challenge response.\n\n                            CReq = " + creqData.sanitize$3ds2sdk_release() + "\n                            ")), it));
                }
                bl = false;
                boolean bl7 = false;
                Throwable throwable4 = Result.exceptionOrNull-impl((Object)default_);
                if (throwable4 == null) {
                    JSONObject it = (JSONObject)default_;
                    boolean bl8 = false;
                    challengeRequestResult = this.processPayload(creqData, it);
                } else {
                    Throwable it = throwable4;
                    boolean bl9 = false;
                    ProtocolError protocolError = ProtocolError.DataDecryptionFailure;
                    int n = protocolError.getCode();
                    String string2 = protocolError.getDescription();
                    String string3 = it.getMessage();
                    boolean bl10 = false;
                    String string4 = string3;
                    if (string4 == null) {
                        string4 = "";
                    }
                    challengeRequestResult = new ChallengeRequestResult.ProtocolError(this.createErrorData(creqData, n, string2, string4));
                }
            }
            return challengeRequestResult;
        }

        @VisibleForTesting
        @NotNull
        public final ChallengeRequestResult processPayload(@NotNull ChallengeRequestData creqData, @NotNull JSONObject payload) {
            ChallengeRequestResult challengeRequestResult;
            Intrinsics.checkNotNullParameter((Object)creqData, (String)"creqData");
            Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
            if (ErrorData.Companion.isErrorMessage$3ds2sdk_release(payload)) {
                challengeRequestResult = new ChallengeRequestResult.ProtocolError(ErrorData.Companion.fromJson$3ds2sdk_release(payload));
            } else {
                Object object;
                Default default_ = this;
                boolean bl = false;
                try {
                    object = Result.Companion;
                    Object $this$runCatching = default_;
                    boolean bl2 = false;
                    $this$runCatching = ChallengeResponseData.Companion.fromJson$3ds2sdk_release(payload);
                    bl2 = false;
                    object = Result.constructor-impl((Object)$this$runCatching);
                }
                catch (Throwable $this$runCatching) {
                    Result.Companion bl2 = Result.Companion;
                    boolean bl3 = false;
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$runCatching));
                }
                default_ = object;
                bl = false;
                boolean bl4 = false;
                Throwable throwable = Result.exceptionOrNull-impl((Object)default_);
                if (throwable == null) {
                    ChallengeResponseData cresData = (ChallengeResponseData)((Object)default_);
                    boolean bl5 = false;
                    if (!this.isValidChallengeResponse(creqData, cresData)) {
                        ProtocolError protocolError = ProtocolError.InvalidTransactionId;
                        challengeRequestResult = new ChallengeRequestResult.ProtocolError(this.createErrorData(creqData, protocolError.getCode(), protocolError.getDescription(), "The Transaction ID received was invalid."));
                    } else {
                        challengeRequestResult = !this.isMessageVersionCorrect(creqData, cresData) ? (ChallengeRequestResult)new ChallengeRequestResult.ProtocolError(this.createErrorData(creqData, ProtocolError.UnsupportedMessageVersion.getCode(), ProtocolError.UnsupportedMessageVersion.getDescription(), creqData.getMessageVersion())) : (ChallengeRequestResult)new ChallengeRequestResult.Success(creqData, cresData);
                    }
                } else {
                    Throwable throwable2 = throwable;
                    boolean bl6 = false;
                    Throwable throwable3 = throwable2;
                    challengeRequestResult = throwable3 instanceof ChallengeResponseParseException ? (ChallengeRequestResult)new ChallengeRequestResult.ProtocolError(this.createErrorData(creqData, ((ChallengeResponseParseException)throwable2).getCode(), ((ChallengeResponseParseException)throwable2).getDescription(), ((ChallengeResponseParseException)throwable2).getDetail())) : (ChallengeRequestResult)new ChallengeRequestResult.RuntimeError(throwable2);
                }
            }
            return challengeRequestResult;
        }

        private final boolean isValidChallengeResponse(ChallengeRequestData creqData, ChallengeResponseData cresData) {
            return Intrinsics.areEqual((Object)creqData.getSdkTransId(), (Object)cresData.getSdkTransId()) && Intrinsics.areEqual((Object)creqData.getThreeDsServerTransId(), (Object)cresData.getServerTransId()) && Intrinsics.areEqual((Object)creqData.getAcsTransId(), (Object)cresData.getAcsTransId());
        }

        private final boolean isMessageVersionCorrect(ChallengeRequestData creqData, ChallengeResponseData cresData) {
            return Intrinsics.areEqual((Object)creqData.getMessageVersion(), (Object)cresData.getMessageVersion());
        }

        private final JSONObject getResponsePayload(String responseBody) throws ParseException, JOSEException, JSONException, ChallengeResponseParseException {
            return this.messageTransformer.decrypt(responseBody, this.secretKey);
        }

        private final ErrorData createErrorData(ChallengeRequestData creqData, int code, String description, String detail) {
            String string2 = creqData.getMessageVersion();
            String string3 = creqData.getThreeDsServerTransId();
            SdkTransactionId sdkTransactionId2 = creqData.getSdkTransId();
            String string4 = creqData.getAcsTransId();
            ErrorData.ErrorComponent errorComponent = ErrorData.ErrorComponent.ThreeDsSdk;
            String string5 = "CRes";
            String string6 = detail;
            String string7 = null;
            String string8 = description;
            String string9 = String.valueOf(code);
            return new ErrorData(string3, string4, string7, string9, errorComponent, string8, string6, string5, string2, sdkTransactionId2, 4, null);
        }

        public Default(@NotNull MessageTransformer messageTransformer, @NotNull SecretKey secretKey, @NotNull ErrorReporter errorReporter2) {
            Intrinsics.checkNotNullParameter((Object)messageTransformer, (String)"messageTransformer");
            Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
            Intrinsics.checkNotNullParameter((Object)errorReporter2, (String)"errorReporter");
            this.messageTransformer = messageTransformer;
            this.secretKey = secretKey;
            this.errorReporter = errorReporter2;
        }
    }
}

