package com.stripe.android.stripe3ds2.transaction

import com.stripe.android.stripe3ds2.observability.ErrorReporter
import com.stripe.android.stripe3ds2.transactions.ErrorData
import java.io.Serializable

interface ErrorRequestExecutor {
    fun executeAsync(errorData: ErrorData)

    interface Factory : Serializable {
        fun create(
            acsUrl: String,
            errorReporter: ErrorReporter
        ): ErrorRequestExecutor
    }
}
