/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.service;

import android.content.Context;
import android.os.Parcelable;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.stripe3ds2.exceptions.InvalidInputException;
import com.stripe.android.stripe3ds2.exceptions.SDKAlreadyInitializedException;
import com.stripe.android.stripe3ds2.exceptions.SDKNotInitializedException;
import com.stripe.android.stripe3ds2.exceptions.SDKRuntimeException;
import com.stripe.android.stripe3ds2.init.DefaultAppInfoRepository;
import com.stripe.android.stripe3ds2.init.DeviceDataFactory;
import com.stripe.android.stripe3ds2.init.DeviceDataFactoryImpl;
import com.stripe.android.stripe3ds2.init.DeviceParamNotAvailableFactory;
import com.stripe.android.stripe3ds2.init.DeviceParamNotAvailableFactoryImpl;
import com.stripe.android.stripe3ds2.init.HardwareIdSupplier;
import com.stripe.android.stripe3ds2.init.SecurityChecker;
import com.stripe.android.stripe3ds2.init.Warning;
import com.stripe.android.stripe3ds2.init.ui.StripeUiCustomization;
import com.stripe.android.stripe3ds2.init.ui.UiCustomization;
import com.stripe.android.stripe3ds2.observability.DefaultErrorReporter;
import com.stripe.android.stripe3ds2.observability.ErrorReporter;
import com.stripe.android.stripe3ds2.security.EphemeralKeyPairGenerator;
import com.stripe.android.stripe3ds2.security.PublicKeyFactory;
import com.stripe.android.stripe3ds2.security.StripeEphemeralKeyPairGenerator;
import com.stripe.android.stripe3ds2.service.StripeThreeDs2Service;
import com.stripe.android.stripe3ds2.transaction.ChallengeStatusReceiverProvider;
import com.stripe.android.stripe3ds2.transaction.DefaultAuthenticationRequestParametersFactory;
import com.stripe.android.stripe3ds2.transaction.Logger;
import com.stripe.android.stripe3ds2.transaction.MessageVersionRegistry;
import com.stripe.android.stripe3ds2.transaction.SdkTransactionId;
import com.stripe.android.stripe3ds2.transaction.Transaction;
import com.stripe.android.stripe3ds2.transaction.TransactionFactory;
import com.stripe.android.stripe3ds2.transaction.TransactionTimerProvider;
import com.stripe.android.stripe3ds2.utils.ImageCache;
import com.stripe.android.stripe3ds2.utils.ParcelUtils;
import com.stripe.android.stripe3ds2.views.ProgressViewFactory;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 I2\u00020\u0001:\u0001IB\u0019\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B!\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tB7\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012B?\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015B_\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\u0002\u0010\u001eBO\b\u0001\u0012\u0006\u0010\u001f\u001a\u00020 \u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\u0006\u0010!\u001a\u00020\"\u0012\u0006\u0010\u001c\u001a\u00020\u001d\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\u0006\u0010#\u001a\u00020$\u00a2\u0006\u0002\u0010%J\b\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020*2\u0006\u0010)\u001a\u00020*H\u0002J\u001a\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\b2\b\u0010<\u001a\u0004\u0018\u00010\bH\u0016J*\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\b2\b\u0010<\u001a\u0004\u0018\u00010\b2\u0006\u0010=\u001a\u00020\u00052\u0006\u0010>\u001a\u00020\bH\u0016JJ\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\b2\b\u0010<\u001a\u0004\u0018\u00010\b2\u0006\u0010=\u001a\u00020\u00052\u0006\u0010>\u001a\u00020\b2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020@022\u0006\u0010A\u001a\u00020B2\b\u0010C\u001a\u0004\u0018\u00010\bH\u0016JR\u00109\u001a\u00020:2\u0006\u0010;\u001a\u00020\b2\b\u0010<\u001a\u0004\u0018\u00010\b2\u0006\u0010=\u001a\u00020\u00052\u0006\u0010>\u001a\u00020\b2\f\u0010?\u001a\b\u0012\u0004\u0012\u00020@022\u0006\u0010A\u001a\u00020B2\b\u0010C\u001a\u0004\u0018\u00010\b2\u0006\u0010D\u001a\u00020EH\u0002J\u0012\u0010F\u001a\u0002072\b\u0010)\u001a\u0004\u0018\u00010GH\u0016J\b\u0010H\u001a\u000207H\u0002R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010)\u001a\u0004\u0018\u00010*8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b+\u0010,\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001a\u00101\u001a\b\u0012\u0004\u0012\u000203028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105\u00a8\u0006J"}, d2={"Lcom/stripe/android/stripe3ds2/service/StripeThreeDs2ServiceImpl;", "Lcom/stripe/android/stripe3ds2/service/StripeThreeDs2Service;", "context", "Landroid/content/Context;", "enableLogging", "", "(Landroid/content/Context;Z)V", "sdkReferenceNumber", "", "(Landroid/content/Context;Ljava/lang/String;Z)V", "imageCache", "Lcom/stripe/android/stripe3ds2/utils/ImageCache;", "challengeStatusReceiverProvider", "Lcom/stripe/android/stripe3ds2/transaction/ChallengeStatusReceiverProvider;", "transactionTimerProvider", "Lcom/stripe/android/stripe3ds2/transaction/TransactionTimerProvider;", "logger", "Lcom/stripe/android/stripe3ds2/transaction/Logger;", "(Landroid/content/Context;Lcom/stripe/android/stripe3ds2/utils/ImageCache;Lcom/stripe/android/stripe3ds2/transaction/ChallengeStatusReceiverProvider;Lcom/stripe/android/stripe3ds2/transaction/TransactionTimerProvider;Ljava/lang/String;Lcom/stripe/android/stripe3ds2/transaction/Logger;)V", "errorReporter", "Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;", "(Landroid/content/Context;Lcom/stripe/android/stripe3ds2/utils/ImageCache;Lcom/stripe/android/stripe3ds2/transaction/ChallengeStatusReceiverProvider;Lcom/stripe/android/stripe3ds2/transaction/TransactionTimerProvider;Ljava/lang/String;Lcom/stripe/android/stripe3ds2/transaction/Logger;Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;)V", "ephemeralKeyPairGenerator", "Lcom/stripe/android/stripe3ds2/security/EphemeralKeyPairGenerator;", "hardwareIdSupplier", "Lcom/stripe/android/stripe3ds2/init/HardwareIdSupplier;", "securityChecker", "Lcom/stripe/android/stripe3ds2/init/SecurityChecker;", "messageVersionRegistry", "Lcom/stripe/android/stripe3ds2/transaction/MessageVersionRegistry;", "(Landroid/content/Context;Lcom/stripe/android/stripe3ds2/utils/ImageCache;Lcom/stripe/android/stripe3ds2/transaction/ChallengeStatusReceiverProvider;Lcom/stripe/android/stripe3ds2/transaction/TransactionTimerProvider;Ljava/lang/String;Lcom/stripe/android/stripe3ds2/transaction/Logger;Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;Lcom/stripe/android/stripe3ds2/security/EphemeralKeyPairGenerator;Lcom/stripe/android/stripe3ds2/init/HardwareIdSupplier;Lcom/stripe/android/stripe3ds2/init/SecurityChecker;Lcom/stripe/android/stripe3ds2/transaction/MessageVersionRegistry;)V", "isInitialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "publicKeyFactory", "Lcom/stripe/android/stripe3ds2/security/PublicKeyFactory;", "transactionFactory", "Lcom/stripe/android/stripe3ds2/transaction/TransactionFactory;", "(Ljava/util/concurrent/atomic/AtomicBoolean;Lcom/stripe/android/stripe3ds2/init/SecurityChecker;Lcom/stripe/android/stripe3ds2/security/PublicKeyFactory;Lcom/stripe/android/stripe3ds2/transaction/MessageVersionRegistry;Lcom/stripe/android/stripe3ds2/utils/ImageCache;Lcom/stripe/android/stripe3ds2/transaction/ChallengeStatusReceiverProvider;Lcom/stripe/android/stripe3ds2/transaction/TransactionTimerProvider;Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;Lcom/stripe/android/stripe3ds2/transaction/TransactionFactory;)V", "sdkVersion", "getSdkVersion", "()Ljava/lang/String;", "uiCustomization", "Lcom/stripe/android/stripe3ds2/init/ui/StripeUiCustomization;", "getUiCustomization$3ds2sdk_release$annotations", "()V", "getUiCustomization$3ds2sdk_release", "()Lcom/stripe/android/stripe3ds2/init/ui/StripeUiCustomization;", "setUiCustomization$3ds2sdk_release", "(Lcom/stripe/android/stripe3ds2/init/ui/StripeUiCustomization;)V", "warnings", "", "Lcom/stripe/android/stripe3ds2/init/Warning;", "getWarnings", "()Ljava/util/List;", "cleanup", "", "copyUiCustomization", "createTransaction", "Lcom/stripe/android/stripe3ds2/transaction/Transaction;", "directoryServerID", "messageVersion", "isLiveMode", "directoryServerName", "rootCerts", "Ljava/security/cert/X509Certificate;", "dsPublicKey", "Ljava/security/PublicKey;", "keyId", "sdkTransactionId", "Lcom/stripe/android/stripe3ds2/transaction/SdkTransactionId;", "initialize", "Lcom/stripe/android/stripe3ds2/init/ui/UiCustomization;", "requireInitialization", "Companion", "3ds2sdk_release"})
public final class StripeThreeDs2ServiceImpl
implements StripeThreeDs2Service {
    @Nullable
    private StripeUiCustomization uiCustomization;
    private final AtomicBoolean isInitialized;
    private final SecurityChecker securityChecker;
    private final PublicKeyFactory publicKeyFactory;
    private final MessageVersionRegistry messageVersionRegistry;
    private final ImageCache imageCache;
    private final ChallengeStatusReceiverProvider challengeStatusReceiverProvider;
    private final TransactionTimerProvider transactionTimerProvider;
    private final ErrorReporter errorReporter;
    private final TransactionFactory transactionFactory;
    private static final String STRIPE_SDK_REFERENCE_NUMBER = "3DS_LOA_SDK_STIN_020100_00142";
    private static final String SDK_VERSION = "1.0.0";
    @NotNull
    private static final Companion Companion = new Companion(null);

    @VisibleForTesting
    public static /* synthetic */ void getUiCustomization$3ds2sdk_release$annotations() {
    }

    @Nullable
    public final StripeUiCustomization getUiCustomization$3ds2sdk_release() {
        return this.uiCustomization;
    }

    public final void setUiCustomization$3ds2sdk_release(@Nullable StripeUiCustomization stripeUiCustomization) {
        this.uiCustomization = stripeUiCustomization;
    }

    @Override
    @NotNull
    public String getSdkVersion() throws SDKNotInitializedException, SDKRuntimeException {
        this.requireInitialization();
        return SDK_VERSION;
    }

    @Override
    @NotNull
    public List<Warning> getWarnings() {
        return this.securityChecker.getWarnings();
    }

    @Override
    public void initialize(@Nullable UiCustomization uiCustomization) throws InvalidInputException, SDKAlreadyInitializedException, SDKRuntimeException {
        StripeUiCustomization stripeUiCustomization;
        if (!this.isInitialized.compareAndSet(false, true)) {
            throw (Throwable)new SDKAlreadyInitializedException();
        }
        UiCustomization uiCustomization2 = uiCustomization;
        if (uiCustomization2 instanceof StripeUiCustomization) {
            stripeUiCustomization = this.copyUiCustomization((StripeUiCustomization)uiCustomization);
        } else if (uiCustomization2 == null) {
            stripeUiCustomization = null;
        } else {
            throw (Throwable)new InvalidInputException(new RuntimeException("UiCustomization must be an instance of StripeUiCustomization"));
        }
        this.uiCustomization = stripeUiCustomization;
    }

    @Override
    @NotNull
    public Transaction createTransaction(@NotNull String directoryServerID, @Nullable String messageVersion) {
        Intrinsics.checkNotNullParameter((Object)directoryServerID, (String)"directoryServerID");
        return this.createTransaction(directoryServerID, messageVersion, true, "visa");
    }

    @Override
    @NotNull
    public Transaction createTransaction(@NotNull String directoryServerID, @Nullable String messageVersion, boolean isLiveMode, @NotNull String directoryServerName) throws InvalidInputException, SDKNotInitializedException, SDKRuntimeException {
        Intrinsics.checkNotNullParameter((Object)directoryServerID, (String)"directoryServerID");
        Intrinsics.checkNotNullParameter((Object)directoryServerName, (String)"directoryServerName");
        PublicKey publicKey = this.publicKeyFactory.create(directoryServerID);
        return this.createTransaction(directoryServerID, messageVersion, isLiveMode, directoryServerName, CollectionsKt.emptyList(), publicKey, null, SdkTransactionId.Companion.create());
    }

    @Override
    @NotNull
    public Transaction createTransaction(@NotNull String directoryServerID, @Nullable String messageVersion, boolean isLiveMode, @NotNull String directoryServerName, @NotNull List<? extends X509Certificate> rootCerts, @NotNull PublicKey dsPublicKey, @Nullable String keyId) throws InvalidInputException, SDKNotInitializedException, SDKRuntimeException {
        Intrinsics.checkNotNullParameter((Object)directoryServerID, (String)"directoryServerID");
        Intrinsics.checkNotNullParameter((Object)directoryServerName, (String)"directoryServerName");
        Intrinsics.checkNotNullParameter(rootCerts, (String)"rootCerts");
        Intrinsics.checkNotNullParameter((Object)dsPublicKey, (String)"dsPublicKey");
        return this.createTransaction(directoryServerID, messageVersion, isLiveMode, directoryServerName, rootCerts, dsPublicKey, keyId, SdkTransactionId.Companion.create());
    }

    private final Transaction createTransaction(String directoryServerID, String messageVersion, boolean isLiveMode, String directoryServerName, List<? extends X509Certificate> rootCerts, PublicKey dsPublicKey, String keyId, SdkTransactionId sdkTransactionId2) {
        this.requireInitialization();
        if (!this.messageVersionRegistry.isSupported(messageVersion)) {
            StringBuilder stringBuilder = new StringBuilder().append("Message version is unsupported: ");
            String string = messageVersion;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                string2 = "";
            }
            throw (Throwable)new InvalidInputException(stringBuilder.append(string2).toString(), null, 2, null);
        }
        return this.transactionFactory.create(directoryServerID, rootCerts, dsPublicKey, keyId, sdkTransactionId2, this.uiCustomization, isLiveMode, ProgressViewFactory.Brand.Companion.lookup$3ds2sdk_release(directoryServerName, this.errorReporter));
    }

    @Override
    public void cleanup() throws SDKNotInitializedException {
        this.requireInitialization();
        this.imageCache.clear();
        this.challengeStatusReceiverProvider.clear();
        this.transactionTimerProvider.clear();
    }

    private final void requireInitialization() {
        if (!this.isInitialized.get()) {
            throw (Throwable)new SDKNotInitializedException();
        }
    }

    private final StripeUiCustomization copyUiCustomization(StripeUiCustomization uiCustomization) {
        Parcelable parcelable = uiCustomization;
        Parcelable.Creator<StripeUiCustomization> creator = StripeUiCustomization.CREATOR;
        Intrinsics.checkNotNullExpressionValue(creator, (String)"StripeUiCustomization.CREATOR");
        StripeUiCustomization stripeUiCustomization = ParcelUtils.copy(parcelable, creator);
        Intrinsics.checkNotNullExpressionValue((Object)stripeUiCustomization, (String)"ParcelUtils.copy(uiCusto\u2026eUiCustomization.CREATOR)");
        return stripeUiCustomization;
    }

    @VisibleForTesting
    public StripeThreeDs2ServiceImpl(@NotNull AtomicBoolean isInitialized, @NotNull SecurityChecker securityChecker, @NotNull PublicKeyFactory publicKeyFactory, @NotNull MessageVersionRegistry messageVersionRegistry, @NotNull ImageCache imageCache, @NotNull ChallengeStatusReceiverProvider challengeStatusReceiverProvider, @NotNull TransactionTimerProvider transactionTimerProvider, @NotNull ErrorReporter errorReporter2, @NotNull TransactionFactory transactionFactory) {
        Intrinsics.checkNotNullParameter((Object)isInitialized, (String)"isInitialized");
        Intrinsics.checkNotNullParameter((Object)securityChecker, (String)"securityChecker");
        Intrinsics.checkNotNullParameter((Object)publicKeyFactory, (String)"publicKeyFactory");
        Intrinsics.checkNotNullParameter((Object)messageVersionRegistry, (String)"messageVersionRegistry");
        Intrinsics.checkNotNullParameter((Object)imageCache, (String)"imageCache");
        Intrinsics.checkNotNullParameter((Object)challengeStatusReceiverProvider, (String)"challengeStatusReceiverProvider");
        Intrinsics.checkNotNullParameter((Object)transactionTimerProvider, (String)"transactionTimerProvider");
        Intrinsics.checkNotNullParameter((Object)errorReporter2, (String)"errorReporter");
        Intrinsics.checkNotNullParameter((Object)transactionFactory, (String)"transactionFactory");
        this.isInitialized = isInitialized;
        this.securityChecker = securityChecker;
        this.publicKeyFactory = publicKeyFactory;
        this.messageVersionRegistry = messageVersionRegistry;
        this.imageCache = imageCache;
        this.challengeStatusReceiverProvider = challengeStatusReceiverProvider;
        this.transactionTimerProvider = transactionTimerProvider;
        this.errorReporter = errorReporter2;
        this.transactionFactory = transactionFactory;
    }

    @JvmOverloads
    public StripeThreeDs2ServiceImpl(@NotNull Context context, boolean enableLogging) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, STRIPE_SDK_REFERENCE_NUMBER, enableLogging);
    }

    public /* synthetic */ StripeThreeDs2ServiceImpl(Context context, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        this(context, bl);
    }

    @JvmOverloads
    public StripeThreeDs2ServiceImpl(@NotNull Context context) {
        this(context, false, 2, null);
    }

    public StripeThreeDs2ServiceImpl(@NotNull Context context, @NotNull String sdkReferenceNumber, boolean enableLogging) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)sdkReferenceNumber, (String)"sdkReferenceNumber");
        this(context, ImageCache.Default.INSTANCE, ChallengeStatusReceiverProvider.Default.INSTANCE, TransactionTimerProvider.Default.INSTANCE, sdkReferenceNumber, enableLogging ? Logger.Companion.real$3ds2sdk_release() : Logger.Companion.noop$3ds2sdk_release());
    }

    public /* synthetic */ StripeThreeDs2ServiceImpl(Context context, String string, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl = false;
        }
        this(context, string, bl);
    }

    private StripeThreeDs2ServiceImpl(Context context, ImageCache imageCache, ChallengeStatusReceiverProvider challengeStatusReceiverProvider, TransactionTimerProvider transactionTimerProvider, String sdkReferenceNumber, Logger logger) {
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        this(context, imageCache, challengeStatusReceiverProvider, transactionTimerProvider, sdkReferenceNumber, logger, new DefaultErrorReporter(context2, null, null, logger, null, null, null, 0, 246, null));
    }

    private StripeThreeDs2ServiceImpl(Context context, ImageCache imageCache, ChallengeStatusReceiverProvider challengeStatusReceiverProvider, TransactionTimerProvider transactionTimerProvider, String sdkReferenceNumber, Logger logger, ErrorReporter errorReporter2) {
        this(context, imageCache, challengeStatusReceiverProvider, transactionTimerProvider, sdkReferenceNumber, logger, errorReporter2, new StripeEphemeralKeyPairGenerator(errorReporter2), new HardwareIdSupplier(context), new SecurityChecker.Default(null, 1, null), new MessageVersionRegistry());
    }

    private StripeThreeDs2ServiceImpl(Context context, ImageCache imageCache, ChallengeStatusReceiverProvider challengeStatusReceiverProvider, TransactionTimerProvider transactionTimerProvider, String sdkReferenceNumber, Logger logger, ErrorReporter errorReporter2, EphemeralKeyPairGenerator ephemeralKeyPairGenerator, HardwareIdSupplier hardwareIdSupplier, SecurityChecker securityChecker, MessageVersionRegistry messageVersionRegistry) {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        PublicKeyFactory publicKeyFactory = new PublicKeyFactory(context, errorReporter2);
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"context.applicationContext");
        this(atomicBoolean, securityChecker, publicKeyFactory, messageVersionRegistry, imageCache, challengeStatusReceiverProvider, transactionTimerProvider, errorReporter2, new TransactionFactory.Default(new DefaultAuthenticationRequestParametersFactory((DeviceDataFactory)new DeviceDataFactoryImpl(context2, hardwareIdSupplier), (DeviceParamNotAvailableFactory)new DeviceParamNotAvailableFactoryImpl(hardwareIdSupplier), securityChecker, ephemeralKeyPairGenerator, new DefaultAppInfoRepository(context), messageVersionRegistry, sdkReferenceNumber, errorReporter2), ephemeralKeyPairGenerator, messageVersionRegistry, sdkReferenceNumber, errorReporter2, logger, null, null, null, 448, null));
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/stripe3ds2/service/StripeThreeDs2ServiceImpl$Companion;", "", "()V", "SDK_VERSION", "", "STRIPE_SDK_REFERENCE_NUMBER", "3ds2sdk_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

