package com.stripe.android.stripe3ds2.transaction

import com.stripe.android.stripe3ds2.exceptions.SDKRuntimeException

/**
 * A singleton instance that provides access to a given transaction's
 * [ChallengeStatusReceiver].
 */
interface ChallengeStatusReceiverProvider {
    fun put(sdkTransactionId: SdkTransactionId, challengeStatusReceiver: ChallengeStatusReceiver)

    operator fun get(sdkTransactionId: SdkTransactionId): ChallengeStatusReceiver

    fun clear()

    object Default : ChallengeStatusReceiverProvider {
        private val receivers = mutableMapOf<SdkTransactionId, ChallengeStatusReceiver>()

        override fun put(
            sdkTransactionId: SdkTransactionId,
            challengeStatusReceiver:
                ChallengeStatusReceiver
        ) {
            receivers[sdkTransactionId] = challengeStatusReceiver
        }

        override operator fun get(
            sdkTransactionId: SdkTransactionId
        ): ChallengeStatusReceiver {
            return receivers[sdkTransactionId]
                ?: throw SDKRuntimeException(
                    "No ChallengeStatusReceiver for transaction id $sdkTransactionId"
                )
        }

        override fun clear() {
            receivers.clear()
        }
    }
}
