/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.transaction;

import android.content.Intent;
import com.stripe.android.stripe3ds2.init.ui.StripeUiCustomization;
import com.stripe.android.stripe3ds2.observability.ErrorReporter;
import com.stripe.android.stripe3ds2.security.EphemeralKeyPairGenerator;
import com.stripe.android.stripe3ds2.security.MessageTransformerFactory;
import com.stripe.android.stripe3ds2.transaction.AuthenticationRequestParametersFactory;
import com.stripe.android.stripe3ds2.transaction.ChallengeStatusReceiverProvider;
import com.stripe.android.stripe3ds2.transaction.JwsValidator;
import com.stripe.android.stripe3ds2.transaction.Logger;
import com.stripe.android.stripe3ds2.transaction.MessageVersionRegistry;
import com.stripe.android.stripe3ds2.transaction.ProtocolErrorEventFactory;
import com.stripe.android.stripe3ds2.transaction.SdkTransactionId;
import com.stripe.android.stripe3ds2.transaction.StripeTransaction;
import com.stripe.android.stripe3ds2.transaction.Transaction;
import com.stripe.android.stripe3ds2.views.ProgressViewFactory;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00e0\u0080\u0001\u0018\u00002\u00020\u0001:\u0001\u0018Jd\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017H&\u00a8\u0006\u0019"}, d2={"Lcom/stripe/android/stripe3ds2/transaction/TransactionFactory;", "", "create", "Lcom/stripe/android/stripe3ds2/transaction/Transaction;", "directoryServerId", "", "rootCerts", "", "Ljava/security/cert/X509Certificate;", "directoryServerPublicKey", "Ljava/security/PublicKey;", "keyId", "sdkTransactionId", "Lcom/stripe/android/stripe3ds2/transaction/SdkTransactionId;", "uiCustomization", "Lcom/stripe/android/stripe3ds2/init/ui/StripeUiCustomization;", "isLiveMode", "", "brand", "Lcom/stripe/android/stripe3ds2/views/ProgressViewFactory$Brand;", "challengeCompletionIntent", "Landroid/content/Intent;", "challengeCompletionRequestCode", "", "Default", "3ds2sdk_release"})
public interface TransactionFactory {
    @NotNull
    public Transaction create(@NotNull String var1, @NotNull List<? extends X509Certificate> var2, @NotNull PublicKey var3, @Nullable String var4, @NotNull SdkTransactionId var5, @Nullable StripeUiCustomization var6, boolean var7, @NotNull ProgressViewFactory.Brand var8, @Nullable Intent var9, int var10);

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001BW\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014Jd\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\t2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\t2\u0006\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020-H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/stripe/android/stripe3ds2/transaction/TransactionFactory$Default;", "Lcom/stripe/android/stripe3ds2/transaction/TransactionFactory;", "areqParamsFactory", "Lcom/stripe/android/stripe3ds2/transaction/AuthenticationRequestParametersFactory;", "ephemeralKeyPairGenerator", "Lcom/stripe/android/stripe3ds2/security/EphemeralKeyPairGenerator;", "messageVersionRegistry", "Lcom/stripe/android/stripe3ds2/transaction/MessageVersionRegistry;", "sdkReferenceNumber", "", "errorReporter", "Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;", "logger", "Lcom/stripe/android/stripe3ds2/transaction/Logger;", "progressViewFactory", "Lcom/stripe/android/stripe3ds2/views/ProgressViewFactory;", "jwsValidator", "Lcom/stripe/android/stripe3ds2/transaction/JwsValidator;", "challengeStatusReceiverProvider", "Lcom/stripe/android/stripe3ds2/transaction/ChallengeStatusReceiverProvider;", "(Lcom/stripe/android/stripe3ds2/transaction/AuthenticationRequestParametersFactory;Lcom/stripe/android/stripe3ds2/security/EphemeralKeyPairGenerator;Lcom/stripe/android/stripe3ds2/transaction/MessageVersionRegistry;Ljava/lang/String;Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;Lcom/stripe/android/stripe3ds2/transaction/Logger;Lcom/stripe/android/stripe3ds2/views/ProgressViewFactory;Lcom/stripe/android/stripe3ds2/transaction/JwsValidator;Lcom/stripe/android/stripe3ds2/transaction/ChallengeStatusReceiverProvider;)V", "messageTransformerFactory", "Lcom/stripe/android/stripe3ds2/security/MessageTransformerFactory;", "protocolErrorEventFactory", "Lcom/stripe/android/stripe3ds2/transaction/ProtocolErrorEventFactory;", "create", "Lcom/stripe/android/stripe3ds2/transaction/Transaction;", "directoryServerId", "rootCerts", "", "Ljava/security/cert/X509Certificate;", "directoryServerPublicKey", "Ljava/security/PublicKey;", "keyId", "sdkTransactionId", "Lcom/stripe/android/stripe3ds2/transaction/SdkTransactionId;", "uiCustomization", "Lcom/stripe/android/stripe3ds2/init/ui/StripeUiCustomization;", "isLiveMode", "", "brand", "Lcom/stripe/android/stripe3ds2/views/ProgressViewFactory$Brand;", "challengeCompletionIntent", "Landroid/content/Intent;", "challengeCompletionRequestCode", "", "3ds2sdk_release"})
    public static final class Default
    implements TransactionFactory {
        private final ProtocolErrorEventFactory protocolErrorEventFactory;
        private final MessageTransformerFactory messageTransformerFactory;
        private final AuthenticationRequestParametersFactory areqParamsFactory;
        private final EphemeralKeyPairGenerator ephemeralKeyPairGenerator;
        private final MessageVersionRegistry messageVersionRegistry;
        private final String sdkReferenceNumber;
        private final ErrorReporter errorReporter;
        private final Logger logger;
        private final ProgressViewFactory progressViewFactory;
        private final JwsValidator jwsValidator;
        private final ChallengeStatusReceiverProvider challengeStatusReceiverProvider;

        @Override
        @NotNull
        public Transaction create(@NotNull String directoryServerId, @NotNull List<? extends X509Certificate> rootCerts, @NotNull PublicKey directoryServerPublicKey, @Nullable String keyId, @NotNull SdkTransactionId sdkTransactionId, @Nullable StripeUiCustomization uiCustomization, boolean isLiveMode, @NotNull ProgressViewFactory.Brand brand, @Nullable Intent challengeCompletionIntent, int challengeCompletionRequestCode) {
            Intrinsics.checkNotNullParameter((Object)directoryServerId, (String)"directoryServerId");
            Intrinsics.checkNotNullParameter(rootCerts, (String)"rootCerts");
            Intrinsics.checkNotNullParameter((Object)directoryServerPublicKey, (String)"directoryServerPublicKey");
            Intrinsics.checkNotNullParameter((Object)sdkTransactionId, (String)"sdkTransactionId");
            Intrinsics.checkNotNullParameter((Object)((Object)brand), (String)"brand");
            KeyPair sdkKeyPair = this.ephemeralKeyPairGenerator.generate();
            return new StripeTransaction(this.areqParamsFactory, this.progressViewFactory, this.challengeStatusReceiverProvider, this.messageVersionRegistry, this.sdkReferenceNumber, this.jwsValidator, this.protocolErrorEventFactory, directoryServerId, directoryServerPublicKey, keyId, sdkTransactionId, sdkKeyPair, isLiveMode, rootCerts, this.messageTransformerFactory.create(isLiveMode), uiCustomization, brand, this.logger, this.errorReporter, challengeCompletionIntent, challengeCompletionRequestCode);
        }

        @JvmOverloads
        public Default(@NotNull AuthenticationRequestParametersFactory areqParamsFactory, @NotNull EphemeralKeyPairGenerator ephemeralKeyPairGenerator, @NotNull MessageVersionRegistry messageVersionRegistry, @NotNull String sdkReferenceNumber, @NotNull ErrorReporter errorReporter2, @NotNull Logger logger, @NotNull ProgressViewFactory progressViewFactory, @NotNull JwsValidator jwsValidator, @NotNull ChallengeStatusReceiverProvider challengeStatusReceiverProvider) {
            Intrinsics.checkNotNullParameter((Object)areqParamsFactory, (String)"areqParamsFactory");
            Intrinsics.checkNotNullParameter((Object)ephemeralKeyPairGenerator, (String)"ephemeralKeyPairGenerator");
            Intrinsics.checkNotNullParameter((Object)messageVersionRegistry, (String)"messageVersionRegistry");
            Intrinsics.checkNotNullParameter((Object)sdkReferenceNumber, (String)"sdkReferenceNumber");
            Intrinsics.checkNotNullParameter((Object)errorReporter2, (String)"errorReporter");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            Intrinsics.checkNotNullParameter((Object)progressViewFactory, (String)"progressViewFactory");
            Intrinsics.checkNotNullParameter((Object)jwsValidator, (String)"jwsValidator");
            Intrinsics.checkNotNullParameter((Object)challengeStatusReceiverProvider, (String)"challengeStatusReceiverProvider");
            this.areqParamsFactory = areqParamsFactory;
            this.ephemeralKeyPairGenerator = ephemeralKeyPairGenerator;
            this.messageVersionRegistry = messageVersionRegistry;
            this.sdkReferenceNumber = sdkReferenceNumber;
            this.errorReporter = errorReporter2;
            this.logger = logger;
            this.progressViewFactory = progressViewFactory;
            this.jwsValidator = jwsValidator;
            this.challengeStatusReceiverProvider = challengeStatusReceiverProvider;
            this.protocolErrorEventFactory = new ProtocolErrorEventFactory();
            this.messageTransformerFactory = new MessageTransformerFactory(this.errorReporter);
        }

        public /* synthetic */ Default(AuthenticationRequestParametersFactory authenticationRequestParametersFactory, EphemeralKeyPairGenerator ephemeralKeyPairGenerator, MessageVersionRegistry messageVersionRegistry, String string2, ErrorReporter errorReporter2, Logger logger, ProgressViewFactory progressViewFactory, JwsValidator jwsValidator, ChallengeStatusReceiverProvider challengeStatusReceiverProvider, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x20) != 0) {
                logger = Logger.Companion.noop$3ds2sdk_release();
            }
            if ((n & 0x40) != 0) {
                progressViewFactory = new ProgressViewFactory.Default();
            }
            if ((n & 0x80) != 0) {
                jwsValidator = new JwsValidator.Default(errorReporter2);
            }
            if ((n & 0x100) != 0) {
                challengeStatusReceiverProvider = ChallengeStatusReceiverProvider.Default.INSTANCE;
            }
            this(authenticationRequestParametersFactory, ephemeralKeyPairGenerator, messageVersionRegistry, string2, errorReporter2, logger, progressViewFactory, jwsValidator, challengeStatusReceiverProvider);
        }

        @JvmOverloads
        public Default(@NotNull AuthenticationRequestParametersFactory areqParamsFactory, @NotNull EphemeralKeyPairGenerator ephemeralKeyPairGenerator, @NotNull MessageVersionRegistry messageVersionRegistry, @NotNull String sdkReferenceNumber, @NotNull ErrorReporter errorReporter2, @NotNull Logger logger, @NotNull ProgressViewFactory progressViewFactory, @NotNull JwsValidator jwsValidator) {
            this(areqParamsFactory, ephemeralKeyPairGenerator, messageVersionRegistry, sdkReferenceNumber, errorReporter2, logger, progressViewFactory, jwsValidator, null, 256, null);
        }

        @JvmOverloads
        public Default(@NotNull AuthenticationRequestParametersFactory areqParamsFactory, @NotNull EphemeralKeyPairGenerator ephemeralKeyPairGenerator, @NotNull MessageVersionRegistry messageVersionRegistry, @NotNull String sdkReferenceNumber, @NotNull ErrorReporter errorReporter2, @NotNull Logger logger, @NotNull ProgressViewFactory progressViewFactory) {
            this(areqParamsFactory, ephemeralKeyPairGenerator, messageVersionRegistry, sdkReferenceNumber, errorReporter2, logger, progressViewFactory, null, null, 384, null);
        }

        @JvmOverloads
        public Default(@NotNull AuthenticationRequestParametersFactory areqParamsFactory, @NotNull EphemeralKeyPairGenerator ephemeralKeyPairGenerator, @NotNull MessageVersionRegistry messageVersionRegistry, @NotNull String sdkReferenceNumber, @NotNull ErrorReporter errorReporter2, @NotNull Logger logger) {
            this(areqParamsFactory, ephemeralKeyPairGenerator, messageVersionRegistry, sdkReferenceNumber, errorReporter2, logger, null, null, null, 448, null);
        }

        @JvmOverloads
        public Default(@NotNull AuthenticationRequestParametersFactory areqParamsFactory, @NotNull EphemeralKeyPairGenerator ephemeralKeyPairGenerator, @NotNull MessageVersionRegistry messageVersionRegistry, @NotNull String sdkReferenceNumber, @NotNull ErrorReporter errorReporter2) {
            this(areqParamsFactory, ephemeralKeyPairGenerator, messageVersionRegistry, sdkReferenceNumber, errorReporter2, null, null, null, null, 480, null);
        }
    }
}

