/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.utils;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Color;
import android.os.Build;
import android.text.SpannableString;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.TypefaceSpan;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.ProgressBar;
import androidx.annotation.ColorInt;
import androidx.appcompat.app.AppCompatActivity;
import com.stripe.android.stripe3ds2.exceptions.InvalidInputException;
import com.stripe.android.stripe3ds2.init.ui.Customization;
import com.stripe.android.stripe3ds2.init.ui.UiCustomization;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0000\u00a2\u0006\u0002\b\fJ\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u0010\u001a\u00020\u0011J\u001f\u0010\u0012\u001a\u00020\u00112\b\b\u0001\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0005H\u0001\u00a2\u0006\u0002\b\u0015J\u0012\u0010\u0016\u001a\u00020\u00172\b\b\u0001\u0010\u0013\u001a\u00020\u0011H\u0007J\u001e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eJ\u0017\u0010\u0012\u001a\u00020\u00112\b\b\u0001\u0010\u0013\u001a\u00020\u0011H\u0001\u00a2\u0006\u0002\b\u0015J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0017H\u0007J\u0010\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u0011H\u0007J\u0010\u0010#\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u0011H\u0007J\u0010\u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u0017H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/stripe/android/stripe3ds2/utils/CustomizeUtils;", "", "<init>", "()V", "DEFAULT_DARKEN_FACTOR", "", "applyProgressBarColor", "", "progressBar", "Landroid/widget/ProgressBar;", "uiCustomization", "Lcom/stripe/android/stripe3ds2/init/ui/UiCustomization;", "applyProgressBarColor$3ds2sdk_release", "setStatusBarColor", "activity", "Landroidx/appcompat/app/AppCompatActivity;", "statusBarColor", "", "darken", "color", "factor", "darken$3ds2sdk_release", "colorIntToHex", "", "buildStyledText", "Landroid/text/SpannableString;", "context", "Landroid/content/Context;", "text", "customization", "Lcom/stripe/android/stripe3ds2/init/ui/Customization;", "requireValidColor", "hexColor", "requireValidFontSize", "fontSize", "requireValidDimension", "dimension", "requireValidString", "string", "3ds2sdk_release"})
@SourceDebugExtension(value={"SMAP\nCustomizeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomizeUtils.kt\ncom/stripe/android/stripe3ds2/utils/CustomizeUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,212:1\n1#2:213\n*E\n"})
public final class CustomizeUtils {
    @NotNull
    public static final CustomizeUtils INSTANCE = new CustomizeUtils();
    private static final float DEFAULT_DARKEN_FACTOR = 0.8f;

    private CustomizeUtils() {
    }

    public final void applyProgressBarColor$3ds2sdk_release(@NotNull ProgressBar progressBar, @Nullable UiCustomization uiCustomization) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)progressBar, (String)"progressBar");
            Object object = uiCustomization;
            if (object == null || (object = object.getAccentColor()) == null) break block0;
            Object accentColor = object;
            boolean bl = false;
            progressBar.setIndeterminateTintList(ColorStateList.valueOf((int)Color.parseColor((String)accentColor)));
        }
    }

    public final void setStatusBarColor(@NotNull AppCompatActivity activity, @ColorInt int statusBarColor) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (Build.VERSION.SDK_INT <= 34) {
            activity.getWindow().setStatusBarColor(statusBarColor);
        }
    }

    @ColorInt
    public final int darken$3ds2sdk_release(@ColorInt int color, float factor) {
        int alpha = Color.alpha((int)color);
        int red = (int)((float)Color.red((int)color) * factor);
        int green = (int)((float)Color.green((int)color) * factor);
        int blue = (int)((float)Color.blue((int)color) * factor);
        return Color.argb((int)alpha, (int)Math.min(Math.max(red, 0), 255), (int)Math.min(Math.max(green, 0), 255), (int)Math.min(Math.max(blue, 0), 255));
    }

    @JvmStatic
    @NotNull
    public static final String colorIntToHex(@ColorInt int color) {
        int alpha = Color.alpha((int)color);
        int blue = Color.blue((int)color);
        int green = Color.green((int)color);
        int red = Color.red((int)color);
        Locale locale = Locale.ENGLISH;
        String string2 = "%02X";
        Object[] objectArray = new Object[]{alpha};
        String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        locale = Locale.ENGLISH;
        string2 = "%02X";
        objectArray = new Object[]{red};
        String string4 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        locale = Locale.ENGLISH;
        string2 = "%02X";
        objectArray = new Object[]{green};
        String string5 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
        locale = Locale.ENGLISH;
        string2 = "%02X";
        objectArray = new Object[]{blue};
        String string6 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(...)");
        return "#" + string3 + string4 + string5 + string6;
    }

    @NotNull
    public final SpannableString buildStyledText(@NotNull Context context, @NotNull String text, @NotNull Customization customization) {
        SpannableString styledText;
        block2: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            Intrinsics.checkNotNullParameter((Object)customization, (String)"customization");
            styledText = new SpannableString((CharSequence)text);
            String string2 = customization.getTextColor();
            if (string2 != null) {
                String textColor = string2;
                boolean bl = false;
                styledText.setSpan((Object)new ForegroundColorSpan(Color.parseColor((String)textColor)), 0, styledText.length(), 0);
            }
            Integer n = customization.getTextFontSize();
            int it = ((Number)n).intValue();
            boolean bl = false;
            Integer n2 = it > 0 ? n : null;
            if (n2 != null) {
                int textFontSize = ((Number)n2).intValue();
                boolean bl2 = false;
                int fontSize = (int)TypedValue.applyDimension((int)2, (float)textFontSize, (DisplayMetrics)context.getResources().getDisplayMetrics());
                AbsoluteSizeSpan sizeSpan = new AbsoluteSizeSpan(fontSize);
                styledText.setSpan((Object)sizeSpan, 0, styledText.length(), 0);
            }
            String string3 = customization.getTextFontName();
            if (string3 == null) break block2;
            String textFontName = string3;
            boolean bl3 = false;
            styledText.setSpan((Object)new TypefaceSpan(textFontName), 0, styledText.length(), 0);
        }
        return styledText;
    }

    @ColorInt
    public final int darken$3ds2sdk_release(@ColorInt int color) {
        return this.darken$3ds2sdk_release(color, 0.8f);
    }

    @JvmStatic
    @NotNull
    public static final String requireValidColor(@NotNull String hexColor) throws InvalidInputException {
        Object $this$requireValidColor_u24lambda_u245;
        Intrinsics.checkNotNullParameter((Object)hexColor, (String)"hexColor");
        Object object = INSTANCE;
        try {
            $this$requireValidColor_u24lambda_u245 = object;
            boolean bl = false;
            Color.parseColor((String)hexColor);
            $this$requireValidColor_u24lambda_u245 = Result.constructor-impl((Object)hexColor);
        }
        catch (Throwable bl) {
            $this$requireValidColor_u24lambda_u245 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object = $this$requireValidColor_u24lambda_u245;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object);
        if (throwable != null) {
            Throwable it = throwable;
            boolean bl = false;
            throw new InvalidInputException("Unable to parse color: " + hexColor, null, 2, null);
        }
        return (String)object;
    }

    @JvmStatic
    public static final int requireValidFontSize(int fontSize) throws InvalidInputException {
        if (fontSize <= 0) {
            throw new InvalidInputException("Font size must be greater than 0", null, 2, null);
        }
        return fontSize;
    }

    @JvmStatic
    public static final int requireValidDimension(int dimension) throws InvalidInputException {
        if (dimension < 0) {
            throw new InvalidInputException("Dimension must be greater or equal to 0", null, 2, null);
        }
        return dimension;
    }

    @JvmStatic
    @NotNull
    public static final String requireValidString(@NotNull String string2) throws InvalidInputException {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"string");
        if (StringsKt.isBlank((CharSequence)string2)) {
            throw new InvalidInputException("String must not be null or empty", null, 2, null);
        }
        return string2;
    }
}

