/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.observability;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.os.Build;
import androidx.annotation.VisibleForTesting;
import com.stripe.android.stripe3ds2.observability.DefaultSentryConfig;
import com.stripe.android.stripe3ds2.observability.ErrorReporter;
import com.stripe.android.stripe3ds2.observability.SentryConfig;
import com.stripe.android.stripe3ds2.transaction.Logger;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import javax.net.ssl.HttpsURLConnection;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0000\u0018\u0000 /2\u00020\u0001:\u0003-./BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\r\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0010H\u0002J\u0010\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\u001cH\u0002J\b\u0010\"\u001a\u00020\u001cH\u0002J\u0015\u0010#\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0001\u00a2\u0006\u0002\b$J\r\u0010%\u001a\u00020\u0019H\u0001\u00a2\u0006\u0002\b&J\u0015\u0010'\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0001\u00a2\u0006\u0002\b(J\r\u0010)\u001a\u00020\rH\u0001\u00a2\u0006\u0002\b*J\u0010\u0010+\u001a\u00020\u00142\u0006\u0010,\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/stripe/android/stripe3ds2/observability/DefaultErrorReporter;", "Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;", "context", "Landroid/content/Context;", "config", "Lcom/stripe/android/stripe3ds2/observability/DefaultErrorReporter$Config;", "workContext", "Lkotlin/coroutines/CoroutineContext;", "logger", "Lcom/stripe/android/stripe3ds2/transaction/Logger;", "sentryConfig", "Lcom/stripe/android/stripe3ds2/observability/SentryConfig;", "environment", "", "localeCountry", "osVersion", "", "<init>", "(Landroid/content/Context;Lcom/stripe/android/stripe3ds2/observability/DefaultErrorReporter$Config;Lkotlin/coroutines/CoroutineContext;Lcom/stripe/android/stripe3ds2/transaction/Logger;Lcom/stripe/android/stripe3ds2/observability/SentryConfig;Ljava/lang/String;Ljava/lang/String;I)V", "reportError", "", "t", "", "send", "requestBody", "Lorg/json/JSONObject;", "logResponse", "connection", "Ljavax/net/ssl/HttpsURLConnection;", "responseCode", "getResponseBody", "responseStream", "Ljava/io/InputStream;", "createPostConnection", "openConnection", "createRequestBody", "createRequestBody$3ds2sdk_release", "createRequestContexts", "createRequestContexts$3ds2sdk_release", "createRequestStacktrace", "createRequestStacktrace$3ds2sdk_release", "createSentryAuthHeader", "createSentryAuthHeader$3ds2sdk_release", "onFailure", "exception", "Config", "EmptyConfig", "Companion", "3ds2sdk_release"})
@SourceDebugExtension(value={"SMAP\nDefaultErrorReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultErrorReporter.kt\ncom/stripe/android/stripe3ds2/observability/DefaultErrorReporter\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,247:1\n216#2,2:248\n216#2,2:250\n13402#3,2:252\n1863#4,2:254\n*S KotlinDebug\n*F\n+ 1 DefaultErrorReporter.kt\ncom/stripe/android/stripe3ds2/observability/DefaultErrorReporter\n*L\n98#1:248,2\n136#1:250,2\n178#1:252,2\n191#1:254,2\n*E\n"})
public final class DefaultErrorReporter
implements ErrorReporter {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final Config config;
    @NotNull
    private final CoroutineContext workContext;
    @NotNull
    private final Logger logger;
    @NotNull
    private final SentryConfig sentryConfig;
    @NotNull
    private final String environment;
    @NotNull
    private final String localeCountry;
    private final int osVersion;
    @NotNull
    private static final String HOST = "https://errors.stripe.com";
    @NotNull
    private static final String HTTP_METHOD = "POST";
    @NotNull
    private static final String HEADER_CONTENT_TYPE = "Content-Type";
    @NotNull
    private static final String CONTENT_TYPE = "application/json; charset=utf-8";
    @NotNull
    private static final String HEADER_USER_AGENT = "User-Agent";
    @NotNull
    private static final String USER_AGENT = "Android3ds2Sdk 21.23.1";
    @NotNull
    private static final String HEADER_SENTRY_AUTH = "X-Sentry-Auth";
    private static final String CHARSET = StandardCharsets.UTF_8.name();

    public DefaultErrorReporter(@NotNull Context context, @NotNull Config config, @NotNull CoroutineContext workContext, @NotNull Logger logger, @NotNull SentryConfig sentryConfig, @NotNull String environment, @NotNull String localeCountry, int osVersion) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)workContext, (String)"workContext");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)sentryConfig, (String)"sentryConfig");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)localeCountry, (String)"localeCountry");
        this.context = context;
        this.config = config;
        this.workContext = workContext;
        this.logger = logger;
        this.sentryConfig = sentryConfig;
        this.environment = environment;
        this.localeCountry = localeCountry;
        this.osVersion = osVersion;
    }

    public /* synthetic */ DefaultErrorReporter(Context context, Config config, CoroutineContext coroutineContext, Logger logger, SentryConfig sentryConfig, String string, String string2, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            config = EmptyConfig.INSTANCE;
        }
        if ((n2 & 4) != 0) {
            coroutineContext = (CoroutineContext)Dispatchers.getIO();
        }
        if ((n2 & 8) != 0) {
            logger = Logger.Noop.INSTANCE;
        }
        if ((n2 & 0x10) != 0) {
            sentryConfig = DefaultSentryConfig.INSTANCE;
        }
        if ((n2 & 0x20) != 0) {
            string = "release";
        }
        if ((n2 & 0x40) != 0) {
            string2 = Locale.getDefault().getCountry();
        }
        if ((n2 & 0x80) != 0) {
            n = Build.VERSION.SDK_INT;
        }
        this(context, config, coroutineContext, logger, sentryConfig, string, string2, n);
    }

    @Override
    public void reportError(@NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)this.workContext), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, t, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ DefaultErrorReporter this$0;
            final /* synthetic */ Throwable $t;
            {
                this.this$0 = $receiver;
                this.$t = $t;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Object object2;
                        CoroutineScope $this$launch;
                        ResultKt.throwOnFailure((Object)object);
                        Object object3 = $this$launch = (CoroutineScope)this.L$0;
                        DefaultErrorReporter defaultErrorReporter = this.this$0;
                        Throwable throwable = this.$t;
                        try {
                            boolean bl = false;
                            DefaultErrorReporter.access$send(defaultErrorReporter, defaultErrorReporter.createRequestBody$3ds2sdk_release(throwable));
                            object2 = Result.constructor-impl((Object)Unit.INSTANCE);
                        }
                        catch (Throwable bl) {
                            object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                        }
                        object3 = object2;
                        defaultErrorReporter = this.this$0;
                        Throwable throwable2 = Result.exceptionOrNull-impl((Object)object3);
                        if (throwable2 != null) {
                            Throwable p0 = throwable = throwable2;
                            boolean bl = false;
                            DefaultErrorReporter.access$onFailure(defaultErrorReporter, p0);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void send(JSONObject requestBody) {
        int n;
        HttpsURLConnection connection = this.createPostConnection();
        boolean bl = false;
        Closeable closeable = connection.getOutputStream();
        Throwable throwable = null;
        try {
            OutputStream os = (OutputStream)closeable;
            boolean bl2 = false;
            Intrinsics.checkNotNull((Object)os);
            Closeable closeable2 = os;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            Object object = charset;
            closeable2 = new OutputStreamWriter((OutputStream)closeable2, (Charset)object);
            object = null;
            try {
                OutputStreamWriter osw = (OutputStreamWriter)closeable2;
                boolean bl3 = false;
                osw.write(requestBody.toString());
                osw.flush();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                object = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object);
            }
            os = Unit.INSTANCE;
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        connection.connect();
        int responseCode = n = connection.getResponseCode();
        boolean bl4 = false;
        this.logResponse(connection, responseCode);
        connection.disconnect();
    }

    private final void logResponse(HttpsURLConnection connection, int responseCode) {
    }

    private final String getResponseBody(InputStream responseStream) {
        Object object;
        Object object2 = this;
        try {
            DefaultErrorReporter $this$getResponseBody_u24lambda_u245 = object2;
            boolean bl = false;
            Scanner scanner = new Scanner(responseStream, CHARSET).useDelimiter("\\A");
            object = Result.constructor-impl((Object)(scanner.hasNext() ? scanner.next() : null));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        String string = (String)(Result.isFailure-impl((Object)object2) ? null : object2);
        if (string == null) {
            string = "";
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final HttpsURLConnection createPostConnection() {
        void $this$forEach$iv;
        HttpsURLConnection httpsURLConnection;
        HttpsURLConnection $this$createPostConnection_u24lambda_u247 = httpsURLConnection = this.openConnection();
        boolean bl = false;
        $this$createPostConnection_u24lambda_u247.setRequestMethod(HTTP_METHOD);
        $this$createPostConnection_u24lambda_u247.setDoOutput(true);
        Object object = new Pair[]{TuplesKt.to((Object)HEADER_CONTENT_TYPE, (Object)CONTENT_TYPE), TuplesKt.to((Object)HEADER_USER_AGENT, (Object)USER_AGENT), TuplesKt.to((Object)HEADER_SENTRY_AUTH, (Object)this.createSentryAuthHeader$3ds2sdk_release())};
        object = MapsKt.mapOf((Pair[])object);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry entry = element$iv = iterator.next();
            boolean bl2 = false;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            $this$createPostConnection_u24lambda_u247.setRequestProperty(key, value);
        }
        return httpsURLConnection;
    }

    private final HttpsURLConnection openConnection() {
        URLConnection uRLConnection = new URL("https://errors.stripe.com/api/" + this.sentryConfig.getProjectId() + "/store/").openConnection();
        Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type javax.net.ssl.HttpsURLConnection");
        return (HttpsURLConnection)uRLConnection;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final /* synthetic */ JSONObject createRequestBody$3ds2sdk_release(Throwable t) {
        JSONObject jSONObject;
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        JSONObject jSONObject2 = new JSONObject().put("release", (Object)"com.stripe.android.stripe3ds2@21.23.1");
        JSONObject jSONObject3 = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject4 = new JSONObject().put("type", (Object)t.getClass().getCanonicalName());
        String string = t.getMessage();
        if (string == null) {
            string = "";
        }
        JSONObject jSONObject5 = jSONObject = new JSONObject().put("locale", (Object)this.localeCountry).put("environment", (Object)this.environment).put("android_os_version", this.osVersion);
        String string2 = "tags";
        JSONObject jSONObject6 = jSONObject2.put("exception", (Object)jSONObject3.put("values", (Object)jSONArray.put((Object)jSONObject4.put("value", (Object)string).put("stacktrace", (Object)this.createRequestStacktrace$3ds2sdk_release(t)))));
        boolean bl = false;
        Map<String, String> $this$forEach$iv = this.config.getCustomTags();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, String>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void it;
            Map.Entry<String, String> element$iv;
            Map.Entry<String, String> entry = element$iv = iterator.next();
            boolean bl2 = false;
            String key = entry.getKey();
            String value = entry.getValue();
            it.put(key, (Object)value);
        }
        Unit unit = Unit.INSTANCE;
        JSONObject jSONObject7 = jSONObject6.put(string2, (Object)jSONObject).put("contexts", (Object)this.createRequestContexts$3ds2sdk_release());
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject7, (String)"put(...)");
        return jSONObject7;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final /* synthetic */ JSONObject createRequestContexts$3ds2sdk_release() {
        JSONArray jSONArray;
        Object object;
        Object object2 = this;
        try {
            DefaultErrorReporter $this$createRequestContexts_u24lambda_u2410 = object2;
            boolean bl = false;
            object = Result.constructor-impl((Object)$this$createRequestContexts_u24lambda_u2410.context.getPackageManager().getPackageInfo($this$createRequestContexts_u24lambda_u2410.context.getPackageName(), 0));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        PackageInfo packageInfo = (PackageInfo)(Result.isFailure-impl((Object)object2) ? null : object2);
        PackageInfo packageInfo2 = packageInfo;
        CharSequence appName = packageInfo2 != null && (packageInfo2 = packageInfo2.applicationInfo) != null ? packageInfo2.loadLabel(this.context.getPackageManager()) : null;
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = new JSONObject().put("app_identifier", (Object)this.context.getPackageName()).put("app_name", (Object)appName);
        PackageInfo packageInfo3 = packageInfo;
        String string = packageInfo3 != null ? packageInfo3.versionName : null;
        if (string == null) {
            string = "";
        }
        JSONArray jSONArray2 = jSONArray = new JSONArray();
        String string2 = "archs";
        JSONObject jSONObject3 = new JSONObject().put("model_id", (Object)Build.ID).put("model", (Object)Build.MODEL).put("manufacturer", (Object)Build.MANUFACTURER).put("type", (Object)Build.TYPE);
        String string3 = "device";
        JSONObject jSONObject4 = jSONObject.put("app", (Object)jSONObject2.put("app_version", (Object)string)).put("os", (Object)new JSONObject().put("name", (Object)"Android").put("version", (Object)Build.VERSION.RELEASE).put("type", (Object)Build.TYPE).put("build", (Object)Build.DISPLAY));
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)Build.SUPPORTED_ABIS, (String)"SUPPORTED_ABIS");
        Object[] $this$forEach$iv = Build.SUPPORTED_ABIS;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void archs;
            String arch = (String)element$iv;
            boolean bl2 = false;
            archs.put((Object)arch);
        }
        Unit unit = Unit.INSTANCE;
        JSONObject jSONObject5 = jSONObject4.put(string3, (Object)jSONObject3.put(string2, (Object)jSONArray));
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject5, (String)"put(...)");
        return jSONObject5;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    public final /* synthetic */ JSONObject createRequestStacktrace$3ds2sdk_release(Throwable t) {
        JSONArray jSONArray;
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        JSONArray jSONArray2 = jSONArray = new JSONArray();
        String string = "frames";
        JSONObject jSONObject = new JSONObject();
        boolean bl = false;
        StackTraceElement[] stackTraceElementArray = t.getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
        Iterable $this$forEach$iv = ArraysKt.reversed((Object[])stackTraceElementArray);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void frames;
            StackTraceElement el = (StackTraceElement)element$iv;
            boolean bl2 = false;
            frames.put((Object)new JSONObject().put("lineno", el.getLineNumber()).put("filename", (Object)el.getClassName()).put("function", (Object)el.getMethodName()));
        }
        Unit unit = Unit.INSTANCE;
        JSONObject jSONObject2 = jSONObject.put(string, (Object)jSONArray);
        Intrinsics.checkNotNullExpressionValue((Object)jSONObject2, (String)"put(...)");
        return jSONObject2;
    }

    @VisibleForTesting
    public final /* synthetic */ String createSentryAuthHeader$3ds2sdk_release() {
        Object[] objectArray = new String[2];
        objectArray[0] = "Sentry";
        Object[] objectArray2 = new Pair[]{TuplesKt.to((Object)"sentry_key", (Object)this.sentryConfig.getKey()), TuplesKt.to((Object)"sentry_version", (Object)this.sentryConfig.getVersion()), TuplesKt.to((Object)"sentry_timestamp", (Object)this.sentryConfig.getTimestamp()), TuplesKt.to((Object)"sentry_client", (Object)USER_AGENT), TuplesKt.to((Object)"sentry_secret", (Object)this.sentryConfig.getSecret())};
        objectArray[1] = CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray2), (CharSequence)", ", null, null, (int)0, null, DefaultErrorReporter::createSentryAuthHeader$lambda$15, (int)30, null);
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])objectArray), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
    }

    private final void onFailure(Throwable exception) {
        this.logger.error("Failed to send error report.", exception);
    }

    private static final CharSequence createSentryAuthHeader$lambda$15(Pair pair) {
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        String key = (String)pair.component1();
        String value = (String)pair.component2();
        return key + "=" + value;
    }

    public static final /* synthetic */ void access$send(DefaultErrorReporter $this, JSONObject requestBody) {
        $this.send(requestBody);
    }

    public static final /* synthetic */ void access$onFailure(DefaultErrorReporter $this, Throwable exception) {
        $this.onFailure(exception);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\n \r*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/stripe3ds2/observability/DefaultErrorReporter$Companion;", "", "<init>", "()V", "HOST", "", "HTTP_METHOD", "HEADER_CONTENT_TYPE", "CONTENT_TYPE", "HEADER_USER_AGENT", "USER_AGENT", "HEADER_SENTRY_AUTH", "CHARSET", "kotlin.jvm.PlatformType", "Ljava/lang/String;", "3ds2sdk_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001R\u001e\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/stripe/android/stripe3ds2/observability/DefaultErrorReporter$Config;", "", "customTags", "", "", "getCustomTags", "()Ljava/util/Map;", "3ds2sdk_release"})
    public static interface Config {
        @NotNull
        public Map<String, String> getCustomTags();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R \u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/stripe/android/stripe3ds2/observability/DefaultErrorReporter$EmptyConfig;", "Lcom/stripe/android/stripe3ds2/observability/DefaultErrorReporter$Config;", "<init>", "()V", "customTags", "", "", "getCustomTags", "()Ljava/util/Map;", "3ds2sdk_release"})
    public static final class EmptyConfig
    implements Config {
        @NotNull
        public static final EmptyConfig INSTANCE = new EmptyConfig();
        @NotNull
        private static final Map<String, String> customTags = MapsKt.emptyMap();

        private EmptyConfig() {
        }

        @Override
        @NotNull
        public Map<String, String> getCustomTags() {
            return customTags;
        }
    }
}

