/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.transaction;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.jwk.ECKey;
import com.nimbusds.jose.util.JSONObjectUtils;
import com.stripe.android.stripe3ds2.observability.ErrorReporter;
import com.stripe.android.stripe3ds2.transaction.AcsData;
import com.stripe.android.stripe3ds2.transaction.AcsDataParser;
import java.security.interfaces.ECPublicKey;
import java.text.ParseException;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/stripe3ds2/transaction/DefaultAcsDataParser;", "Lcom/stripe/android/stripe3ds2/transaction/AcsDataParser;", "errorReporter", "Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;", "<init>", "(Lcom/stripe/android/stripe3ds2/observability/ErrorReporter;)V", "parse", "Lcom/stripe/android/stripe3ds2/transaction/AcsData;", "payloadJson", "Lorg/json/JSONObject;", "parsePublicKey", "Ljava/security/interfaces/ECPublicKey;", "ephemPubkey", "", "Companion", "3ds2sdk_release"})
public final class DefaultAcsDataParser
implements AcsDataParser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ErrorReporter errorReporter;
    @NotNull
    public static final String FIELD_ACS_URL = "acsURL";
    @NotNull
    public static final String FIELD_ACS_EPHEM_PUB_KEY = "acsEphemPubKey";
    @NotNull
    public static final String FIELD_SDK_EPHEM_PUB_KEY = "sdkEphemPubKey";

    public DefaultAcsDataParser(@NotNull ErrorReporter errorReporter) {
        Intrinsics.checkNotNullParameter((Object)errorReporter, (String)"errorReporter");
        this.errorReporter = errorReporter;
    }

    @Override
    @NotNull
    public AcsData parse(@NotNull JSONObject payloadJson) throws JSONException, ParseException, JOSEException {
        Object object;
        Intrinsics.checkNotNullParameter((Object)payloadJson, (String)"payloadJson");
        Object object2 = this;
        try {
            DefaultAcsDataParser $this$parse_u24lambda_u240 = object2;
            boolean bl = false;
            Map map = JSONObjectUtils.parse((String)payloadJson.toString());
            Intrinsics.checkNotNullExpressionValue((Object)map, (String)"parse(...)");
            Map payload = MapsKt.toMap((Map)map);
            object = Result.constructor-impl((Object)new AcsData(String.valueOf(payload.get(FIELD_ACS_URL)), $this$parse_u24lambda_u240.parsePublicKey(payload.get(FIELD_ACS_EPHEM_PUB_KEY)), $this$parse_u24lambda_u240.parsePublicKey(payload.get(FIELD_SDK_EPHEM_PUB_KEY))));
        }
        catch (Throwable bl) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable != null) {
            Object it = object = throwable;
            boolean bl = false;
            this.errorReporter.reportError(new IllegalArgumentException("Failed to parse ACS data: " + payloadJson, (Throwable)it));
        }
        ResultKt.throwOnFailure((Object)object2);
        return (AcsData)object2;
    }

    private final ECPublicKey parsePublicKey(Object ephemPubkey) {
        ECKey eCKey;
        if (ephemPubkey instanceof Map) {
            Object object = ephemPubkey;
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.Any>");
            eCKey = ECKey.parse((Map)((Map)object));
        } else {
            Object object = ephemPubkey;
            String string2 = object != null ? object.toString() : null;
            if (string2 == null) {
                string2 = "";
            }
            eCKey = ECKey.parse((String)string2);
        }
        ECPublicKey eCPublicKey = eCKey.toECPublicKey();
        Intrinsics.checkNotNullExpressionValue((Object)eCPublicKey, (String)"toECPublicKey(...)");
        return eCPublicKey;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/android/stripe3ds2/transaction/DefaultAcsDataParser$Companion;", "", "<init>", "()V", "FIELD_ACS_URL", "", "FIELD_ACS_EPHEM_PUB_KEY", "FIELD_SDK_EPHEM_PUB_KEY", "3ds2sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

