/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.stripe3ds2.utils;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.SpannableString;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.TypefaceSpan;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.Window;
import android.widget.ProgressBar;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.appcompat.R;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.ContextCompat;
import com.stripe.android.stripe3ds2.exceptions.InvalidInputException;
import com.stripe.android.stripe3ds2.init.ui.Customization;
import com.stripe.android.stripe3ds2.init.ui.UiCustomization;
import com.stripe.android.stripe3ds2.utils.e;
import java.util.Arrays;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J \u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0012\u0010\u0013\u001a\u00020\u00102\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0007J\u0012\u0010\u0016\u001a\u00020\u00152\b\b\u0001\u0010\u0014\u001a\u00020\u0015H\u0007J\u001a\u0010\u0016\u001a\u00020\u00152\b\b\u0001\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u0004H\u0007J\u0019\u0010\u0018\u001a\u0004\u0018\u00010\u00152\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0004\b\u0019\u0010\u001aJ#\u0010\u001b\u001a\u0004\u0018\u00010\u00152\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0001\u0010\u001c\u001a\u00020\u0015H\u0000\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u0010H\u0007J\u0010\u0010!\u001a\u00020\u00152\u0006\u0010\"\u001a\u00020\u0015H\u0007J\u0010\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u0015H\u0007J\u0010\u0010%\u001a\u00020\u00102\u0006\u0010&\u001a\u00020\u0010H\u0007J\u001a\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020)2\b\b\u0001\u0010*\u001a\u00020\u0015H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/stripe/android/stripe3ds2/utils/CustomizeUtils;", "", "()V", "DEFAULT_DARKEN_FACTOR", "", "applyProgressBarColor", "", "progressBar", "Landroid/widget/ProgressBar;", "uiCustomization", "Lcom/stripe/android/stripe3ds2/init/ui/UiCustomization;", "buildStyledText", "Landroid/text/SpannableString;", "context", "Landroid/content/Context;", "text", "", "customization", "Lcom/stripe/android/stripe3ds2/init/ui/Customization;", "colorIntToHex", "color", "", "darken", "factor", "getThemeAccentColor", "getThemeAccentColor$sdk_release", "(Landroid/content/Context;)Ljava/lang/Integer;", "getThemeColor", "colorAttrResId", "getThemeColor$sdk_release", "(Landroid/content/Context;I)Ljava/lang/Integer;", "requireValidColor", "hexColor", "requireValidDimension", "dimension", "requireValidFontSize", "fontSize", "requireValidString", "string", "setStatusBarColor", "activity", "Landroidx/appcompat/app/AppCompatActivity;", "statusBarColor", "sdk_release"})
public final class CustomizeUtils {
    public static final CustomizeUtils INSTANCE = new CustomizeUtils();

    @Nullable
    public final Integer getThemeAccentColor$sdk_release(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        int n2 = Build.VERSION.SDK_INT >= 21 ? 16843829 : R.attr.colorAccent;
        return this.getThemeColor$sdk_release(context, n2);
    }

    @Nullable
    public final Integer getThemeColor$sdk_release(@NotNull Context context, @AttrRes int n2) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        TypedValue typedValue = new TypedValue();
        if (context.getTheme().resolveAttribute(n2, typedValue, true)) {
            if (typedValue.resourceId != 0) {
                return ContextCompat.getColor((Context)context, (int)typedValue.resourceId);
            }
            return typedValue.data;
        }
        return null;
    }

    @JvmStatic
    public static final void applyProgressBarColor(@NotNull ProgressBar progressBar, @NotNull UiCustomization uiCustomization) {
        Intrinsics.checkParameterIsNotNull((Object)progressBar, (String)"progressBar");
        Intrinsics.checkParameterIsNotNull((Object)uiCustomization, (String)"uiCustomization");
        if (uiCustomization.getAccentColor() != null) {
            int n2 = Color.parseColor((String)uiCustomization.getAccentColor());
            if (Build.VERSION.SDK_INT >= 21) {
                progressBar.setIndeterminateTintList(ColorStateList.valueOf((int)n2));
                return;
            }
            Drawable drawable = progressBar.getIndeterminateDrawable().mutate();
            Intrinsics.checkExpressionValueIsNotNull((Object)drawable, (String)"progressBar.indeterminateDrawable.mutate()");
            Drawable drawable2 = drawable;
            drawable.setColorFilter(n2, PorterDuff.Mode.SRC_IN);
            progressBar.setIndeterminateDrawable(drawable2);
        }
    }

    @JvmStatic
    public static final void setStatusBarColor(@NotNull AppCompatActivity appCompatActivity, @ColorInt int n2) {
        Intrinsics.checkParameterIsNotNull((Object)appCompatActivity, (String)"activity");
        if (Build.VERSION.SDK_INT >= 21) {
            Window window = appCompatActivity.getWindow();
            Intrinsics.checkExpressionValueIsNotNull((Object)window, (String)"activity.window");
            window.setStatusBarColor(n2);
        }
    }

    @ColorInt
    public final int darken(@ColorInt int n2, float f2) {
        int n3 = Color.alpha((int)n2);
        int n4 = (int)((float)Color.red((int)n2) * f2);
        int n5 = (int)((float)Color.green((int)n2) * f2);
        n2 = (int)((float)Color.blue((int)n2) * f2);
        n4 = Math.min(Math.max(n4, 0), 255);
        int n6 = n5 = Math.max(n5, 0);
        n5 = Math.min(n6, 255);
        n2 = Math.min(Math.max(n2, 0), 255);
        return Color.argb((int)n3, (int)n4, (int)n5, (int)n2);
    }

    @JvmStatic
    @NotNull
    public static final String colorIntToHex(@ColorInt int n2) {
        int n3 = Color.alpha((int)n2);
        int n4 = Color.blue((int)n2);
        int n5 = Color.green((int)n2);
        n2 = Color.red((int)n2);
        StringBuilder stringBuilder = new StringBuilder("#");
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.ENGLISH");
        Locale locale2 = locale;
        String string = "%02X";
        Object object = new Object[]{n3};
        StringBuilder stringBuilder2 = stringBuilder;
        String string2 = String.format(locale2, string, Arrays.copyOf(object, 1));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(locale, format, *args)");
        object = string2;
        StringBuilder stringBuilder3 = stringBuilder2.append((String)object);
        Locale locale3 = Locale.ENGLISH;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale3, (String)"Locale.ENGLISH");
        locale2 = locale3;
        string = "%02X";
        object = new Object[]{n2};
        stringBuilder2 = stringBuilder3;
        String string3 = String.format(locale2, string, Arrays.copyOf(object, 1));
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(locale, format, *args)");
        object = string3;
        StringBuilder stringBuilder4 = stringBuilder2.append((String)object);
        Locale locale4 = Locale.ENGLISH;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale4, (String)"Locale.ENGLISH");
        locale2 = locale4;
        string = "%02X";
        object = new Object[]{n5};
        stringBuilder2 = stringBuilder4;
        String string4 = String.format(locale2, string, Arrays.copyOf(object, 1));
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"java.lang.String.format(locale, format, *args)");
        object = string4;
        StringBuilder stringBuilder5 = stringBuilder2.append((String)object);
        Locale locale5 = Locale.ENGLISH;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale5, (String)"Locale.ENGLISH");
        locale2 = locale5;
        string = "%02X";
        object = new Object[]{n4};
        stringBuilder2 = stringBuilder5;
        String string5 = String.format(locale2, string, Arrays.copyOf(object, 1));
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"java.lang.String.format(locale, format, *args)");
        object = string5;
        return stringBuilder2.append((String)object).toString();
    }

    @JvmStatic
    @NotNull
    public static final SpannableString buildStyledText(@NotNull Context context, @NotNull String string, @NotNull Customization customization) {
        ForegroundColorSpan foregroundColorSpan;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)customization, (String)"customization");
        string = new SpannableString((CharSequence)string);
        if (customization.getTextColor() != null) {
            int n2 = Color.parseColor((String)customization.getTextColor());
            foregroundColorSpan = new ForegroundColorSpan(n2);
            string.setSpan((Object)foregroundColorSpan, 0, string.length(), 0);
        }
        if (customization.getTextFontSize() > 0) {
            float f2 = customization.getTextFontSize();
            Resources resources = context.getResources();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
            int n3 = (int)TypedValue.applyDimension((int)2, (float)f2, (DisplayMetrics)resources.getDisplayMetrics());
            foregroundColorSpan = new AbsoluteSizeSpan(n3);
            string.setSpan((Object)foregroundColorSpan, 0, string.length(), 0);
        }
        if (customization.getTextFontName() != null) {
            foregroundColorSpan = new TypefaceSpan(customization.getTextFontName());
            string.setSpan((Object)foregroundColorSpan, 0, string.length(), 0);
        }
        return string;
    }

    @JvmStatic
    @ColorInt
    public static final int darken(@ColorInt int n2) {
        return INSTANCE.darken(n2, 0.8f);
    }

    @JvmStatic
    @NotNull
    public static final String requireValidColor(@NotNull String string) throws InvalidInputException {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"hexColor");
        try {
            Color.parseColor((String)string);
            return string;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw (Throwable)new InvalidInputException(new RuntimeException("Unable to parse color: ".concat(String.valueOf(string))));
        }
    }

    @JvmStatic
    public static final int requireValidFontSize(int n2) throws InvalidInputException {
        if (n2 <= 0) {
            throw (Throwable)new InvalidInputException(new RuntimeException("Font size must be greater than 0"));
        }
        return n2;
    }

    @JvmStatic
    public static final int requireValidDimension(int n2) throws InvalidInputException {
        if (n2 < 0) {
            throw (Throwable)new InvalidInputException(new RuntimeException("Dimension must be greater or equal to 0"));
        }
        return n2;
    }

    @JvmStatic
    @NotNull
    public static final String requireValidString(@NotNull String string) throws InvalidInputException {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"string");
        if (e.a(string)) {
            throw (Throwable)new InvalidInputException(new RuntimeException("String must not be null or empty"));
        }
        return string;
    }

    private CustomizeUtils() {
    }
}

