/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.viewmodels;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.strings.ResolvableString;
import com.stripe.android.lpmfoundations.paymentmethod.CustomerMetadata;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.paymentsheet.PaymentOptionsItem;
import com.stripe.android.paymentsheet.PaymentOptionsStateFactory;
import com.stripe.android.paymentsheet.state.CustomerState;
import com.stripe.android.uicore.utils.StateFlowsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001Bw\u0012\u000e\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\u000e\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0003\u0012\u001a\u0010\n\u001a\u0016\u0012\f\u0012\n\u0018\u00010\fj\u0004\u0018\u0001`\r\u0012\u0004\u0012\u00020\u000e0\u000b\u0012\u0006\u0010\u000f\u001a\u00020\b\u0012\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\u0003H\u0086\u0002J?\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00152\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00152\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u001a\u001a\u0004\u0018\u00010\fH\u0002\u00a2\u0006\u0002\u0010\u001bR\u0016\u0010\u0002\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\n\u001a\u0016\u0012\f\u0012\n\u0018\u00010\fj\u0004\u0018\u0001`\r\u0012\u0004\u0012\u00020\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/stripe/android/paymentsheet/viewmodels/PaymentOptionsItemsMapper;", "", "customerMetadata", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/stripe/android/lpmfoundations/paymentmethod/CustomerMetadata;", "customerState", "Lcom/stripe/android/paymentsheet/state/CustomerState;", "isGooglePayReady", "", "isLinkEnabled", "nameProvider", "Lkotlin/Function1;", "", "Lcom/stripe/android/model/PaymentMethodCode;", "Lcom/stripe/android/core/strings/ResolvableString;", "isNotPaymentFlow", "isCbcEligible", "Lkotlin/Function0;", "<init>", "(Lkotlinx/coroutines/flow/StateFlow;Lkotlinx/coroutines/flow/StateFlow;Lkotlinx/coroutines/flow/StateFlow;Lkotlinx/coroutines/flow/StateFlow;Lkotlin/jvm/functions/Function1;ZLkotlin/jvm/functions/Function0;)V", "invoke", "", "Lcom/stripe/android/paymentsheet/PaymentOptionsItem;", "createPaymentOptionsItems", "paymentMethods", "Lcom/stripe/android/model/PaymentMethod;", "defaultPaymentMethodId", "(Ljava/util/List;Ljava/lang/Boolean;ZLjava/lang/String;)Ljava/util/List;", "paymentsheet_release"})
@StabilityInferred(parameters=0)
public final class PaymentOptionsItemsMapper {
    @NotNull
    private final StateFlow<CustomerMetadata> customerMetadata;
    @NotNull
    private final StateFlow<CustomerState> customerState;
    @NotNull
    private final StateFlow<Boolean> isGooglePayReady;
    @NotNull
    private final StateFlow<Boolean> isLinkEnabled;
    @NotNull
    private final Function1<String, ResolvableString> nameProvider;
    private final boolean isNotPaymentFlow;
    @NotNull
    private final Function0<Boolean> isCbcEligible;
    public static final int $stable = 8;

    public PaymentOptionsItemsMapper(@NotNull StateFlow<CustomerMetadata> customerMetadata, @NotNull StateFlow<CustomerState> customerState, @NotNull StateFlow<Boolean> isGooglePayReady2, @NotNull StateFlow<Boolean> isLinkEnabled, @NotNull Function1<? super String, ? extends ResolvableString> nameProvider, boolean isNotPaymentFlow, @NotNull Function0<Boolean> isCbcEligible) {
        Intrinsics.checkNotNullParameter(customerMetadata, (String)"customerMetadata");
        Intrinsics.checkNotNullParameter(customerState, (String)"customerState");
        Intrinsics.checkNotNullParameter(isGooglePayReady2, (String)"isGooglePayReady");
        Intrinsics.checkNotNullParameter(isLinkEnabled, (String)"isLinkEnabled");
        Intrinsics.checkNotNullParameter(nameProvider, (String)"nameProvider");
        Intrinsics.checkNotNullParameter(isCbcEligible, (String)"isCbcEligible");
        this.customerMetadata = customerMetadata;
        this.customerState = customerState;
        this.isGooglePayReady = isGooglePayReady2;
        this.isLinkEnabled = isLinkEnabled;
        this.nameProvider = nameProvider;
        this.isNotPaymentFlow = isNotPaymentFlow;
        this.isCbcEligible = isCbcEligible;
    }

    @NotNull
    public final StateFlow<List<PaymentOptionsItem>> invoke() {
        return StateFlowsKt.combineAsStateFlow(this.customerState, this.isLinkEnabled, this.isGooglePayReady, this.customerMetadata, (arg_0, arg_1, arg_2, arg_3) -> PaymentOptionsItemsMapper.invoke$lambda$0(this, arg_0, arg_1, arg_2, arg_3));
    }

    private final List<PaymentOptionsItem> createPaymentOptionsItems(List<PaymentMethod> paymentMethods, Boolean isLinkEnabled, boolean isGooglePayReady2, String defaultPaymentMethodId) {
        if (isLinkEnabled == null) {
            return null;
        }
        return PaymentOptionsStateFactory.INSTANCE.createPaymentOptionsList(paymentMethods, isGooglePayReady2 && this.isNotPaymentFlow, isLinkEnabled != false && this.isNotPaymentFlow, this.nameProvider, (Boolean)this.isCbcEligible.invoke(), defaultPaymentMethodId);
    }

    private static final List invoke$lambda$0(PaymentOptionsItemsMapper this$0, CustomerState customerState, Boolean isLinkEnabled, boolean isGooglePayReady2, CustomerMetadata customerMetadata) {
        List list;
        String string2;
        Object object = customerState;
        if (object == null || (object = ((CustomerState)object).getPaymentMethods()) == null) {
            object = CollectionsKt.emptyList();
        }
        CustomerMetadata customerMetadata2 = customerMetadata;
        boolean bl = customerMetadata2 != null ? customerMetadata2.isPaymentMethodSetAsDefaultEnabled() : false;
        if (bl) {
            CustomerState customerState2 = customerState;
            string2 = customerState2 != null ? customerState2.getDefaultPaymentMethodId() : null;
        } else {
            string2 = null;
        }
        if ((list = this$0.createPaymentOptionsItems((List<PaymentMethod>)object, isLinkEnabled, isGooglePayReady2, string2)) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }
}

