/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.utils;

import com.stripe.android.paymentelement.confirmation.ConfirmationHandler;
import com.stripe.android.paymentsheet.analytics.EventReporter;
import com.stripe.android.paymentsheet.analytics.PaymentSheetConfirmationError;
import com.stripe.android.paymentsheet.model.PaymentSelection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u0002H\u0000\u001a\u001e\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0000\u00a8\u0006\n"}, d2={"toConfirmationError", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetConfirmationError;", "Lcom/stripe/android/paymentelement/confirmation/ConfirmationHandler$Result$Failed;", "reportPaymentResult", "", "Lcom/stripe/android/paymentsheet/analytics/EventReporter;", "result", "Lcom/stripe/android/paymentelement/confirmation/ConfirmationHandler$Result;", "paymentSelection", "Lcom/stripe/android/paymentsheet/model/PaymentSelection;", "paymentsheet_release"})
public final class ConfirmationReportingUtilsKt {
    @Nullable
    public static final PaymentSheetConfirmationError toConfirmationError(@NotNull ConfirmationHandler.Result.Failed $this$toConfirmationError) {
        PaymentSheetConfirmationError paymentSheetConfirmationError;
        Intrinsics.checkNotNullParameter((Object)$this$toConfirmationError, (String)"<this>");
        ConfirmationHandler.Result.Failed.ErrorType errorType = $this$toConfirmationError.getType();
        if (Intrinsics.areEqual((Object)errorType, (Object)ConfirmationHandler.Result.Failed.ErrorType.ExternalPaymentMethod.INSTANCE)) {
            paymentSheetConfirmationError = PaymentSheetConfirmationError.ExternalPaymentMethod.INSTANCE;
        } else if (Intrinsics.areEqual((Object)errorType, (Object)ConfirmationHandler.Result.Failed.ErrorType.Payment.INSTANCE)) {
            paymentSheetConfirmationError = new PaymentSheetConfirmationError.Stripe($this$toConfirmationError.getCause());
        } else if (errorType instanceof ConfirmationHandler.Result.Failed.ErrorType.GooglePay) {
            paymentSheetConfirmationError = new PaymentSheetConfirmationError.GooglePay(((ConfirmationHandler.Result.Failed.ErrorType.GooglePay)$this$toConfirmationError.getType()).getErrorCode());
        } else if (Intrinsics.areEqual((Object)errorType, (Object)ConfirmationHandler.Result.Failed.ErrorType.Internal.INSTANCE) || Intrinsics.areEqual((Object)errorType, (Object)ConfirmationHandler.Result.Failed.ErrorType.MerchantIntegration.INSTANCE) || Intrinsics.areEqual((Object)errorType, (Object)ConfirmationHandler.Result.Failed.ErrorType.Fatal.INSTANCE)) {
            paymentSheetConfirmationError = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return paymentSheetConfirmationError;
    }

    public static final void reportPaymentResult(@NotNull EventReporter $this$reportPaymentResult, @NotNull ConfirmationHandler.Result result2, @Nullable PaymentSelection paymentSelection2) {
        Intrinsics.checkNotNullParameter((Object)$this$reportPaymentResult, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        ConfirmationHandler.Result result3 = result2;
        if (result3 instanceof ConfirmationHandler.Result.Succeeded) {
            $this$reportPaymentResult.onPaymentSuccess(paymentSelection2, ((ConfirmationHandler.Result.Succeeded)result2).getDeferredIntentConfirmationType());
        } else if (result3 instanceof ConfirmationHandler.Result.Failed) {
            PaymentSheetConfirmationError paymentSheetConfirmationError = ConfirmationReportingUtilsKt.toConfirmationError((ConfirmationHandler.Result.Failed)result2);
            if (paymentSheetConfirmationError != null) {
                PaymentSheetConfirmationError confirmationError = paymentSheetConfirmationError;
                boolean bl = false;
                $this$reportPaymentResult.onPaymentFailure(paymentSelection2, confirmationError);
            }
        } else if (!(result3 instanceof ConfirmationHandler.Result.Canceled)) {
            throw new NoWhenBranchMatchedException();
        }
    }
}

