/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.ui;

import androidx.compose.runtime.Composable;
import androidx.compose.runtime.ComposableTarget;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.RecomposeScopeImplKt;
import androidx.compose.runtime.ScopeUpdateScope;
import androidx.compose.ui.res.StringResources_androidKt;
import com.stripe.android.R;
import com.stripe.android.core.strings.ResolvableString;
import com.stripe.android.core.strings.ResolvableStringUtilsKt;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.paymentsheet.DisplayableSavedPaymentMethod;
import com.stripe.android.paymentsheet.R;
import com.stripe.android.ui.core.elements.SimpleDialogElementUIKt;
import com.stripe.android.uicore.strings.ResolvableStringComposeUtilsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a1\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00010\u0005H\u0001\u00a2\u0006\u0002\u0010\u0007\u001a\f\u0010\b\u001a\u00020\t*\u00020\u0003H\u0002\u001a\f\u0010\n\u001a\u00020\t*\u00020\u0003H\u0002\u00a8\u0006\u000b"}, d2={"RemovePaymentMethodDialogUI", "", "paymentMethod", "Lcom/stripe/android/paymentsheet/DisplayableSavedPaymentMethod;", "onConfirmListener", "Lkotlin/Function0;", "onDismissListener", "(Lcom/stripe/android/paymentsheet/DisplayableSavedPaymentMethod;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;Landroidx/compose/runtime/Composer;I)V", "getRemoveDialogTitle", "Lcom/stripe/android/core/strings/ResolvableString;", "getRemoveDialogDescription", "paymentsheet_release"})
public final class RemovePaymentMethodDialogUIKt {
    @Composable
    @ComposableTarget(applier="androidx.compose.ui.UiComposable")
    public static final void RemovePaymentMethodDialogUI(@NotNull DisplayableSavedPaymentMethod paymentMethod, @NotNull Function0<Unit> onConfirmListener, @NotNull Function0<Unit> onDismissListener, @Nullable Composer $composer, int $changed) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
            Intrinsics.checkNotNullParameter(onConfirmListener, (String)"onConfirmListener");
            Intrinsics.checkNotNullParameter(onDismissListener, (String)"onDismissListener");
            $composer = $composer.startRestartGroup(-404084240);
            int $dirty = $changed;
            if (($changed & 6) == 0) {
                $dirty |= $composer.changedInstance((Object)paymentMethod) ? 4 : 2;
            }
            if (($changed & 0x30) == 0) {
                $dirty |= $composer.changedInstance(onConfirmListener) ? 32 : 16;
            }
            if (($changed & 0x180) == 0) {
                $dirty |= $composer.changedInstance(onDismissListener) ? 256 : 128;
            }
            if (($dirty & 0x93) != 146 || !$composer.getSkipping()) {
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventStart((int)-404084240, (int)$dirty, (int)-1, (String)"com.stripe.android.paymentsheet.ui.RemovePaymentMethodDialogUI (RemovePaymentMethodDialogUI.kt:17)");
                }
                String removeTitle = ResolvableStringComposeUtilsKt.resolve((ResolvableString)RemovePaymentMethodDialogUIKt.getRemoveDialogTitle(paymentMethod), (Composer)$composer, (int)0);
                String messageText = ResolvableStringComposeUtilsKt.resolve((ResolvableString)RemovePaymentMethodDialogUIKt.getRemoveDialogDescription(paymentMethod), (Composer)$composer, (int)0);
                SimpleDialogElementUIKt.SimpleDialogElementUI((String)removeTitle, (String)messageText, (String)StringResources_androidKt.stringResource((int)R.string.stripe_remove, (Composer)$composer, (int)0), (String)StringResources_androidKt.stringResource((int)R.string.stripe_cancel, (Composer)$composer, (int)0), (boolean)true, onConfirmListener, onDismissListener, (Composer)$composer, (int)(0x6000 | 0x70000 & $dirty << 12 | 0x380000 & $dirty << 12), (int)0);
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventEnd();
                }
            } else {
                $composer.skipToGroupEnd();
            }
            ScopeUpdateScope scopeUpdateScope = $composer.endRestartGroup();
            if (scopeUpdateScope == null) break block7;
            scopeUpdateScope.updateScope((arg_0, arg_1) -> RemovePaymentMethodDialogUIKt.RemovePaymentMethodDialogUI$lambda$0(paymentMethod, onConfirmListener, onDismissListener, $changed, arg_0, arg_1));
        }
    }

    private static final ResolvableString getRemoveDialogTitle(DisplayableSavedPaymentMethod $this$getRemoveDialogTitle) {
        ResolvableString resolvableString;
        PaymentMethod.Type type = $this$getRemoveDialogTitle.getPaymentMethod().type;
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                resolvableString = ResolvableStringUtilsKt.resolvableString$default((int)R.string.stripe_paymentsheet_remove_card_title, (Object[])new Object[0], null, (int)4, null);
                break;
            }
            case 2: 
            case 3: {
                resolvableString = ResolvableStringUtilsKt.resolvableString$default((int)R.string.stripe_paymentsheet_remove_bank_account_question_title, (Object[])new Object[0], null, (int)4, null);
                break;
            }
            default: {
                resolvableString = ResolvableStringUtilsKt.resolvableString((String)"", (Object[])new Object[0]);
            }
        }
        return resolvableString;
    }

    private static final ResolvableString getRemoveDialogDescription(DisplayableSavedPaymentMethod $this$getRemoveDialogDescription) {
        ResolvableString resolvableString;
        PaymentMethod.Type type = $this$getRemoveDialogDescription.getPaymentMethod().type;
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                Object[] objectArray = new Object[2];
                objectArray[0] = $this$getRemoveDialogDescription.brandDisplayName();
                PaymentMethod.Card card = $this$getRemoveDialogDescription.getPaymentMethod().card;
                objectArray[1] = card != null ? card.last4 : null;
                resolvableString = ResolvableStringUtilsKt.resolvableString$default((int)R.string.stripe_card_with_last_4, (Object[])objectArray, null, (int)4, null);
                break;
            }
            case 2: {
                Object[] objectArray = new Object[1];
                PaymentMethod.SepaDebit sepaDebit = $this$getRemoveDialogDescription.getPaymentMethod().sepaDebit;
                objectArray[0] = sepaDebit != null ? sepaDebit.last4 : null;
                resolvableString = ResolvableStringUtilsKt.resolvableString$default((int)R.string.stripe_bank_account_with_last_4, (Object[])objectArray, null, (int)4, null);
                break;
            }
            case 3: {
                Object[] objectArray = new Object[1];
                PaymentMethod.USBankAccount uSBankAccount = $this$getRemoveDialogDescription.getPaymentMethod().usBankAccount;
                objectArray[0] = uSBankAccount != null ? uSBankAccount.last4 : null;
                resolvableString = ResolvableStringUtilsKt.resolvableString$default((int)R.string.stripe_bank_account_with_last_4, (Object[])objectArray, null, (int)4, null);
                break;
            }
            default: {
                resolvableString = ResolvableStringUtilsKt.resolvableString((String)"", (Object[])new Object[0]);
            }
        }
        return resolvableString;
    }

    private static final Unit RemovePaymentMethodDialogUI$lambda$0(DisplayableSavedPaymentMethod $paymentMethod, Function0 $onConfirmListener, Function0 $onDismissListener, int $$changed, Composer $composer, int $force) {
        RemovePaymentMethodDialogUIKt.RemovePaymentMethodDialogUI($paymentMethod, (Function0<Unit>)$onConfirmListener, (Function0<Unit>)$onDismissListener, $composer, RecomposeScopeImplKt.updateChangedFlags((int)($$changed | 1)));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PaymentMethod.Type.values().length];
            try {
                nArray[PaymentMethod.Type.Card.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentMethod.Type.SepaDebit.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentMethod.Type.USBankAccount.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

