/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.ui;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.CardBrandFilter;
import com.stripe.android.core.utils.DateUtils;
import com.stripe.android.model.CardBrand;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.paymentsheet.CardUpdateParams;
import com.stripe.android.paymentsheet.ui.CardBrandChoice;
import com.stripe.android.paymentsheet.ui.CardDetailsEntry;
import com.stripe.android.paymentsheet.ui.CardDetailsEntryKt;
import com.stripe.android.paymentsheet.ui.EditCardDetailsInteractor;
import com.stripe.android.paymentsheet.ui.ExpiryDateState;
import com.stripe.android.paymentsheet.ui.PaymentMethodCardKtxKt;
import com.stripe.android.paymentsheet.ui.PaymentMethodsUiExtensionKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.SharingStarted;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001:\u0001,Ba\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0016\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u0002`\u000f\u0012\u0018\u0010\u0010\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0004\u0012\u00020\u000e0\fj\u0002`\u0012\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u000b\u001a\u00020\u000e2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u000e2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020\u0017H\u0002J\b\u0010&\u001a\u00020\u001eH\u0002J\b\u0010'\u001a\u00020(H\u0002J\u001c\u0010)\u001a\u00020\u001a2\b\b\u0002\u0010\u001d\u001a\u00020\u001e2\b\b\u0002\u0010*\u001a\u00020(H\u0002J\b\u0010+\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u0012\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fj\u0002`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0004\u0012\u00020\u000e0\fj\u0002`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006-"}, d2={"Lcom/stripe/android/paymentsheet/ui/DefaultEditCardDetailsInteractor;", "Lcom/stripe/android/paymentsheet/ui/EditCardDetailsInteractor;", "card", "Lcom/stripe/android/model/PaymentMethod$Card;", "cardBrandFilter", "Lcom/stripe/android/CardBrandFilter;", "isModifiable", "", "areExpiryDateAndAddressModificationSupported", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "onBrandChoiceChanged", "Lkotlin/Function1;", "Lcom/stripe/android/model/CardBrand;", "", "Lcom/stripe/android/paymentsheet/ui/CardBrandCallback;", "onCardUpdateParamsChanged", "Lcom/stripe/android/paymentsheet/CardUpdateParams;", "Lcom/stripe/android/paymentsheet/ui/CardUpdateParamsCallback;", "<init>", "(Lcom/stripe/android/model/PaymentMethod$Card;Lcom/stripe/android/CardBrandFilter;ZZLkotlinx/coroutines/CoroutineScope;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "cardDetailsEntry", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/stripe/android/paymentsheet/ui/CardDetailsEntry;", "state", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/stripe/android/paymentsheet/ui/EditCardDetailsInteractor$State;", "getState", "()Lkotlinx/coroutines/flow/StateFlow;", "cardBrandChoice", "Lcom/stripe/android/paymentsheet/ui/CardBrandChoice;", "onDateChanged", "text", "", "handleViewAction", "viewAction", "Lcom/stripe/android/paymentsheet/ui/EditCardDetailsInteractor$ViewAction;", "buildDefaultCardEntry", "defaultCardBrandChoice", "defaultExpiryDateState", "Lcom/stripe/android/paymentsheet/ui/ExpiryDateState;", "uiState", "expiryDateState", "isExpired", "Factory", "paymentsheet_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nEditCardDetailsInteractor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditCardDetailsInteractor.kt\ncom/stripe/android/paymentsheet/ui/DefaultEditCardDetailsInteractor\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,194:1\n230#2,5:195\n230#2,5:200\n*S KotlinDebug\n*F\n+ 1 EditCardDetailsInteractor.kt\ncom/stripe/android/paymentsheet/ui/DefaultEditCardDetailsInteractor\n*L\n104#1:195,5\n112#1:200,5\n*E\n"})
public final class DefaultEditCardDetailsInteractor
implements EditCardDetailsInteractor {
    @NotNull
    private final PaymentMethod.Card card;
    @NotNull
    private final CardBrandFilter cardBrandFilter;
    private final boolean isModifiable;
    private final boolean areExpiryDateAndAddressModificationSupported;
    @NotNull
    private final Function1<CardBrand, Unit> onBrandChoiceChanged;
    @NotNull
    private final Function1<CardUpdateParams, Unit> onCardUpdateParamsChanged;
    @NotNull
    private final MutableStateFlow<CardDetailsEntry> cardDetailsEntry;
    @NotNull
    private final StateFlow<EditCardDetailsInteractor.State> state;
    public static final int $stable = 8;

    public DefaultEditCardDetailsInteractor(@NotNull PaymentMethod.Card card, @NotNull CardBrandFilter cardBrandFilter, boolean isModifiable, boolean areExpiryDateAndAddressModificationSupported, @NotNull CoroutineScope coroutineScope, @NotNull Function1<? super CardBrand, Unit> onBrandChoiceChanged, @NotNull Function1<? super CardUpdateParams, Unit> onCardUpdateParamsChanged) {
        Intrinsics.checkNotNullParameter((Object)card, (String)"card");
        Intrinsics.checkNotNullParameter((Object)cardBrandFilter, (String)"cardBrandFilter");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter(onBrandChoiceChanged, (String)"onBrandChoiceChanged");
        Intrinsics.checkNotNullParameter(onCardUpdateParamsChanged, (String)"onCardUpdateParamsChanged");
        this.card = card;
        this.cardBrandFilter = cardBrandFilter;
        this.isModifiable = isModifiable;
        this.areExpiryDateAndAddressModificationSupported = areExpiryDateAndAddressModificationSupported;
        this.onBrandChoiceChanged = onBrandChoiceChanged;
        this.onCardUpdateParamsChanged = onCardUpdateParamsChanged;
        this.cardDetailsEntry = StateFlowKt.MutableStateFlow((Object)this.buildDefaultCardEntry());
        this.state = FlowKt.stateIn((Flow)FlowKt.mapLatest((Flow)((Flow)this.cardDetailsEntry), (Function2)((Function2)new Function2<CardDetailsEntry, Continuation<? super EditCardDetailsInteractor.State>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ DefaultEditCardDetailsInteractor this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CardDetailsEntry inputState = (CardDetailsEntry)this.L$0;
                        return DefaultEditCardDetailsInteractor.access$uiState(this.this$0, inputState.getCardBrandChoice(), inputState.getExpiryDateState());
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CardDetailsEntry p1, Continuation<? super EditCardDetailsInteractor.State> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })), (CoroutineScope)coroutineScope, (SharingStarted)SharingStarted.Companion.getEagerly(), (Object)DefaultEditCardDetailsInteractor.uiState$default(this, null, null, 3, null));
        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getMain()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ DefaultEditCardDetailsInteractor this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FlowKt.collectLatest((Flow)((Flow)this.this$0.cardDetailsEntry), (Function2)((Function2)new Function2<CardDetailsEntry, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ DefaultEditCardDetailsInteractor this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        CardDetailsEntry state2;
                                        ResultKt.throwOnFailure((Object)object);
                                        CardDetailsEntry cardDetailsEntry = state2 = (CardDetailsEntry)this.L$0;
                                        DefaultEditCardDetailsInteractor defaultEditCardDetailsInteractor = this.this$0;
                                        CardDetailsEntry it = cardDetailsEntry;
                                        boolean bl = false;
                                        boolean hasChanged = it.hasChanged(defaultEditCardDetailsInteractor.card, defaultEditCardDetailsInteractor.defaultCardBrandChoice());
                                        boolean isComplete = it.isComplete();
                                        CardDetailsEntry cardDetailsEntry2 = hasChanged && isComplete ? cardDetailsEntry : null;
                                        CardUpdateParams newParams = cardDetailsEntry2 != null ? CardDetailsEntryKt.toUpdateParams(cardDetailsEntry2) : null;
                                        this.this$0.onCardUpdateParamsChanged.invoke((Object)newParams);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(CardDetailsEntry p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @Override
    @NotNull
    public StateFlow<EditCardDetailsInteractor.State> getState() {
        return this.state;
    }

    private final void onBrandChoiceChanged(CardBrandChoice cardBrandChoice) {
        CardDetailsEntry it;
        CardDetailsEntry nextValue$iv;
        Object prevValue$iv;
        if (!Intrinsics.areEqual((Object)cardBrandChoice, (Object)((EditCardDetailsInteractor.State)this.getState().getValue()).getSelectedCardBrand())) {
            this.onBrandChoiceChanged.invoke((Object)cardBrandChoice.getBrand());
        }
        MutableStateFlow<CardDetailsEntry> $this$update$iv = this.cardDetailsEntry;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (CardDetailsEntry)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = CardDetailsEntry.copy$default(it, cardBrandChoice, null, 2, null))));
    }

    private final void onDateChanged(String text) {
        CardDetailsEntry entry;
        CardDetailsEntry nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<CardDetailsEntry> $this$update$iv = this.cardDetailsEntry;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            entry = (CardDetailsEntry)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = CardDetailsEntry.copy$default(entry, null, entry.getExpiryDateState().onDateChanged(text), 1, null))));
    }

    @Override
    public void handleViewAction(@NotNull EditCardDetailsInteractor.ViewAction viewAction) {
        Intrinsics.checkNotNullParameter((Object)viewAction, (String)"viewAction");
        EditCardDetailsInteractor.ViewAction viewAction2 = viewAction;
        if (viewAction2 instanceof EditCardDetailsInteractor.ViewAction.BrandChoiceChanged) {
            this.onBrandChoiceChanged(((EditCardDetailsInteractor.ViewAction.BrandChoiceChanged)viewAction).getCardBrandChoice());
        } else if (viewAction2 instanceof EditCardDetailsInteractor.ViewAction.DateChanged) {
            this.onDateChanged(((EditCardDetailsInteractor.ViewAction.DateChanged)viewAction).getText());
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final CardDetailsEntry buildDefaultCardEntry() {
        return new CardDetailsEntry(this.defaultCardBrandChoice(), this.defaultExpiryDateState());
    }

    private final CardBrandChoice defaultCardBrandChoice() {
        return PaymentMethodCardKtxKt.getPreferredChoice(this.card, this.cardBrandFilter);
    }

    private final ExpiryDateState defaultExpiryDateState() {
        return ExpiryDateState.Companion.create(this.card, this.areExpiryDateAndAddressModificationSupported);
    }

    private final EditCardDetailsInteractor.State uiState(CardBrandChoice cardBrandChoice, ExpiryDateState expiryDateState) {
        return new EditCardDetailsInteractor.State(this.card, cardBrandChoice, PaymentMethodsUiExtensionKt.getSavedPaymentMethodIcon$default(this.card, true, null, 2, null), this.isModifiable && !this.isExpired(), PaymentMethodCardKtxKt.getAvailableNetworks(this.card, this.cardBrandFilter), expiryDateState);
    }

    static /* synthetic */ EditCardDetailsInteractor.State uiState$default(DefaultEditCardDetailsInteractor defaultEditCardDetailsInteractor, CardBrandChoice cardBrandChoice, ExpiryDateState expiryDateState, int n, Object object) {
        if ((n & 1) != 0) {
            cardBrandChoice = defaultEditCardDetailsInteractor.defaultCardBrandChoice();
        }
        if ((n & 2) != 0) {
            expiryDateState = defaultEditCardDetailsInteractor.defaultExpiryDateState();
        }
        return defaultEditCardDetailsInteractor.uiState(cardBrandChoice, expiryDateState);
    }

    private final boolean isExpired() {
        Integer cardExpiryMonth = this.card.expiryMonth;
        Integer cardExpiryYear = this.card.expiryYear;
        return cardExpiryMonth != null && cardExpiryYear != null && !DateUtils.isExpiryDataValid((int)cardExpiryMonth, (int)cardExpiryYear);
    }

    public static final /* synthetic */ EditCardDetailsInteractor.State access$uiState(DefaultEditCardDetailsInteractor $this, CardBrandChoice cardBrandChoice, ExpiryDateState expiryDateState) {
        return $this.uiState(cardBrandChoice, expiryDateState);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003Jb\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0016\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010j\u0002`\u00132\u0018\u0010\u0014\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0015\u0012\u0004\u0012\u00020\u00120\u0010j\u0002`\u0016H\u0016\u00a8\u0006\u0017"}, d2={"Lcom/stripe/android/paymentsheet/ui/DefaultEditCardDetailsInteractor$Factory;", "Lcom/stripe/android/paymentsheet/ui/EditCardDetailsInteractor$Factory;", "<init>", "()V", "create", "Lcom/stripe/android/paymentsheet/ui/EditCardDetailsInteractor;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "isModifiable", "", "areExpiryDateAndAddressModificationSupported", "cardBrandFilter", "Lcom/stripe/android/CardBrandFilter;", "card", "Lcom/stripe/android/model/PaymentMethod$Card;", "onBrandChoiceChanged", "Lkotlin/Function1;", "Lcom/stripe/android/model/CardBrand;", "", "Lcom/stripe/android/paymentsheet/ui/CardBrandCallback;", "onCardUpdateParamsChanged", "Lcom/stripe/android/paymentsheet/CardUpdateParams;", "Lcom/stripe/android/paymentsheet/ui/CardUpdateParamsCallback;", "paymentsheet_release"})
    @StabilityInferred(parameters=1)
    public static final class Factory
    implements EditCardDetailsInteractor.Factory {
        public static final int $stable;

        @Override
        @NotNull
        public EditCardDetailsInteractor create(@NotNull CoroutineScope coroutineScope, boolean isModifiable, boolean areExpiryDateAndAddressModificationSupported, @NotNull CardBrandFilter cardBrandFilter, @NotNull PaymentMethod.Card card, @NotNull Function1<? super CardBrand, Unit> onBrandChoiceChanged, @NotNull Function1<? super CardUpdateParams, Unit> onCardUpdateParamsChanged) {
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            Intrinsics.checkNotNullParameter((Object)cardBrandFilter, (String)"cardBrandFilter");
            Intrinsics.checkNotNullParameter((Object)card, (String)"card");
            Intrinsics.checkNotNullParameter(onBrandChoiceChanged, (String)"onBrandChoiceChanged");
            Intrinsics.checkNotNullParameter(onCardUpdateParamsChanged, (String)"onCardUpdateParamsChanged");
            return new DefaultEditCardDetailsInteractor(card, cardBrandFilter, isModifiable, areExpiryDateAndAddressModificationSupported, coroutineScope, onBrandChoiceChanged, onCardUpdateParamsChanged);
        }
    }
}

