/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.state;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.common.model.CommonConfiguration;
import com.stripe.android.lpmfoundations.paymentmethod.PaymentMethodMetadata;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.paymentsheet.model.PaymentSelection;
import com.stripe.android.paymentsheet.state.CustomerState;
import com.stripe.android.paymentsheet.state.PaymentElementLoader;
import com.stripe.android.paymentsheet.state.PaymentSheetLoadingException;
import java.io.Serializable;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bp\u0018\u00002\u00020\u0001:\u0002\u0002\u0003\u0082\u0001\u0002\u0004\u0005\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/paymentsheet/state/PaymentSheetState;", "Landroid/os/Parcelable;", "Loading", "Full", "Lcom/stripe/android/paymentsheet/state/PaymentSheetState$Full;", "Lcom/stripe/android/paymentsheet/state/PaymentSheetState$Loading;", "paymentsheet_release"})
public interface PaymentSheetState
extends Parcelable {

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rB\u0011\b\u0016\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\f\u0010\u0010J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010$\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010%\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010&\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\t\u0010'\u001a\u00020\u000bH\u00c6\u0003JA\u0010(\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\u000bH\u00c6\u0001J\u0006\u0010)\u001a\u00020*J\u0013\u0010+\u001a\u00020\u001c2\b\u0010,\u001a\u0004\u0018\u00010-H\u00d6\u0003J\t\u0010.\u001a\u00020*H\u00d6\u0001J\t\u0010/\u001a\u000200H\u00d6\u0001J\u0016\u00101\u001a\u0002022\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020*R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u00066"}, d2={"Lcom/stripe/android/paymentsheet/state/PaymentSheetState$Full;", "Lcom/stripe/android/paymentsheet/state/PaymentSheetState;", "config", "Lcom/stripe/android/common/model/CommonConfiguration;", "customer", "Lcom/stripe/android/paymentsheet/state/CustomerState;", "paymentSelection", "Lcom/stripe/android/paymentsheet/model/PaymentSelection;", "validationError", "Lcom/stripe/android/paymentsheet/state/PaymentSheetLoadingException;", "paymentMethodMetadata", "Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodMetadata;", "<init>", "(Lcom/stripe/android/common/model/CommonConfiguration;Lcom/stripe/android/paymentsheet/state/CustomerState;Lcom/stripe/android/paymentsheet/model/PaymentSelection;Lcom/stripe/android/paymentsheet/state/PaymentSheetLoadingException;Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodMetadata;)V", "state", "Lcom/stripe/android/paymentsheet/state/PaymentElementLoader$State;", "(Lcom/stripe/android/paymentsheet/state/PaymentElementLoader$State;)V", "getConfig", "()Lcom/stripe/android/common/model/CommonConfiguration;", "getCustomer", "()Lcom/stripe/android/paymentsheet/state/CustomerState;", "getPaymentSelection", "()Lcom/stripe/android/paymentsheet/model/PaymentSelection;", "getValidationError", "()Lcom/stripe/android/paymentsheet/state/PaymentSheetLoadingException;", "getPaymentMethodMetadata", "()Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodMetadata;", "showSavedPaymentMethods", "", "getShowSavedPaymentMethods", "()Z", "stripeIntent", "Lcom/stripe/android/model/StripeIntent;", "getStripeIntent", "()Lcom/stripe/android/model/StripeIntent;", "component1", "component2", "component3", "component4", "component5", "copy", "describeContents", "", "equals", "other", "", "hashCode", "toString", "", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "paymentsheet_release"})
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class Full
    implements PaymentSheetState {
        @NotNull
        private final CommonConfiguration config;
        @Nullable
        private final CustomerState customer;
        @Nullable
        private final PaymentSelection paymentSelection;
        @Nullable
        private final PaymentSheetLoadingException validationError;
        @NotNull
        private final PaymentMethodMetadata paymentMethodMetadata;
        @NotNull
        public static final Parcelable.Creator<Full> CREATOR;
        public static final int $stable;

        public Full(@NotNull CommonConfiguration config, @Nullable CustomerState customer2, @Nullable PaymentSelection paymentSelection2, @Nullable PaymentSheetLoadingException validationError, @NotNull PaymentMethodMetadata paymentMethodMetadata) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)paymentMethodMetadata, (String)"paymentMethodMetadata");
            this.config = config;
            this.customer = customer2;
            this.paymentSelection = paymentSelection2;
            this.validationError = validationError;
            this.paymentMethodMetadata = paymentMethodMetadata;
        }

        @NotNull
        public final CommonConfiguration getConfig() {
            return this.config;
        }

        @Nullable
        public final CustomerState getCustomer() {
            return this.customer;
        }

        @Nullable
        public final PaymentSelection getPaymentSelection() {
            return this.paymentSelection;
        }

        @Nullable
        public final PaymentSheetLoadingException getValidationError() {
            return this.validationError;
        }

        @NotNull
        public final PaymentMethodMetadata getPaymentMethodMetadata() {
            return this.paymentMethodMetadata;
        }

        public Full(@NotNull PaymentElementLoader.State state2) {
            Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
            this(state2.getConfig(), state2.getCustomer(), state2.getPaymentSelection(), state2.getValidationError(), state2.getPaymentMethodMetadata());
        }

        public final boolean getShowSavedPaymentMethods() {
            return this.customer != null && !((Collection)this.customer.getPaymentMethods()).isEmpty() || this.paymentMethodMetadata.isGooglePayReady();
        }

        @NotNull
        public final StripeIntent getStripeIntent() {
            return this.paymentMethodMetadata.getStripeIntent();
        }

        public final void writeToParcel(@NotNull Parcel dest, int flags) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            this.config.writeToParcel(dest, flags);
            CustomerState customerState = this.customer;
            if (customerState == null) {
                dest.writeInt(0);
            } else {
                dest.writeInt(1);
                customerState.writeToParcel(dest, flags);
            }
            dest.writeParcelable((Parcelable)this.paymentSelection, flags);
            dest.writeSerializable((Serializable)this.validationError);
            this.paymentMethodMetadata.writeToParcel(dest, flags);
        }

        public final int describeContents() {
            return 0;
        }

        @NotNull
        public final CommonConfiguration component1() {
            return this.config;
        }

        @Nullable
        public final CustomerState component2() {
            return this.customer;
        }

        @Nullable
        public final PaymentSelection component3() {
            return this.paymentSelection;
        }

        @Nullable
        public final PaymentSheetLoadingException component4() {
            return this.validationError;
        }

        @NotNull
        public final PaymentMethodMetadata component5() {
            return this.paymentMethodMetadata;
        }

        @NotNull
        public final Full copy(@NotNull CommonConfiguration config, @Nullable CustomerState customer2, @Nullable PaymentSelection paymentSelection2, @Nullable PaymentSheetLoadingException validationError, @NotNull PaymentMethodMetadata paymentMethodMetadata) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)paymentMethodMetadata, (String)"paymentMethodMetadata");
            return new Full(config, customer2, paymentSelection2, validationError, paymentMethodMetadata);
        }

        public static /* synthetic */ Full copy$default(Full full, CommonConfiguration commonConfiguration, CustomerState customerState, PaymentSelection paymentSelection2, PaymentSheetLoadingException paymentSheetLoadingException, PaymentMethodMetadata paymentMethodMetadata, int n, Object object) {
            if ((n & 1) != 0) {
                commonConfiguration = full.config;
            }
            if ((n & 2) != 0) {
                customerState = full.customer;
            }
            if ((n & 4) != 0) {
                paymentSelection2 = full.paymentSelection;
            }
            if ((n & 8) != 0) {
                paymentSheetLoadingException = full.validationError;
            }
            if ((n & 0x10) != 0) {
                paymentMethodMetadata = full.paymentMethodMetadata;
            }
            return full.copy(commonConfiguration, customerState, paymentSelection2, paymentSheetLoadingException, paymentMethodMetadata);
        }

        @NotNull
        public String toString() {
            return "Full(config=" + this.config + ", customer=" + this.customer + ", paymentSelection=" + this.paymentSelection + ", validationError=" + this.validationError + ", paymentMethodMetadata=" + this.paymentMethodMetadata + ")";
        }

        public int hashCode() {
            int result2 = this.config.hashCode();
            result2 = result2 * 31 + (this.customer == null ? 0 : this.customer.hashCode());
            result2 = result2 * 31 + (this.paymentSelection == null ? 0 : this.paymentSelection.hashCode());
            result2 = result2 * 31 + (this.validationError == null ? 0 : this.validationError.hashCode());
            result2 = result2 * 31 + this.paymentMethodMetadata.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Full)) {
                return false;
            }
            Full full = (Full)other;
            if (!Intrinsics.areEqual((Object)this.config, (Object)full.config)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.customer, (Object)full.customer)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.paymentSelection, (Object)full.paymentSelection)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.validationError, (Object)full.validationError)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.paymentMethodMetadata, (Object)full.paymentMethodMetadata);
        }

        static {
            @Metadata(mv={2, 1, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<Full> {
                public final Full[] newArray(int size) {
                    return new Full[size];
                }

                public final Full createFromParcel(Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    return new Full((CommonConfiguration)CommonConfiguration.CREATOR.createFromParcel(parcel), (CustomerState)(parcel.readInt() == 0 ? null : CustomerState.CREATOR.createFromParcel(parcel)), (PaymentSelection)parcel.readParcelable(Full.class.getClassLoader()), (PaymentSheetLoadingException)parcel.readSerializable(), (PaymentMethodMetadata)PaymentMethodMetadata.CREATOR.createFromParcel(parcel));
                }
            }
            CREATOR = new Creator();
            $stable = 8;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/paymentsheet/state/PaymentSheetState$Loading;", "Lcom/stripe/android/paymentsheet/state/PaymentSheetState;", "<init>", "()V", "describeContents", "", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "paymentsheet_release"})
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class Loading
    implements PaymentSheetState {
        @NotNull
        public static final Loading INSTANCE = new Loading();
        @NotNull
        public static final Parcelable.Creator<Loading> CREATOR;
        public static final int $stable;

        private Loading() {
        }

        public final void writeToParcel(@NotNull Parcel dest, int flags) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            dest.writeInt(1);
        }

        public final int describeContents() {
            return 0;
        }

        static {
            @Metadata(mv={2, 1, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<Loading> {
                public final Loading[] newArray(int size) {
                    return new Loading[size];
                }

                public final Loading createFromParcel(Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    parcel.readInt();
                    return INSTANCE;
                }
            }
            CREATOR = new Creator();
            $stable = 8;
        }
    }
}

