/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.paymentdatacollection.cvcrecollection;

import androidx.compose.runtime.Immutable;
import com.stripe.android.R;
import com.stripe.android.model.CardBrand;
import com.stripe.android.ui.core.elements.CvcConfig;
import com.stripe.android.uicore.elements.TextFieldIcon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0081\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u000f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020\u0012H\u00d6\u0001J\t\u0010 \u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006!"}, d2={"Lcom/stripe/android/paymentsheet/paymentdatacollection/cvcrecollection/CvcState;", "", "cvc", "", "cardBrand", "Lcom/stripe/android/model/CardBrand;", "<init>", "(Ljava/lang/String;Lcom/stripe/android/model/CardBrand;)V", "getCvc", "()Ljava/lang/String;", "getCardBrand", "()Lcom/stripe/android/model/CardBrand;", "cvcTextFieldConfig", "Lcom/stripe/android/ui/core/elements/CvcConfig;", "isValid", "", "()Z", "label", "", "getLabel", "()I", "cvcIcon", "Lcom/stripe/android/uicore/elements/TextFieldIcon$Trailing;", "getCvcIcon", "()Lcom/stripe/android/uicore/elements/TextFieldIcon$Trailing;", "updateCvc", "component1", "component2", "copy", "equals", "other", "hashCode", "toString", "paymentsheet_release"})
@Immutable
public final class CvcState {
    @NotNull
    private final String cvc;
    @NotNull
    private final CardBrand cardBrand;
    @NotNull
    private final CvcConfig cvcTextFieldConfig;
    private final boolean isValid;
    private final int label;
    @NotNull
    private final TextFieldIcon.Trailing cvcIcon;
    public static final int $stable;

    public CvcState(@NotNull String cvc, @NotNull CardBrand cardBrand) {
        Intrinsics.checkNotNullParameter((Object)cvc, (String)"cvc");
        Intrinsics.checkNotNullParameter((Object)cardBrand, (String)"cardBrand");
        this.cvc = cvc;
        this.cardBrand = cardBrand;
        this.cvcTextFieldConfig = new CvcConfig();
        this.isValid = this.cvcTextFieldConfig.determineState(this.cardBrand, this.cvc, this.cardBrand.getMaxCvcLength()).isValid();
        this.label = this.cardBrand == CardBrand.AmericanExpress ? R.string.stripe_cvc_amex_hint : R.string.stripe_cvc_number_hint;
        this.cvcIcon = new TextFieldIcon.Trailing(this.cardBrand.getCvcIcon(), null, false, null, 10, null);
    }

    @NotNull
    public final String getCvc() {
        return this.cvc;
    }

    @NotNull
    public final CardBrand getCardBrand() {
        return this.cardBrand;
    }

    public final boolean isValid() {
        return this.isValid;
    }

    public final int getLabel() {
        return this.label;
    }

    @NotNull
    public final TextFieldIcon.Trailing getCvcIcon() {
        return this.cvcIcon;
    }

    @NotNull
    public final CvcState updateCvc(@NotNull String cvc) {
        Intrinsics.checkNotNullParameter((Object)cvc, (String)"cvc");
        if (cvc.length() > this.cardBrand.getMaxCvcLength()) {
            return this;
        }
        return new CvcState(cvc, this.cardBrand);
    }

    @NotNull
    public final String component1() {
        return this.cvc;
    }

    @NotNull
    public final CardBrand component2() {
        return this.cardBrand;
    }

    @NotNull
    public final CvcState copy(@NotNull String cvc, @NotNull CardBrand cardBrand) {
        Intrinsics.checkNotNullParameter((Object)cvc, (String)"cvc");
        Intrinsics.checkNotNullParameter((Object)cardBrand, (String)"cardBrand");
        return new CvcState(cvc, cardBrand);
    }

    public static /* synthetic */ CvcState copy$default(CvcState cvcState, String string2, CardBrand cardBrand, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = cvcState.cvc;
        }
        if ((n & 2) != 0) {
            cardBrand = cvcState.cardBrand;
        }
        return cvcState.copy(string2, cardBrand);
    }

    @NotNull
    public String toString() {
        return "CvcState(cvc=" + this.cvc + ", cardBrand=" + this.cardBrand + ")";
    }

    public int hashCode() {
        int result2 = this.cvc.hashCode();
        result2 = result2 * 31 + this.cardBrand.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CvcState)) {
            return false;
        }
        CvcState cvcState = (CvcState)other;
        if (!Intrinsics.areEqual((Object)this.cvc, (Object)cvcState.cvc)) {
            return false;
        }
        return this.cardBrand == cvcState.cardBrand;
    }
}

