/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.model;

import com.stripe.android.R;
import com.stripe.android.core.strings.ResolvableString;
import com.stripe.android.core.strings.ResolvableStringUtilsKt;
import com.stripe.android.model.Address;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.R;
import com.stripe.android.paymentsheet.model.PaymentSelection;
import com.stripe.android.paymentsheet.ui.PaymentMethodsUiExtensionKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00132\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\f\u0010\u001d\u001a\u00020\u001e*\u00020\u001aH\u0000\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0018\u0010\u0004\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0003\"\u0018\u0010\u0005\u001a\u00020\u0006*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u001a\u0010\f\u001a\u0004\u0018\u00010\r*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\"\u001a\u0010\u0010\u001a\u0004\u0018\u00010\r*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000f\"\u0018\u0010\u0012\u001a\u00020\u0013*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\"\u0018\u0010\u0017\u001a\u00020\r*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u000f\"\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001f"}, d2={"isLink", "", "Lcom/stripe/android/paymentsheet/model/PaymentSelection;", "(Lcom/stripe/android/paymentsheet/model/PaymentSelection;)Z", "isSaved", "drawableResourceId", "", "getDrawableResourceId", "(Lcom/stripe/android/paymentsheet/model/PaymentSelection;)I", "getSavedIcon", "selection", "Lcom/stripe/android/paymentsheet/model/PaymentSelection$Saved;", "lightThemeIconUrl", "", "getLightThemeIconUrl", "(Lcom/stripe/android/paymentsheet/model/PaymentSelection;)Ljava/lang/String;", "darkThemeIconUrl", "getDarkThemeIconUrl", "label", "Lcom/stripe/android/core/strings/ResolvableString;", "getLabel", "(Lcom/stripe/android/paymentsheet/model/PaymentSelection;)Lcom/stripe/android/core/strings/ResolvableString;", "getSavedLabel", "paymentMethodType", "getPaymentMethodType", "billingDetails", "Lcom/stripe/android/model/PaymentMethod$BillingDetails;", "getBillingDetails", "(Lcom/stripe/android/paymentsheet/model/PaymentSelection;)Lcom/stripe/android/model/PaymentMethod$BillingDetails;", "toPaymentSheetBillingDetails", "Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetails;", "paymentsheet_release"})
public final class PaymentSelectionKt {
    public static final boolean isLink(@NotNull PaymentSelection $this$isLink) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isLink, (String)"<this>");
        PaymentSelection paymentSelection2 = $this$isLink;
        if (paymentSelection2 instanceof PaymentSelection.GooglePay) {
            bl = false;
        } else if (paymentSelection2 instanceof PaymentSelection.Link) {
            bl = true;
        } else if (paymentSelection2 instanceof PaymentSelection.New.LinkInline) {
            bl = true;
        } else if (paymentSelection2 instanceof PaymentSelection.New) {
            bl = false;
        } else if (paymentSelection2 instanceof PaymentSelection.Saved) {
            bl = ((PaymentSelection.Saved)$this$isLink).getWalletType() == PaymentSelection.Saved.WalletType.Link;
        } else if (paymentSelection2 instanceof PaymentSelection.CustomPaymentMethod || paymentSelection2 instanceof PaymentSelection.ExternalPaymentMethod) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    public static final boolean isSaved(@NotNull PaymentSelection $this$isSaved) {
        Intrinsics.checkNotNullParameter((Object)$this$isSaved, (String)"<this>");
        return $this$isSaved instanceof PaymentSelection.Saved;
    }

    public static final int getDrawableResourceId(@NotNull PaymentSelection $this$drawableResourceId) {
        int n;
        Intrinsics.checkNotNullParameter((Object)$this$drawableResourceId, (String)"<this>");
        PaymentSelection paymentSelection2 = $this$drawableResourceId;
        if (paymentSelection2 instanceof PaymentSelection.ExternalPaymentMethod) {
            n = ((PaymentSelection.ExternalPaymentMethod)$this$drawableResourceId).getIconResource();
        } else if (paymentSelection2 instanceof PaymentSelection.CustomPaymentMethod) {
            n = 0;
        } else if (Intrinsics.areEqual((Object)paymentSelection2, (Object)PaymentSelection.GooglePay.INSTANCE)) {
            n = R.drawable.stripe_google_pay_mark;
        } else if (paymentSelection2 instanceof PaymentSelection.Link) {
            n = PaymentMethodsUiExtensionKt.getLinkIcon$default(null, 1, null);
        } else if (paymentSelection2 instanceof PaymentSelection.New.Card) {
            n = PaymentMethodsUiExtensionKt.getCardBrandIcon(((PaymentSelection.New.Card)$this$drawableResourceId).getBrand());
        } else if (paymentSelection2 instanceof PaymentSelection.New.GenericPaymentMethod) {
            n = ((PaymentSelection.New.GenericPaymentMethod)$this$drawableResourceId).getIconResource();
        } else if (paymentSelection2 instanceof PaymentSelection.New.LinkInline) {
            n = PaymentMethodsUiExtensionKt.getCardBrandIcon(((PaymentSelection.New.LinkInline)$this$drawableResourceId).getBrand());
        } else if (paymentSelection2 instanceof PaymentSelection.New.USBankAccount) {
            n = ((PaymentSelection.New.USBankAccount)$this$drawableResourceId).getIconResource();
        } else if (paymentSelection2 instanceof PaymentSelection.Saved) {
            n = PaymentSelectionKt.getSavedIcon((PaymentSelection.Saved)$this$drawableResourceId);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private static final int getSavedIcon(PaymentSelection.Saved selection) {
        int n;
        int resourceId = PaymentMethodsUiExtensionKt.getSavedPaymentMethodIcon$default(selection.getPaymentMethod(), false, null, 3, null);
        if (resourceId == R.drawable.stripe_ic_paymentsheet_card_unknown_ref) {
            PaymentSelection.Saved.WalletType walletType = selection.getWalletType();
            switch (walletType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[walletType.ordinal()]) {
                case 1: {
                    n = PaymentMethodsUiExtensionKt.getLinkIcon$default(null, 1, null);
                    break;
                }
                case 2: {
                    n = R.drawable.stripe_google_pay_mark;
                    break;
                }
                default: {
                    n = resourceId;
                    break;
                }
            }
        } else {
            void var1_1;
            n = var1_1;
        }
        return n;
    }

    @Nullable
    public static final String getLightThemeIconUrl(@NotNull PaymentSelection $this$lightThemeIconUrl) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$lightThemeIconUrl, (String)"<this>");
        PaymentSelection paymentSelection2 = $this$lightThemeIconUrl;
        if (paymentSelection2 instanceof PaymentSelection.ExternalPaymentMethod) {
            string2 = ((PaymentSelection.ExternalPaymentMethod)$this$lightThemeIconUrl).getLightThemeIconUrl();
        } else if (paymentSelection2 instanceof PaymentSelection.CustomPaymentMethod) {
            string2 = ((PaymentSelection.CustomPaymentMethod)$this$lightThemeIconUrl).getLightThemeIconUrl();
        } else if (Intrinsics.areEqual((Object)paymentSelection2, (Object)PaymentSelection.GooglePay.INSTANCE)) {
            string2 = null;
        } else if (paymentSelection2 instanceof PaymentSelection.Link) {
            string2 = null;
        } else if (paymentSelection2 instanceof PaymentSelection.New.Card) {
            string2 = null;
        } else if (paymentSelection2 instanceof PaymentSelection.New.GenericPaymentMethod) {
            string2 = ((PaymentSelection.New.GenericPaymentMethod)$this$lightThemeIconUrl).getLightThemeIconUrl();
        } else if (paymentSelection2 instanceof PaymentSelection.New.LinkInline) {
            string2 = null;
        } else if (paymentSelection2 instanceof PaymentSelection.New.USBankAccount) {
            string2 = null;
        } else if (paymentSelection2 instanceof PaymentSelection.Saved) {
            string2 = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }

    @Nullable
    public static final String getDarkThemeIconUrl(@NotNull PaymentSelection $this$darkThemeIconUrl) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$darkThemeIconUrl, (String)"<this>");
        PaymentSelection paymentSelection2 = $this$darkThemeIconUrl;
        if (paymentSelection2 instanceof PaymentSelection.ExternalPaymentMethod) {
            string2 = ((PaymentSelection.ExternalPaymentMethod)$this$darkThemeIconUrl).getDarkThemeIconUrl();
        } else if (paymentSelection2 instanceof PaymentSelection.CustomPaymentMethod) {
            string2 = ((PaymentSelection.CustomPaymentMethod)$this$darkThemeIconUrl).getDarkThemeIconUrl();
        } else if (Intrinsics.areEqual((Object)paymentSelection2, (Object)PaymentSelection.GooglePay.INSTANCE)) {
            string2 = null;
        } else if (paymentSelection2 instanceof PaymentSelection.Link) {
            string2 = null;
        } else if (paymentSelection2 instanceof PaymentSelection.New.Card) {
            string2 = null;
        } else if (paymentSelection2 instanceof PaymentSelection.New.GenericPaymentMethod) {
            string2 = ((PaymentSelection.New.GenericPaymentMethod)$this$darkThemeIconUrl).getDarkThemeIconUrl();
        } else if (paymentSelection2 instanceof PaymentSelection.New.LinkInline) {
            string2 = null;
        } else if (paymentSelection2 instanceof PaymentSelection.New.USBankAccount) {
            string2 = null;
        } else if (paymentSelection2 instanceof PaymentSelection.Saved) {
            string2 = null;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }

    @NotNull
    public static final ResolvableString getLabel(@NotNull PaymentSelection $this$label) {
        ResolvableString resolvableString;
        Intrinsics.checkNotNullParameter((Object)$this$label, (String)"<this>");
        PaymentSelection paymentSelection2 = $this$label;
        if (paymentSelection2 instanceof PaymentSelection.ExternalPaymentMethod) {
            resolvableString = ((PaymentSelection.ExternalPaymentMethod)$this$label).getLabel();
        } else if (paymentSelection2 instanceof PaymentSelection.CustomPaymentMethod) {
            resolvableString = ((PaymentSelection.CustomPaymentMethod)$this$label).getLabel();
        } else if (Intrinsics.areEqual((Object)paymentSelection2, (Object)PaymentSelection.GooglePay.INSTANCE)) {
            resolvableString = ResolvableStringUtilsKt.getResolvableString((int)R.string.stripe_google_pay);
        } else if (paymentSelection2 instanceof PaymentSelection.Link) {
            resolvableString = ResolvableStringUtilsKt.getResolvableString((int)R.string.stripe_link);
        } else if (paymentSelection2 instanceof PaymentSelection.New.Card) {
            resolvableString = ResolvableStringUtilsKt.orEmpty((ResolvableString)PaymentMethodsUiExtensionKt.createCardLabel(((PaymentSelection.New.Card)$this$label).getLast4()));
        } else if (paymentSelection2 instanceof PaymentSelection.New.GenericPaymentMethod) {
            resolvableString = ((PaymentSelection.New.GenericPaymentMethod)$this$label).getLabel();
        } else if (paymentSelection2 instanceof PaymentSelection.New.LinkInline) {
            resolvableString = ResolvableStringUtilsKt.orEmpty((ResolvableString)PaymentMethodsUiExtensionKt.createCardLabel(((PaymentSelection.New.LinkInline)$this$label).getLast4()));
        } else if (paymentSelection2 instanceof PaymentSelection.New.USBankAccount) {
            resolvableString = ResolvableStringUtilsKt.getResolvableString((String)((PaymentSelection.New.USBankAccount)$this$label).getLabel());
        } else if (paymentSelection2 instanceof PaymentSelection.Saved) {
            resolvableString = ResolvableStringUtilsKt.orEmpty((ResolvableString)PaymentSelectionKt.getSavedLabel((PaymentSelection.Saved)$this$label));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return resolvableString;
    }

    private static final ResolvableString getSavedLabel(PaymentSelection.Saved selection) {
        ResolvableString resolvableString = PaymentMethodsUiExtensionKt.getLabel(selection.getPaymentMethod());
        if (resolvableString == null) {
            boolean bl = false;
            PaymentSelection.Saved.WalletType walletType = selection.getWalletType();
            switch (walletType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[walletType.ordinal()]) {
                case 1: {
                    resolvableString = ResolvableStringUtilsKt.getResolvableString((int)R.string.stripe_link);
                    break;
                }
                case 2: {
                    resolvableString = ResolvableStringUtilsKt.getResolvableString((int)R.string.stripe_google_pay);
                    break;
                }
                default: {
                    resolvableString = null;
                }
            }
        }
        return resolvableString;
    }

    @NotNull
    public static final String getPaymentMethodType(@NotNull PaymentSelection $this$paymentMethodType) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)$this$paymentMethodType, (String)"<this>");
        PaymentSelection paymentSelection2 = $this$paymentMethodType;
        if (paymentSelection2 instanceof PaymentSelection.ExternalPaymentMethod) {
            string2 = ((PaymentSelection.ExternalPaymentMethod)$this$paymentMethodType).getType();
        } else if (paymentSelection2 instanceof PaymentSelection.CustomPaymentMethod) {
            string2 = ((PaymentSelection.CustomPaymentMethod)$this$paymentMethodType).getId();
        } else if (Intrinsics.areEqual((Object)paymentSelection2, (Object)PaymentSelection.GooglePay.INSTANCE)) {
            string2 = "google_pay";
        } else if (paymentSelection2 instanceof PaymentSelection.Link) {
            string2 = "link";
        } else if (paymentSelection2 instanceof PaymentSelection.New) {
            string2 = ((PaymentSelection.New)$this$paymentMethodType).getPaymentMethodCreateParams().getTypeCode();
        } else if (paymentSelection2 instanceof PaymentSelection.Saved) {
            string2 = ((PaymentSelection.Saved)$this$paymentMethodType).getPaymentMethod().type;
            if (string2 == null || (string2 = string2.name()) == null) {
                string2 = "card";
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return string2;
    }

    @Nullable
    public static final PaymentMethod.BillingDetails getBillingDetails(@NotNull PaymentSelection $this$billingDetails) {
        PaymentMethod.BillingDetails billingDetails;
        Intrinsics.checkNotNullParameter((Object)$this$billingDetails, (String)"<this>");
        PaymentSelection paymentSelection2 = $this$billingDetails;
        if (paymentSelection2 instanceof PaymentSelection.ExternalPaymentMethod) {
            billingDetails = ((PaymentSelection.ExternalPaymentMethod)$this$billingDetails).getBillingDetails();
        } else if (paymentSelection2 instanceof PaymentSelection.CustomPaymentMethod) {
            billingDetails = ((PaymentSelection.CustomPaymentMethod)$this$billingDetails).getBillingDetails();
        } else if (Intrinsics.areEqual((Object)paymentSelection2, (Object)PaymentSelection.GooglePay.INSTANCE)) {
            billingDetails = null;
        } else if (paymentSelection2 instanceof PaymentSelection.Link) {
            billingDetails = null;
        } else if (paymentSelection2 instanceof PaymentSelection.New) {
            billingDetails = ((PaymentSelection.New)$this$billingDetails).getPaymentMethodCreateParams().getBillingDetails();
        } else if (paymentSelection2 instanceof PaymentSelection.Saved) {
            billingDetails = ((PaymentSelection.Saved)$this$billingDetails).getPaymentMethod().billingDetails;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return billingDetails;
    }

    @NotNull
    public static final PaymentSheet.BillingDetails toPaymentSheetBillingDetails(@NotNull PaymentMethod.BillingDetails $this$toPaymentSheetBillingDetails) {
        Intrinsics.checkNotNullParameter((Object)$this$toPaymentSheetBillingDetails, (String)"<this>");
        Address address = $this$toPaymentSheetBillingDetails.address;
        Address address2 = $this$toPaymentSheetBillingDetails.address;
        Address address3 = $this$toPaymentSheetBillingDetails.address;
        Address address4 = $this$toPaymentSheetBillingDetails.address;
        Address address5 = $this$toPaymentSheetBillingDetails.address;
        Address address6 = $this$toPaymentSheetBillingDetails.address;
        return new PaymentSheet.BillingDetails(new PaymentSheet.Address(address != null ? address.getCity() : null, address2 != null ? address2.getCountry() : null, address3 != null ? address3.getLine1() : null, address4 != null ? address4.getLine2() : null, address5 != null ? address5.getPostalCode() : null, address6 != null ? address6.getState() : null), $this$toPaymentSheetBillingDetails.email, $this$toPaymentSheetBillingDetails.name, $this$toPaymentSheetBillingDetails.phone);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PaymentSelection.Saved.WalletType.values().length];
            try {
                nArray[PaymentSelection.Saved.WalletType.Link.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentSelection.Saved.WalletType.GooglePay.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

