/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.forms;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.lpmfoundations.paymentmethod.PaymentMethodMetadata;
import com.stripe.android.lpmfoundations.paymentmethod.PaymentMethodSaveConsentBehavior;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.addresselement.AddressDetails;
import com.stripe.android.paymentsheet.paymentdatacollection.FormArguments;
import com.stripe.android.ui.core.Amount;
import com.stripe.android.ui.core.cbc.CardBrandChoiceEligibility;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u00060\u0007j\u0002`\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/paymentsheet/forms/FormArgumentsFactory;", "", "<init>", "()V", "create", "Lcom/stripe/android/paymentsheet/paymentdatacollection/FormArguments;", "paymentMethodCode", "", "Lcom/stripe/android/model/PaymentMethodCode;", "metadata", "Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodMetadata;", "paymentsheet_release"})
@StabilityInferred(parameters=1)
public final class FormArgumentsFactory {
    @NotNull
    public static final FormArgumentsFactory INSTANCE = new FormArgumentsFactory();
    public static final int $stable;

    private FormArgumentsFactory() {
    }

    @NotNull
    public final FormArguments create(@NotNull String paymentMethodCode, @NotNull PaymentMethodMetadata metadata2) {
        Intrinsics.checkNotNullParameter((Object)paymentMethodCode, (String)"paymentMethodCode");
        Intrinsics.checkNotNullParameter((Object)metadata2, (String)"metadata");
        String string2 = metadata2.getMerchantName();
        Amount amount = metadata2.amount();
        PaymentSheet.BillingDetails billingDetails = metadata2.getDefaultBillingDetails();
        AddressDetails addressDetails = metadata2.getShippingDetails();
        PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration = metadata2.getBillingDetailsCollectionConfiguration();
        CardBrandChoiceEligibility cardBrandChoiceEligibility = metadata2.getCbcEligibility();
        boolean bl = metadata2.hasIntentToSetup();
        PaymentMethodSaveConsentBehavior paymentMethodSaveConsentBehavior = metadata2.getPaymentMethodSaveConsentBehavior();
        return new FormArguments(paymentMethodCode, cardBrandChoiceEligibility, string2, amount, billingDetails, addressDetails, paymentMethodSaveConsentBehavior, bl, billingDetailsCollectionConfiguration);
    }
}

