/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.flowcontroller;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.common.model.CommonConfigurationKt;
import com.stripe.android.lpmfoundations.paymentmethod.PaymentMethodMetadata;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.flowcontroller.PaymentSelectionUpdater;
import com.stripe.android.paymentsheet.flowcontroller.PaymentSelectionUpdaterKt;
import com.stripe.android.paymentsheet.model.PaymentSelection;
import com.stripe.android.paymentsheet.state.CustomerState;
import com.stripe.android.paymentsheet.state.PaymentSheetState;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\t\b\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J/\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0096\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\nH\u0002J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/stripe/android/paymentsheet/flowcontroller/DefaultPaymentSelectionUpdater;", "Lcom/stripe/android/paymentsheet/flowcontroller/PaymentSelectionUpdater;", "<init>", "()V", "invoke", "Lcom/stripe/android/paymentsheet/model/PaymentSelection;", "currentSelection", "previousConfig", "Lcom/stripe/android/paymentsheet/PaymentSheet$Configuration;", "newState", "Lcom/stripe/android/paymentsheet/state/PaymentSheetState$Full;", "newConfig", "canUseSelection", "", "selection", "state", "shouldAskForMandate", "Lcom/stripe/android/paymentsheet/model/PaymentSelection$New;", "metadata", "Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodMetadata;", "paymentsheet_release"})
@StabilityInferred(parameters=1)
public final class DefaultPaymentSelectionUpdater
implements PaymentSelectionUpdater {
    public static final int $stable;

    @Inject
    public DefaultPaymentSelectionUpdater() {
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @Nullable
    public PaymentSelection invoke(@Nullable PaymentSelection currentSelection, @Nullable PaymentSheet.Configuration previousConfig, @NotNull PaymentSheetState.Full newState, @NotNull PaymentSheet.Configuration newConfig) {
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
                Intrinsics.checkNotNullParameter((Object)newConfig, (String)"newConfig");
                v0 = currentSelection;
                if (v0 == null) break block7;
                selection = var5_5 = v0;
                $i$a$-takeIf-DefaultPaymentSelectionUpdater$invoke$1 = false;
                if (!this.canUseSelection(selection, newState)) ** GOTO lbl-1000
                v1 = previousConfig;
                if (v1 != null) {
                    previousConfig = v1;
                    $i$a$-let-DefaultPaymentSelectionUpdater$invoke$1$1 = false;
                    v2 = !CommonConfigurationKt.containsVolatileDifferences(CommonConfigurationKt.asCommonConfiguration(previousConfig), CommonConfigurationKt.asCommonConfiguration(newConfig));
                    v3 = !v2;
                } else {
                    v3 = false;
                }
                if (!v3) {
                    v4 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v4 = false;
                }
                if ((v0 = v4 != false ? var5_5 : null) != null) break block8;
            }
            v0 = newState.getPaymentSelection();
        }
        return v0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean canUseSelection(PaymentSelection selection, PaymentSheetState.Full state2) {
        boolean bl;
        List<String> allowedTypes = state2.getPaymentMethodMetadata().supportedPaymentMethodTypes();
        PaymentSelection paymentSelection2 = selection;
        if (paymentSelection2 instanceof PaymentSelection.New) {
            boolean requiresMandate = this.shouldAskForMandate((PaymentSelection.New)selection, state2.getPaymentMethodMetadata());
            String code = ((PaymentSelection.New)selection).getPaymentMethodCreateParams().getTypeCode();
            if (!allowedTypes.contains(code)) return false;
            if (requiresMandate) return false;
            return true;
        }
        if (paymentSelection2 instanceof PaymentSelection.Saved) {
            PaymentMethod paymentMethod = ((PaymentSelection.Saved)selection).getPaymentMethod();
            PaymentMethod.Type type = paymentMethod.type;
            String code = type != null ? type.code : null;
            if (!CollectionsKt.contains((Iterable)allowedTypes, (Object)code)) return false;
            Object object = state2.getCustomer();
            if (object == null || (object = ((CustomerState)object).getPaymentMethods()) == null) {
                object = CollectionsKt.emptyList();
            }
            if (!object.contains(paymentMethod)) return false;
            return true;
        }
        if (paymentSelection2 instanceof PaymentSelection.GooglePay) {
            bl = state2.getPaymentMethodMetadata().isGooglePayReady();
            return bl;
        } else {
            if (paymentSelection2 instanceof PaymentSelection.Link) {
                if (state2.getPaymentMethodMetadata().getLinkState() == null) return false;
                return true;
            }
            if (paymentSelection2 instanceof PaymentSelection.ExternalPaymentMethod) {
                bl = state2.getPaymentMethodMetadata().isExternalPaymentMethod(((PaymentSelection.ExternalPaymentMethod)selection).getType());
                return bl;
            } else {
                if (!(paymentSelection2 instanceof PaymentSelection.CustomPaymentMethod)) throw new NoWhenBranchMatchedException();
                bl = state2.getPaymentMethodMetadata().isCustomPaymentMethod(((PaymentSelection.CustomPaymentMethod)selection).getId());
            }
        }
        return bl;
    }

    private final boolean shouldAskForMandate(PaymentSelection.New currentSelection, PaymentMethodMetadata metadata2) {
        String code = currentSelection.getPaymentMethodCreateParams().getTypeCode();
        boolean paymentMethodRequiresMandate = metadata2.requiresMandate(code);
        return paymentMethodRequiresMandate ? !PaymentSelectionUpdaterKt.access$getCustomerAcknowledgedMandate(currentSelection) : false;
    }
}

