/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.cvcrecollection;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodOptionsParams;
import com.stripe.android.model.SetupIntent;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.cvcrecollection.CvcRecollectionHandler;
import com.stripe.android.paymentsheet.paymentdatacollection.cvcrecollection.CvcRecollectionData;
import com.stripe.android.paymentsheet.state.PaymentElementLoader;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050\bH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J*\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\f\u0010\u0013\u001a\u00020\u000b*\u00020\u0007H\u0002J\f\u0010\u0014\u001a\u00020\u000b*\u00020\u0007H\u0002J\f\u0010\u0015\u001a\u00020\u000b*\u00020\rH\u0002\u00a8\u0006\u0016"}, d2={"Lcom/stripe/android/paymentsheet/cvcrecollection/CvcRecollectionHandlerImpl;", "Lcom/stripe/android/paymentsheet/cvcrecollection/CvcRecollectionHandler;", "<init>", "()V", "launch", "", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "Lkotlin/Function1;", "Lcom/stripe/android/paymentsheet/paymentdatacollection/cvcrecollection/CvcRecollectionData;", "cvcRecollectionEnabled", "", "stripeIntent", "Lcom/stripe/android/model/StripeIntent;", "initializationMode", "Lcom/stripe/android/paymentsheet/state/PaymentElementLoader$InitializationMode;", "requiresCVCRecollection", "optionsParams", "Lcom/stripe/android/model/PaymentMethodOptionsParams;", "isCard", "hasNoWallet", "supportsCvcRecollection", "paymentsheet_release"})
@StabilityInferred(parameters=1)
public final class CvcRecollectionHandlerImpl
implements CvcRecollectionHandler {
    public static final int $stable;

    @Override
    public void launch(@NotNull PaymentMethod paymentMethod, @NotNull Function1<? super CvcRecollectionData, Unit> launch) {
        Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
        Intrinsics.checkNotNullParameter(launch, (String)"launch");
        CvcRecollectionData cvcRecollectionData = CvcRecollectionData.Companion.fromPaymentSelection(paymentMethod.card);
        if (cvcRecollectionData == null) {
            throw new IllegalStateException("unable to create CvcRecollectionData");
        }
        launch.invoke((Object)cvcRecollectionData);
    }

    @Override
    public boolean cvcRecollectionEnabled(@NotNull StripeIntent stripeIntent, @NotNull PaymentElementLoader.InitializationMode initializationMode) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)stripeIntent, (String)"stripeIntent");
        Intrinsics.checkNotNullParameter((Object)initializationMode, (String)"initializationMode");
        PaymentElementLoader.InitializationMode initializationMode2 = initializationMode;
        if (initializationMode2 instanceof PaymentElementLoader.InitializationMode.DeferredIntent) {
            bl = ((PaymentElementLoader.InitializationMode.DeferredIntent)initializationMode).getIntentConfiguration().getRequireCvcRecollection$paymentsheet_release() && ((PaymentElementLoader.InitializationMode.DeferredIntent)initializationMode).getIntentConfiguration().getMode() instanceof PaymentSheet.IntentConfiguration.Mode.Payment;
        } else if (initializationMode2 instanceof PaymentElementLoader.InitializationMode.PaymentIntent) {
            bl = this.supportsCvcRecollection(stripeIntent);
        } else if (initializationMode2 instanceof PaymentElementLoader.InitializationMode.SetupIntent) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }

    @Override
    public boolean requiresCVCRecollection(@NotNull StripeIntent stripeIntent, @NotNull PaymentMethod paymentMethod, @Nullable PaymentMethodOptionsParams optionsParams, @NotNull PaymentElementLoader.InitializationMode initializationMode) {
        Intrinsics.checkNotNullParameter((Object)stripeIntent, (String)"stripeIntent");
        Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
        Intrinsics.checkNotNullParameter((Object)initializationMode, (String)"initializationMode");
        return this.isCard(paymentMethod) && this.hasNoWallet(paymentMethod) && this.cvcRecollectionEnabled(stripeIntent, initializationMode);
    }

    private final boolean isCard(PaymentMethod $this$isCard) {
        return $this$isCard.type == PaymentMethod.Type.Card;
    }

    private final boolean hasNoWallet(PaymentMethod $this$hasNoWallet) {
        PaymentMethod.Card card = $this$hasNoWallet.card;
        return (card != null ? card.wallet : null) == null;
    }

    private final boolean supportsCvcRecollection(StripeIntent $this$supportsCvcRecollection) {
        boolean bl;
        StripeIntent stripeIntent = $this$supportsCvcRecollection;
        if (stripeIntent instanceof PaymentIntent) {
            bl = ((PaymentIntent)$this$supportsCvcRecollection).getRequireCvcRecollection();
        } else if (stripeIntent instanceof SetupIntent) {
            bl = false;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return bl;
    }
}

