/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.analytics;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.common.analytics.AnalyticsKtxKt;
import com.stripe.android.common.analytics.experiment.LoggableExperiment;
import com.stripe.android.common.model.CommonConfiguration;
import com.stripe.android.core.networking.AnalyticsEvent;
import com.stripe.android.model.CardBrand;
import com.stripe.android.model.LinkMode;
import com.stripe.android.model.LinkModeKt;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.paymentelement.confirmation.intent.DeferredIntentConfirmationType;
import com.stripe.android.payments.core.analytics.ErrorReporter;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.analytics.EventReporter;
import com.stripe.android.paymentsheet.analytics.PaymentSheetConfirmationError;
import com.stripe.android.paymentsheet.analytics.PaymentSheetEventKt;
import com.stripe.android.paymentsheet.model.PaymentSelection;
import com.stripe.android.paymentsheet.state.PaymentElementLoader;
import com.stripe.android.paymentsheet.state.PaymentSheetLoadingExceptionKt;
import com.stripe.android.paymentsheet.utils.SelectionUtilsKt;
import com.stripe.android.utils.MapUtilsKt;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.time.Duration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b1\u0018\u0000 12\u00020\u0001:\u001d\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'()*+,-./01B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00052\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bH\u0002R\u001f\u0010\u0004\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00058F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0012\u0010\r\u001a\u00020\u000bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0012\u0010\u000f\u001a\u00020\u000bX\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\fR \u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0005X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\t\u0082\u0001\u001c23456789:;<=>?@ABCDEFGHIJKLM\u00a8\u0006N"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "Lcom/stripe/android/core/networking/AnalyticsEvent;", "<init>", "()V", "params", "", "", "", "getParams", "()Ljava/util/Map;", "isDeferred", "", "()Z", "linkEnabled", "getLinkEnabled", "googlePaySupported", "getGooglePaySupported", "additionalParams", "getAdditionalParams", "standardParams", "isDecoupled", "LoadStarted", "LoadSucceeded", "LoadFailed", "ElementsSessionLoadFailed", "Init", "Dismiss", "ShowNewPaymentOptions", "ShowExistingPaymentOptions", "ShowManagePaymentMethods", "SelectPaymentMethod", "SelectPaymentOption", "ShowPaymentOptionForm", "PaymentOptionFormInteraction", "CardNumberCompleted", "CardBrandDisallowed", "PressConfirmButton", "Payment", "LpmSerializeFailureEvent", "AutofillEvent", "ShowEditablePaymentOption", "HideEditablePaymentOption", "CardBrandSelected", "SetAsDefaultPaymentMethodSucceeded", "SetAsDefaultPaymentMethodFailed", "UpdatePaymentOptionSucceeded", "UpdatePaymentOptionFailed", "CannotProperlyReturnFromLinkAndLPMs", "ExperimentExposure", "Companion", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$AutofillEvent;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$CannotProperlyReturnFromLinkAndLPMs;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$CardBrandDisallowed;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$CardBrandSelected;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$CardNumberCompleted;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Dismiss;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$ElementsSessionLoadFailed;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$ExperimentExposure;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$HideEditablePaymentOption;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Init;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$LoadFailed;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$LoadStarted;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$LoadSucceeded;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$LpmSerializeFailureEvent;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Payment;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$PaymentOptionFormInteraction;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$PressConfirmButton;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$SelectPaymentMethod;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$SelectPaymentOption;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$SetAsDefaultPaymentMethodFailed;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$SetAsDefaultPaymentMethodSucceeded;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$ShowEditablePaymentOption;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$ShowExistingPaymentOptions;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$ShowManagePaymentMethods;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$ShowNewPaymentOptions;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$ShowPaymentOptionForm;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$UpdatePaymentOptionFailed;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$UpdatePaymentOptionSucceeded;", "paymentsheet_release"})
@StabilityInferred(parameters=1)
public abstract class PaymentSheetEvent
implements AnalyticsEvent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    @NotNull
    public static final String FIELD_CUSTOMER = "customer";
    @NotNull
    public static final String FIELD_CUSTOMER_ACCESS_PROVIDER = "customer_access_provider";
    @NotNull
    public static final String FIELD_GOOGLE_PAY = "googlepay";
    @NotNull
    public static final String FIELD_GOOGLE_PAY_ENABLED = "google_pay_enabled";
    @NotNull
    public static final String FIELD_PRIMARY_BUTTON_COLOR = "primary_button_color";
    @NotNull
    public static final String FIELD_BILLING = "default_billing_details";
    @NotNull
    public static final String FIELD_PREFERRED_NETWORKS = "preferred_networks";
    @NotNull
    public static final String FIELD_DELAYED_PMS = "allows_delayed_payment_methods";
    @NotNull
    public static final String FIELD_MOBILE_PAYMENT_ELEMENT_CONFIGURATION = "mpe_config";
    @NotNull
    public static final String FIELD_APPEARANCE = "appearance";
    @NotNull
    public static final String FIELD_ALLOWS_PAYMENT_METHODS_REQUIRING_SHIPPING_ADDRESS = "allows_payment_methods_requiring_shipping_address";
    @NotNull
    public static final String FIELD_ALLOWS_REMOVAL_OF_LAST_SAVED_PAYMENT_METHOD = "allows_removal_of_last_saved_payment_method";
    @NotNull
    public static final String FIELD_BILLING_DETAILS_COLLECTION_CONFIGURATION = "billing_details_collection_configuration";
    @NotNull
    public static final String FIELD_PAYMENT_METHOD_ORDER = "payment_method_order";
    @NotNull
    public static final String FIELD_IS_DECOUPLED = "is_decoupled";
    @NotNull
    public static final String FIELD_DEFERRED_INTENT_CONFIRMATION_TYPE = "deferred_intent_confirmation_type";
    @NotNull
    public static final String FIELD_DURATION = "duration";
    @NotNull
    public static final String FIELD_LINK_ENABLED = "link_enabled";
    @NotNull
    public static final String FIELD_CURRENCY = "currency";
    @NotNull
    public static final String FIELD_SELECTED_LPM = "selected_lpm";
    @NotNull
    public static final String FIELD_ERROR_MESSAGE = "error_message";
    @NotNull
    public static final String FIELD_ERROR_CODE = "error_code";
    @NotNull
    public static final String FIELD_CBC_EVENT_SOURCE = "cbc_event_source";
    @NotNull
    public static final String FIELD_PAYMENT_METHOD_TYPE = "payment_method_type";
    @NotNull
    public static final String FIELD_SET_AS_DEFAULT_ENABLED = "set_as_default_enabled";
    @NotNull
    public static final String FIELD_HAS_DEFAULT_PAYMENT_METHOD = "has_default_payment_method";
    @NotNull
    public static final String FIELD_SELECTED_CARD_BRAND = "selected_card_brand";
    @NotNull
    public static final String FIELD_SET_AS_DEFAULT = "set_as_default";
    @NotNull
    public static final String FIELD_LINK_CONTEXT = "link_context";
    @NotNull
    public static final String FIELD_EXTERNAL_PAYMENT_METHODS = "external_payment_methods";
    @NotNull
    public static final String FIELD_PAYMENT_METHOD_LAYOUT = "payment_method_layout";
    @NotNull
    public static final String FIELD_COMPOSE = "compose";
    @NotNull
    public static final String FIELD_INTENT_TYPE = "intent_type";
    @NotNull
    public static final String FIELD_LINK_MODE = "link_mode";
    @NotNull
    public static final String FIELD_ORDERED_LPMS = "ordered_lpms";
    @NotNull
    public static final String FIELD_REQUIRE_CVC_RECOLLECTION = "require_cvc_recollection";
    @NotNull
    public static final String FIELD_CARD_BRAND_ACCEPTANCE = "card_brand_acceptance";
    @NotNull
    public static final String FIELD_CARD_SCAN_AVAILABLE = "card_scan_available";
    @NotNull
    public static final String FIELD_LINK_DISPLAY = "link_display";
    @NotNull
    public static final String VALUE_EDIT_CBC_EVENT_SOURCE = "edit";
    @NotNull
    public static final String VALUE_ADD_CBC_EVENT_SOURCE = "add";
    @NotNull
    public static final String VALUE_CARD_BRAND = "brand";
    public static final int MAX_EXTERNAL_PAYMENT_METHODS = 10;

    private PaymentSheetEvent() {
    }

    @NotNull
    public final Map<String, Object> getParams() {
        return MapsKt.plus(this.standardParams(this.isDeferred(), this.getLinkEnabled(), this.getGooglePaySupported()), this.getAdditionalParams());
    }

    protected abstract boolean isDeferred();

    protected abstract boolean getLinkEnabled();

    protected abstract boolean getGooglePaySupported();

    @NotNull
    protected abstract Map<String, Object> getAdditionalParams();

    private final Map<String, Object> standardParams(boolean isDecoupled, boolean linkEnabled, boolean googlePaySupported) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)FIELD_IS_DECOUPLED, (Object)isDecoupled), TuplesKt.to((Object)FIELD_LINK_ENABLED, (Object)linkEnabled), TuplesKt.to((Object)FIELD_GOOGLE_PAY_ENABLED, (Object)googlePaySupported)};
        return MapsKt.mapOf((Pair[])pairArray);
    }

    public /* synthetic */ PaymentSheetEvent(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\f\u0010\r\u001a\u00020\u0003*\u00020\u0003H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0007\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\u000e\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\"\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$AutofillEvent;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "type", "", "isDeferred", "", "linkEnabled", "googlePaySupported", "<init>", "(Ljava/lang/String;ZZZ)V", "()Z", "getLinkEnabled", "getGooglePaySupported", "toSnakeCase", "eventName", "getEventName", "()Ljava/lang/String;", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class AutofillEvent
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public AutofillEvent(@NotNull String type, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = "autofill_" + this.toSnakeCase(type);
            this.additionalParams = MapsKt.emptyMap();
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        private final String toSnakeCase(String $this$toSnakeCase) {
            CharSequence charSequence = $this$toSnakeCase;
            Regex regex = new Regex("(?<=.)(?=\\p{Upper})");
            String string2 = "_";
            String string3 = regex.replace(charSequence, string2).toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            return string3;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0006\u001a\u00020\u0007X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u0007X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0014\u0010\u000b\u001a\u00020\u0007X\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0014\u0010\r\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\"\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$CannotProperlyReturnFromLinkAndLPMs;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "mode", "Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;", "<init>", "(Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;)V", "linkEnabled", "", "getLinkEnabled", "()Z", "isDeferred", "googlePaySupported", "getGooglePaySupported", "eventName", "", "getEventName", "()Ljava/lang/String;", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class CannotProperlyReturnFromLinkAndLPMs
    extends PaymentSheetEvent {
        private final boolean linkEnabled;
        private final boolean isDeferred;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public CannotProperlyReturnFromLinkAndLPMs(@NotNull EventReporter.Mode mode) {
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            super(null);
            this.eventName = Companion.formatEventName(mode, "cannot_return_from_link_and_lpms");
            this.additionalParams = MapsKt.emptyMap();
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0007\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\"\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$CardBrandDisallowed;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "cardBrand", "Lcom/stripe/android/model/CardBrand;", "isDeferred", "", "linkEnabled", "googlePaySupported", "<init>", "(Lcom/stripe/android/model/CardBrand;ZZZ)V", "()Z", "getLinkEnabled", "getGooglePaySupported", "eventName", "", "getEventName", "()Ljava/lang/String;", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class CardBrandDisallowed
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public CardBrandDisallowed(@NotNull CardBrand cardBrand, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            Intrinsics.checkNotNullParameter((Object)cardBrand, (String)"cardBrand");
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = "mc_disallowed_card_brand";
            this.additionalParams = MapsKt.mapOf((Pair)TuplesKt.to((Object)PaymentSheetEvent.VALUE_CARD_BRAND, (Object)cardBrand.getCode()));
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0018B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\fR\u0014\u0010\b\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\t\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\"\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$CardBrandSelected;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "source", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$CardBrandSelected$Source;", "selectedBrand", "Lcom/stripe/android/model/CardBrand;", "isDeferred", "", "linkEnabled", "googlePaySupported", "<init>", "(Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$CardBrandSelected$Source;Lcom/stripe/android/model/CardBrand;ZZZ)V", "()Z", "getLinkEnabled", "getGooglePaySupported", "eventName", "", "getEventName", "()Ljava/lang/String;", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "Source", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class CardBrandSelected
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public CardBrandSelected(@NotNull Source source, @NotNull CardBrand selectedBrand, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
            Intrinsics.checkNotNullParameter((Object)selectedBrand, (String)"selectedBrand");
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = "mc_cbc_selected";
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)PaymentSheetEvent.FIELD_CBC_EVENT_SOURCE, (Object)source.getValue()), TuplesKt.to((Object)PaymentSheetEvent.FIELD_SELECTED_CARD_BRAND, (Object)selectedBrand.getCode())};
            this.additionalParams = MapsKt.mapOf((Pair[])pairArray);
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$CardBrandSelected$Source;", "", "value", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getValue", "()Ljava/lang/String;", "Edit", "Add", "paymentsheet_release"})
        public static final class Source
        extends Enum<Source> {
            @NotNull
            private final String value;
            public static final /* enum */ Source Edit = new Source("edit");
            public static final /* enum */ Source Add = new Source("add");
            private static final /* synthetic */ Source[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private Source(String value) {
                this.value = value;
            }

            @NotNull
            public final String getValue() {
                return this.value;
            }

            public static Source[] values() {
                return (Source[])$VALUES.clone();
            }

            public static Source valueOf(String value) {
                return Enum.valueOf(Source.class, value);
            }

            @NotNull
            public static EnumEntries<Source> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = sourceArray = new Source[]{Source.Edit, Source.Add};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010\u0005\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\"\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$CardNumberCompleted;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "isDeferred", "", "linkEnabled", "googlePaySupported", "<init>", "(ZZZ)V", "()Z", "getLinkEnabled", "getGooglePaySupported", "eventName", "", "getEventName", "()Ljava/lang/String;", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class CardNumberCompleted
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public CardNumberCompleted(boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = "mc_card_number_completed";
            this.additionalParams = MapsKt.emptyMap();
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b,\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0002J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010,\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u000207X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Companion;", "", "<init>", "()V", "analyticsValue", "", "paymentSelection", "Lcom/stripe/android/paymentsheet/model/PaymentSelection;", "formatEventName", "mode", "Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;", "eventName", "FIELD_CUSTOMER", "FIELD_CUSTOMER_ACCESS_PROVIDER", "FIELD_GOOGLE_PAY", "FIELD_GOOGLE_PAY_ENABLED", "FIELD_PRIMARY_BUTTON_COLOR", "FIELD_BILLING", "FIELD_PREFERRED_NETWORKS", "FIELD_DELAYED_PMS", "FIELD_MOBILE_PAYMENT_ELEMENT_CONFIGURATION", "FIELD_APPEARANCE", "FIELD_ALLOWS_PAYMENT_METHODS_REQUIRING_SHIPPING_ADDRESS", "FIELD_ALLOWS_REMOVAL_OF_LAST_SAVED_PAYMENT_METHOD", "FIELD_BILLING_DETAILS_COLLECTION_CONFIGURATION", "FIELD_PAYMENT_METHOD_ORDER", "FIELD_IS_DECOUPLED", "FIELD_DEFERRED_INTENT_CONFIRMATION_TYPE", "FIELD_DURATION", "FIELD_LINK_ENABLED", "FIELD_CURRENCY", "FIELD_SELECTED_LPM", "FIELD_ERROR_MESSAGE", "FIELD_ERROR_CODE", "FIELD_CBC_EVENT_SOURCE", "FIELD_PAYMENT_METHOD_TYPE", "FIELD_SET_AS_DEFAULT_ENABLED", "FIELD_HAS_DEFAULT_PAYMENT_METHOD", "FIELD_SELECTED_CARD_BRAND", "FIELD_SET_AS_DEFAULT", "FIELD_LINK_CONTEXT", "FIELD_EXTERNAL_PAYMENT_METHODS", "FIELD_PAYMENT_METHOD_LAYOUT", "FIELD_COMPOSE", "FIELD_INTENT_TYPE", "FIELD_LINK_MODE", "FIELD_ORDERED_LPMS", "FIELD_REQUIRE_CVC_RECOLLECTION", "FIELD_CARD_BRAND_ACCEPTANCE", "FIELD_CARD_SCAN_AVAILABLE", "FIELD_LINK_DISPLAY", "VALUE_EDIT_CBC_EVENT_SOURCE", "VALUE_ADD_CBC_EVENT_SOURCE", "VALUE_CARD_BRAND", "MAX_EXTERNAL_PAYMENT_METHODS", "", "paymentsheet_release"})
    public static final class Companion {
        private Companion() {
        }

        private final String analyticsValue(PaymentSelection paymentSelection2) {
            String string2;
            PaymentSelection paymentSelection3 = paymentSelection2;
            if (paymentSelection3 instanceof PaymentSelection.GooglePay) {
                string2 = PaymentSheetEvent.FIELD_GOOGLE_PAY;
            } else if (paymentSelection3 instanceof PaymentSelection.Saved) {
                string2 = "savedpm";
            } else if (paymentSelection3 instanceof PaymentSelection.Link || paymentSelection3 instanceof PaymentSelection.New.LinkInline) {
                string2 = "link";
            } else if (paymentSelection3 instanceof PaymentSelection.ExternalPaymentMethod || paymentSelection3 instanceof PaymentSelection.CustomPaymentMethod || paymentSelection3 instanceof PaymentSelection.New) {
                string2 = "newpm";
            } else if (paymentSelection3 == null) {
                string2 = "unknown";
            } else {
                throw new NoWhenBranchMatchedException();
            }
            return string2;
        }

        private final String formatEventName(EventReporter.Mode mode, String eventName) {
            return "mc_" + mode + "_" + eventName;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010\u0005\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR \u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00110\u0010X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Dismiss;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "isDeferred", "", "linkEnabled", "googlePaySupported", "<init>", "(ZZZ)V", "()Z", "getLinkEnabled", "getGooglePaySupported", "eventName", "", "getEventName", "()Ljava/lang/String;", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class Dismiss
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public Dismiss(boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = "mc_dismiss";
            this.additionalParams = MapsKt.emptyMap();
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0007\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\"\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$ElementsSessionLoadFailed;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "error", "", "isDeferred", "", "linkEnabled", "googlePaySupported", "<init>", "(Ljava/lang/Throwable;ZZZ)V", "()Z", "getLinkEnabled", "getGooglePaySupported", "eventName", "", "getEventName", "()Ljava/lang/String;", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class ElementsSessionLoadFailed
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public ElementsSessionLoadFailed(@NotNull Throwable error, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = "mc_elements_session_load_failed";
            this.additionalParams = MapsKt.plus((Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)PaymentSheetEvent.FIELD_ERROR_MESSAGE, (Object)PaymentSheetLoadingExceptionKt.getAsPaymentSheetLoadingException(error).getType())), (Map)ErrorReporter.Companion.getAdditionalParamsFromError(error));
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\"\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$ExperimentExposure;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "isDeferred", "", "linkEnabled", "googlePaySupported", "experiment", "Lcom/stripe/android/common/analytics/experiment/LoggableExperiment;", "<init>", "(ZZZLcom/stripe/android/common/analytics/experiment/LoggableExperiment;)V", "()Z", "getLinkEnabled", "getGooglePaySupported", "eventName", "", "getEventName", "()Ljava/lang/String;", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    @SourceDebugExtension(value={"SMAP\nPaymentSheetEvent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaymentSheetEvent.kt\ncom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$ExperimentExposure\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,642:1\n477#2:643\n423#2:644\n1246#3,4:645\n*S KotlinDebug\n*F\n+ 1 PaymentSheetEvent.kt\ncom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$ExperimentExposure\n*L\n522#1:643\n522#1:644\n522#1:645,4\n*E\n"})
    public static final class ExperimentExposure
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        /*
         * WARNING - void declaration
         */
        public ExperimentExposure(boolean isDeferred, boolean linkEnabled, boolean googlePaySupported, @NotNull LoggableExperiment experiment) {
            Map map2;
            void $this$mapKeysTo$iv$iv;
            void $this$mapKeys$iv;
            Intrinsics.checkNotNullParameter((Object)experiment, (String)"experiment");
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = "elements.experiment_exposure";
            Object object = new Pair[]{TuplesKt.to((Object)"experiment_retrieved", (Object)experiment.getExperiment().getExperimentValue()), TuplesKt.to((Object)"arb_id", (Object)experiment.getArbId()), TuplesKt.to((Object)"assignment_group", (Object)experiment.getGroup())};
            Map map3 = MapsKt.mapOf((Pair[])object);
            object = experiment.getDimensions();
            Map map4 = map3;
            ExperimentExposure experimentExposure = this;
            boolean $i$f$mapKeys = false;
            void var7_9 = $this$mapKeys$iv;
            Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
            boolean $i$f$mapKeysTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it$iv$iv;
                void it;
                Map.Entry entry = (Map.Entry)element$iv$iv$iv;
                map2 = destination$iv$iv;
                boolean bl = false;
                Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
                String string2 = "dimensions-" + it.getKey();
                Map map5 = map2;
                boolean bl2 = false;
                entry = it$iv$iv.getValue();
                map5.put(string2, entry);
            }
            map2 = destination$iv$iv;
            experimentExposure.additionalParams = MapsKt.plus((Map)map4, (Map)map2);
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010\u0005\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\"\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$HideEditablePaymentOption;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "isDeferred", "", "linkEnabled", "googlePaySupported", "<init>", "(ZZZ)V", "()Z", "getLinkEnabled", "getGooglePaySupported", "eventName", "", "getEventName", "()Ljava/lang/String;", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class HideEditablePaymentOption
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public HideEditablePaymentOption(boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = "mc_cancel_edit_screen";
            this.additionalParams = MapsKt.emptyMap();
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001BS\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\t\u0012\u0006\u0010\r\u001a\u00020\t\u0012\u0006\u0010\u000e\u001a\u00020\t\u0012\u0006\u0010\u000f\u001a\u00020\t\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\r\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0014\u0010\u000e\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0014R\u000e\u0010\u000f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\u00020\u00178VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\"\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u0017\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001b8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006\u001f"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Init;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "mode", "Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;", "configuration", "Lcom/stripe/android/common/model/CommonConfiguration;", "appearance", "Lcom/stripe/android/paymentsheet/PaymentSheet$Appearance;", "primaryButtonColor", "", "paymentMethodLayout", "Lcom/stripe/android/paymentsheet/PaymentSheet$PaymentMethodLayout;", "linkEnabled", "googlePaySupported", "isDeferred", "isStripeCardScanAvailable", "<init>", "(Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;Lcom/stripe/android/common/model/CommonConfiguration;Lcom/stripe/android/paymentsheet/PaymentSheet$Appearance;Ljava/lang/Boolean;Lcom/stripe/android/paymentsheet/PaymentSheet$PaymentMethodLayout;ZZZZ)V", "Ljava/lang/Boolean;", "getLinkEnabled", "()Z", "getGooglePaySupported", "eventName", "", "getEventName", "()Ljava/lang/String;", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    @SourceDebugExtension(value={"SMAP\nPaymentSheetEvent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaymentSheetEvent.kt\ncom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Init\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,642:1\n1#2:643\n*E\n"})
    public static final class Init
    extends PaymentSheetEvent {
        @NotNull
        private final EventReporter.Mode mode;
        @NotNull
        private final CommonConfiguration configuration;
        @NotNull
        private final PaymentSheet.Appearance appearance;
        @Nullable
        private final Boolean primaryButtonColor;
        @Nullable
        private final PaymentSheet.PaymentMethodLayout paymentMethodLayout;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        private final boolean isDeferred;
        private final boolean isStripeCardScanAvailable;
        public static final int $stable = 8;

        public Init(@NotNull EventReporter.Mode mode, @NotNull CommonConfiguration configuration, @NotNull PaymentSheet.Appearance appearance, @Nullable Boolean primaryButtonColor, @Nullable PaymentSheet.PaymentMethodLayout paymentMethodLayout, boolean linkEnabled, boolean googlePaySupported, boolean isDeferred, boolean isStripeCardScanAvailable) {
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Intrinsics.checkNotNullParameter((Object)appearance, (String)PaymentSheetEvent.FIELD_APPEARANCE);
            super(null);
            this.mode = mode;
            this.configuration = configuration;
            this.appearance = appearance;
            this.primaryButtonColor = primaryButtonColor;
            this.paymentMethodLayout = paymentMethodLayout;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.isDeferred = isDeferred;
            this.isStripeCardScanAvailable = isStripeCardScanAvailable;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @NotNull
        public String getEventName() {
            String string2;
            if (this.mode == EventReporter.Mode.Embedded) {
                string2 = Companion.formatEventName(this.mode, "init");
            } else {
                String string3;
                Object object = new String[2];
                String string4 = string3 = PaymentSheetEvent.FIELD_CUSTOMER;
                int n = 0;
                Object[] objectArray = object;
                boolean bl = false;
                boolean bl2 = this.configuration.getCustomer() != null;
                objectArray[n] = bl2 ? string3 : null;
                String it = string3 = PaymentSheetEvent.FIELD_GOOGLE_PAY;
                n = 1;
                objectArray = object;
                boolean bl3 = false;
                bl2 = this.configuration.getGooglePay() != null;
                objectArray[n] = bl2 ? string3 : null;
                Object it2 = object = CollectionsKt.listOfNotNull((Object[])object);
                boolean bl4 = false;
                Object object2 = !it2.isEmpty() ? object : null;
                String configValue = object2 != null && (object = CollectionsKt.joinToString$default((Iterable)((Iterable)object2), (CharSequence)"_", null, null, (int)0, null, null, (int)62, null)) != null ? object : "default";
                string2 = Companion.formatEventName(this.mode, "init_" + configValue);
            }
            return string2;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            Pair[] pairArray = new Pair[16];
            pairArray[0] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_CUSTOMER, (Object)(this.configuration.getCustomer() != null ? 1 : 0));
            Object object = this.configuration.getCustomer();
            pairArray[1] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_CUSTOMER_ACCESS_PROVIDER, object != null && (object = ((PaymentSheet.CustomerConfiguration)object).getAccessType$paymentsheet_release()) != null ? object.getAnalyticsValue() : null);
            pairArray[2] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_GOOGLE_PAY, (Object)(this.configuration.getGooglePay() != null ? 1 : 0));
            pairArray[3] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_PRIMARY_BUTTON_COLOR, (Object)this.primaryButtonColor);
            PaymentSheet.BillingDetails billingDetails = this.configuration.getDefaultBillingDetails();
            pairArray[4] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_BILLING, (Object)(billingDetails != null ? billingDetails.isFilledOut$paymentsheet_release() : false));
            pairArray[5] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_DELAYED_PMS, (Object)this.configuration.getAllowsDelayedPaymentMethods());
            pairArray[6] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_APPEARANCE, AnalyticsKtxKt.toAnalyticsMap(this.appearance, this.mode == EventReporter.Mode.Embedded));
            pairArray[7] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_PAYMENT_METHOD_ORDER, this.configuration.getPaymentMethodOrder());
            pairArray[8] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_ALLOWS_PAYMENT_METHODS_REQUIRING_SHIPPING_ADDRESS, (Object)this.configuration.getAllowsPaymentMethodsRequiringShippingAddress());
            pairArray[9] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_ALLOWS_REMOVAL_OF_LAST_SAVED_PAYMENT_METHOD, (Object)this.configuration.getAllowsRemovalOfLastSavedPaymentMethod());
            pairArray[10] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_BILLING_DETAILS_COLLECTION_CONFIGURATION, AnalyticsKtxKt.toAnalyticsMap(this.configuration.getBillingDetailsCollectionConfiguration()));
            pairArray[11] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_PREFERRED_NETWORKS, (Object)AnalyticsKtxKt.toAnalyticsValue(this.configuration.getPreferredNetworks()));
            pairArray[12] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_EXTERNAL_PAYMENT_METHODS, AnalyticsKtxKt.getExternalPaymentMethodsAnalyticsValue(this.configuration));
            PaymentSheet.PaymentMethodLayout paymentMethodLayout = this.paymentMethodLayout;
            pairArray[13] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_PAYMENT_METHOD_LAYOUT, (Object)(paymentMethodLayout != null ? AnalyticsKtxKt.toAnalyticsValue(paymentMethodLayout) : null));
            pairArray[14] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_CARD_BRAND_ACCEPTANCE, (Object)AnalyticsKtxKt.toAnalyticsValue(this.configuration.getCardBrandAcceptance()));
            pairArray[15] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_CARD_SCAN_AVAILABLE, (Object)this.isStripeCardScanAvailable);
            Map configurationMap = MapsKt.mapOf((Pair[])pairArray);
            return MapsKt.mapOf((Pair)TuplesKt.to((Object)PaymentSheetEvent.FIELD_MOBILE_PAYMENT_ELEMENT_CONFIGURATION, (Object)configurationMap));
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B1\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\fR\u0014\u0010\b\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\t\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\"\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$LoadFailed;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "duration", "Lkotlin/time/Duration;", "error", "", "isDeferred", "", "linkEnabled", "googlePaySupported", "<init>", "(Lkotlin/time/Duration;Ljava/lang/Throwable;ZZZLkotlin/jvm/internal/DefaultConstructorMarker;)V", "()Z", "getLinkEnabled", "getGooglePaySupported", "eventName", "", "getEventName", "()Ljava/lang/String;", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class LoadFailed
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        private LoadFailed(Duration duration, Throwable error, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = "mc_load_failed";
            Pair[] pairArray = new Pair[2];
            Duration duration2 = duration;
            pairArray[0] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_DURATION, (Object)(duration2 != null ? Float.valueOf(PaymentSheetEventKt.access$getAsSeconds-LRDsOJo(duration2.unbox-impl())) : null));
            pairArray[1] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_ERROR_MESSAGE, (Object)PaymentSheetLoadingExceptionKt.getAsPaymentSheetLoadingException(error).getType());
            this.additionalParams = MapsKt.plus((Map)MapsKt.mapOf((Pair[])pairArray), (Map)ErrorReporter.Companion.getAdditionalParamsFromError(error));
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }

        public /* synthetic */ LoadFailed(Duration duration, Throwable error, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported, DefaultConstructorMarker $constructor_marker) {
            this(duration, error, isDeferred, linkEnabled, googlePaySupported);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\"\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$LoadStarted;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "isDeferred", "", "linkEnabled", "googlePaySupported", "initializedViaCompose", "<init>", "(ZZZZ)V", "()Z", "getLinkEnabled", "getGooglePaySupported", "eventName", "", "getEventName", "()Ljava/lang/String;", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class LoadStarted
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public LoadStarted(boolean isDeferred, boolean linkEnabled, boolean googlePaySupported, boolean initializedViaCompose) {
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = "mc_load_started";
            this.additionalParams = MapsKt.mapOf((Pair)TuplesKt.to((Object)PaymentSheetEvent.FIELD_COMPOSE, (Object)initializedViaCompose));
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B}\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u000e\u0012\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u0014\u0010\r\u001a\u00020\u000eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u000f\u001a\u00020\u000eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0019R\u0014\u0010\u0010\u001a\u00020\u000eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0014\u0010\u001b\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\"\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010 0\u001fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020\b*\u0004\u0018\u00010\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0018\u0010#\u001a\u00020\b*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010&\u00a8\u0006'"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$LoadSucceeded;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "paymentSelection", "Lcom/stripe/android/paymentsheet/model/PaymentSelection;", "initializationMode", "Lcom/stripe/android/paymentsheet/state/PaymentElementLoader$InitializationMode;", "orderedLpms", "", "", "duration", "Lkotlin/time/Duration;", "linkMode", "Lcom/stripe/android/model/LinkMode;", "linkEnabled", "", "isDeferred", "googlePaySupported", "linkDisplay", "Lcom/stripe/android/paymentsheet/PaymentSheet$LinkConfiguration$Display;", "requireCvcRecollection", "hasDefaultPaymentMethod", "setAsDefaultEnabled", "<init>", "(Lcom/stripe/android/paymentsheet/model/PaymentSelection;Lcom/stripe/android/paymentsheet/state/PaymentElementLoader$InitializationMode;Ljava/util/List;Lkotlin/time/Duration;Lcom/stripe/android/model/LinkMode;ZZZLcom/stripe/android/paymentsheet/PaymentSheet$LinkConfiguration$Display;ZLjava/lang/Boolean;Ljava/lang/Boolean;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "getLinkEnabled", "()Z", "getGooglePaySupported", "eventName", "getEventName", "()Ljava/lang/String;", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "defaultAnalyticsValue", "getDefaultAnalyticsValue", "(Lcom/stripe/android/paymentsheet/model/PaymentSelection;)Ljava/lang/String;", "(Lcom/stripe/android/paymentsheet/state/PaymentElementLoader$InitializationMode;)Ljava/lang/String;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class LoadSucceeded
    extends PaymentSheetEvent {
        private final boolean linkEnabled;
        private final boolean isDeferred;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        /*
         * WARNING - void declaration
         */
        private LoadSucceeded(PaymentSelection paymentSelection2, PaymentElementLoader.InitializationMode initializationMode, List<String> orderedLpms, Duration duration, LinkMode linkMode, boolean linkEnabled, boolean isDeferred, boolean googlePaySupported, PaymentSheet.LinkConfiguration.Display linkDisplay, boolean requireCvcRecollection, Boolean hasDefaultPaymentMethod, Boolean setAsDefaultEnabled) {
            void $this$additionalParams_u24lambda_u242;
            Map map2;
            Intrinsics.checkNotNullParameter((Object)initializationMode, (String)"initializationMode");
            Intrinsics.checkNotNullParameter(orderedLpms, (String)"orderedLpms");
            Intrinsics.checkNotNullParameter((Object)((Object)linkDisplay), (String)"linkDisplay");
            super(null);
            this.linkEnabled = linkEnabled;
            this.isDeferred = isDeferred;
            this.googlePaySupported = googlePaySupported;
            this.eventName = "mc_load_succeeded";
            Map map3 = map2 = MapsKt.createMapBuilder();
            LoadSucceeded loadSucceeded = this;
            boolean bl = false;
            Duration duration2 = duration;
            $this$additionalParams_u24lambda_u242.put(PaymentSheetEvent.FIELD_DURATION, duration2 != null ? Float.valueOf(PaymentSheetEventKt.access$getAsSeconds-LRDsOJo(duration2.unbox-impl())) : null);
            $this$additionalParams_u24lambda_u242.put(PaymentSheetEvent.FIELD_SELECTED_LPM, this.getDefaultAnalyticsValue(paymentSelection2));
            $this$additionalParams_u24lambda_u242.put(PaymentSheetEvent.FIELD_INTENT_TYPE, this.getDefaultAnalyticsValue(initializationMode));
            $this$additionalParams_u24lambda_u242.put(PaymentSheetEvent.FIELD_ORDERED_LPMS, CollectionsKt.joinToString$default((Iterable)orderedLpms, (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
            $this$additionalParams_u24lambda_u242.put(PaymentSheetEvent.FIELD_REQUIRE_CVC_RECOLLECTION, requireCvcRecollection);
            LinkMode linkMode2 = linkMode;
            if (linkMode2 != null) {
                LinkMode mode = linkMode2;
                boolean bl2 = false;
                $this$additionalParams_u24lambda_u242.put(PaymentSheetEvent.FIELD_LINK_MODE, LinkModeKt.getAnalyticsValue((LinkMode)mode));
            }
            Boolean bl3 = setAsDefaultEnabled;
            if (bl3 != null) {
                boolean it = bl3;
                boolean bl4 = false;
                $this$additionalParams_u24lambda_u242.put(PaymentSheetEvent.FIELD_SET_AS_DEFAULT_ENABLED, it);
            }
            $this$additionalParams_u24lambda_u242.put(PaymentSheetEvent.FIELD_LINK_DISPLAY, linkDisplay.getAnalyticsValue$paymentsheet_release());
            if (Intrinsics.areEqual((Object)setAsDefaultEnabled, (Object)true) && hasDefaultPaymentMethod != null) {
                $this$additionalParams_u24lambda_u242.put(PaymentSheetEvent.FIELD_HAS_DEFAULT_PAYMENT_METHOD, hasDefaultPaymentMethod);
            }
            loadSucceeded.additionalParams = MapsKt.build((Map)map2);
        }

        public /* synthetic */ LoadSucceeded(PaymentSelection paymentSelection2, PaymentElementLoader.InitializationMode initializationMode, List list, Duration duration, LinkMode linkMode, boolean bl, boolean bl2, boolean bl3, PaymentSheet.LinkConfiguration.Display display, boolean bl4, Boolean bl5, Boolean bl6, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x200) != 0) {
                bl4 = false;
            }
            if ((n & 0x400) != 0) {
                bl5 = null;
            }
            if ((n & 0x800) != 0) {
                bl6 = null;
            }
            this(paymentSelection2, initializationMode, list, duration, linkMode, bl, bl2, bl3, display, bl4, bl5, bl6, null);
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }

        private final String getDefaultAnalyticsValue(PaymentSelection $this$defaultAnalyticsValue) {
            String string2;
            PaymentSelection paymentSelection2 = $this$defaultAnalyticsValue;
            if (paymentSelection2 instanceof PaymentSelection.GooglePay) {
                string2 = "google_pay";
            } else if (paymentSelection2 instanceof PaymentSelection.Link) {
                string2 = "link";
            } else if (paymentSelection2 instanceof PaymentSelection.Saved) {
                string2 = ((PaymentSelection.Saved)$this$defaultAnalyticsValue).getPaymentMethod().type;
                if (string2 == null || (string2 = ((PaymentMethod.Type)string2).code) == null) {
                    string2 = "saved";
                }
            } else {
                string2 = "none";
            }
            return string2;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final String getDefaultAnalyticsValue(PaymentElementLoader.InitializationMode $this$defaultAnalyticsValue) {
            PaymentElementLoader.InitializationMode initializationMode = $this$defaultAnalyticsValue;
            if (initializationMode instanceof PaymentElementLoader.InitializationMode.DeferredIntent) {
                PaymentSheet.IntentConfiguration.Mode mode = ((PaymentElementLoader.InitializationMode.DeferredIntent)$this$defaultAnalyticsValue).getIntentConfiguration().getMode();
                if (mode instanceof PaymentSheet.IntentConfiguration.Mode.Payment) {
                    return "deferred_payment_intent";
                }
                if (!(mode instanceof PaymentSheet.IntentConfiguration.Mode.Setup)) throw new NoWhenBranchMatchedException();
                return "deferred_setup_intent";
            }
            if (initializationMode instanceof PaymentElementLoader.InitializationMode.PaymentIntent) {
                return "payment_intent";
            }
            if (!(initializationMode instanceof PaymentElementLoader.InitializationMode.SetupIntent)) throw new NoWhenBranchMatchedException();
            return "setup_intent";
        }

        public /* synthetic */ LoadSucceeded(PaymentSelection paymentSelection2, PaymentElementLoader.InitializationMode initializationMode, List orderedLpms, Duration duration, LinkMode linkMode, boolean linkEnabled, boolean isDeferred, boolean googlePaySupported, PaymentSheet.LinkConfiguration.Display linkDisplay, boolean requireCvcRecollection, Boolean hasDefaultPaymentMethod, Boolean setAsDefaultEnabled, DefaultConstructorMarker $constructor_marker) {
            this(paymentSelection2, initializationMode, orderedLpms, duration, linkMode, linkEnabled, isDeferred, googlePaySupported, linkDisplay, requireCvcRecollection, hasDefaultPaymentMethod, setAsDefaultEnabled);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\"\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$LpmSerializeFailureEvent;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "isDeferred", "", "linkEnabled", "googlePaySupported", "errorMessage", "", "<init>", "(ZZZLjava/lang/String;)V", "()Z", "getLinkEnabled", "getGooglePaySupported", "getErrorMessage", "()Ljava/lang/String;", "eventName", "getEventName", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class LpmSerializeFailureEvent
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @Nullable
        private final String errorMessage;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public LpmSerializeFailureEvent(boolean isDeferred, boolean linkEnabled, boolean googlePaySupported, @Nullable String errorMessage) {
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.errorMessage = errorMessage;
            this.eventName = "luxe_serialize_failure";
            this.additionalParams = MapsKt.mapOf((Pair)TuplesKt.to((Object)PaymentSheetEvent.FIELD_ERROR_MESSAGE, (Object)this.errorMessage));
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @Nullable
        public final String getErrorMessage() {
            return this.errorMessage;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001:\u0001\u001fBW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\r\u0012\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0014R\u0014\u0010\u000e\u001a\u00020\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0014\u0010\u000f\u001a\u00020\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\"\u0010\u001a\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001bX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006 "}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Payment;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "mode", "Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;", "result", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Payment$Result;", "duration", "Lkotlin/time/Duration;", "paymentSelection", "Lcom/stripe/android/paymentsheet/model/PaymentSelection;", "currency", "", "isDeferred", "", "linkEnabled", "googlePaySupported", "deferredIntentConfirmationType", "Lcom/stripe/android/paymentelement/confirmation/intent/DeferredIntentConfirmationType;", "<init>", "(Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Payment$Result;Lkotlin/time/Duration;Lcom/stripe/android/paymentsheet/model/PaymentSelection;Ljava/lang/String;ZZZLcom/stripe/android/paymentelement/confirmation/intent/DeferredIntentConfirmationType;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "()Z", "getLinkEnabled", "getGooglePaySupported", "eventName", "getEventName", "()Ljava/lang/String;", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "Result", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class Payment
    extends PaymentSheetEvent {
        @NotNull
        private final Result result;
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @Nullable
        private final DeferredIntentConfirmationType deferredIntentConfirmationType;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        /*
         * WARNING - void declaration
         */
        private Payment(EventReporter.Mode mode, Result result2, Duration duration, PaymentSelection paymentSelection2, String currency, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported, DeferredIntentConfirmationType deferredIntentConfirmationType) {
            Object object;
            void $this$additionalParams_u24lambda_u245;
            Map map2;
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
            super(null);
            this.result = result2;
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.deferredIntentConfirmationType = deferredIntentConfirmationType;
            this.eventName = mode == EventReporter.Mode.Embedded ? Companion.formatEventName(mode, "payment_" + this.result.getAnalyticsValue()) : Companion.formatEventName(mode, "payment_" + Companion.analyticsValue(paymentSelection2) + "_" + this.result.getAnalyticsValue());
            Map map3 = map2 = MapsKt.createMapBuilder();
            Payment payment = this;
            boolean bl = false;
            Duration duration2 = duration;
            $this$additionalParams_u24lambda_u245.put(PaymentSheetEvent.FIELD_DURATION, duration2 != null ? Float.valueOf(PaymentSheetEventKt.access$getAsSeconds-LRDsOJo(duration2.unbox-impl())) : null);
            $this$additionalParams_u24lambda_u245.put(PaymentSheetEvent.FIELD_CURRENCY, currency);
            DeferredIntentConfirmationType deferredIntentConfirmationType2 = this.deferredIntentConfirmationType;
            if (deferredIntentConfirmationType2 != null) {
                DeferredIntentConfirmationType type = deferredIntentConfirmationType2;
                boolean bl2 = false;
                $this$additionalParams_u24lambda_u245.put(PaymentSheetEvent.FIELD_DEFERRED_INTENT_CONFIRMATION_TYPE, type.getValue());
            }
            if (this.result instanceof Result.Failure) {
                $this$additionalParams_u24lambda_u245.put(PaymentSheetEvent.FIELD_ERROR_MESSAGE, ((Result.Failure)this.result).getError().getAnalyticsValue());
                String string2 = ((Result.Failure)this.result).getError().getErrorCode();
                if (string2 != null) {
                    String errorCode = string2;
                    boolean bl3 = false;
                    $this$additionalParams_u24lambda_u245.put(PaymentSheetEvent.FIELD_ERROR_CODE, errorCode);
                }
            }
            String string3 = PaymentSheetEventKt.code(paymentSelection2);
            if (string3 != null) {
                String code = string3;
                boolean bl4 = false;
                $this$additionalParams_u24lambda_u245.put(PaymentSheetEvent.FIELD_SELECTED_LPM, code);
            }
            String string4 = PaymentSheetEventKt.linkContext(paymentSelection2);
            if (string4 != null) {
                String linkContext = string4;
                boolean bl5 = false;
                $this$additionalParams_u24lambda_u245.put(PaymentSheetEvent.FIELD_LINK_CONTEXT, linkContext);
            }
            if ((object = paymentSelection2) != null && (object = SelectionUtilsKt.getSetAsDefaultPaymentMethodFromPaymentSelection((PaymentSelection)object)) != null) {
                boolean setAsDefault = (Boolean)object;
                boolean bl6 = false;
                $this$additionalParams_u24lambda_u245.put(PaymentSheetEvent.FIELD_SET_AS_DEFAULT, setAsDefault);
            }
            payment.additionalParams = MapsKt.build((Map)map2);
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }

        public /* synthetic */ Payment(EventReporter.Mode mode, Result result2, Duration duration, PaymentSelection paymentSelection2, String currency, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported, DeferredIntentConfirmationType deferredIntentConfirmationType, DefaultConstructorMarker $constructor_marker) {
            this(mode, result2, duration, paymentSelection2, currency, isDeferred, linkEnabled, googlePaySupported, deferredIntentConfirmationType);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u00020\u0001:\u0002\u0006\u0007R\u0014\u0010\u0002\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u0082\u0001\u0002\b\t\u00a8\u0006\n"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Payment$Result;", "", "analyticsValue", "", "getAnalyticsValue", "()Ljava/lang/String;", "Success", "Failure", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Payment$Result$Failure;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Payment$Result$Success;", "paymentsheet_release"})
        public static interface Result {
            @NotNull
            public String getAnalyticsValue();

            @Metadata(mv={2, 1, 0}, k=3, xi=48)
            public static final class DefaultImpls {
                @NotNull
                public static String getAnalyticsValue(@NotNull Result $this) {
                    String string2;
                    Result result2 = $this;
                    if (result2 instanceof Success) {
                        string2 = "success";
                    } else if (result2 instanceof Failure) {
                        string2 = "failure";
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    return string2;
                }
            }

            @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Payment$Result$Failure;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Payment$Result;", "error", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetConfirmationError;", "<init>", "(Lcom/stripe/android/paymentsheet/analytics/PaymentSheetConfirmationError;)V", "getError", "()Lcom/stripe/android/paymentsheet/analytics/PaymentSheetConfirmationError;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "paymentsheet_release"})
            @StabilityInferred(parameters=1)
            public static final class Failure
            implements Result {
                @NotNull
                private final PaymentSheetConfirmationError error;
                public static final int $stable;

                public Failure(@NotNull PaymentSheetConfirmationError error) {
                    Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                    this.error = error;
                }

                @NotNull
                public final PaymentSheetConfirmationError getError() {
                    return this.error;
                }

                @NotNull
                public final PaymentSheetConfirmationError component1() {
                    return this.error;
                }

                @NotNull
                public final Failure copy(@NotNull PaymentSheetConfirmationError error) {
                    Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                    return new Failure(error);
                }

                public static /* synthetic */ Failure copy$default(Failure failure, PaymentSheetConfirmationError paymentSheetConfirmationError, int n, Object object) {
                    if ((n & 1) != 0) {
                        paymentSheetConfirmationError = failure.error;
                    }
                    return failure.copy(paymentSheetConfirmationError);
                }

                @NotNull
                public String toString() {
                    return "Failure(error=" + this.error + ")";
                }

                public int hashCode() {
                    return this.error.hashCode();
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Failure)) {
                        return false;
                    }
                    Failure failure = (Failure)other;
                    return Intrinsics.areEqual((Object)this.error, (Object)failure.error);
                }

                @Override
                @NotNull
                public String getAnalyticsValue() {
                    return DefaultImpls.getAnalyticsValue(this);
                }
            }

            @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c7\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00d6\u0003J\t\u0010\b\u001a\u00020\tH\u00d6\u0001J\t\u0010\n\u001a\u00020\u000bH\u00d6\u0001\u00a8\u0006\f"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Payment$Result$Success;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$Payment$Result;", "<init>", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "paymentsheet_release"})
            @StabilityInferred(parameters=1)
            public static final class Success
            implements Result {
                @NotNull
                public static final Success INSTANCE = new Success();
                public static final int $stable;

                private Success() {
                }

                @NotNull
                public String toString() {
                    return "Success";
                }

                public int hashCode() {
                    return 1616357393;
                }

                public boolean equals(@Nullable Object other) {
                    if (this == other) {
                        return true;
                    }
                    if (!(other instanceof Success)) {
                        return false;
                    }
                    Success cfr_ignored_0 = (Success)other;
                    return true;
                }

                @Override
                @NotNull
                public String getAnalyticsValue() {
                    return DefaultImpls.getAnalyticsValue(this);
                }
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0007\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\"\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$PaymentOptionFormInteraction;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "code", "", "isDeferred", "", "linkEnabled", "googlePaySupported", "<init>", "(Ljava/lang/String;ZZZ)V", "()Z", "getLinkEnabled", "getGooglePaySupported", "eventName", "getEventName", "()Ljava/lang/String;", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class PaymentOptionFormInteraction
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public PaymentOptionFormInteraction(@NotNull String code, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = "mc_form_interacted";
            this.additionalParams = MapsKt.mapOf((Pair)TuplesKt.to((Object)PaymentSheetEvent.FIELD_SELECTED_LPM, (Object)code));
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001BG\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rR\u0014\u0010\b\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u000eR\u0014\u0010\n\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0014\u0010\u000b\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\"\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0015X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$PressConfirmButton;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "currency", "", "duration", "Lkotlin/time/Duration;", "selectedLpm", "linkContext", "isDeferred", "", "linkEnabled", "googlePaySupported", "<init>", "(Ljava/lang/String;Lkotlin/time/Duration;Ljava/lang/String;Ljava/lang/String;ZZZLkotlin/jvm/internal/DefaultConstructorMarker;)V", "()Z", "getLinkEnabled", "getGooglePaySupported", "eventName", "getEventName", "()Ljava/lang/String;", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class PressConfirmButton
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        private PressConfirmButton(String currency, Duration duration, String selectedLpm, String linkContext, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = "mc_confirm_button_tapped";
            Pair[] pairArray = new Pair[4];
            Duration duration2 = duration;
            pairArray[0] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_DURATION, (Object)(duration2 != null ? Float.valueOf(PaymentSheetEventKt.access$getAsSeconds-LRDsOJo(duration2.unbox-impl())) : null));
            pairArray[1] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_CURRENCY, (Object)currency);
            pairArray[2] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_SELECTED_LPM, (Object)selectedLpm);
            pairArray[3] = TuplesKt.to((Object)PaymentSheetEvent.FIELD_LINK_CONTEXT, (Object)linkContext);
            this.additionalParams = MapUtilsKt.filterNotNullValues((Map)MapsKt.mapOf((Pair[])pairArray));
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }

        public /* synthetic */ PressConfirmButton(String currency, Duration duration, String selectedLpm, String linkContext, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported, DefaultConstructorMarker $constructor_marker) {
            this(currency, duration, selectedLpm, linkContext, isDeferred, linkEnabled, googlePaySupported);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\fR\u0014\u0010\b\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\t\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\"\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$SelectPaymentMethod;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "code", "", "currency", "linkContext", "isDeferred", "", "linkEnabled", "googlePaySupported", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZZZ)V", "()Z", "getLinkEnabled", "getGooglePaySupported", "eventName", "getEventName", "()Ljava/lang/String;", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class SelectPaymentMethod
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public SelectPaymentMethod(@NotNull String code, @Nullable String currency, @Nullable String linkContext, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = "mc_carousel_payment_method_tapped";
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)PaymentSheetEvent.FIELD_CURRENCY, (Object)currency), TuplesKt.to((Object)PaymentSheetEvent.FIELD_SELECTED_LPM, (Object)code), TuplesKt.to((Object)PaymentSheetEvent.FIELD_LINK_CONTEXT, (Object)linkContext)};
            this.additionalParams = MapsKt.mapOf((Pair[])pairArray);
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\rR\u0014\u0010\b\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u000eR\u0014\u0010\n\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000eR\u0014\u0010\u000b\u001a\u00020\tX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u0014\u0010\u0011\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\"\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0015X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u0019"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$SelectPaymentOption;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "mode", "Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;", "paymentSelection", "Lcom/stripe/android/paymentsheet/model/PaymentSelection;", "currency", "", "isDeferred", "", "linkEnabled", "googlePaySupported", "<init>", "(Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;Lcom/stripe/android/paymentsheet/model/PaymentSelection;Ljava/lang/String;ZZZ)V", "()Z", "getLinkEnabled", "getGooglePaySupported", "eventName", "getEventName", "()Ljava/lang/String;", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class SelectPaymentOption
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public SelectPaymentOption(@NotNull EventReporter.Mode mode, @Nullable PaymentSelection paymentSelection2, @Nullable String currency, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = Companion.formatEventName(mode, "paymentoption_" + Companion.analyticsValue(paymentSelection2) + "_select");
            this.additionalParams = MapsKt.mapOf((Pair)TuplesKt.to((Object)PaymentSheetEvent.FIELD_CURRENCY, (Object)currency));
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\fR\u0014\u0010\u0006\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\u0007\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\"\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$SetAsDefaultPaymentMethodFailed;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "error", "", "isDeferred", "", "linkEnabled", "googlePaySupported", "paymentMethodType", "", "<init>", "(Ljava/lang/Throwable;ZZZLjava/lang/String;)V", "()Z", "getLinkEnabled", "getGooglePaySupported", "eventName", "getEventName", "()Ljava/lang/String;", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class SetAsDefaultPaymentMethodFailed
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public SetAsDefaultPaymentMethodFailed(@NotNull Throwable error, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported, @Nullable String paymentMethodType) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = "mc_set_default_payment_method_failed";
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)PaymentSheetEvent.FIELD_ERROR_MESSAGE, (Object)error.getMessage()), TuplesKt.to((Object)PaymentSheetEvent.FIELD_PAYMENT_METHOD_TYPE, (Object)paymentMethodType)};
            this.additionalParams = MapsKt.plus((Map)MapsKt.mapOf((Pair[])pairArray), (Map)ErrorReporter.Companion.getAdditionalParamsFromError(error));
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0005\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0007X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\"\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$SetAsDefaultPaymentMethodSucceeded;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "isDeferred", "", "linkEnabled", "googlePaySupported", "paymentMethodType", "", "<init>", "(ZZZLjava/lang/String;)V", "()Z", "getLinkEnabled", "getGooglePaySupported", "getPaymentMethodType", "()Ljava/lang/String;", "eventName", "getEventName", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class SetAsDefaultPaymentMethodSucceeded
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @Nullable
        private final String paymentMethodType;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public SetAsDefaultPaymentMethodSucceeded(boolean isDeferred, boolean linkEnabled, boolean googlePaySupported, @Nullable String paymentMethodType) {
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.paymentMethodType = paymentMethodType;
            this.eventName = "mc_set_default_payment_method";
            this.additionalParams = MapsKt.mapOf((Pair)TuplesKt.to((Object)PaymentSheetEvent.FIELD_PAYMENT_METHOD_TYPE, (Object)this.paymentMethodType));
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @Nullable
        public final String getPaymentMethodType() {
            return this.paymentMethodType;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\bR\u0014\u0010\u0004\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0014\u0010\u0005\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\fX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\"\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u0010X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$ShowEditablePaymentOption;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "isDeferred", "", "linkEnabled", "googlePaySupported", "<init>", "(ZZZ)V", "()Z", "getLinkEnabled", "getGooglePaySupported", "eventName", "", "getEventName", "()Ljava/lang/String;", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class ShowEditablePaymentOption
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public ShowEditablePaymentOption(boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = "mc_open_edit_screen";
            this.additionalParams = MapsKt.emptyMap();
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\fR\u0014\u0010\b\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\t\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\"\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$ShowExistingPaymentOptions;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "mode", "Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;", "currency", "", "isDeferred", "", "linkEnabled", "googlePaySupported", "<init>", "(Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;Ljava/lang/String;ZZZ)V", "()Z", "getLinkEnabled", "getGooglePaySupported", "eventName", "getEventName", "()Ljava/lang/String;", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class ShowExistingPaymentOptions
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public ShowExistingPaymentOptions(@NotNull EventReporter.Mode mode, @Nullable String currency, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = Companion.formatEventName(mode, "sheet_savedpm_show");
            this.additionalParams = MapsKt.mapOf((Pair)TuplesKt.to((Object)PaymentSheetEvent.FIELD_CURRENCY, (Object)currency));
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\fR\u0014\u0010\b\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\t\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\"\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$ShowManagePaymentMethods;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "mode", "Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;", "currency", "", "isDeferred", "", "linkEnabled", "googlePaySupported", "<init>", "(Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;Ljava/lang/String;ZZZ)V", "()Z", "getLinkEnabled", "getGooglePaySupported", "eventName", "getEventName", "()Ljava/lang/String;", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class ShowManagePaymentMethods
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public ShowManagePaymentMethods(@NotNull EventReporter.Mode mode, @Nullable String currency, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = Companion.formatEventName(mode, "manage_savedpm_show");
            this.additionalParams = MapsKt.mapOf((Pair)TuplesKt.to((Object)PaymentSheetEvent.FIELD_CURRENCY, (Object)currency));
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\fR\u0014\u0010\b\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\t\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\"\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0013X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$ShowNewPaymentOptions;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "mode", "Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;", "currency", "", "isDeferred", "", "linkEnabled", "googlePaySupported", "<init>", "(Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;Ljava/lang/String;ZZZ)V", "()Z", "getLinkEnabled", "getGooglePaySupported", "eventName", "getEventName", "()Ljava/lang/String;", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class ShowNewPaymentOptions
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public ShowNewPaymentOptions(@NotNull EventReporter.Mode mode, @Nullable String currency, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = Companion.formatEventName(mode, "sheet_newpm_show");
            this.additionalParams = MapsKt.mapOf((Pair)TuplesKt.to((Object)PaymentSheetEvent.FIELD_CURRENCY, (Object)currency));
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0007\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u0003X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\"\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$ShowPaymentOptionForm;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "code", "", "isDeferred", "", "linkEnabled", "googlePaySupported", "<init>", "(Ljava/lang/String;ZZZ)V", "()Z", "getLinkEnabled", "getGooglePaySupported", "eventName", "getEventName", "()Ljava/lang/String;", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class ShowPaymentOptionForm
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        public ShowPaymentOptionForm(@NotNull String code, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            Intrinsics.checkNotNullParameter((Object)code, (String)"code");
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = "mc_form_shown";
            this.additionalParams = MapsKt.mapOf((Pair)TuplesKt.to((Object)PaymentSheetEvent.FIELD_SELECTED_LPM, (Object)code));
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B1\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\fR\u0014\u0010\b\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0014\u0010\t\u001a\u00020\u0007X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\"\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$UpdatePaymentOptionFailed;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "selectedBrand", "Lcom/stripe/android/model/CardBrand;", "error", "", "isDeferred", "", "linkEnabled", "googlePaySupported", "<init>", "(Lcom/stripe/android/model/CardBrand;Ljava/lang/Throwable;ZZZ)V", "()Z", "getLinkEnabled", "getGooglePaySupported", "eventName", "", "getEventName", "()Ljava/lang/String;", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class UpdatePaymentOptionFailed
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        /*
         * WARNING - void declaration
         */
        public UpdatePaymentOptionFailed(@Nullable CardBrand selectedBrand, @NotNull Throwable error, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            void $this$additionalParams_u24lambda_u240;
            Map map2;
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            super(null);
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = "mc_update_card_failed";
            Map map3 = map2 = MapsKt.createMapBuilder();
            UpdatePaymentOptionFailed updatePaymentOptionFailed = this;
            boolean bl = false;
            if (selectedBrand != null) {
                $this$additionalParams_u24lambda_u240.put(PaymentSheetEvent.FIELD_SELECTED_CARD_BRAND, selectedBrand.getCode());
            }
            $this$additionalParams_u24lambda_u240.put(PaymentSheetEvent.FIELD_ERROR_MESSAGE, error.getMessage());
            updatePaymentOptionFailed.additionalParams = MapsKt.plus((Map)MapsKt.build((Map)map2), (Map)ErrorReporter.Companion.getAdditionalParamsFromError(error));
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\nR\u0014\u0010\u0006\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0007\u001a\u00020\u0005X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\"\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u000e\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u0012X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent$UpdatePaymentOptionSucceeded;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetEvent;", "selectedBrand", "Lcom/stripe/android/model/CardBrand;", "isDeferred", "", "linkEnabled", "googlePaySupported", "<init>", "(Lcom/stripe/android/model/CardBrand;ZZZ)V", "()Z", "getLinkEnabled", "getGooglePaySupported", "eventName", "", "getEventName", "()Ljava/lang/String;", "additionalParams", "", "", "getAdditionalParams", "()Ljava/util/Map;", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class UpdatePaymentOptionSucceeded
    extends PaymentSheetEvent {
        private final boolean isDeferred;
        private final boolean linkEnabled;
        private final boolean googlePaySupported;
        @NotNull
        private final String eventName;
        @NotNull
        private final Map<String, Object> additionalParams;
        public static final int $stable = 8;

        /*
         * WARNING - void declaration
         */
        public UpdatePaymentOptionSucceeded(@Nullable CardBrand selectedBrand, boolean isDeferred, boolean linkEnabled, boolean googlePaySupported) {
            super(null);
            Map map2;
            this.isDeferred = isDeferred;
            this.linkEnabled = linkEnabled;
            this.googlePaySupported = googlePaySupported;
            this.eventName = "mc_update_card";
            Map map3 = map2 = MapsKt.createMapBuilder();
            UpdatePaymentOptionSucceeded updatePaymentOptionSucceeded = this;
            boolean bl = false;
            if (selectedBrand != null) {
                void $this$additionalParams_u24lambda_u240;
                $this$additionalParams_u24lambda_u240.put(PaymentSheetEvent.FIELD_SELECTED_CARD_BRAND, selectedBrand.getCode());
            }
            updatePaymentOptionSucceeded.additionalParams = MapsKt.build((Map)map2);
        }

        @Override
        protected boolean isDeferred() {
            return this.isDeferred;
        }

        @Override
        protected boolean getLinkEnabled() {
            return this.linkEnabled;
        }

        @Override
        protected boolean getGooglePaySupported() {
            return this.googlePaySupported;
        }

        @NotNull
        public String getEventName() {
            return this.eventName;
        }

        @Override
        @NotNull
        protected Map<String, Object> getAdditionalParams() {
            return this.additionalParams;
        }
    }
}

