/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.analytics;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.StripeError;
import com.stripe.android.core.exception.StripeException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b1\u0018\u00002\u00020\u0001:\u0004\n\u000b\f\rB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u0004\u0018\u00010\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u0082\u0001\u0004\u000e\u000f\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetConfirmationError;", "", "<init>", "()V", "analyticsValue", "", "getAnalyticsValue", "()Ljava/lang/String;", "errorCode", "getErrorCode", "Stripe", "GooglePay", "ExternalPaymentMethod", "InvalidState", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetConfirmationError$ExternalPaymentMethod;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetConfirmationError$GooglePay;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetConfirmationError$InvalidState;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetConfirmationError$Stripe;", "paymentsheet_release"})
@StabilityInferred(parameters=1)
public abstract class PaymentSheetConfirmationError
extends Throwable {
    public static final int $stable;

    private PaymentSheetConfirmationError() {
    }

    @NotNull
    public abstract String getAnalyticsValue();

    @Nullable
    public abstract String getErrorCode();

    public /* synthetic */ PaymentSheetConfirmationError(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c7\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0005H\u00d6\u0001R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0011"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetConfirmationError$ExternalPaymentMethod;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetConfirmationError;", "<init>", "()V", "errorCode", "", "getErrorCode", "()Ljava/lang/String;", "analyticsValue", "getAnalyticsValue", "equals", "", "other", "", "hashCode", "", "toString", "paymentsheet_release"})
    @StabilityInferred(parameters=1)
    public static final class ExternalPaymentMethod
    extends PaymentSheetConfirmationError {
        @NotNull
        public static final ExternalPaymentMethod INSTANCE = new ExternalPaymentMethod();
        @Nullable
        private static final String errorCode;
        public static final int $stable;

        private ExternalPaymentMethod() {
            super((DefaultConstructorMarker)null);
        }

        @Override
        @Nullable
        public String getErrorCode() {
            return errorCode;
        }

        @Override
        @NotNull
        public String getAnalyticsValue() {
            return "externalPaymentMethodError";
        }

        @Override
        @NotNull
        public String toString() {
            return "ExternalPaymentMethod";
        }

        public int hashCode() {
            return -1706746466;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ExternalPaymentMethod)) {
                return false;
            }
            ExternalPaymentMethod cfr_ignored_0 = (ExternalPaymentMethod)other;
            return true;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0087\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetConfirmationError$GooglePay;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetConfirmationError;", "errorCodeInt", "", "<init>", "(I)V", "getErrorCodeInt", "()I", "errorCode", "", "getErrorCode", "()Ljava/lang/String;", "analyticsValue", "getAnalyticsValue", "component1", "copy", "equals", "", "other", "", "hashCode", "toString", "paymentsheet_release"})
    @StabilityInferred(parameters=1)
    public static final class GooglePay
    extends PaymentSheetConfirmationError {
        private final int errorCodeInt;
        @NotNull
        private final String errorCode;
        public static final int $stable;

        public GooglePay(int errorCodeInt) {
            super((DefaultConstructorMarker)null);
            this.errorCodeInt = errorCodeInt;
            this.errorCode = String.valueOf(this.errorCodeInt);
        }

        public final int getErrorCodeInt() {
            return this.errorCodeInt;
        }

        @Override
        @NotNull
        public String getErrorCode() {
            return this.errorCode;
        }

        @Override
        @NotNull
        public String getAnalyticsValue() {
            return "googlePay_" + this.getErrorCode();
        }

        public final int component1() {
            return this.errorCodeInt;
        }

        @NotNull
        public final GooglePay copy(int errorCodeInt) {
            return new GooglePay(errorCodeInt);
        }

        public static /* synthetic */ GooglePay copy$default(GooglePay googlePay, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = googlePay.errorCodeInt;
            }
            return googlePay.copy(n);
        }

        @Override
        @NotNull
        public String toString() {
            return "GooglePay(errorCodeInt=" + this.errorCodeInt + ")";
        }

        public int hashCode() {
            return Integer.hashCode(this.errorCodeInt);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof GooglePay)) {
                return false;
            }
            GooglePay googlePay = (GooglePay)other;
            return this.errorCodeInt == googlePay.errorCodeInt;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetConfirmationError$InvalidState;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetConfirmationError;", "<init>", "()V", "errorCode", "", "getErrorCode", "()Ljava/lang/String;", "analyticsValue", "getAnalyticsValue", "paymentsheet_release"})
    @StabilityInferred(parameters=1)
    public static final class InvalidState
    extends PaymentSheetConfirmationError {
        @NotNull
        public static final InvalidState INSTANCE = new InvalidState();
        @Nullable
        private static final String errorCode;
        public static final int $stable;

        private InvalidState() {
            super((DefaultConstructorMarker)null);
        }

        @Override
        @Nullable
        public String getErrorCode() {
            return errorCode;
        }

        @Override
        @NotNull
        public String getAnalyticsValue() {
            return "invalidState";
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u000bH\u00d6\u0001R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\r\u00a8\u0006\u0019"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetConfirmationError$Stripe;", "Lcom/stripe/android/paymentsheet/analytics/PaymentSheetConfirmationError;", "cause", "", "<init>", "(Ljava/lang/Throwable;)V", "getCause", "()Ljava/lang/Throwable;", "stripeException", "Lcom/stripe/android/core/exception/StripeException;", "errorCode", "", "getErrorCode", "()Ljava/lang/String;", "analyticsValue", "getAnalyticsValue", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "paymentsheet_release"})
    @StabilityInferred(parameters=0)
    public static final class Stripe
    extends PaymentSheetConfirmationError {
        @NotNull
        private final Throwable cause;
        @NotNull
        private final StripeException stripeException;
        @Nullable
        private final String errorCode;
        public static final int $stable = 8;

        public Stripe(@NotNull Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            super((DefaultConstructorMarker)null);
            this.cause = cause;
            this.stripeException = StripeException.Companion.create(this.getCause());
            StripeError stripeError = this.stripeException.getStripeError();
            this.errorCode = stripeError != null ? stripeError.getCode() : null;
        }

        @Override
        @NotNull
        public Throwable getCause() {
            return this.cause;
        }

        @Override
        @Nullable
        public String getErrorCode() {
            return this.errorCode;
        }

        @Override
        @NotNull
        public String getAnalyticsValue() {
            return this.stripeException.analyticsValue();
        }

        @NotNull
        public final Throwable component1() {
            return this.cause;
        }

        @NotNull
        public final Stripe copy(@NotNull Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            return new Stripe(cause);
        }

        public static /* synthetic */ Stripe copy$default(Stripe stripe, Throwable throwable, int n, Object object) {
            if ((n & 1) != 0) {
                throwable = stripe.cause;
            }
            return stripe.copy(throwable);
        }

        @Override
        @NotNull
        public String toString() {
            return "Stripe(cause=" + this.cause + ")";
        }

        public int hashCode() {
            return this.cause.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Stripe)) {
                return false;
            }
            Stripe stripe = (Stripe)other;
            return Intrinsics.areEqual((Object)this.cause, (Object)stripe.cause);
        }
    }
}

