/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet.analytics;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.SavedStateHandle;
import com.stripe.android.paymentsheet.analytics.EventReporter;
import com.stripe.android.paymentsheet.navigation.PaymentSheetScreen;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\b\b\u0001\u0018\u0000 (2\u00020\u0001:\u0001(B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0006\u0010 \u001a\u00020!J\u0012\u0010\"\u001a\u00020!2\n\u0010#\u001a\u00060\rj\u0002`\u0017J\u0010\u0010$\u001a\u00020!2\u0006\u0010\u0006\u001a\u00020\bH\u0002J\u000e\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020\bJ\u0010\u0010'\u001a\u00020!2\u0006\u0010#\u001a\u00020\rH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00118B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R4\u0010\u0018\u001a\n\u0018\u00010\rj\u0004\u0018\u0001`\u00172\u000e\u0010\u0010\u001a\n\u0018\u00010\rj\u0004\u0018\u0001`\u00178B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR4\u0010\u001d\u001a\n\u0018\u00010\rj\u0004\u0018\u0001`\u00172\u000e\u0010\u0010\u001a\n\u0018\u00010\rj\u0004\u0018\u0001`\u00178B@BX\u0082\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u001a\"\u0004\b\u001f\u0010\u001c\u00a8\u0006)"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetAnalyticsListener;", "", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "eventReporter", "Lcom/stripe/android/paymentsheet/analytics/EventReporter;", "currentScreen", "Lkotlinx/coroutines/flow/Flow;", "Lcom/stripe/android/paymentsheet/navigation/PaymentSheetScreen;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "currentPaymentMethodTypeProvider", "Lkotlin/Function0;", "", "<init>", "(Landroidx/lifecycle/SavedStateHandle;Lcom/stripe/android/paymentsheet/analytics/EventReporter;Lkotlinx/coroutines/flow/Flow;Lkotlinx/coroutines/CoroutineScope;Lkotlin/jvm/functions/Function0;)V", "value", "", "previouslySentDeepLinkEvent", "getPreviouslySentDeepLinkEvent", "()Z", "setPreviouslySentDeepLinkEvent", "(Z)V", "Lcom/stripe/android/model/PaymentMethodCode;", "previouslyShownForm", "getPreviouslyShownForm", "()Ljava/lang/String;", "setPreviouslyShownForm", "(Ljava/lang/String;)V", "previouslyInteractedForm", "getPreviouslyInteractedForm", "setPreviouslyInteractedForm", "cannotProperlyReturnFromLinkAndOtherLPMs", "", "reportFieldInteraction", "code", "reportPaymentSheetShown", "reportPaymentSheetHidden", "hiddenScreen", "reportFormShown", "Companion", "paymentsheet_release"})
@StabilityInferred(parameters=0)
public final class PaymentSheetAnalyticsListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SavedStateHandle savedStateHandle;
    @NotNull
    private final EventReporter eventReporter;
    @NotNull
    private final Function0<String> currentPaymentMethodTypeProvider;
    public static final int $stable = 8;
    @NotNull
    public static final String PREVIOUSLY_SHOWN_PAYMENT_FORM = "previously_shown_payment_form";
    @NotNull
    public static final String PREVIOUSLY_INTERACTION_PAYMENT_FORM = "previously_interacted_payment_form";
    @NotNull
    public static final String PREVIOUSLY_SENT_DEEP_LINK_EVENT = "previously_sent_deep_link_event";

    public PaymentSheetAnalyticsListener(@NotNull SavedStateHandle savedStateHandle, @NotNull EventReporter eventReporter, @NotNull Flow<? extends PaymentSheetScreen> currentScreen, @NotNull CoroutineScope coroutineScope, @NotNull Function0<String> currentPaymentMethodTypeProvider) {
        Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
        Intrinsics.checkNotNullParameter((Object)eventReporter, (String)"eventReporter");
        Intrinsics.checkNotNullParameter(currentScreen, (String)"currentScreen");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter(currentPaymentMethodTypeProvider, (String)"currentPaymentMethodTypeProvider");
        this.savedStateHandle = savedStateHandle;
        this.eventReporter = eventReporter;
        this.currentPaymentMethodTypeProvider = currentPaymentMethodTypeProvider;
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(currentScreen, this, null){
            int label;
            final /* synthetic */ Flow<PaymentSheetScreen> $currentScreen;
            final /* synthetic */ PaymentSheetAnalyticsListener this$0;
            {
                this.$currentScreen = $currentScreen;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = FlowKt.collectLatest(this.$currentScreen, (Function2)((Function2)new Function2<PaymentSheetScreen, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ PaymentSheetAnalyticsListener this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        PaymentSheetScreen screen = (PaymentSheetScreen)this.L$0;
                                        this.this$0.reportPaymentSheetShown(screen);
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(PaymentSheetScreen p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final boolean getPreviouslySentDeepLinkEvent() {
        Boolean bl = (Boolean)this.savedStateHandle.get(PREVIOUSLY_SENT_DEEP_LINK_EVENT);
        return bl != null ? bl : false;
    }

    private final void setPreviouslySentDeepLinkEvent(boolean value) {
        this.savedStateHandle.set(PREVIOUSLY_SENT_DEEP_LINK_EVENT, (Object)value);
    }

    private final String getPreviouslyShownForm() {
        return (String)this.savedStateHandle.get(PREVIOUSLY_SHOWN_PAYMENT_FORM);
    }

    private final void setPreviouslyShownForm(String value) {
        this.savedStateHandle.set(PREVIOUSLY_SHOWN_PAYMENT_FORM, (Object)value);
    }

    private final String getPreviouslyInteractedForm() {
        return (String)this.savedStateHandle.get(PREVIOUSLY_INTERACTION_PAYMENT_FORM);
    }

    private final void setPreviouslyInteractedForm(String value) {
        this.savedStateHandle.set(PREVIOUSLY_INTERACTION_PAYMENT_FORM, (Object)value);
    }

    public final void cannotProperlyReturnFromLinkAndOtherLPMs() {
        if (!this.getPreviouslySentDeepLinkEvent()) {
            this.eventReporter.onCannotProperlyReturnFromLinkAndOtherLPMs();
            this.setPreviouslySentDeepLinkEvent(true);
        }
    }

    public final void reportFieldInteraction(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        if (!Intrinsics.areEqual((Object)this.getPreviouslyInteractedForm(), (Object)code)) {
            this.eventReporter.onPaymentMethodFormInteraction(code);
            this.setPreviouslyInteractedForm(code);
        }
    }

    private final void reportPaymentSheetShown(PaymentSheetScreen currentScreen) {
        PaymentSheetScreen paymentSheetScreen = currentScreen;
        if (!(paymentSheetScreen instanceof PaymentSheetScreen.Loading || paymentSheetScreen instanceof PaymentSheetScreen.VerticalModeForm || paymentSheetScreen instanceof PaymentSheetScreen.CvcRecollection)) {
            if (paymentSheetScreen instanceof PaymentSheetScreen.ManageSavedPaymentMethods) {
                this.eventReporter.onShowManageSavedPaymentMethods();
            } else if (paymentSheetScreen instanceof PaymentSheetScreen.UpdatePaymentMethod) {
                this.eventReporter.onShowEditablePaymentOption();
            } else if (paymentSheetScreen instanceof PaymentSheetScreen.SelectSavedPaymentMethods) {
                this.eventReporter.onShowExistingPaymentOptions();
                this.setPreviouslyShownForm(null);
                this.setPreviouslyInteractedForm(null);
            } else if (paymentSheetScreen instanceof PaymentSheetScreen.VerticalMode) {
                this.eventReporter.onShowNewPaymentOptions();
            } else if (paymentSheetScreen instanceof PaymentSheetScreen.AddFirstPaymentMethod || paymentSheetScreen instanceof PaymentSheetScreen.AddAnotherPaymentMethod) {
                this.reportFormShown((String)this.currentPaymentMethodTypeProvider.invoke());
                this.eventReporter.onShowNewPaymentOptions();
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final void reportPaymentSheetHidden(@NotNull PaymentSheetScreen hiddenScreen) {
        Intrinsics.checkNotNullParameter((Object)hiddenScreen, (String)"hiddenScreen");
        if (hiddenScreen instanceof PaymentSheetScreen.UpdatePaymentMethod) {
            this.eventReporter.onHideEditablePaymentOption();
        }
    }

    private final void reportFormShown(String code) {
        if (!Intrinsics.areEqual((Object)this.getPreviouslyShownForm(), (Object)code)) {
            this.eventReporter.onPaymentMethodFormShown(code);
            this.setPreviouslyShownForm(code);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/stripe/android/paymentsheet/analytics/PaymentSheetAnalyticsListener$Companion;", "", "<init>", "()V", "PREVIOUSLY_SHOWN_PAYMENT_FORM", "", "PREVIOUSLY_INTERACTION_PAYMENT_FORM", "PREVIOUSLY_SENT_DEEP_LINK_EVENT", "paymentsheet_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

