/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.R;
import com.stripe.android.core.strings.ResolvableString;
import com.stripe.android.core.strings.ResolvableStringUtilsKt;
import com.stripe.android.model.CardBrand;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.paymentsheet.R;
import com.stripe.android.paymentsheet.SavedPaymentMethod;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0003\b\u0081\b\u0018\u0000 (2\u00020\u0001:\u0001(B5\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u0015\u001a\u00020\tJ\u0006\u0010\u0016\u001a\u00020\u0003J\u0006\u0010\u0017\u001a\u00020\u0003J\u0006\u0010\u0018\u001a\u00020\u0003J\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aJ\u0010\u0010\u001b\u001a\u00020\t2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001aJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0007H\u00c6\u0003J\t\u0010 \u001a\u00020\tH\u00c6\u0003J\t\u0010!\u001a\u00020\tH\u00c6\u0003J;\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\tH\u00c2\u0001J\u0013\u0010#\u001a\u00020\t2\b\u0010$\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010%\u001a\u00020&H\u00d6\u0001J\t\u0010'\u001a\u00020\u001aH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0013R\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013\u00a8\u0006)"}, d2={"Lcom/stripe/android/paymentsheet/DisplayableSavedPaymentMethod;", "", "displayName", "Lcom/stripe/android/core/strings/ResolvableString;", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "savedPaymentMethod", "Lcom/stripe/android/paymentsheet/SavedPaymentMethod;", "isCbcEligible", "", "shouldShowDefaultBadge", "<init>", "(Lcom/stripe/android/core/strings/ResolvableString;Lcom/stripe/android/model/PaymentMethod;Lcom/stripe/android/paymentsheet/SavedPaymentMethod;ZZ)V", "getDisplayName", "()Lcom/stripe/android/core/strings/ResolvableString;", "getPaymentMethod", "()Lcom/stripe/android/model/PaymentMethod;", "getSavedPaymentMethod", "()Lcom/stripe/android/paymentsheet/SavedPaymentMethod;", "()Z", "getShouldShowDefaultBadge", "isModifiable", "getDescription", "getModifyDescription", "getRemoveDescription", "brandDisplayName", "", "isDefaultPaymentMethod", "defaultPaymentMethodId", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "paymentsheet_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nDisplayableSavedPaymentMethod.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DisplayableSavedPaymentMethod.kt\ncom/stripe/android/paymentsheet/DisplayableSavedPaymentMethod\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,126:1\n1#2:127\n*E\n"})
public final class DisplayableSavedPaymentMethod {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ResolvableString displayName;
    @NotNull
    private final PaymentMethod paymentMethod;
    @NotNull
    private final SavedPaymentMethod savedPaymentMethod;
    private final boolean isCbcEligible;
    private final boolean shouldShowDefaultBadge;
    public static final int $stable = 8;

    private DisplayableSavedPaymentMethod(ResolvableString displayName, PaymentMethod paymentMethod, SavedPaymentMethod savedPaymentMethod, boolean isCbcEligible, boolean shouldShowDefaultBadge) {
        this.displayName = displayName;
        this.paymentMethod = paymentMethod;
        this.savedPaymentMethod = savedPaymentMethod;
        this.isCbcEligible = isCbcEligible;
        this.shouldShowDefaultBadge = shouldShowDefaultBadge;
    }

    /* synthetic */ DisplayableSavedPaymentMethod(ResolvableString resolvableString, PaymentMethod paymentMethod, SavedPaymentMethod savedPaymentMethod, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        this(resolvableString, paymentMethod, savedPaymentMethod, bl, bl2);
    }

    @NotNull
    public final ResolvableString getDisplayName() {
        return this.displayName;
    }

    @NotNull
    public final PaymentMethod getPaymentMethod() {
        return this.paymentMethod;
    }

    @NotNull
    public final SavedPaymentMethod getSavedPaymentMethod() {
        return this.savedPaymentMethod;
    }

    public final boolean isCbcEligible() {
        return this.isCbcEligible;
    }

    public final boolean getShouldShowDefaultBadge() {
        return this.shouldShowDefaultBadge;
    }

    public final boolean isModifiable() {
        SavedPaymentMethod savedPaymentMethod = this.savedPaymentMethod;
        if (savedPaymentMethod instanceof SavedPaymentMethod.Card) {
            boolean bl;
            Object object = ((SavedPaymentMethod.Card)this.savedPaymentMethod).getCard().networks;
            if (object != null && (object = object.getAvailable()) != null) {
                Object available = object;
                boolean bl2 = false;
                bl = available.size() > 1;
            } else {
                bl = false;
            }
            boolean hasMultipleNetworks = bl;
            return this.isCbcEligible && hasMultipleNetworks;
        }
        if (!(savedPaymentMethod instanceof SavedPaymentMethod.SepaDebit || savedPaymentMethod instanceof SavedPaymentMethod.USBankAccount || Intrinsics.areEqual((Object)savedPaymentMethod, (Object)SavedPaymentMethod.Unexpected.INSTANCE))) {
            throw new NoWhenBranchMatchedException();
        }
        return false;
    }

    @NotNull
    public final ResolvableString getDescription() {
        ResolvableString resolvableString;
        SavedPaymentMethod savedPaymentMethod = this.savedPaymentMethod;
        if (savedPaymentMethod instanceof SavedPaymentMethod.Card) {
            Object[] objectArray = new Object[]{this.brandDisplayName(), ((SavedPaymentMethod.Card)this.savedPaymentMethod).getCard().last4};
            resolvableString = ResolvableStringUtilsKt.resolvableString$default((int)R.string.stripe_card_ending_in, (Object[])objectArray, null, (int)4, null);
        } else if (savedPaymentMethod instanceof SavedPaymentMethod.SepaDebit) {
            Object[] objectArray = new Object[]{((SavedPaymentMethod.SepaDebit)this.savedPaymentMethod).getSepaDebit().last4};
            resolvableString = ResolvableStringUtilsKt.resolvableString$default((int)R.string.stripe_bank_account_ending_in, (Object[])objectArray, null, (int)4, null);
        } else if (savedPaymentMethod instanceof SavedPaymentMethod.USBankAccount) {
            Object[] objectArray = new Object[]{((SavedPaymentMethod.USBankAccount)this.savedPaymentMethod).getUsBankAccount().last4};
            resolvableString = ResolvableStringUtilsKt.resolvableString$default((int)R.string.stripe_bank_account_ending_in, (Object[])objectArray, null, (int)4, null);
        } else if (savedPaymentMethod instanceof SavedPaymentMethod.Unexpected) {
            resolvableString = ResolvableStringUtilsKt.resolvableString((String)"", (Object[])new Object[0]);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return resolvableString;
    }

    @NotNull
    public final ResolvableString getModifyDescription() {
        Object[] objectArray = new Object[]{this.getDescription()};
        return ResolvableStringUtilsKt.resolvableString$default((int)R.string.stripe_paymentsheet_modify_pm, (Object[])objectArray, null, (int)4, null);
    }

    @NotNull
    public final ResolvableString getRemoveDescription() {
        Object[] objectArray = new Object[]{this.getDescription()};
        return ResolvableStringUtilsKt.resolvableString$default((int)R.string.stripe_paymentsheet_remove_pm, (Object[])objectArray, null, (int)4, null);
    }

    @Nullable
    public final String brandDisplayName() {
        SavedPaymentMethod savedPaymentMethod;
        block4: {
            String string2;
            block6: {
                block5: {
                    savedPaymentMethod = this.savedPaymentMethod;
                    if (!(savedPaymentMethod instanceof SavedPaymentMethod.Card)) break block4;
                    string2 = ((SavedPaymentMethod.Card)this.savedPaymentMethod).getCard().displayBrand;
                    if (string2 == null) break block5;
                    String it = string2;
                    boolean bl = false;
                    CardBrand cardBrand = CardBrand.Companion.fromCode(it);
                    string2 = cardBrand;
                    if (cardBrand != null) break block6;
                }
                string2 = ((SavedPaymentMethod.Card)this.savedPaymentMethod).getCard().brand;
            }
            String brand = string2;
            return brand.getDisplayName();
        }
        if (!(savedPaymentMethod instanceof SavedPaymentMethod.USBankAccount || savedPaymentMethod instanceof SavedPaymentMethod.SepaDebit || savedPaymentMethod instanceof SavedPaymentMethod.Unexpected)) {
            throw new NoWhenBranchMatchedException();
        }
        return null;
    }

    public final boolean isDefaultPaymentMethod(@Nullable String defaultPaymentMethodId) {
        return this.paymentMethod.id != null && Intrinsics.areEqual((Object)this.paymentMethod.id, (Object)defaultPaymentMethodId);
    }

    @NotNull
    public final ResolvableString component1() {
        return this.displayName;
    }

    @NotNull
    public final PaymentMethod component2() {
        return this.paymentMethod;
    }

    @NotNull
    public final SavedPaymentMethod component3() {
        return this.savedPaymentMethod;
    }

    public final boolean component4() {
        return this.isCbcEligible;
    }

    public final boolean component5() {
        return this.shouldShowDefaultBadge;
    }

    private final DisplayableSavedPaymentMethod copy(ResolvableString displayName, PaymentMethod paymentMethod, SavedPaymentMethod savedPaymentMethod, boolean isCbcEligible, boolean shouldShowDefaultBadge) {
        return new DisplayableSavedPaymentMethod(displayName, paymentMethod, savedPaymentMethod, isCbcEligible, shouldShowDefaultBadge);
    }

    static /* synthetic */ DisplayableSavedPaymentMethod copy$default(DisplayableSavedPaymentMethod displayableSavedPaymentMethod, ResolvableString resolvableString, PaymentMethod paymentMethod, SavedPaymentMethod savedPaymentMethod, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 1) != 0) {
            resolvableString = displayableSavedPaymentMethod.displayName;
        }
        if ((n & 2) != 0) {
            paymentMethod = displayableSavedPaymentMethod.paymentMethod;
        }
        if ((n & 4) != 0) {
            savedPaymentMethod = displayableSavedPaymentMethod.savedPaymentMethod;
        }
        if ((n & 8) != 0) {
            bl = displayableSavedPaymentMethod.isCbcEligible;
        }
        if ((n & 0x10) != 0) {
            bl2 = displayableSavedPaymentMethod.shouldShowDefaultBadge;
        }
        return displayableSavedPaymentMethod.copy(resolvableString, paymentMethod, savedPaymentMethod, bl, bl2);
    }

    @NotNull
    public String toString() {
        return "DisplayableSavedPaymentMethod(displayName=" + this.displayName + ", paymentMethod=" + this.paymentMethod + ", savedPaymentMethod=" + this.savedPaymentMethod + ", isCbcEligible=" + this.isCbcEligible + ", shouldShowDefaultBadge=" + this.shouldShowDefaultBadge + ")";
    }

    public int hashCode() {
        int result2 = this.displayName.hashCode();
        result2 = result2 * 31 + this.paymentMethod.hashCode();
        result2 = result2 * 31 + this.savedPaymentMethod.hashCode();
        result2 = result2 * 31 + Boolean.hashCode(this.isCbcEligible);
        result2 = result2 * 31 + Boolean.hashCode(this.shouldShowDefaultBadge);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DisplayableSavedPaymentMethod)) {
            return false;
        }
        DisplayableSavedPaymentMethod displayableSavedPaymentMethod = (DisplayableSavedPaymentMethod)other;
        if (!Intrinsics.areEqual((Object)this.displayName, (Object)displayableSavedPaymentMethod.displayName)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.paymentMethod, (Object)displayableSavedPaymentMethod.paymentMethod)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.savedPaymentMethod, (Object)displayableSavedPaymentMethod.savedPaymentMethod)) {
            return false;
        }
        if (this.isCbcEligible != displayableSavedPaymentMethod.isCbcEligible) {
            return false;
        }
        return this.shouldShowDefaultBadge == displayableSavedPaymentMethod.shouldShowDefaultBadge;
    }

    public /* synthetic */ DisplayableSavedPaymentMethod(ResolvableString displayName, PaymentMethod paymentMethod, SavedPaymentMethod savedPaymentMethod, boolean isCbcEligible, boolean shouldShowDefaultBadge, DefaultConstructorMarker $constructor_marker) {
        this(displayName, paymentMethod, savedPaymentMethod, isCbcEligible, shouldShowDefaultBadge);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a8\u0006\r"}, d2={"Lcom/stripe/android/paymentsheet/DisplayableSavedPaymentMethod$Companion;", "", "<init>", "()V", "create", "Lcom/stripe/android/paymentsheet/DisplayableSavedPaymentMethod;", "displayName", "Lcom/stripe/android/core/strings/ResolvableString;", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "isCbcEligible", "", "shouldShowDefaultBadge", "paymentsheet_release"})
    @SourceDebugExtension(value={"SMAP\nDisplayableSavedPaymentMethod.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DisplayableSavedPaymentMethod.kt\ncom/stripe/android/paymentsheet/DisplayableSavedPaymentMethod$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,126:1\n1#2:127\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DisplayableSavedPaymentMethod create(@NotNull ResolvableString displayName, @NotNull PaymentMethod paymentMethod, boolean isCbcEligible, boolean shouldShowDefaultBadge) {
            SavedPaymentMethod savedPaymentMethod;
            SavedPaymentMethod savedPaymentMethod2;
            SavedPaymentMethod savedPaymentMethod3;
            Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
            Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
            PaymentMethod.Type type = paymentMethod.type;
            switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    SavedPaymentMethod.Card card;
                    PaymentMethod.Card it;
                    PaymentMethod.Card card2 = paymentMethod.card;
                    if (card2 != null) {
                        it = card2;
                        boolean bl = false;
                        card = new SavedPaymentMethod.Card(it);
                    } else {
                        card = null;
                    }
                    savedPaymentMethod3 = card;
                    break;
                }
                case 2: {
                    SavedPaymentMethod.USBankAccount uSBankAccount;
                    PaymentMethod.Card it;
                    PaymentMethod.USBankAccount uSBankAccount2 = paymentMethod.usBankAccount;
                    if (uSBankAccount2 != null) {
                        it = uSBankAccount2;
                        boolean bl = false;
                        uSBankAccount = new SavedPaymentMethod.USBankAccount((PaymentMethod.USBankAccount)it);
                    } else {
                        uSBankAccount = null;
                    }
                    savedPaymentMethod3 = uSBankAccount;
                    break;
                }
                case 3: {
                    SavedPaymentMethod.SepaDebit sepaDebit;
                    PaymentMethod.Card it;
                    PaymentMethod.SepaDebit sepaDebit2 = paymentMethod.sepaDebit;
                    if (sepaDebit2 != null) {
                        it = sepaDebit2;
                        boolean bl = false;
                        sepaDebit = new SavedPaymentMethod.SepaDebit((PaymentMethod.SepaDebit)it);
                    } else {
                        sepaDebit = null;
                    }
                    savedPaymentMethod3 = sepaDebit;
                    break;
                }
                default: {
                    savedPaymentMethod3 = null;
                }
            }
            if ((savedPaymentMethod2 = (savedPaymentMethod = savedPaymentMethod3)) == null) {
                savedPaymentMethod2 = SavedPaymentMethod.Unexpected.INSTANCE;
            }
            return new DisplayableSavedPaymentMethod(displayName, paymentMethod, savedPaymentMethod2, isCbcEligible, shouldShowDefaultBadge, null);
        }

        public static /* synthetic */ DisplayableSavedPaymentMethod create$default(Companion companion, ResolvableString resolvableString, PaymentMethod paymentMethod, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                bl2 = false;
            }
            return companion.create(resolvableString, paymentMethod, bl, bl2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[PaymentMethod.Type.values().length];
                try {
                    nArray[PaymentMethod.Type.Card.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PaymentMethod.Type.USBankAccount.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[PaymentMethod.Type.SepaDebit.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

