/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet;

import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.model.DeferredIntentParams;
import com.stripe.android.model.PaymentIntent;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.SetupIntent;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.paymentsheet.DeferredIntentValidatorKt;
import com.stripe.android.paymentsheet.IntentConfigurationKtxKt;
import com.stripe.android.paymentsheet.PaymentSheet;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fJ\u001a\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000fH\u0002J3\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u000f2\u0019\u0010\u0016\u001a\u0015\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u0017\u00a2\u0006\u0002\b\u0019H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/stripe/android/paymentsheet/DeferredIntentValidator;", "", "<init>", "()V", "validate", "Lcom/stripe/android/model/StripeIntent;", "stripeIntent", "intentConfiguration", "Lcom/stripe/android/paymentsheet/PaymentSheet$IntentConfiguration;", "allowsManualConfirmation", "", "validatePaymentMethod", "", "intent", "paymentMethod", "Lcom/stripe/android/model/PaymentMethod;", "isSimilarPaymentMethod", "providedPaymentMethod", "attachedPaymentMethod", "isSameFingerprint", "firstPaymentMethod", "secondPaymentMethod", "fingerprintProvider", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "paymentsheet_release"})
@StabilityInferred(parameters=1)
public final class DeferredIntentValidator {
    @NotNull
    public static final DeferredIntentValidator INSTANCE = new DeferredIntentValidator();
    public static final int $stable;

    private DeferredIntentValidator() {
    }

    @NotNull
    public final StripeIntent validate(@NotNull StripeIntent stripeIntent, @NotNull PaymentSheet.IntentConfiguration intentConfiguration, boolean allowsManualConfirmation) {
        Intrinsics.checkNotNullParameter((Object)stripeIntent, (String)"stripeIntent");
        Intrinsics.checkNotNullParameter((Object)intentConfiguration, (String)"intentConfiguration");
        DeferredIntentParams params = IntentConfigurationKtxKt.toDeferredIntentParams(intentConfiguration);
        StripeIntent stripeIntent2 = stripeIntent;
        if (stripeIntent2 instanceof PaymentIntent) {
            String string2;
            DeferredIntentParams.Mode mode = params.getMode();
            DeferredIntentParams.Mode.Payment payment = mode instanceof DeferredIntentParams.Mode.Payment ? (DeferredIntentParams.Mode.Payment)mode : null;
            if (payment == null) {
                boolean $i$a$-requireNotNull-DeferredIntentValidator$validate$paymentMode$22 = false;
                String $i$a$-requireNotNull-DeferredIntentValidator$validate$paymentMode$22 = "You returned a PaymentIntent client secret but used a PaymentSheet.IntentConfiguration in setup mode.";
                throw new IllegalArgumentException($i$a$-requireNotNull-DeferredIntentValidator$validate$paymentMode$22.toString());
            }
            DeferredIntentParams.Mode.Payment paymentMode = payment;
            String string3 = paymentMode.getCurrency().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
            String string4 = ((PaymentIntent)stripeIntent).getCurrency();
            if (string4 != null) {
                String string5 = string4.toLowerCase(Locale.ROOT);
                string2 = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"toLowerCase(...)");
            } else {
                string2 = null;
            }
            if (!Intrinsics.areEqual((Object)string3, (Object)string2)) {
                String string6;
                boolean $i$a$-require-DeferredIntentValidator$validate$52 = false;
                String string7 = ((PaymentIntent)stripeIntent).getCurrency();
                if (string7 != null) {
                    String string8 = string7.toLowerCase(Locale.ROOT);
                    string6 = string8;
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"toLowerCase(...)");
                } else {
                    string6 = null;
                }
                String string9 = paymentMode.getCurrency().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"toLowerCase(...)");
                String $i$a$-require-DeferredIntentValidator$validate$52 = "Your PaymentIntent currency (" + string6 + ") does not match the PaymentSheet.IntentConfiguration currency (" + string9 + ").";
                throw new IllegalArgumentException($i$a$-require-DeferredIntentValidator$validate$52.toString());
            }
            if (!(DeferredIntentValidatorKt.access$isNull(paymentMode.getSetupFutureUsage()) == DeferredIntentValidatorKt.access$isNull(((PaymentIntent)stripeIntent).getSetupFutureUsage()))) {
                boolean $i$a$-require-DeferredIntentValidator$validate$62 = false;
                String $i$a$-require-DeferredIntentValidator$validate$62 = "Your PaymentIntent setupFutureUsage (" + ((PaymentIntent)stripeIntent).getSetupFutureUsage() + ") does not match the PaymentSheet.IntentConfiguration setupFutureUsage (" + paymentMode.getSetupFutureUsage() + ").";
                throw new IllegalArgumentException($i$a$-require-DeferredIntentValidator$validate$62.toString());
            }
            if (!(((PaymentIntent)stripeIntent).getConfirmationMethod() != PaymentIntent.ConfirmationMethod.Manual || allowsManualConfirmation)) {
                boolean $i$a$-require-DeferredIntentValidator$validate$72 = false;
                String $i$a$-require-DeferredIntentValidator$validate$72 = "Your PaymentIntent confirmationMethod (" + ((PaymentIntent)stripeIntent).getConfirmationMethod() + ") can only be used with PaymentSheet.FlowController.";
                throw new IllegalArgumentException($i$a$-require-DeferredIntentValidator$validate$72.toString());
            }
        } else if (stripeIntent2 instanceof SetupIntent) {
            DeferredIntentParams.Mode mode = params.getMode();
            DeferredIntentParams.Mode.Setup setup = mode instanceof DeferredIntentParams.Mode.Setup ? (DeferredIntentParams.Mode.Setup)mode : null;
            if (setup == null) {
                boolean $i$a$-requireNotNull-DeferredIntentValidator$validate$setupMode$22 = false;
                String $i$a$-requireNotNull-DeferredIntentValidator$validate$setupMode$22 = "You returned a SetupIntent client secret but used a PaymentSheet.IntentConfiguration in payment mode.";
                throw new IllegalArgumentException($i$a$-requireNotNull-DeferredIntentValidator$validate$setupMode$22.toString());
            }
            DeferredIntentParams.Mode.Setup setupMode = setup;
            if (!(DeferredIntentValidatorKt.access$isNull(setupMode.getSetupFutureUsage()) == DeferredIntentValidatorKt.access$isNull(((SetupIntent)stripeIntent).getUsage()))) {
                boolean bl = false;
                String string10 = "Your SetupIntent usage (" + ((SetupIntent)stripeIntent).getUsage() + ") does not match the PaymentSheet.IntentConfiguration usage (" + ((SetupIntent)stripeIntent).getUsage() + ").";
                throw new IllegalArgumentException(string10.toString());
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return stripeIntent;
    }

    public final void validatePaymentMethod(@NotNull StripeIntent intent, @NotNull PaymentMethod paymentMethod) {
        String attachedPaymentMethod;
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        Intrinsics.checkNotNullParameter((Object)paymentMethod, (String)"paymentMethod");
        String string2 = intent.getPaymentMethodId();
        if (string2 == null) {
            PaymentMethod paymentMethod2 = intent.getPaymentMethod();
            string2 = paymentMethod2 != null ? paymentMethod2.id : null;
        }
        if (!((attachedPaymentMethod = string2) == null || Intrinsics.areEqual((Object)attachedPaymentMethod, (Object)paymentMethod.id) || this.isSimilarPaymentMethod(paymentMethod, intent.getPaymentMethod()))) {
            boolean bl = false;
            String string3 = "Your payment method (" + attachedPaymentMethod + ") attached to the intent does not match the provided payment method (" + paymentMethod.id + ")!";
            throw new IllegalArgumentException(string3.toString());
        }
    }

    private final boolean isSimilarPaymentMethod(PaymentMethod providedPaymentMethod, PaymentMethod attachedPaymentMethod) {
        boolean bl;
        if (attachedPaymentMethod == null || providedPaymentMethod.type != attachedPaymentMethod.type) {
            return false;
        }
        PaymentMethod.Type type = providedPaymentMethod.type;
        switch (type == null ? -1 : WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                bl = this.isSameFingerprint(providedPaymentMethod, attachedPaymentMethod, (Function1<? super PaymentMethod, String>)((Function1)DeferredIntentValidator::isSimilarPaymentMethod$lambda$7));
                break;
            }
            case 2: {
                bl = this.isSameFingerprint(providedPaymentMethod, attachedPaymentMethod, (Function1<? super PaymentMethod, String>)((Function1)DeferredIntentValidator::isSimilarPaymentMethod$lambda$8));
                break;
            }
            case 3: {
                bl = this.isSameFingerprint(providedPaymentMethod, attachedPaymentMethod, (Function1<? super PaymentMethod, String>)((Function1)DeferredIntentValidator::isSimilarPaymentMethod$lambda$9));
                break;
            }
            case 4: {
                bl = this.isSameFingerprint(providedPaymentMethod, attachedPaymentMethod, (Function1<? super PaymentMethod, String>)((Function1)DeferredIntentValidator::isSimilarPaymentMethod$lambda$10));
                break;
            }
            case 5: {
                bl = this.isSameFingerprint(providedPaymentMethod, attachedPaymentMethod, (Function1<? super PaymentMethod, String>)((Function1)DeferredIntentValidator::isSimilarPaymentMethod$lambda$11));
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isSameFingerprint(PaymentMethod firstPaymentMethod, PaymentMethod secondPaymentMethod, Function1<? super PaymentMethod, String> fingerprintProvider) {
        String firstFingerprint = (String)fingerprintProvider.invoke((Object)firstPaymentMethod);
        String secondFingerprint = (String)fingerprintProvider.invoke((Object)secondPaymentMethod);
        if (firstFingerprint == null || secondFingerprint == null) {
            return false;
        }
        return Intrinsics.areEqual((Object)firstFingerprint, (Object)secondFingerprint);
    }

    private static final String isSimilarPaymentMethod$lambda$7(PaymentMethod $this$isSameFingerprint) {
        Intrinsics.checkNotNullParameter((Object)$this$isSameFingerprint, (String)"$this$isSameFingerprint");
        PaymentMethod.Card card = $this$isSameFingerprint.card;
        return card != null ? card.fingerprint : null;
    }

    private static final String isSimilarPaymentMethod$lambda$8(PaymentMethod $this$isSameFingerprint) {
        Intrinsics.checkNotNullParameter((Object)$this$isSameFingerprint, (String)"$this$isSameFingerprint");
        PaymentMethod.USBankAccount uSBankAccount = $this$isSameFingerprint.usBankAccount;
        return uSBankAccount != null ? uSBankAccount.fingerprint : null;
    }

    private static final String isSimilarPaymentMethod$lambda$9(PaymentMethod $this$isSameFingerprint) {
        Intrinsics.checkNotNullParameter((Object)$this$isSameFingerprint, (String)"$this$isSameFingerprint");
        PaymentMethod.AuBecsDebit auBecsDebit = $this$isSameFingerprint.auBecsDebit;
        return auBecsDebit != null ? auBecsDebit.fingerprint : null;
    }

    private static final String isSimilarPaymentMethod$lambda$10(PaymentMethod $this$isSameFingerprint) {
        Intrinsics.checkNotNullParameter((Object)$this$isSameFingerprint, (String)"$this$isSameFingerprint");
        PaymentMethod.BacsDebit bacsDebit = $this$isSameFingerprint.bacsDebit;
        return bacsDebit != null ? bacsDebit.fingerprint : null;
    }

    private static final String isSimilarPaymentMethod$lambda$11(PaymentMethod $this$isSameFingerprint) {
        Intrinsics.checkNotNullParameter((Object)$this$isSameFingerprint, (String)"$this$isSameFingerprint");
        PaymentMethod.SepaDebit sepaDebit = $this$isSameFingerprint.sepaDebit;
        return sepaDebit != null ? sepaDebit.fingerprint : null;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PaymentMethod.Type.values().length];
            try {
                nArray[PaymentMethod.Type.Card.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentMethod.Type.USBankAccount.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentMethod.Type.AuBecsDebit.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentMethod.Type.BacsDebit.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PaymentMethod.Type.SepaDebit.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

