/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentsheet;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.SavedStateHandle;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.paymentsheet.model.PaymentSelection;
import com.stripe.android.paymentsheet.state.CustomerState;
import com.stripe.android.paymentsheet.viewmodels.BaseSheetViewModel;
import com.stripe.android.uicore.utils.StateFlowsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0001\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\nJ\u0010\u0010\u0019\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u000fJ\u0010\u0010\u001b\u001a\u00020\u00172\b\u0010\u001a\u001a\u0004\u0018\u00010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0019\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\f\u00a8\u0006\u001d"}, d2={"Lcom/stripe/android/paymentsheet/CustomerStateHolder;", "", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "selection", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/stripe/android/paymentsheet/model/PaymentSelection;", "<init>", "(Landroidx/lifecycle/SavedStateHandle;Lkotlinx/coroutines/flow/StateFlow;)V", "customer", "Lcom/stripe/android/paymentsheet/state/CustomerState;", "getCustomer", "()Lkotlinx/coroutines/flow/StateFlow;", "paymentMethods", "", "Lcom/stripe/android/model/PaymentMethod;", "getPaymentMethods", "mostRecentlySelectedSavedPaymentMethod", "getMostRecentlySelectedSavedPaymentMethod", "canRemove", "", "getCanRemove", "setCustomerState", "", "customerState", "setDefaultPaymentMethod", "paymentMethod", "updateMostRecentlySelectedSavedPaymentMethod", "Companion", "paymentsheet_release"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nCustomerStateHolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CustomerStateHolder.kt\ncom/stripe/android/paymentsheet/CustomerStateHolder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n295#2,2:76\n*S KotlinDebug\n*F\n+ 1 CustomerStateHolder.kt\ncom/stripe/android/paymentsheet/CustomerStateHolder\n*L\n49#1:76,2\n*E\n"})
public final class CustomerStateHolder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SavedStateHandle savedStateHandle;
    @NotNull
    private final StateFlow<PaymentSelection> selection;
    @NotNull
    private final StateFlow<CustomerState> customer;
    @NotNull
    private final StateFlow<List<PaymentMethod>> paymentMethods;
    @NotNull
    private final StateFlow<PaymentMethod> mostRecentlySelectedSavedPaymentMethod;
    @NotNull
    private final StateFlow<Boolean> canRemove;
    public static final int $stable = 8;
    @NotNull
    public static final String SAVED_CUSTOMER = "customer_info";
    @NotNull
    public static final String SAVED_PM_SELECTION = "saved_selection";

    public CustomerStateHolder(@NotNull SavedStateHandle savedStateHandle, @NotNull StateFlow<? extends PaymentSelection> selection) {
        Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
        Intrinsics.checkNotNullParameter(selection, (String)"selection");
        this.savedStateHandle = savedStateHandle;
        this.selection = selection;
        this.customer = this.savedStateHandle.getStateFlow(SAVED_CUSTOMER, null);
        this.paymentMethods = StateFlowsKt.mapAsStateFlow(this.customer, CustomerStateHolder::paymentMethods$lambda$0);
        Object object = this.selection.getValue();
        PaymentSelection.Saved saved = object instanceof PaymentSelection.Saved ? (PaymentSelection.Saved)object : null;
        this.mostRecentlySelectedSavedPaymentMethod = this.savedStateHandle.getStateFlow(SAVED_PM_SELECTION, saved != null ? saved.getPaymentMethod() : null);
        this.canRemove = StateFlowsKt.mapAsStateFlow(this.customer, CustomerStateHolder::canRemove$lambda$2);
    }

    @NotNull
    public final StateFlow<CustomerState> getCustomer() {
        return this.customer;
    }

    @NotNull
    public final StateFlow<List<PaymentMethod>> getPaymentMethods() {
        return this.paymentMethods;
    }

    @NotNull
    public final StateFlow<PaymentMethod> getMostRecentlySelectedSavedPaymentMethod() {
        return this.mostRecentlySelectedSavedPaymentMethod;
    }

    @NotNull
    public final StateFlow<Boolean> getCanRemove() {
        return this.canRemove;
    }

    public final void setCustomerState(@Nullable CustomerState customerState) {
        PaymentMethod paymentMethod;
        this.savedStateHandle.set(SAVED_CUSTOMER, (Object)customerState);
        PaymentMethod currentSelection = (PaymentMethod)this.mostRecentlySelectedSavedPaymentMethod.getValue();
        Object object = customerState;
        if (object != null && (object = ((CustomerState)object).getPaymentMethods()) != null) {
            Object v2;
            block3: {
                Iterable $this$firstOrNull$iv = (Iterable)object;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PaymentMethod it = (PaymentMethod)element$iv;
                    boolean bl = false;
                    PaymentMethod paymentMethod2 = currentSelection;
                    if (!Intrinsics.areEqual((Object)it.id, (Object)(paymentMethod2 != null ? paymentMethod2.id : null))) continue;
                    v2 = element$iv;
                    break block3;
                }
                v2 = null;
            }
            paymentMethod = v2;
        } else {
            paymentMethod = null;
        }
        PaymentMethod newSelection = paymentMethod;
        this.updateMostRecentlySelectedSavedPaymentMethod(newSelection);
    }

    public final void setDefaultPaymentMethod(@Nullable PaymentMethod paymentMethod) {
        CustomerState customerState;
        CustomerState customerState2 = (CustomerState)this.customer.getValue();
        if (customerState2 != null) {
            PaymentMethod paymentMethod2 = paymentMethod;
            customerState = CustomerState.copy$default(customerState2, null, null, null, null, null, paymentMethod2 != null ? paymentMethod2.id : null, 31, null);
        } else {
            customerState = null;
        }
        CustomerState newCustomer = customerState;
        this.savedStateHandle.set(SAVED_CUSTOMER, newCustomer);
    }

    public final void updateMostRecentlySelectedSavedPaymentMethod(@Nullable PaymentMethod paymentMethod) {
        this.savedStateHandle.set(SAVED_PM_SELECTION, (Object)paymentMethod);
    }

    private static final List paymentMethods$lambda$0(CustomerState state2) {
        Object object = state2;
        if (object == null || (object = ((CustomerState)object).getPaymentMethods()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    private static final boolean canRemove$lambda$2(CustomerState customerState) {
        boolean bl;
        CustomerState customerState2 = customerState;
        if (customerState2 != null) {
            CustomerState $this$canRemove_u24lambda_u242_u24lambda_u241 = customerState2;
            boolean bl2 = false;
            boolean hasRemovePermissions = customerState.getPermissions().getCanRemovePaymentMethods();
            boolean hasRemoveLastPaymentMethodPermissions = customerState.getPermissions().getCanRemoveLastPaymentMethod();
            switch ($this$canRemove_u24lambda_u242_u24lambda_u241.getPaymentMethods().size()) {
                case 0: {
                    bl = false;
                    break;
                }
                case 1: {
                    if (hasRemoveLastPaymentMethodPermissions && hasRemovePermissions) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    bl = hasRemovePermissions;
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/stripe/android/paymentsheet/CustomerStateHolder$Companion;", "", "<init>", "()V", "SAVED_CUSTOMER", "", "SAVED_PM_SELECTION", "create", "Lcom/stripe/android/paymentsheet/CustomerStateHolder;", "viewModel", "Lcom/stripe/android/paymentsheet/viewmodels/BaseSheetViewModel;", "paymentsheet_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CustomerStateHolder create(@NotNull BaseSheetViewModel viewModel) {
            Intrinsics.checkNotNullParameter((Object)((Object)viewModel), (String)"viewModel");
            return new CustomerStateHolder(viewModel.getSavedStateHandle(), viewModel.getSelection$paymentsheet_release());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

