/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentelement.embedded.manage;

import androidx.compose.foundation.layout.Arrangement;
import androidx.compose.foundation.layout.ColumnKt;
import androidx.compose.foundation.layout.ColumnScope;
import androidx.compose.foundation.layout.ColumnScopeInstance;
import androidx.compose.runtime.Applier;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.ComposableTarget;
import androidx.compose.runtime.ComposablesKt;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.CompositionLocalMap;
import androidx.compose.runtime.SkippableUpdater;
import androidx.compose.runtime.Updater;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.Alignment;
import androidx.compose.ui.Modifier;
import androidx.compose.ui.layout.LayoutKt;
import androidx.compose.ui.layout.MeasurePolicy;
import androidx.compose.ui.node.ComposeUiNode;
import androidx.compose.ui.unit.Dp;
import com.stripe.android.core.strings.ResolvableString;
import com.stripe.android.paymentsheet.analytics.EventReporter;
import com.stripe.android.paymentsheet.navigation.NavigationHandler;
import com.stripe.android.paymentsheet.ui.PaymentSheetTopBarState;
import com.stripe.android.paymentsheet.ui.UpdatePaymentMethodInteractor;
import com.stripe.android.paymentsheet.ui.UpdatePaymentMethodUIKt;
import com.stripe.android.paymentsheet.utils.ComposeUtilsKt;
import com.stripe.android.paymentsheet.verticalmode.ManageScreenInteractor;
import com.stripe.android.paymentsheet.verticalmode.ManageScreenUIKt;
import com.stripe.android.uicore.utils.StateFlowsKt;
import java.io.Closeable;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.StateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001:\u0002!\"B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB!\b\u0016\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\fJ\u000e\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u0006H\u0002J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006#"}, d2={"Lcom/stripe/android/paymentelement/embedded/manage/ManageNavigator;", "", "eventReporter", "Lcom/stripe/android/paymentsheet/analytics/EventReporter;", "navigationHandler", "Lcom/stripe/android/paymentsheet/navigation/NavigationHandler;", "Lcom/stripe/android/paymentelement/embedded/manage/ManageNavigator$Screen;", "<init>", "(Lcom/stripe/android/paymentsheet/analytics/EventReporter;Lcom/stripe/android/paymentsheet/navigation/NavigationHandler;)V", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "initialScreen", "(Lkotlinx/coroutines/CoroutineScope;Lcom/stripe/android/paymentelement/embedded/manage/ManageNavigator$Screen;Lcom/stripe/android/paymentsheet/analytics/EventReporter;)V", "screen", "Lkotlinx/coroutines/flow/StateFlow;", "getScreen", "()Lkotlinx/coroutines/flow/StateFlow;", "canGoBack", "", "getCanGoBack", "()Z", "_result", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "result", "Lkotlinx/coroutines/flow/SharedFlow;", "getResult", "()Lkotlinx/coroutines/flow/SharedFlow;", "performAction", "action", "Lcom/stripe/android/paymentelement/embedded/manage/ManageNavigator$Action;", "onScreenShown", "onScreenHidden", "Screen", "Action", "paymentsheet_release"})
@StabilityInferred(parameters=0)
public final class ManageNavigator {
    @NotNull
    private final EventReporter eventReporter;
    @NotNull
    private final NavigationHandler<Screen> navigationHandler;
    @NotNull
    private final StateFlow<Screen> screen;
    @NotNull
    private final MutableSharedFlow<Unit> _result;
    @NotNull
    private final SharedFlow<Unit> result;
    public static final int $stable = 8;

    private ManageNavigator(EventReporter eventReporter, NavigationHandler<Screen> navigationHandler) {
        this.eventReporter = eventReporter;
        this.navigationHandler = navigationHandler;
        this.screen = this.navigationHandler.getCurrentScreen();
        this._result = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, null, (int)6, null);
        this.result = FlowKt.asSharedFlow(this._result);
        this.onScreenShown((Screen)this.screen.getValue());
    }

    public ManageNavigator(@NotNull CoroutineScope coroutineScope, @NotNull Screen initialScreen, @NotNull EventReporter eventReporter) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)initialScreen, (String)"initialScreen");
        Intrinsics.checkNotNullParameter((Object)eventReporter, (String)"eventReporter");
        this(eventReporter, new NavigationHandler<Screen>(coroutineScope, initialScreen, false, ManageNavigator::_init_$lambda$0));
    }

    @NotNull
    public final StateFlow<Screen> getScreen() {
        return this.screen;
    }

    public final boolean getCanGoBack() {
        return this.navigationHandler.getCanGoBack();
    }

    @NotNull
    public final SharedFlow<Unit> getResult() {
        return this.result;
    }

    public final void performAction(@NotNull Action action2) {
        Intrinsics.checkNotNullParameter((Object)action2, (String)"action");
        Action action3 = action2;
        if (action3 instanceof Action.Back) {
            this.onScreenHidden((Screen)this.screen.getValue());
            if (this.navigationHandler.getCanGoBack()) {
                this.navigationHandler.pop();
            } else {
                this._result.tryEmit((Object)Unit.INSTANCE);
            }
        } else if (action3 instanceof Action.Close) {
            this.onScreenHidden((Screen)this.screen.getValue());
            this._result.tryEmit((Object)Unit.INSTANCE);
        } else if (action3 instanceof Action.GoToScreen) {
            this.navigationHandler.transitionToWithDelay(((Action.GoToScreen)action2).getScreen());
            this.onScreenShown(((Action.GoToScreen)action2).getScreen());
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void onScreenShown(Screen screen) {
        Screen screen2 = screen;
        if (screen2 instanceof Screen.All) {
            this.eventReporter.onShowManageSavedPaymentMethods();
        } else if (screen2 instanceof Screen.Update) {
            this.eventReporter.onShowEditablePaymentOption();
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void onScreenHidden(Screen screen) {
        Screen screen2 = screen;
        if (!(screen2 instanceof Screen.All)) {
            if (screen2 instanceof Screen.Update) {
                this.eventReporter.onHideEditablePaymentOption();
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private static final Unit _init_$lambda$0(Screen it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\u0007\b\t\u00a8\u0006\n"}, d2={"Lcom/stripe/android/paymentelement/embedded/manage/ManageNavigator$Action;", "", "<init>", "()V", "Back", "Close", "GoToScreen", "Lcom/stripe/android/paymentelement/embedded/manage/ManageNavigator$Action$Back;", "Lcom/stripe/android/paymentelement/embedded/manage/ManageNavigator$Action$Close;", "Lcom/stripe/android/paymentelement/embedded/manage/ManageNavigator$Action$GoToScreen;", "paymentsheet_release"})
    @StabilityInferred(parameters=1)
    public static abstract class Action {
        public static final int $stable;

        private Action() {
        }

        public /* synthetic */ Action(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/stripe/android/paymentelement/embedded/manage/ManageNavigator$Action$Back;", "Lcom/stripe/android/paymentelement/embedded/manage/ManageNavigator$Action;", "<init>", "()V", "paymentsheet_release"})
        @StabilityInferred(parameters=1)
        public static final class Back
        extends Action {
            @NotNull
            public static final Back INSTANCE = new Back();
            public static final int $stable;

            private Back() {
                super(null);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/stripe/android/paymentelement/embedded/manage/ManageNavigator$Action$Close;", "Lcom/stripe/android/paymentelement/embedded/manage/ManageNavigator$Action;", "<init>", "()V", "paymentsheet_release"})
        @StabilityInferred(parameters=1)
        public static final class Close
        extends Action {
            @NotNull
            public static final Close INSTANCE = new Close();
            public static final int $stable;

            private Close() {
                super(null);
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/paymentelement/embedded/manage/ManageNavigator$Action$GoToScreen;", "Lcom/stripe/android/paymentelement/embedded/manage/ManageNavigator$Action;", "screen", "Lcom/stripe/android/paymentelement/embedded/manage/ManageNavigator$Screen;", "<init>", "(Lcom/stripe/android/paymentelement/embedded/manage/ManageNavigator$Screen;)V", "getScreen", "()Lcom/stripe/android/paymentelement/embedded/manage/ManageNavigator$Screen;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "paymentsheet_release"})
        @StabilityInferred(parameters=1)
        public static final class GoToScreen
        extends Action {
            @NotNull
            private final Screen screen;
            public static final int $stable;

            public GoToScreen(@NotNull Screen screen) {
                Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
                super(null);
                this.screen = screen;
            }

            @NotNull
            public final Screen getScreen() {
                return this.screen;
            }

            @NotNull
            public final Screen component1() {
                return this.screen;
            }

            @NotNull
            public final GoToScreen copy(@NotNull Screen screen) {
                Intrinsics.checkNotNullParameter((Object)screen, (String)"screen");
                return new GoToScreen(screen);
            }

            public static /* synthetic */ GoToScreen copy$default(GoToScreen goToScreen, Screen screen, int n, Object object) {
                if ((n & 1) != 0) {
                    screen = goToScreen.screen;
                }
                return goToScreen.copy(screen);
            }

            @NotNull
            public String toString() {
                return "GoToScreen(screen=" + this.screen + ")";
            }

            public int hashCode() {
                return this.screen.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof GoToScreen)) {
                    return false;
                }
                GoToScreen goToScreen = (GoToScreen)other;
                return Intrinsics.areEqual((Object)this.screen, (Object)goToScreen.screen);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00020\u0005H'\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bH&J\u0010\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\bH&J\b\u0010\f\u001a\u00020\rH&\u0082\u0001\u0002\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/paymentelement/embedded/manage/ManageNavigator$Screen;", "", "<init>", "()V", "Content", "", "(Landroidx/compose/runtime/Composer;I)V", "topBarState", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/stripe/android/paymentsheet/ui/PaymentSheetTopBarState;", "title", "Lcom/stripe/android/core/strings/ResolvableString;", "isPerformingNetworkOperation", "", "All", "Update", "Lcom/stripe/android/paymentelement/embedded/manage/ManageNavigator$Screen$All;", "Lcom/stripe/android/paymentelement/embedded/manage/ManageNavigator$Screen$Update;", "paymentsheet_release"})
    @StabilityInferred(parameters=1)
    public static abstract class Screen {
        public static final int $stable;

        private Screen() {
        }

        @Composable
        public abstract void Content(@Nullable Composer var1, int var2);

        @NotNull
        public abstract StateFlow<PaymentSheetTopBarState> topBarState();

        @NotNull
        public abstract StateFlow<ResolvableString> title();

        public abstract boolean isPerformingNetworkOperation();

        public /* synthetic */ Screen(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\bH\u0016J\u0010\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\r\u0010\u000e\u001a\u00020\u000fH\u0017\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/paymentelement/embedded/manage/ManageNavigator$Screen$All;", "Lcom/stripe/android/paymentelement/embedded/manage/ManageNavigator$Screen;", "Ljava/io/Closeable;", "interactor", "Lcom/stripe/android/paymentsheet/verticalmode/ManageScreenInteractor;", "<init>", "(Lcom/stripe/android/paymentsheet/verticalmode/ManageScreenInteractor;)V", "topBarState", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/stripe/android/paymentsheet/ui/PaymentSheetTopBarState;", "title", "Lcom/stripe/android/core/strings/ResolvableString;", "isPerformingNetworkOperation", "", "Content", "", "(Landroidx/compose/runtime/Composer;I)V", "close", "paymentsheet_release"})
        @StabilityInferred(parameters=0)
        @SourceDebugExtension(value={"SMAP\nManageNavigator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManageNavigator.kt\ncom/stripe/android/paymentelement/embedded/manage/ManageNavigator$Screen$All\n+ 2 Column.kt\nandroidx/compose/foundation/layout/ColumnKt\n+ 3 Layout.kt\nandroidx/compose/ui/layout/LayoutKt\n+ 4 Composables.kt\nandroidx/compose/runtime/ComposablesKt\n+ 5 Composer.kt\nandroidx/compose/runtime/Updater\n+ 6 Dp.kt\nandroidx/compose/ui/unit/DpKt\n*L\n1#1,162:1\n73#2,7:163\n80#2:198\n84#2:204\n79#3,11:170\n92#3:203\n456#4,8:181\n464#4,3:195\n467#4,3:200\n3737#5,6:189\n154#6:199\n*S KotlinDebug\n*F\n+ 1 ManageNavigator.kt\ncom/stripe/android/paymentelement/embedded/manage/ManageNavigator$Screen$All\n*L\n120#1:163,7\n120#1:198\n120#1:204\n120#1:170,11\n120#1:203\n120#1:181,8\n120#1:195,3\n120#1:200,3\n120#1:189,6\n122#1:199\n*E\n"})
        public static final class All
        extends Screen
        implements Closeable {
            @NotNull
            private final ManageScreenInteractor interactor;
            public static final int $stable = 8;

            public All(@NotNull ManageScreenInteractor interactor) {
                Intrinsics.checkNotNullParameter((Object)interactor, (String)"interactor");
                super(null);
                this.interactor = interactor;
            }

            @Override
            @NotNull
            public StateFlow<PaymentSheetTopBarState> topBarState() {
                return StateFlowsKt.mapAsStateFlow(this.interactor.getState(), arg_0 -> All.topBarState$lambda$0(this, arg_0));
            }

            @Override
            @NotNull
            public StateFlow<ResolvableString> title() {
                return StateFlowsKt.mapAsStateFlow(this.interactor.getState(), All::title$lambda$1);
            }

            @Override
            public boolean isPerformingNetworkOperation() {
                return false;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @Composable
            @ComposableTarget(applier="androidx.compose.ui.UiComposable")
            public void Content(@Nullable Composer $composer, int $changed) {
                void $composer2;
                void $changed$iv$iv$iv;
                void skippableUpdate$iv$iv$iv;
                void $changed$iv$iv;
                void $changed$iv;
                $composer.startReplaceGroup(-1339058932);
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventStart((int)-1339058932, (int)$changed, (int)-1, (String)"com.stripe.android.paymentelement.embedded.manage.ManageNavigator.Screen.All.Content (ManageNavigator.kt:118)");
                }
                boolean bl = false;
                boolean $i$f$Column = false;
                $composer.startReplaceableGroup(-483455358);
                ComposerKt.sourceInformation((Composer)$composer, (String)"CC(Column)P(2,3,1)77@3865L61,78@3931L133:Column.kt#2w3rfo");
                Modifier modifier$iv = (Modifier)Modifier.Companion;
                Arrangement.Vertical verticalArrangement$iv = Arrangement.INSTANCE.getTop();
                Alignment.Horizontal horizontalAlignment$iv = Alignment.Companion.getStart();
                MeasurePolicy measurePolicy$iv = ColumnKt.columnMeasurePolicy((Arrangement.Vertical)verticalArrangement$iv, (Alignment.Horizontal)horizontalAlignment$iv, (Composer)$composer, (int)(0xE & $changed$iv >> 3 | 0x70 & $changed$iv >> 3));
                int n = 0x70 & $changed$iv << 3;
                boolean $i$f$Layout = false;
                $composer.startReplaceableGroup(-1323940314);
                ComposerKt.sourceInformation((Composer)$composer, (String)"CC(Layout)P(!1,2)78@3182L23,80@3272L420:Layout.kt#80mrfh");
                int compositeKeyHash$iv$iv = ComposablesKt.getCurrentCompositeKeyHash((Composer)$composer, (int)0);
                CompositionLocalMap localMap$iv$iv = $composer.getCurrentCompositionLocalMap();
                Function0 function0 = ComposeUiNode.Companion.getConstructor();
                Function3 function3 = LayoutKt.modifierMaterializerOf((Modifier)modifier$iv);
                int n2 = 6 | 0x1C00 & $changed$iv$iv << 9;
                boolean $i$f$ReusableComposeNode = false;
                if (!($composer.getApplier() instanceof Applier)) {
                    ComposablesKt.invalidApplier();
                }
                $composer.startReusableNode();
                if ($composer.getInserting()) {
                    void factory$iv$iv$iv;
                    $composer.createNode((Function0)factory$iv$iv$iv);
                } else {
                    $composer.useNode();
                }
                Composer $this$Layout_u24lambda_u240$iv$iv = Updater.constructor-impl((Composer)$composer);
                boolean bl2 = false;
                Updater.set-impl((Composer)$this$Layout_u24lambda_u240$iv$iv, (Object)measurePolicy$iv, (Function2)ComposeUiNode.Companion.getSetMeasurePolicy());
                Updater.set-impl((Composer)$this$Layout_u24lambda_u240$iv$iv, (Object)localMap$iv$iv, (Function2)ComposeUiNode.Companion.getSetResolvedCompositionLocals());
                Function2 block$iv$iv$iv = ComposeUiNode.Companion.getSetCompositeKeyHash();
                boolean bl3 = false;
                Composer $this$set_impl_u24lambda_u240$iv$iv$iv = $this$Layout_u24lambda_u240$iv$iv;
                boolean bl4 = false;
                if ($this$set_impl_u24lambda_u240$iv$iv$iv.getInserting() || !Intrinsics.areEqual((Object)$this$set_impl_u24lambda_u240$iv$iv$iv.rememberedValue(), (Object)compositeKeyHash$iv$iv)) {
                    $this$set_impl_u24lambda_u240$iv$iv$iv.updateRememberedValue((Object)compositeKeyHash$iv$iv);
                    $this$Layout_u24lambda_u240$iv$iv.apply((Object)compositeKeyHash$iv$iv, block$iv$iv$iv);
                }
                skippableUpdate$iv$iv$iv.invoke((Object)SkippableUpdater.box-impl((Composer)SkippableUpdater.constructor-impl((Composer)$composer)), (Object)$composer, (Object)(0x70 & $changed$iv$iv$iv >> 3));
                $composer.startReplaceableGroup(2058660585);
                int n3 = 0xE & $changed$iv$iv$iv >> 9;
                Composer $composer$iv = $composer;
                boolean bl5 = false;
                ComposerKt.sourceInformationMarkerStart((Composer)$composer$iv, (int)276693656, (String)"C79@3979L9:Column.kt#2w3rfo");
                int n4 = 6 | 0x70 & $changed$iv >> 6;
                Composer composer = $composer$iv;
                ColumnScope $this$Content_u24lambda_u242 = (ColumnScope)ColumnScopeInstance.INSTANCE;
                boolean bl6 = false;
                ManageScreenUIKt.ManageScreenUI(this.interactor, (Composer)$composer2, 0);
                int $this$dp$iv = 12;
                boolean $i$f$getDp = false;
                ComposeUtilsKt.PaymentSheetContentPadding-kHDZbjc(Dp.constructor-impl((float)$this$dp$iv), (Composer)$composer2, 6, 0);
                ComposerKt.sourceInformationMarkerEnd((Composer)$composer$iv);
                $composer.endReplaceableGroup();
                $composer.endNode();
                $composer.endReplaceableGroup();
                $composer.endReplaceableGroup();
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventEnd();
                }
                $composer.endReplaceGroup();
            }

            @Override
            public void close() {
                this.interactor.close();
            }

            private static final PaymentSheetTopBarState topBarState$lambda$0(All this$0, ManageScreenInteractor.State state2) {
                Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
                return state2.topBarState(this$0.interactor);
            }

            private static final ResolvableString title$lambda$1(ManageScreenInteractor.State state2) {
                Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
                return state2.getTitle();
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007H\u0016J\u0010\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0007H\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\r\u0010\r\u001a\u00020\u000eH\u0017\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/stripe/android/paymentelement/embedded/manage/ManageNavigator$Screen$Update;", "Lcom/stripe/android/paymentelement/embedded/manage/ManageNavigator$Screen;", "interactor", "Lcom/stripe/android/paymentsheet/ui/UpdatePaymentMethodInteractor;", "<init>", "(Lcom/stripe/android/paymentsheet/ui/UpdatePaymentMethodInteractor;)V", "topBarState", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/stripe/android/paymentsheet/ui/PaymentSheetTopBarState;", "title", "Lcom/stripe/android/core/strings/ResolvableString;", "isPerformingNetworkOperation", "", "Content", "", "(Landroidx/compose/runtime/Composer;I)V", "paymentsheet_release"})
        @StabilityInferred(parameters=0)
        @SourceDebugExtension(value={"SMAP\nManageNavigator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ManageNavigator.kt\ncom/stripe/android/paymentelement/embedded/manage/ManageNavigator$Screen$Update\n+ 2 Column.kt\nandroidx/compose/foundation/layout/ColumnKt\n+ 3 Layout.kt\nandroidx/compose/ui/layout/LayoutKt\n+ 4 Composables.kt\nandroidx/compose/runtime/ComposablesKt\n+ 5 Composer.kt\nandroidx/compose/runtime/Updater\n+ 6 Dp.kt\nandroidx/compose/ui/unit/DpKt\n*L\n1#1,162:1\n73#2,7:163\n80#2:198\n84#2:204\n79#3,11:170\n92#3:203\n456#4,8:181\n464#4,3:195\n467#4,3:200\n3737#5,6:189\n154#6:199\n*S KotlinDebug\n*F\n+ 1 ManageNavigator.kt\ncom/stripe/android/paymentelement/embedded/manage/ManageNavigator$Screen$Update\n*L\n146#1:163,7\n146#1:198\n146#1:204\n146#1:170,11\n146#1:203\n146#1:181,8\n146#1:195,3\n146#1:200,3\n146#1:189,6\n148#1:199\n*E\n"})
        public static final class Update
        extends Screen {
            @NotNull
            private final UpdatePaymentMethodInteractor interactor;
            public static final int $stable = 8;

            public Update(@NotNull UpdatePaymentMethodInteractor interactor) {
                Intrinsics.checkNotNullParameter((Object)interactor, (String)"interactor");
                super(null);
                this.interactor = interactor;
            }

            @Override
            @NotNull
            public StateFlow<PaymentSheetTopBarState> topBarState() {
                return StateFlowsKt.stateFlowOf((Object)this.interactor.getTopBarState());
            }

            @Override
            @NotNull
            public StateFlow<ResolvableString> title() {
                return StateFlowsKt.stateFlowOf((Object)this.interactor.getScreenTitle());
            }

            @Override
            public boolean isPerformingNetworkOperation() {
                return ((UpdatePaymentMethodInteractor.State)this.interactor.getState().getValue()).getStatus().isPerformingNetworkOperation();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @Composable
            @ComposableTarget(applier="androidx.compose.ui.UiComposable")
            public void Content(@Nullable Composer $composer, int $changed) {
                void $composer2;
                void $changed$iv$iv$iv;
                void skippableUpdate$iv$iv$iv;
                void $changed$iv$iv;
                void $changed$iv;
                $composer.startReplaceGroup(1472404668);
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventStart((int)1472404668, (int)$changed, (int)-1, (String)"com.stripe.android.paymentelement.embedded.manage.ManageNavigator.Screen.Update.Content (ManageNavigator.kt:144)");
                }
                boolean bl = false;
                boolean $i$f$Column = false;
                $composer.startReplaceableGroup(-483455358);
                ComposerKt.sourceInformation((Composer)$composer, (String)"CC(Column)P(2,3,1)77@3865L61,78@3931L133:Column.kt#2w3rfo");
                Modifier modifier$iv = (Modifier)Modifier.Companion;
                Arrangement.Vertical verticalArrangement$iv = Arrangement.INSTANCE.getTop();
                Alignment.Horizontal horizontalAlignment$iv = Alignment.Companion.getStart();
                MeasurePolicy measurePolicy$iv = ColumnKt.columnMeasurePolicy((Arrangement.Vertical)verticalArrangement$iv, (Alignment.Horizontal)horizontalAlignment$iv, (Composer)$composer, (int)(0xE & $changed$iv >> 3 | 0x70 & $changed$iv >> 3));
                int n = 0x70 & $changed$iv << 3;
                boolean $i$f$Layout = false;
                $composer.startReplaceableGroup(-1323940314);
                ComposerKt.sourceInformation((Composer)$composer, (String)"CC(Layout)P(!1,2)78@3182L23,80@3272L420:Layout.kt#80mrfh");
                int compositeKeyHash$iv$iv = ComposablesKt.getCurrentCompositeKeyHash((Composer)$composer, (int)0);
                CompositionLocalMap localMap$iv$iv = $composer.getCurrentCompositionLocalMap();
                Function0 function0 = ComposeUiNode.Companion.getConstructor();
                Function3 function3 = LayoutKt.modifierMaterializerOf((Modifier)modifier$iv);
                int n2 = 6 | 0x1C00 & $changed$iv$iv << 9;
                boolean $i$f$ReusableComposeNode = false;
                if (!($composer.getApplier() instanceof Applier)) {
                    ComposablesKt.invalidApplier();
                }
                $composer.startReusableNode();
                if ($composer.getInserting()) {
                    void factory$iv$iv$iv;
                    $composer.createNode((Function0)factory$iv$iv$iv);
                } else {
                    $composer.useNode();
                }
                Composer $this$Layout_u24lambda_u240$iv$iv = Updater.constructor-impl((Composer)$composer);
                boolean bl2 = false;
                Updater.set-impl((Composer)$this$Layout_u24lambda_u240$iv$iv, (Object)measurePolicy$iv, (Function2)ComposeUiNode.Companion.getSetMeasurePolicy());
                Updater.set-impl((Composer)$this$Layout_u24lambda_u240$iv$iv, (Object)localMap$iv$iv, (Function2)ComposeUiNode.Companion.getSetResolvedCompositionLocals());
                Function2 block$iv$iv$iv = ComposeUiNode.Companion.getSetCompositeKeyHash();
                boolean bl3 = false;
                Composer $this$set_impl_u24lambda_u240$iv$iv$iv = $this$Layout_u24lambda_u240$iv$iv;
                boolean bl4 = false;
                if ($this$set_impl_u24lambda_u240$iv$iv$iv.getInserting() || !Intrinsics.areEqual((Object)$this$set_impl_u24lambda_u240$iv$iv$iv.rememberedValue(), (Object)compositeKeyHash$iv$iv)) {
                    $this$set_impl_u24lambda_u240$iv$iv$iv.updateRememberedValue((Object)compositeKeyHash$iv$iv);
                    $this$Layout_u24lambda_u240$iv$iv.apply((Object)compositeKeyHash$iv$iv, block$iv$iv$iv);
                }
                skippableUpdate$iv$iv$iv.invoke((Object)SkippableUpdater.box-impl((Composer)SkippableUpdater.constructor-impl((Composer)$composer)), (Object)$composer, (Object)(0x70 & $changed$iv$iv$iv >> 3));
                $composer.startReplaceableGroup(2058660585);
                int n3 = 0xE & $changed$iv$iv$iv >> 9;
                Composer $composer$iv = $composer;
                boolean bl5 = false;
                ComposerKt.sourceInformationMarkerStart((Composer)$composer$iv, (int)276693656, (String)"C79@3979L9:Column.kt#2w3rfo");
                int n4 = 6 | 0x70 & $changed$iv >> 6;
                Composer composer = $composer$iv;
                ColumnScope $this$Content_u24lambda_u240 = (ColumnScope)ColumnScopeInstance.INSTANCE;
                boolean bl6 = false;
                UpdatePaymentMethodUIKt.UpdatePaymentMethodUI(this.interactor, (Modifier)Modifier.Companion, (Composer)$composer2, 48);
                int $this$dp$iv = 16;
                boolean $i$f$getDp = false;
                ComposeUtilsKt.PaymentSheetContentPadding-kHDZbjc(Dp.constructor-impl((float)$this$dp$iv), (Composer)$composer2, 6, 0);
                ComposerKt.sourceInformationMarkerEnd((Composer)$composer$iv);
                $composer.endReplaceableGroup();
                $composer.endNode();
                $composer.endReplaceableGroup();
                $composer.endReplaceableGroup();
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventEnd();
                }
                $composer.endReplaceGroup();
            }
        }
    }
}

