/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentelement.embedded.content;

import android.content.Context;
import android.graphics.drawable.Drawable;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.text.AnnotatedString;
import com.stripe.android.core.strings.ResolvableString;
import com.stripe.android.lpmfoundations.paymentmethod.PaymentMethodMetadata;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.paymentelement.EmbeddedPaymentElement;
import com.stripe.android.paymentelement.ExperimentalEmbeddedPaymentElementApi;
import com.stripe.android.paymentelement.embedded.content.NullUiDefinitionFactoryHelper;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.model.PaymentSelection;
import com.stripe.android.paymentsheet.model.PaymentSelectionKt;
import com.stripe.android.uicore.elements.FormElement;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/stripe/android/paymentelement/embedded/content/PaymentOptionDisplayDataFactory;", "", "iconLoader", "Lcom/stripe/android/paymentsheet/model/PaymentSelection$IconLoader;", "context", "Landroid/content/Context;", "<init>", "(Lcom/stripe/android/paymentsheet/model/PaymentSelection$IconLoader;Landroid/content/Context;)V", "create", "Lcom/stripe/android/paymentelement/EmbeddedPaymentElement$PaymentOptionDisplayData;", "selection", "Lcom/stripe/android/paymentsheet/model/PaymentSelection;", "paymentMethodMetadata", "Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodMetadata;", "paymentsheet_release"})
@ExperimentalEmbeddedPaymentElementApi
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nPaymentOptionDisplayDataFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PaymentOptionDisplayDataFactory.kt\ncom/stripe/android/paymentelement/embedded/content/PaymentOptionDisplayDataFactory\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1#2:66\n*E\n"})
public final class PaymentOptionDisplayDataFactory {
    @NotNull
    private final PaymentSelection.IconLoader iconLoader;
    @NotNull
    private final Context context;
    public static final int $stable = 8;

    @Inject
    public PaymentOptionDisplayDataFactory(@NotNull PaymentSelection.IconLoader iconLoader, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)iconLoader, (String)"iconLoader");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.iconLoader = iconLoader;
        this.context = context;
    }

    @Nullable
    public final EmbeddedPaymentElement.PaymentOptionDisplayData create(@Nullable PaymentSelection selection, @NotNull PaymentMethodMetadata paymentMethodMetadata) {
        ResolvableString resolvableString;
        List<FormElement> list;
        Object object;
        block10: {
            Intrinsics.checkNotNullParameter((Object)paymentMethodMetadata, (String)"paymentMethodMetadata");
            if (selection == null) {
                return null;
            }
            object = selection;
            if (object instanceof PaymentSelection.New) {
                list = paymentMethodMetadata.formElementsForCode(PaymentSelectionKt.getPaymentMethodType(selection), NullUiDefinitionFactoryHelper.INSTANCE.getNullEmbeddedUiDefinitionFactory());
                if (list != null) {
                    for (FormElement it : (Iterable)list) {
                        boolean bl = false;
                        ResolvableString resolvableString2 = it.getMandateText();
                        if (resolvableString2 == null) continue;
                        resolvableString = resolvableString2;
                        break block10;
                    }
                    resolvableString = null;
                } else {
                    resolvableString = null;
                }
            } else if (object instanceof PaymentSelection.Saved) {
                resolvableString = ((PaymentSelection.Saved)selection).mandateText(paymentMethodMetadata.getMerchantName(), paymentMethodMetadata.hasIntentToSetup());
            } else if (object instanceof PaymentSelection.CustomPaymentMethod || object instanceof PaymentSelection.ExternalPaymentMethod || object instanceof PaymentSelection.GooglePay || object instanceof PaymentSelection.Link) {
                resolvableString = null;
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        ResolvableString mandate = resolvableString;
        object = PaymentSelectionKt.getLabel(selection).resolve(this.context);
        PaymentMethod.BillingDetails billingDetails = PaymentSelectionKt.getBillingDetails(selection);
        list = billingDetails != null ? PaymentSelectionKt.toPaymentSheetBillingDetails(billingDetails) : null;
        String string2 = PaymentSelectionKt.getPaymentMethodType(selection);
        AnnotatedString annotatedString = mandate == null ? null : new AnnotatedString(mandate.resolve(this.context), null, null, 6, null);
        return new EmbeddedPaymentElement.PaymentOptionDisplayData((Function1<? super Continuation<? super Drawable>, ? extends Object>)((Function1)new Function1<Continuation<? super Drawable>, Object>(this, selection, null){
            int label;
            final /* synthetic */ PaymentOptionDisplayDataFactory this$0;
            final /* synthetic */ PaymentSelection $selection;
            {
                this.this$0 = $receiver;
                this.$selection = $selection;
                super(1, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = PaymentOptionDisplayDataFactory.access$getIconLoader$p(this.this$0).load(PaymentSelectionKt.getDrawableResourceId(this.$selection), PaymentSelectionKt.getLightThemeIconUrl(this.$selection), PaymentSelectionKt.getDarkThemeIconUrl(this.$selection), (Continuation<? super Drawable>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(Continuation<? super Drawable> p1) {
                return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
            }
        }), (String)object, (PaymentSheet.BillingDetails)((Object)list), string2, annotatedString);
    }

    public static final /* synthetic */ PaymentSelection.IconLoader access$getIconLoader$p(PaymentOptionDisplayDataFactory $this) {
        return $this.iconLoader;
    }
}

