/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentelement.embedded.content;

import androidx.activity.result.ActivityResultCaller;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import com.stripe.android.lpmfoundations.paymentmethod.PaymentMethodMetadata;
import com.stripe.android.paymentelement.EmbeddedPaymentElement;
import com.stripe.android.paymentelement.callbacks.PaymentElementCallbackIdentifier;
import com.stripe.android.paymentelement.embedded.EmbeddedResultCallbackHelper;
import com.stripe.android.paymentelement.embedded.EmbeddedSelectionHolder;
import com.stripe.android.paymentelement.embedded.content.EmbeddedConfirmationStateHolder;
import com.stripe.android.paymentelement.embedded.content.EmbeddedPaymentElementScope;
import com.stripe.android.paymentelement.embedded.content.EmbeddedSheetLauncher;
import com.stripe.android.paymentelement.embedded.content.SheetStateHolder;
import com.stripe.android.paymentelement.embedded.form.FormContract;
import com.stripe.android.paymentelement.embedded.form.FormResult;
import com.stripe.android.paymentelement.embedded.manage.ManageContract;
import com.stripe.android.paymentelement.embedded.manage.ManageResult;
import com.stripe.android.payments.core.analytics.ErrorReporter;
import com.stripe.android.paymentsheet.CustomerStateHolder;
import com.stripe.android.paymentsheet.model.PaymentSelection;
import com.stripe.android.paymentsheet.state.CustomerState;
import javax.inject.Inject;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@EmbeddedPaymentElementScope
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001BW\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\n\b\u0001\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\b\b\u0001\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0004\b\u0014\u0010\u0015J*\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\"\u0010%\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010&\u001a\u00020'2\b\u0010(\u001a\u0004\u0018\u00010)H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/stripe/android/paymentelement/embedded/content/DefaultEmbeddedSheetLauncher;", "Lcom/stripe/android/paymentelement/embedded/content/EmbeddedSheetLauncher;", "activityResultCaller", "Landroidx/activity/result/ActivityResultCaller;", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "selectionHolder", "Lcom/stripe/android/paymentelement/embedded/EmbeddedSelectionHolder;", "customerStateHolder", "Lcom/stripe/android/paymentsheet/CustomerStateHolder;", "sheetStateHolder", "Lcom/stripe/android/paymentelement/embedded/content/SheetStateHolder;", "errorReporter", "Lcom/stripe/android/payments/core/analytics/ErrorReporter;", "statusBarColor", "", "paymentElementCallbackIdentifier", "", "embeddedResultCallbackHelper", "Lcom/stripe/android/paymentelement/embedded/EmbeddedResultCallbackHelper;", "<init>", "(Landroidx/activity/result/ActivityResultCaller;Landroidx/lifecycle/LifecycleOwner;Lcom/stripe/android/paymentelement/embedded/EmbeddedSelectionHolder;Lcom/stripe/android/paymentsheet/CustomerStateHolder;Lcom/stripe/android/paymentelement/embedded/content/SheetStateHolder;Lcom/stripe/android/payments/core/analytics/ErrorReporter;Ljava/lang/Integer;Ljava/lang/String;Lcom/stripe/android/paymentelement/embedded/EmbeddedResultCallbackHelper;)V", "Ljava/lang/Integer;", "formActivityLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "Lcom/stripe/android/paymentelement/embedded/form/FormContract$Args;", "manageActivityLauncher", "Lcom/stripe/android/paymentelement/embedded/manage/ManageContract$Args;", "launchForm", "", "code", "paymentMethodMetadata", "Lcom/stripe/android/lpmfoundations/paymentmethod/PaymentMethodMetadata;", "hasSavedPaymentMethods", "", "embeddedConfirmationState", "Lcom/stripe/android/paymentelement/embedded/content/EmbeddedConfirmationStateHolder$State;", "launchManage", "customerState", "Lcom/stripe/android/paymentsheet/state/CustomerState;", "selection", "Lcom/stripe/android/paymentsheet/model/PaymentSelection;", "paymentsheet_release"})
@StabilityInferred(parameters=0)
public final class DefaultEmbeddedSheetLauncher
implements EmbeddedSheetLauncher {
    @NotNull
    private final EmbeddedSelectionHolder selectionHolder;
    @NotNull
    private final CustomerStateHolder customerStateHolder;
    @NotNull
    private final SheetStateHolder sheetStateHolder;
    @NotNull
    private final ErrorReporter errorReporter;
    @Nullable
    private final Integer statusBarColor;
    @NotNull
    private final String paymentElementCallbackIdentifier;
    @NotNull
    private final ActivityResultLauncher<FormContract.Args> formActivityLauncher;
    @NotNull
    private final ActivityResultLauncher<ManageContract.Args> manageActivityLauncher;
    public static final int $stable = 8;

    @Inject
    public DefaultEmbeddedSheetLauncher(@NotNull ActivityResultCaller activityResultCaller, @NotNull LifecycleOwner lifecycleOwner, @NotNull EmbeddedSelectionHolder selectionHolder, @NotNull CustomerStateHolder customerStateHolder, @NotNull SheetStateHolder sheetStateHolder, @NotNull ErrorReporter errorReporter, @Named(value="STATUS_BAR_COLOR") @Nullable Integer statusBarColor, @PaymentElementCallbackIdentifier @NotNull String paymentElementCallbackIdentifier, @NotNull EmbeddedResultCallbackHelper embeddedResultCallbackHelper) {
        Intrinsics.checkNotNullParameter((Object)activityResultCaller, (String)"activityResultCaller");
        Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
        Intrinsics.checkNotNullParameter((Object)selectionHolder, (String)"selectionHolder");
        Intrinsics.checkNotNullParameter((Object)customerStateHolder, (String)"customerStateHolder");
        Intrinsics.checkNotNullParameter((Object)sheetStateHolder, (String)"sheetStateHolder");
        Intrinsics.checkNotNullParameter((Object)errorReporter, (String)"errorReporter");
        Intrinsics.checkNotNullParameter((Object)paymentElementCallbackIdentifier, (String)"paymentElementCallbackIdentifier");
        Intrinsics.checkNotNullParameter((Object)embeddedResultCallbackHelper, (String)"embeddedResultCallbackHelper");
        this.selectionHolder = selectionHolder;
        this.customerStateHolder = customerStateHolder;
        this.sheetStateHolder = sheetStateHolder;
        this.errorReporter = errorReporter;
        this.statusBarColor = statusBarColor;
        this.paymentElementCallbackIdentifier = paymentElementCallbackIdentifier;
        lifecycleOwner.getLifecycle().addObserver((LifecycleObserver)new DefaultLifecycleObserver(){

            public void onDestroy(LifecycleOwner owner) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                formActivityLauncher.unregister();
                manageActivityLauncher.unregister();
                super.onDestroy(owner);
            }
        });
        this.formActivityLauncher = activityResultCaller.registerForActivityResult((ActivityResultContract)FormContract.INSTANCE, arg_0 -> DefaultEmbeddedSheetLauncher.formActivityLauncher$lambda$0(this, embeddedResultCallbackHelper, arg_0));
        this.manageActivityLauncher = activityResultCaller.registerForActivityResult((ActivityResultContract)ManageContract.INSTANCE, arg_0 -> DefaultEmbeddedSheetLauncher.manageActivityLauncher$lambda$1(this, arg_0));
    }

    @Override
    public void launchForm(@NotNull String code, @NotNull PaymentMethodMetadata paymentMethodMetadata, boolean hasSavedPaymentMethods, @Nullable EmbeddedConfirmationStateHolder.State embeddedConfirmationState) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Intrinsics.checkNotNullParameter((Object)paymentMethodMetadata, (String)"paymentMethodMetadata");
        if (embeddedConfirmationState == null) {
            ErrorReporter.DefaultImpls.report$default((ErrorReporter)this.errorReporter, (ErrorReporter.ErrorEvent)((ErrorReporter.ErrorEvent)ErrorReporter.UnexpectedErrorEvent.EMBEDDED_SHEET_LAUNCHER_EMBEDDED_STATE_IS_NULL), null, null, (int)6, null);
            return;
        }
        if (this.sheetStateHolder.getSheetIsOpen()) {
            return;
        }
        this.sheetStateHolder.setSheetIsOpen(true);
        this.selectionHolder.setTemporary(code);
        FormContract.Args args = new FormContract.Args(code, paymentMethodMetadata, hasSavedPaymentMethods, embeddedConfirmationState.getConfiguration(), embeddedConfirmationState.getInitializationMode(), this.paymentElementCallbackIdentifier, this.statusBarColor);
        this.formActivityLauncher.launch((Object)args);
    }

    @Override
    public void launchManage(@NotNull PaymentMethodMetadata paymentMethodMetadata, @NotNull CustomerState customerState, @Nullable PaymentSelection selection) {
        Intrinsics.checkNotNullParameter((Object)paymentMethodMetadata, (String)"paymentMethodMetadata");
        Intrinsics.checkNotNullParameter((Object)customerState, (String)"customerState");
        if (this.sheetStateHolder.getSheetIsOpen()) {
            return;
        }
        this.sheetStateHolder.setSheetIsOpen(true);
        ManageContract.Args args = new ManageContract.Args(paymentMethodMetadata, customerState, selection, this.paymentElementCallbackIdentifier);
        this.manageActivityLauncher.launch((Object)args);
    }

    private static final void formActivityLauncher$lambda$0(DefaultEmbeddedSheetLauncher this$0, EmbeddedResultCallbackHelper $embeddedResultCallbackHelper, FormResult result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        this$0.sheetStateHolder.setSheetIsOpen(false);
        this$0.selectionHolder.setTemporary(null);
        if (result2 instanceof FormResult.Complete) {
            $embeddedResultCallbackHelper.setResult(new EmbeddedPaymentElement.Result.Completed());
        }
    }

    private static final void manageActivityLauncher$lambda$1(DefaultEmbeddedSheetLauncher this$0, ManageResult result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        this$0.sheetStateHolder.setSheetIsOpen(false);
        ManageResult manageResult = result2;
        if (!(manageResult instanceof ManageResult.Error)) {
            if (manageResult instanceof ManageResult.Complete) {
                this$0.customerStateHolder.setCustomerState(((ManageResult.Complete)result2).getCustomerState());
                this$0.selectionHolder.set(((ManageResult.Complete)result2).getSelection());
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
    }
}

