/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentelement.embedded;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import androidx.lifecycle.SavedStateHandle;
import com.stripe.android.PaymentConfiguration;
import com.stripe.android.core.injection.CoreCommonModule;
import com.stripe.android.core.injection.IOContext;
import com.stripe.android.core.injection.UIContext;
import com.stripe.android.core.networking.AnalyticsRequestFactory;
import com.stripe.android.core.networking.NetworkTypeDetector;
import com.stripe.android.core.utils.ContextUtils;
import com.stripe.android.core.utils.DefaultDurationProvider;
import com.stripe.android.core.utils.DurationProvider;
import com.stripe.android.paymentelement.AnalyticEventCallback;
import com.stripe.android.paymentelement.callbacks.PaymentElementCallbackIdentifier;
import com.stripe.android.paymentelement.callbacks.PaymentElementCallbackReferences;
import com.stripe.android.paymentelement.callbacks.PaymentElementCallbacks;
import com.stripe.android.paymentelement.embedded.EmbeddedSelectionHolder;
import com.stripe.android.payments.core.analytics.ErrorReporter;
import com.stripe.android.payments.core.analytics.RealErrorReporter;
import com.stripe.android.payments.core.injection.StripeRepositoryModule;
import com.stripe.android.paymentsheet.CustomerStateHolder;
import com.stripe.android.paymentsheet.analytics.DefaultEventReporter;
import com.stripe.android.paymentsheet.analytics.EventReporter;
import com.stripe.android.paymentsheet.repositories.CustomerApiRepository;
import com.stripe.android.paymentsheet.repositories.CustomerRepository;
import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Module(includes={StripeRepositoryModule.class, CoreCommonModule.class})
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\ba\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H'J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH'J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH'\u00a8\u0006\u000f"}, d2={"Lcom/stripe/android/paymentelement/embedded/EmbeddedCommonModule;", "", "bindsEventReporter", "Lcom/stripe/android/paymentsheet/analytics/EventReporter;", "eventReporter", "Lcom/stripe/android/paymentsheet/analytics/DefaultEventReporter;", "bindsErrorReporter", "Lcom/stripe/android/payments/core/analytics/ErrorReporter;", "errorReporter", "Lcom/stripe/android/payments/core/analytics/RealErrorReporter;", "bindsCustomerRepository", "Lcom/stripe/android/paymentsheet/repositories/CustomerRepository;", "repository", "Lcom/stripe/android/paymentsheet/repositories/CustomerApiRepository;", "Companion", "paymentsheet_release"})
public interface EmbeddedCommonModule {
    @NotNull
    public static final Companion Companion = com.stripe.android.paymentelement.embedded.EmbeddedCommonModule$Companion.$$INSTANCE;

    @Binds
    @Singleton
    @NotNull
    public EventReporter bindsEventReporter(@NotNull DefaultEventReporter var1);

    @Binds
    @NotNull
    public ErrorReporter bindsErrorReporter(@NotNull RealErrorReporter var1);

    @Binds
    @NotNull
    public CustomerRepository bindsCustomerRepository(@NotNull CustomerApiRepository var1);

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\b\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\tH\u0007J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0007J\b\u0010\r\u001a\u00020\u000eH\u0007J\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0007J\b\u0010\u0016\u001a\u00020\u0005H\u0007J\u0010\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0012H\u0007J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u001a2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0007J\u001e\u0010\u001b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u001a2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0007J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0007J\b\u0010\"\u001a\u00020\u0007H\u0007J\u0014\u0010#\u001a\u0004\u0018\u00010$2\b\b\u0001\u0010%\u001a\u00020\fH\u0007\u00a8\u0006&"}, d2={"Lcom/stripe/android/paymentelement/embedded/EmbeddedCommonModule$Companion;", "", "<init>", "()V", "provideEnabledLogging", "", "ioContext", "Lkotlin/coroutines/CoroutineContext;", "provideEventReporterMode", "Lcom/stripe/android/paymentsheet/analytics/EventReporter$Mode;", "provideProductUsageTokens", "", "", "provideDurationProvider", "Lcom/stripe/android/core/utils/DurationProvider;", "provideAnalyticsRequestFactory", "Lcom/stripe/android/core/networking/AnalyticsRequestFactory;", "context", "Landroid/content/Context;", "paymentConfiguration", "Ljavax/inject/Provider;", "Lcom/stripe/android/PaymentConfiguration;", "provideAllowsManualConfirmation", "providePaymentConfiguration", "appContext", "providePublishableKey", "Lkotlin/Function0;", "provideStripeAccountId", "provideCustomerStateHolder", "Lcom/stripe/android/paymentsheet/CustomerStateHolder;", "savedStateHandle", "Landroidx/lifecycle/SavedStateHandle;", "selectionHolder", "Lcom/stripe/android/paymentelement/embedded/EmbeddedSelectionHolder;", "provideUiContext", "providesAnalyticEventCallback", "Lcom/stripe/android/paymentelement/AnalyticEventCallback;", "paymentElementCallbackIdentifier", "paymentsheet_release"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @Provides
        @Named(value="enableLogging")
        public final boolean provideEnabledLogging() {
            return false;
        }

        @Provides
        @IOContext
        @NotNull
        public final CoroutineContext ioContext() {
            return (CoroutineContext)Dispatchers.getIO();
        }

        @Provides
        @NotNull
        public final EventReporter.Mode provideEventReporterMode() {
            return EventReporter.Mode.Embedded;
        }

        @Provides
        @Named(value="productUsage")
        @NotNull
        public final Set<String> provideProductUsageTokens() {
            return SetsKt.setOf((Object)"EmbeddedPaymentElement");
        }

        @Provides
        @NotNull
        public final DurationProvider provideDurationProvider() {
            return (DurationProvider)DefaultDurationProvider.Companion.getInstance();
        }

        @Provides
        @NotNull
        public final AnalyticsRequestFactory provideAnalyticsRequestFactory(@NotNull Context context, @NotNull Provider<PaymentConfiguration> paymentConfiguration) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(paymentConfiguration, (String)"paymentConfiguration");
            PackageManager packageManager = context.getPackageManager();
            String string2 = context.getPackageName();
            if (string2 == null) {
                string2 = "";
            }
            String string3 = string2;
            PackageInfo packageInfo = ContextUtils.INSTANCE.getPackageInfo(context);
            Provider provider = () -> Companion.provideAnalyticsRequestFactory$lambda$0(paymentConfiguration);
            Provider provider2 = () -> ((NetworkTypeDetector)new NetworkTypeDetector(context)).invoke();
            return new AnalyticsRequestFactory(packageManager, packageInfo, string3, provider, provider2, null, 32, null);
        }

        @Provides
        @Singleton
        @Named(value="ALLOWS_MANUAL_CONFIRMATION")
        public final boolean provideAllowsManualConfirmation() {
            return true;
        }

        @Provides
        @NotNull
        public final PaymentConfiguration providePaymentConfiguration(@NotNull Context appContext) {
            Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
            return PaymentConfiguration.Companion.getInstance(appContext);
        }

        @Provides
        @Named(value="publishableKey")
        @NotNull
        public final Function0<String> providePublishableKey(@NotNull Provider<PaymentConfiguration> paymentConfiguration) {
            Intrinsics.checkNotNullParameter(paymentConfiguration, (String)"paymentConfiguration");
            return () -> Companion.providePublishableKey$lambda$1(paymentConfiguration);
        }

        @Provides
        @Named(value="stripeAccountId")
        @NotNull
        public final Function0<String> provideStripeAccountId(@NotNull Provider<PaymentConfiguration> paymentConfiguration) {
            Intrinsics.checkNotNullParameter(paymentConfiguration, (String)"paymentConfiguration");
            return () -> Companion.provideStripeAccountId$lambda$2(paymentConfiguration);
        }

        @Provides
        @Singleton
        @NotNull
        public final CustomerStateHolder provideCustomerStateHolder(@NotNull SavedStateHandle savedStateHandle, @NotNull EmbeddedSelectionHolder selectionHolder) {
            Intrinsics.checkNotNullParameter((Object)savedStateHandle, (String)"savedStateHandle");
            Intrinsics.checkNotNullParameter((Object)selectionHolder, (String)"selectionHolder");
            return new CustomerStateHolder(savedStateHandle, selectionHolder.getSelection());
        }

        @Provides
        @Singleton
        @UIContext
        @NotNull
        public final CoroutineContext provideUiContext() {
            return (CoroutineContext)Dispatchers.getMain();
        }

        @Provides
        @Nullable
        public final AnalyticEventCallback providesAnalyticEventCallback(@PaymentElementCallbackIdentifier @NotNull String paymentElementCallbackIdentifier) {
            Intrinsics.checkNotNullParameter((Object)paymentElementCallbackIdentifier, (String)"paymentElementCallbackIdentifier");
            PaymentElementCallbacks paymentElementCallbacks = PaymentElementCallbackReferences.INSTANCE.get(paymentElementCallbackIdentifier);
            return paymentElementCallbacks != null ? paymentElementCallbacks.getAnalyticEventCallback() : null;
        }

        private static final String provideAnalyticsRequestFactory$lambda$0(Provider $paymentConfiguration) {
            return ((PaymentConfiguration)$paymentConfiguration.get()).getPublishableKey();
        }

        private static final String providePublishableKey$lambda$1(Provider $paymentConfiguration) {
            return ((PaymentConfiguration)$paymentConfiguration.get()).getPublishableKey();
        }

        private static final String provideStripeAccountId$lambda$2(Provider $paymentConfiguration) {
            return ((PaymentConfiguration)$paymentConfiguration.get()).getStripeAccountId();
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

