/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentelement.confirmation.link;

import androidx.activity.result.ActivityResultCaller;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.common.exception.ExceptionKtKt;
import com.stripe.android.link.LinkAccountUpdate;
import com.stripe.android.link.LinkActivityResult;
import com.stripe.android.link.LinkPaymentLauncher;
import com.stripe.android.link.account.LinkAccountHolder;
import com.stripe.android.link.account.LinkStore;
import com.stripe.android.link.model.LinkAccount;
import com.stripe.android.paymentelement.confirmation.ConfirmationDefinition;
import com.stripe.android.paymentelement.confirmation.ConfirmationHandler;
import com.stripe.android.paymentelement.confirmation.PaymentMethodConfirmationOption;
import com.stripe.android.paymentelement.confirmation.intent.DeferredIntentConfirmationType;
import com.stripe.android.paymentelement.confirmation.link.LinkConfirmationOption;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0001B!\b\u0007\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J$\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00040\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0003H\u0016J$\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u001c2\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001eH\u0096@\u00a2\u0006\u0002\u0010\u001fJ-\u0010 \u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001eH\u0016\u00a2\u0006\u0002\u0010\"J*\u0010#\u001a\u00020$2\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\u0005H\u0016J\f\u0010(\u001a\u00020\u0004*\u00020)H\u0002R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006*"}, d2={"Lcom/stripe/android/paymentelement/confirmation/link/LinkConfirmationDefinition;", "Lcom/stripe/android/paymentelement/confirmation/ConfirmationDefinition;", "Lcom/stripe/android/paymentelement/confirmation/link/LinkConfirmationOption;", "Lcom/stripe/android/link/LinkPaymentLauncher;", "", "Lcom/stripe/android/link/LinkActivityResult;", "linkPaymentLauncher", "linkStore", "Lcom/stripe/android/link/account/LinkStore;", "linkAccountHolder", "Lcom/stripe/android/link/account/LinkAccountHolder;", "<init>", "(Lcom/stripe/android/link/LinkPaymentLauncher;Lcom/stripe/android/link/account/LinkStore;Lcom/stripe/android/link/account/LinkAccountHolder;)V", "key", "", "getKey", "()Ljava/lang/String;", "option", "confirmationOption", "Lcom/stripe/android/paymentelement/confirmation/ConfirmationHandler$Option;", "createLauncher", "activityResultCaller", "Landroidx/activity/result/ActivityResultCaller;", "onResult", "Lkotlin/Function1;", "unregister", "launcher", "action", "Lcom/stripe/android/paymentelement/confirmation/ConfirmationDefinition$Action;", "confirmationParameters", "Lcom/stripe/android/paymentelement/confirmation/ConfirmationDefinition$Parameters;", "(Lcom/stripe/android/paymentelement/confirmation/link/LinkConfirmationOption;Lcom/stripe/android/paymentelement/confirmation/ConfirmationDefinition$Parameters;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "launch", "arguments", "(Lcom/stripe/android/link/LinkPaymentLauncher;Lkotlin/Unit;Lcom/stripe/android/paymentelement/confirmation/link/LinkConfirmationOption;Lcom/stripe/android/paymentelement/confirmation/ConfirmationDefinition$Parameters;)V", "toResult", "Lcom/stripe/android/paymentelement/confirmation/ConfirmationDefinition$Result;", "deferredIntentConfirmationType", "Lcom/stripe/android/paymentelement/confirmation/intent/DeferredIntentConfirmationType;", "result", "updateLinkAccount", "Lcom/stripe/android/link/LinkAccountUpdate;", "paymentsheet_release"})
@StabilityInferred(parameters=0)
public final class LinkConfirmationDefinition
implements ConfirmationDefinition<LinkConfirmationOption, LinkPaymentLauncher, Unit, LinkActivityResult> {
    @NotNull
    private final LinkPaymentLauncher linkPaymentLauncher;
    @NotNull
    private final LinkStore linkStore;
    @NotNull
    private final LinkAccountHolder linkAccountHolder;
    @NotNull
    private final String key;
    public static final int $stable = 8;

    @Inject
    public LinkConfirmationDefinition(@NotNull LinkPaymentLauncher linkPaymentLauncher, @NotNull LinkStore linkStore, @NotNull LinkAccountHolder linkAccountHolder) {
        Intrinsics.checkNotNullParameter((Object)linkPaymentLauncher, (String)"linkPaymentLauncher");
        Intrinsics.checkNotNullParameter((Object)linkStore, (String)"linkStore");
        Intrinsics.checkNotNullParameter((Object)linkAccountHolder, (String)"linkAccountHolder");
        this.linkPaymentLauncher = linkPaymentLauncher;
        this.linkStore = linkStore;
        this.linkAccountHolder = linkAccountHolder;
        this.key = "Link";
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public LinkConfirmationOption option(@NotNull ConfirmationHandler.Option confirmationOption2) {
        Intrinsics.checkNotNullParameter((Object)confirmationOption2, (String)"confirmationOption");
        return confirmationOption2 instanceof LinkConfirmationOption ? (LinkConfirmationOption)confirmationOption2 : null;
    }

    @Override
    @NotNull
    public LinkPaymentLauncher createLauncher(@NotNull ActivityResultCaller activityResultCaller, @NotNull Function1<? super LinkActivityResult, Unit> onResult2) {
        LinkPaymentLauncher linkPaymentLauncher;
        Intrinsics.checkNotNullParameter((Object)activityResultCaller, (String)"activityResultCaller");
        Intrinsics.checkNotNullParameter(onResult2, (String)"onResult");
        LinkPaymentLauncher $this$createLauncher_u24lambda_u240 = linkPaymentLauncher = this.linkPaymentLauncher;
        boolean bl = false;
        $this$createLauncher_u24lambda_u240.register(activityResultCaller, onResult2);
        return linkPaymentLauncher;
    }

    @Override
    public void unregister(@NotNull LinkPaymentLauncher launcher) {
        Intrinsics.checkNotNullParameter((Object)launcher, (String)"launcher");
        launcher.unregister();
    }

    @Override
    @Nullable
    public Object action(@NotNull LinkConfirmationOption confirmationOption2, @NotNull ConfirmationDefinition.Parameters confirmationParameters, @NotNull Continuation<? super ConfirmationDefinition.Action<Unit>> $completion) {
        return new ConfirmationDefinition.Action.Launch<Unit>(Unit.INSTANCE, false, null);
    }

    @Override
    public void launch(@NotNull LinkPaymentLauncher launcher, @NotNull Unit arguments, @NotNull LinkConfirmationOption confirmationOption2, @NotNull ConfirmationDefinition.Parameters confirmationParameters) {
        Intrinsics.checkNotNullParameter((Object)launcher, (String)"launcher");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)confirmationOption2, (String)"confirmationOption");
        Intrinsics.checkNotNullParameter((Object)confirmationParameters, (String)"confirmationParameters");
        launcher.present(confirmationOption2.getConfiguration(), (LinkAccount)this.linkAccountHolder.getLinkAccount().getValue(), confirmationOption2.getUseLinkExpress());
    }

    @Override
    @NotNull
    public ConfirmationDefinition.Result toResult(@NotNull LinkConfirmationOption confirmationOption2, @NotNull ConfirmationDefinition.Parameters confirmationParameters, @Nullable DeferredIntentConfirmationType deferredIntentConfirmationType, @NotNull LinkActivityResult result2) {
        ConfirmationDefinition.Result result3;
        LinkActivityResult linkActivityResult;
        Intrinsics.checkNotNullParameter((Object)confirmationOption2, (String)"confirmationOption");
        Intrinsics.checkNotNullParameter((Object)confirmationParameters, (String)"confirmationParameters");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        if (!(result2 instanceof LinkActivityResult.Canceled) || ((LinkActivityResult.Canceled)result2).getReason() != LinkActivityResult.Canceled.Reason.BackPressed) {
            this.linkStore.markLinkAsUsed();
        }
        if ((linkActivityResult = result2) instanceof LinkActivityResult.PaymentMethodObtained) {
            result3 = new ConfirmationDefinition.Result.NextStep(new PaymentMethodConfirmationOption.Saved(((LinkActivityResult.PaymentMethodObtained)result2).getPaymentMethod(), null), confirmationParameters);
        } else if (linkActivityResult instanceof LinkActivityResult.Failed) {
            this.updateLinkAccount(((LinkActivityResult.Failed)result2).getLinkAccountUpdate());
            result3 = new ConfirmationDefinition.Result.Failed(((LinkActivityResult.Failed)result2).getError(), ExceptionKtKt.stripeErrorMessage(((LinkActivityResult.Failed)result2).getError()), ConfirmationHandler.Result.Failed.ErrorType.Payment.INSTANCE);
        } else if (linkActivityResult instanceof LinkActivityResult.Canceled) {
            this.updateLinkAccount(((LinkActivityResult.Canceled)result2).getLinkAccountUpdate());
            result3 = new ConfirmationDefinition.Result.Canceled(ConfirmationHandler.Result.Canceled.Action.InformCancellation);
        } else if (linkActivityResult instanceof LinkActivityResult.Completed) {
            this.updateLinkAccount(((LinkActivityResult.Completed)result2).getLinkAccountUpdate());
            result3 = new ConfirmationDefinition.Result.Succeeded(confirmationParameters.getIntent(), deferredIntentConfirmationType);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result3;
    }

    private final void updateLinkAccount(LinkAccountUpdate $this$updateLinkAccount) {
        LinkAccountUpdate linkAccountUpdate = $this$updateLinkAccount;
        if (linkAccountUpdate instanceof LinkAccountUpdate.Value) {
            this.linkAccountHolder.set(((LinkAccountUpdate.Value)$this$updateLinkAccount).getLinkAccount());
        } else if (!Intrinsics.areEqual((Object)linkAccountUpdate, (Object)LinkAccountUpdate.None.INSTANCE)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    @Override
    public boolean canConfirm(@NotNull LinkConfirmationOption confirmationOption2, @NotNull ConfirmationDefinition.Parameters confirmationParameters) {
        return ConfirmationDefinition.DefaultImpls.canConfirm(this, (ConfirmationHandler.Option)confirmationOption2, confirmationParameters);
    }
}

