/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentelement.confirmation.cvc;

import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultCaller;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.model.PaymentMethod;
import com.stripe.android.model.PaymentMethodOptionsParams;
import com.stripe.android.model.StripeIntent;
import com.stripe.android.paymentelement.confirmation.ConfirmationDefinition;
import com.stripe.android.paymentelement.confirmation.ConfirmationHandler;
import com.stripe.android.paymentelement.confirmation.PaymentMethodConfirmationOption;
import com.stripe.android.paymentelement.confirmation.intent.DeferredIntentConfirmationType;
import com.stripe.android.paymentsheet.cvcrecollection.CvcRecollectionHandler;
import com.stripe.android.paymentsheet.paymentdatacollection.cvcrecollection.CvcRecollectionContract;
import com.stripe.android.paymentsheet.paymentdatacollection.cvcrecollection.CvcRecollectionData;
import com.stripe.android.paymentsheet.paymentdatacollection.cvcrecollection.CvcRecollectionLauncher;
import com.stripe.android.paymentsheet.paymentdatacollection.cvcrecollection.CvcRecollectionLauncherFactory;
import com.stripe.android.paymentsheet.paymentdatacollection.cvcrecollection.CvcRecollectionResult;
import com.stripe.android.paymentsheet.state.PaymentElementLoader;
import javax.inject.Inject;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0001B\u0019\b\u0007\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J$\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u00182\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0096@\u00a2\u0006\u0002\u0010\u0019J$\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00040\u001eH\u0016J-\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\"J*\u0010#\u001a\u00020$2\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010'\u001a\u00020\u0005H\u0016J\u000e\u0010(\u001a\u00020\u0014*\u0004\u0018\u00010)H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006*"}, d2={"Lcom/stripe/android/paymentelement/confirmation/cvc/CvcRecollectionConfirmationDefinition;", "Lcom/stripe/android/paymentelement/confirmation/ConfirmationDefinition;", "Lcom/stripe/android/paymentelement/confirmation/PaymentMethodConfirmationOption$Saved;", "Lcom/stripe/android/paymentsheet/paymentdatacollection/cvcrecollection/CvcRecollectionLauncher;", "", "Lcom/stripe/android/paymentsheet/paymentdatacollection/cvcrecollection/CvcRecollectionResult;", "handler", "Lcom/stripe/android/paymentsheet/cvcrecollection/CvcRecollectionHandler;", "factory", "Lcom/stripe/android/paymentsheet/paymentdatacollection/cvcrecollection/CvcRecollectionLauncherFactory;", "<init>", "(Lcom/stripe/android/paymentsheet/cvcrecollection/CvcRecollectionHandler;Lcom/stripe/android/paymentsheet/paymentdatacollection/cvcrecollection/CvcRecollectionLauncherFactory;)V", "key", "", "getKey", "()Ljava/lang/String;", "option", "confirmationOption", "Lcom/stripe/android/paymentelement/confirmation/ConfirmationHandler$Option;", "canConfirm", "", "confirmationParameters", "Lcom/stripe/android/paymentelement/confirmation/ConfirmationDefinition$Parameters;", "action", "Lcom/stripe/android/paymentelement/confirmation/ConfirmationDefinition$Action;", "(Lcom/stripe/android/paymentelement/confirmation/PaymentMethodConfirmationOption$Saved;Lcom/stripe/android/paymentelement/confirmation/ConfirmationDefinition$Parameters;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createLauncher", "activityResultCaller", "Landroidx/activity/result/ActivityResultCaller;", "onResult", "Lkotlin/Function1;", "launch", "launcher", "arguments", "(Lcom/stripe/android/paymentsheet/paymentdatacollection/cvcrecollection/CvcRecollectionLauncher;Lkotlin/Unit;Lcom/stripe/android/paymentelement/confirmation/PaymentMethodConfirmationOption$Saved;Lcom/stripe/android/paymentelement/confirmation/ConfirmationDefinition$Parameters;)V", "toResult", "Lcom/stripe/android/paymentelement/confirmation/ConfirmationDefinition$Result;", "deferredIntentConfirmationType", "Lcom/stripe/android/paymentelement/confirmation/intent/DeferredIntentConfirmationType;", "result", "hasAlreadyRecollectedCvc", "Lcom/stripe/android/model/PaymentMethodOptionsParams;", "paymentsheet_release"})
@StabilityInferred(parameters=1)
public final class CvcRecollectionConfirmationDefinition
implements ConfirmationDefinition<PaymentMethodConfirmationOption.Saved, CvcRecollectionLauncher, Unit, CvcRecollectionResult> {
    @NotNull
    private final CvcRecollectionHandler handler;
    @NotNull
    private final CvcRecollectionLauncherFactory factory;
    @NotNull
    private final String key;
    public static final int $stable;

    @Inject
    public CvcRecollectionConfirmationDefinition(@NotNull CvcRecollectionHandler handler, @NotNull CvcRecollectionLauncherFactory factory) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        this.handler = handler;
        this.factory = factory;
        this.key = "CvcRecollection";
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public PaymentMethodConfirmationOption.Saved option(@NotNull ConfirmationHandler.Option confirmationOption2) {
        Intrinsics.checkNotNullParameter((Object)confirmationOption2, (String)"confirmationOption");
        return confirmationOption2 instanceof PaymentMethodConfirmationOption.Saved ? (PaymentMethodConfirmationOption.Saved)confirmationOption2 : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canConfirm(@NotNull PaymentMethodConfirmationOption.Saved confirmationOption2, @NotNull ConfirmationDefinition.Parameters confirmationParameters) {
        PaymentMethodOptionsParams paymentMethodOptionsParams;
        Intrinsics.checkNotNullParameter((Object)confirmationOption2, (String)"confirmationOption");
        Intrinsics.checkNotNullParameter((Object)confirmationParameters, (String)"confirmationParameters");
        if (this.hasAlreadyRecollectedCvc(confirmationOption2.getOptionsParams())) return false;
        CvcRecollectionHandler cvcRecollectionHandler = this.handler;
        StripeIntent stripeIntent = confirmationParameters.getIntent();
        PaymentElementLoader.InitializationMode initializationMode = confirmationParameters.getInitializationMode();
        PaymentMethod paymentMethod = confirmationOption2.getPaymentMethod();
        if (!cvcRecollectionHandler.requiresCVCRecollection(stripeIntent, paymentMethod, paymentMethodOptionsParams = confirmationOption2.getOptionsParams(), initializationMode)) return false;
        return true;
    }

    @Override
    @Nullable
    public Object action(@NotNull PaymentMethodConfirmationOption.Saved confirmationOption2, @NotNull ConfirmationDefinition.Parameters confirmationParameters, @NotNull Continuation<? super ConfirmationDefinition.Action<Unit>> $completion) {
        return new ConfirmationDefinition.Action.Launch<Unit>(Unit.INSTANCE, true, null);
    }

    @Override
    @NotNull
    public CvcRecollectionLauncher createLauncher(@NotNull ActivityResultCaller activityResultCaller, @NotNull Function1<? super CvcRecollectionResult, Unit> onResult2) {
        Intrinsics.checkNotNullParameter((Object)activityResultCaller, (String)"activityResultCaller");
        Intrinsics.checkNotNullParameter(onResult2, (String)"onResult");
        return this.factory.create((ActivityResultLauncher<CvcRecollectionContract.Args>)activityResultCaller.registerForActivityResult((ActivityResultContract)new CvcRecollectionContract(), new ActivityResultCallback(onResult2){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void onActivityResult(Object result2) {
                this.function.invoke(result2);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof ActivityResultCallback ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        }));
    }

    @Override
    public void launch(@NotNull CvcRecollectionLauncher launcher, @NotNull Unit arguments, @NotNull PaymentMethodConfirmationOption.Saved confirmationOption2, @NotNull ConfirmationDefinition.Parameters confirmationParameters) {
        Intrinsics.checkNotNullParameter((Object)launcher, (String)"launcher");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)confirmationOption2, (String)"confirmationOption");
        Intrinsics.checkNotNullParameter((Object)confirmationParameters, (String)"confirmationParameters");
        this.handler.launch(confirmationOption2.getPaymentMethod(), (Function1<? super CvcRecollectionData, Unit>)((Function1)arg_0 -> CvcRecollectionConfirmationDefinition.launch$lambda$0(launcher, confirmationParameters, arg_0)));
    }

    @Override
    @NotNull
    public ConfirmationDefinition.Result toResult(@NotNull PaymentMethodConfirmationOption.Saved confirmationOption2, @NotNull ConfirmationDefinition.Parameters confirmationParameters, @Nullable DeferredIntentConfirmationType deferredIntentConfirmationType, @NotNull CvcRecollectionResult result2) {
        ConfirmationDefinition.Result result3;
        Intrinsics.checkNotNullParameter((Object)confirmationOption2, (String)"confirmationOption");
        Intrinsics.checkNotNullParameter((Object)confirmationParameters, (String)"confirmationParameters");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        CvcRecollectionResult cvcRecollectionResult = result2;
        if (cvcRecollectionResult instanceof CvcRecollectionResult.Confirmed) {
            PaymentMethodOptionsParams params = confirmationOption2.getOptionsParams();
            result3 = new ConfirmationDefinition.Result.NextStep(PaymentMethodConfirmationOption.Saved.copy$default(confirmationOption2, null, (PaymentMethodOptionsParams)(params instanceof PaymentMethodOptionsParams.Card ? PaymentMethodOptionsParams.Card.copy$default((PaymentMethodOptionsParams.Card)((PaymentMethodOptionsParams.Card)params), (String)((CvcRecollectionResult.Confirmed)result2).getCvc(), null, null, null, (int)14, null) : new PaymentMethodOptionsParams.Card(((CvcRecollectionResult.Confirmed)result2).getCvc(), null, null, 6, null)), 1, null), confirmationParameters);
        } else if (cvcRecollectionResult instanceof CvcRecollectionResult.Cancelled) {
            result3 = new ConfirmationDefinition.Result.Canceled(ConfirmationHandler.Result.Canceled.Action.InformCancellation);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result3;
    }

    private final boolean hasAlreadyRecollectedCvc(PaymentMethodOptionsParams $this$hasAlreadyRecollectedCvc) {
        return $this$hasAlreadyRecollectedCvc instanceof PaymentMethodOptionsParams.Card ? ((PaymentMethodOptionsParams.Card)$this$hasAlreadyRecollectedCvc).getCvc() != null : false;
    }

    @Override
    public void unregister(@NotNull CvcRecollectionLauncher launcher) {
        ConfirmationDefinition.DefaultImpls.unregister(this, launcher);
    }

    private static final Unit launch$lambda$0(CvcRecollectionLauncher $launcher, ConfirmationDefinition.Parameters $confirmationParameters, CvcRecollectionData recollectionData) {
        Intrinsics.checkNotNullParameter((Object)recollectionData, (String)"recollectionData");
        $launcher.launch(recollectionData, $confirmationParameters.getAppearance(), $confirmationParameters.getIntent().isLiveMode());
        return Unit.INSTANCE;
    }
}

