/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentelement.confirmation.bacs;

import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultCaller;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.compose.runtime.internal.StabilityInferred;
import com.stripe.android.core.strings.ResolvableStringUtilsKt;
import com.stripe.android.paymentelement.confirmation.ConfirmationDefinition;
import com.stripe.android.paymentelement.confirmation.ConfirmationHandler;
import com.stripe.android.paymentelement.confirmation.PaymentMethodConfirmationOption;
import com.stripe.android.paymentelement.confirmation.bacs.BacsConfirmationOption;
import com.stripe.android.paymentelement.confirmation.intent.DeferredIntentConfirmationType;
import com.stripe.android.paymentsheet.R;
import com.stripe.android.paymentsheet.paymentdatacollection.bacs.BacsMandateConfirmationContract;
import com.stripe.android.paymentsheet.paymentdatacollection.bacs.BacsMandateConfirmationLauncher;
import com.stripe.android.paymentsheet.paymentdatacollection.bacs.BacsMandateConfirmationLauncherFactory;
import com.stripe.android.paymentsheet.paymentdatacollection.bacs.BacsMandateConfirmationResult;
import com.stripe.android.paymentsheet.paymentdatacollection.bacs.BacsMandateData;
import javax.inject.Inject;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.FunctionAdapter;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u001a\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0001B\u0011\b\u0007\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J$\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0015J$\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0017\u001a\u00020\u00182\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J(\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J*\u0010\u001f\u001a\u00020 2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010#\u001a\u00020\u0005H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006$"}, d2={"Lcom/stripe/android/paymentelement/confirmation/bacs/BacsConfirmationDefinition;", "Lcom/stripe/android/paymentelement/confirmation/ConfirmationDefinition;", "Lcom/stripe/android/paymentelement/confirmation/bacs/BacsConfirmationOption;", "Lcom/stripe/android/paymentsheet/paymentdatacollection/bacs/BacsMandateConfirmationLauncher;", "Lcom/stripe/android/paymentsheet/paymentdatacollection/bacs/BacsMandateData;", "Lcom/stripe/android/paymentsheet/paymentdatacollection/bacs/BacsMandateConfirmationResult;", "bacsMandateConfirmationLauncherFactory", "Lcom/stripe/android/paymentsheet/paymentdatacollection/bacs/BacsMandateConfirmationLauncherFactory;", "<init>", "(Lcom/stripe/android/paymentsheet/paymentdatacollection/bacs/BacsMandateConfirmationLauncherFactory;)V", "key", "", "getKey", "()Ljava/lang/String;", "option", "confirmationOption", "Lcom/stripe/android/paymentelement/confirmation/ConfirmationHandler$Option;", "action", "Lcom/stripe/android/paymentelement/confirmation/ConfirmationDefinition$Action;", "confirmationParameters", "Lcom/stripe/android/paymentelement/confirmation/ConfirmationDefinition$Parameters;", "(Lcom/stripe/android/paymentelement/confirmation/bacs/BacsConfirmationOption;Lcom/stripe/android/paymentelement/confirmation/ConfirmationDefinition$Parameters;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createLauncher", "activityResultCaller", "Landroidx/activity/result/ActivityResultCaller;", "onResult", "Lkotlin/Function1;", "", "launch", "launcher", "arguments", "toResult", "Lcom/stripe/android/paymentelement/confirmation/ConfirmationDefinition$Result;", "deferredIntentConfirmationType", "Lcom/stripe/android/paymentelement/confirmation/intent/DeferredIntentConfirmationType;", "result", "paymentsheet_release"})
@StabilityInferred(parameters=0)
public final class BacsConfirmationDefinition
implements ConfirmationDefinition<BacsConfirmationOption, BacsMandateConfirmationLauncher, BacsMandateData, BacsMandateConfirmationResult> {
    @NotNull
    private final BacsMandateConfirmationLauncherFactory bacsMandateConfirmationLauncherFactory;
    @NotNull
    private final String key;
    public static final int $stable = 8;

    @Inject
    public BacsConfirmationDefinition(@NotNull BacsMandateConfirmationLauncherFactory bacsMandateConfirmationLauncherFactory) {
        Intrinsics.checkNotNullParameter((Object)bacsMandateConfirmationLauncherFactory, (String)"bacsMandateConfirmationLauncherFactory");
        this.bacsMandateConfirmationLauncherFactory = bacsMandateConfirmationLauncherFactory;
        this.key = "Bacs";
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public BacsConfirmationOption option(@NotNull ConfirmationHandler.Option confirmationOption2) {
        Intrinsics.checkNotNullParameter((Object)confirmationOption2, (String)"confirmationOption");
        return confirmationOption2 instanceof BacsConfirmationOption ? (BacsConfirmationOption)confirmationOption2 : null;
    }

    @Override
    @Nullable
    public Object action(@NotNull BacsConfirmationOption confirmationOption2, @NotNull ConfirmationDefinition.Parameters confirmationParameters, @NotNull Continuation<? super ConfirmationDefinition.Action<BacsMandateData>> $completion) {
        ConfirmationDefinition.Action action2;
        BacsMandateData bacsMandateData = BacsMandateData.Companion.fromConfirmationOption(confirmationOption2);
        if (bacsMandateData != null) {
            BacsMandateData data = bacsMandateData;
            boolean bl = false;
            action2 = new ConfirmationDefinition.Action.Launch<BacsMandateData>(data, true, null);
        } else {
            BacsConfirmationDefinition $this$action_u24lambda_u241 = this;
            boolean bl = false;
            action2 = new ConfirmationDefinition.Action.Fail(new IllegalArgumentException("Given confirmation option does not have expected Bacs data!"), ResolvableStringUtilsKt.getResolvableString((int)R.string.stripe_something_went_wrong), ConfirmationHandler.Result.Failed.ErrorType.Internal.INSTANCE);
        }
        return action2;
    }

    @Override
    @NotNull
    public BacsMandateConfirmationLauncher createLauncher(@NotNull ActivityResultCaller activityResultCaller, @NotNull Function1<? super BacsMandateConfirmationResult, Unit> onResult2) {
        Intrinsics.checkNotNullParameter((Object)activityResultCaller, (String)"activityResultCaller");
        Intrinsics.checkNotNullParameter(onResult2, (String)"onResult");
        return this.bacsMandateConfirmationLauncherFactory.create((ActivityResultLauncher<BacsMandateConfirmationContract.Args>)activityResultCaller.registerForActivityResult((ActivityResultContract)new BacsMandateConfirmationContract(), new ActivityResultCallback(onResult2){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ void onActivityResult(Object result2) {
                this.function.invoke(result2);
            }

            @NotNull
            public final Function<?> getFunctionDelegate() {
                return (Function)this.function;
            }

            public final boolean equals(@Nullable Object other) {
                return other instanceof ActivityResultCallback ? (other instanceof FunctionAdapter ? Intrinsics.areEqual((Object)((FunctionAdapter)this).getFunctionDelegate(), (Object)((FunctionAdapter)other).getFunctionDelegate()) : false) : false;
            }

            public final int hashCode() {
                return ((FunctionAdapter)this).getFunctionDelegate().hashCode();
            }
        }));
    }

    @Override
    public void launch(@NotNull BacsMandateConfirmationLauncher launcher, @NotNull BacsMandateData arguments, @NotNull BacsConfirmationOption confirmationOption2, @NotNull ConfirmationDefinition.Parameters confirmationParameters) {
        Intrinsics.checkNotNullParameter((Object)launcher, (String)"launcher");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)confirmationOption2, (String)"confirmationOption");
        Intrinsics.checkNotNullParameter((Object)confirmationParameters, (String)"confirmationParameters");
        launcher.launch(arguments, confirmationParameters.getAppearance());
    }

    @Override
    @NotNull
    public ConfirmationDefinition.Result toResult(@NotNull BacsConfirmationOption confirmationOption2, @NotNull ConfirmationDefinition.Parameters confirmationParameters, @Nullable DeferredIntentConfirmationType deferredIntentConfirmationType, @NotNull BacsMandateConfirmationResult result2) {
        ConfirmationDefinition.Result result3;
        Intrinsics.checkNotNullParameter((Object)confirmationOption2, (String)"confirmationOption");
        Intrinsics.checkNotNullParameter((Object)confirmationParameters, (String)"confirmationParameters");
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        BacsMandateConfirmationResult bacsMandateConfirmationResult = result2;
        if (bacsMandateConfirmationResult instanceof BacsMandateConfirmationResult.Confirmed) {
            PaymentMethodConfirmationOption.New nextConfirmationOption = new PaymentMethodConfirmationOption.New(confirmationOption2.getCreateParams(), null, null, false);
            result3 = new ConfirmationDefinition.Result.NextStep(nextConfirmationOption, confirmationParameters);
        } else if (bacsMandateConfirmationResult instanceof BacsMandateConfirmationResult.ModifyDetails) {
            result3 = new ConfirmationDefinition.Result.Canceled(ConfirmationHandler.Result.Canceled.Action.ModifyPaymentDetails);
        } else if (bacsMandateConfirmationResult instanceof BacsMandateConfirmationResult.Cancelled) {
            result3 = new ConfirmationDefinition.Result.Canceled(ConfirmationHandler.Result.Canceled.Action.None);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return result3;
    }

    @Override
    public boolean canConfirm(@NotNull BacsConfirmationOption confirmationOption2, @NotNull ConfirmationDefinition.Parameters confirmationParameters) {
        return ConfirmationDefinition.DefaultImpls.canConfirm(this, (ConfirmationHandler.Option)confirmationOption2, confirmationParameters);
    }

    @Override
    public void unregister(@NotNull BacsMandateConfirmationLauncher launcher) {
        ConfirmationDefinition.DefaultImpls.unregister(this, launcher);
    }
}

