/*
 * Decompiled with CFR 0.152.
 */
package com.stripe.android.paymentelement;

import android.app.Activity;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.view.Window;
import androidx.activity.result.ActivityResultCaller;
import androidx.annotation.RestrictTo;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.ComposableTarget;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.runtime.RecomposeScopeImplKt;
import androidx.compose.runtime.ScopeUpdateScope;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.painter.Painter;
import androidx.compose.ui.text.AnnotatedString;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import com.stripe.android.ExperimentalAllowsRemovalOfLastSavedPaymentMethodApi;
import com.stripe.android.common.configuration.ConfigurationDefaults;
import com.stripe.android.common.ui.DelegateDrawable;
import com.stripe.android.model.CardBrand;
import com.stripe.android.paymentelement.AnalyticEventCallback;
import com.stripe.android.paymentelement.ConfirmCustomPaymentMethodCallback;
import com.stripe.android.paymentelement.ExperimentalAnalyticEventCallbackApi;
import com.stripe.android.paymentelement.ExperimentalCustomPaymentMethodsApi;
import com.stripe.android.paymentelement.ExperimentalEmbeddedPaymentElementApi;
import com.stripe.android.paymentelement.embedded.EmbeddedSelectionHolder;
import com.stripe.android.paymentelement.embedded.content.EmbeddedConfigurationCoordinator;
import com.stripe.android.paymentelement.embedded.content.EmbeddedConfirmationHelper;
import com.stripe.android.paymentelement.embedded.content.EmbeddedConfirmationStateHolder;
import com.stripe.android.paymentelement.embedded.content.EmbeddedContent;
import com.stripe.android.paymentelement.embedded.content.EmbeddedContentHelper;
import com.stripe.android.paymentelement.embedded.content.EmbeddedPaymentElementScope;
import com.stripe.android.paymentelement.embedded.content.EmbeddedPaymentElementSubcomponent;
import com.stripe.android.paymentelement.embedded.content.EmbeddedPaymentElementViewModel;
import com.stripe.android.paymentelement.embedded.content.PaymentOptionDisplayDataHolder;
import com.stripe.android.paymentsheet.CreateIntentCallback;
import com.stripe.android.paymentsheet.ExternalPaymentMethodConfirmHandler;
import com.stripe.android.paymentsheet.PaymentSheet;
import com.stripe.android.paymentsheet.addresselement.AddressDetails;
import com.stripe.android.paymentsheet.state.CustomerState;
import com.stripe.android.paymentsheet.utils.ActivityUtilsKt;
import com.stripe.android.uicore.image.DrawablePainterKt;
import com.stripe.android.uicore.utils.StateFlowsComposeKt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.parcelize.Parcelize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@EmbeddedPaymentElementScope
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0018\u0002\b\u0007\u0018\u0000 &2\u00020\u0001:\b\u001f !\"#$%&B1\b\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0086@\u00a2\u0006\u0002\u0010\u0019J\r\u0010\u001a\u001a\u00020\u001bH\u0007\u00a2\u0006\u0002\u0010\u001cJ\u0006\u0010\u001d\u001a\u00020\u001bJ\u0006\u0010\u001e\u001a\u00020\u001bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\u000e\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006'\u00b2\u0006\f\u0010(\u001a\u0004\u0018\u00010)X\u008a\u0084\u0002"}, d2={"Lcom/stripe/android/paymentelement/EmbeddedPaymentElement;", "", "confirmationHelper", "Lcom/stripe/android/paymentelement/embedded/content/EmbeddedConfirmationHelper;", "contentHelper", "Lcom/stripe/android/paymentelement/embedded/content/EmbeddedContentHelper;", "selectionHolder", "Lcom/stripe/android/paymentelement/embedded/EmbeddedSelectionHolder;", "paymentOptionDisplayDataHolder", "Lcom/stripe/android/paymentelement/embedded/content/PaymentOptionDisplayDataHolder;", "configurationCoordinator", "Lcom/stripe/android/paymentelement/embedded/content/EmbeddedConfigurationCoordinator;", "<init>", "(Lcom/stripe/android/paymentelement/embedded/content/EmbeddedConfirmationHelper;Lcom/stripe/android/paymentelement/embedded/content/EmbeddedContentHelper;Lcom/stripe/android/paymentelement/embedded/EmbeddedSelectionHolder;Lcom/stripe/android/paymentelement/embedded/content/PaymentOptionDisplayDataHolder;Lcom/stripe/android/paymentelement/embedded/content/EmbeddedConfigurationCoordinator;)V", "paymentOption", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/stripe/android/paymentelement/EmbeddedPaymentElement$PaymentOptionDisplayData;", "getPaymentOption", "()Lkotlinx/coroutines/flow/StateFlow;", "configure", "Lcom/stripe/android/paymentelement/EmbeddedPaymentElement$ConfigureResult;", "intentConfiguration", "Lcom/stripe/android/paymentsheet/PaymentSheet$IntentConfiguration;", "configuration", "Lcom/stripe/android/paymentelement/EmbeddedPaymentElement$Configuration;", "(Lcom/stripe/android/paymentsheet/PaymentSheet$IntentConfiguration;Lcom/stripe/android/paymentelement/EmbeddedPaymentElement$Configuration;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Content", "", "(Landroidx/compose/runtime/Composer;I)V", "confirm", "clearPaymentOption", "Builder", "Configuration", "ConfigureResult", "PaymentOptionDisplayData", "Result", "ResultCallback", "State", "Companion", "paymentsheet_release", "embeddedContent", "Lcom/stripe/android/paymentelement/embedded/content/EmbeddedContent;"})
@ExperimentalEmbeddedPaymentElementApi
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nEmbeddedPaymentElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmbeddedPaymentElement.kt\ncom/stripe/android/paymentelement/EmbeddedPaymentElement\n+ 2 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n*L\n1#1,570:1\n81#2:571\n*S KotlinDebug\n*F\n+ 1 EmbeddedPaymentElement.kt\ncom/stripe/android/paymentelement/EmbeddedPaymentElement\n*L\n79#1:571\n*E\n"})
public final class EmbeddedPaymentElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EmbeddedConfirmationHelper confirmationHelper;
    @NotNull
    private final EmbeddedContentHelper contentHelper;
    @NotNull
    private final EmbeddedSelectionHolder selectionHolder;
    @NotNull
    private final EmbeddedConfigurationCoordinator configurationCoordinator;
    @NotNull
    private final StateFlow<PaymentOptionDisplayData> paymentOption;
    public static final int $stable = 8;

    @Inject
    public EmbeddedPaymentElement(@NotNull EmbeddedConfirmationHelper confirmationHelper, @NotNull EmbeddedContentHelper contentHelper, @NotNull EmbeddedSelectionHolder selectionHolder, @NotNull PaymentOptionDisplayDataHolder paymentOptionDisplayDataHolder, @NotNull EmbeddedConfigurationCoordinator configurationCoordinator) {
        Intrinsics.checkNotNullParameter((Object)confirmationHelper, (String)"confirmationHelper");
        Intrinsics.checkNotNullParameter((Object)contentHelper, (String)"contentHelper");
        Intrinsics.checkNotNullParameter((Object)selectionHolder, (String)"selectionHolder");
        Intrinsics.checkNotNullParameter((Object)paymentOptionDisplayDataHolder, (String)"paymentOptionDisplayDataHolder");
        Intrinsics.checkNotNullParameter((Object)configurationCoordinator, (String)"configurationCoordinator");
        this.confirmationHelper = confirmationHelper;
        this.contentHelper = contentHelper;
        this.selectionHolder = selectionHolder;
        this.configurationCoordinator = configurationCoordinator;
        this.paymentOption = paymentOptionDisplayDataHolder.getPaymentOption();
    }

    @NotNull
    public final StateFlow<PaymentOptionDisplayData> getPaymentOption() {
        return this.paymentOption;
    }

    @Nullable
    public final Object configure(@NotNull PaymentSheet.IntentConfiguration intentConfiguration, @NotNull Configuration configuration, @NotNull Continuation<? super ConfigureResult> $completion) {
        return this.configurationCoordinator.configure(intentConfiguration, configuration, $completion);
    }

    @Composable
    @ComposableTarget(applier="androidx.compose.ui.UiComposable")
    public final void Content(@Nullable Composer $composer, int $changed) {
        block6: {
            $composer = $composer.startRestartGroup(746947016);
            int $dirty = $changed;
            if (($changed & 6) == 0) {
                $dirty |= $composer.changedInstance((Object)this) ? 4 : 2;
            }
            if (($dirty & 3) != 2 || !$composer.getSkipping()) {
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventStart((int)746947016, (int)$dirty, (int)-1, (String)"com.stripe.android.paymentelement.EmbeddedPaymentElement.Content (EmbeddedPaymentElement.kt:77)");
                }
                androidx.compose.runtime.State embeddedContent$delegate = StateFlowsComposeKt.collectAsState(this.contentHelper.getEmbeddedContent(), null, (Composer)$composer, (int)0, (int)1);
                EmbeddedContent embeddedContent = EmbeddedPaymentElement.Content$lambda$0((androidx.compose.runtime.State<EmbeddedContent>)embeddedContent$delegate);
                if (embeddedContent != null) {
                    embeddedContent.Content($composer, 0);
                }
                if (ComposerKt.isTraceInProgress()) {
                    ComposerKt.traceEventEnd();
                }
            } else {
                $composer.skipToGroupEnd();
            }
            ScopeUpdateScope scopeUpdateScope = $composer.endRestartGroup();
            if (scopeUpdateScope == null) break block6;
            scopeUpdateScope.updateScope((arg_0, arg_1) -> EmbeddedPaymentElement.Content$lambda$1(this, $changed, arg_0, arg_1));
        }
    }

    public final void confirm() {
        this.confirmationHelper.confirm();
    }

    public final void clearPaymentOption() {
        this.selectionHolder.set(null);
    }

    /*
     * WARNING - void declaration
     */
    private static final EmbeddedContent Content$lambda$0(androidx.compose.runtime.State<EmbeddedContent> $embeddedContent$delegate) {
        void $this$getValue$iv;
        androidx.compose.runtime.State<EmbeddedContent> state2 = $embeddedContent$delegate;
        Object var2_2 = null;
        Object property$iv = null;
        boolean $i$f$getValue = false;
        return (EmbeddedContent)$this$getValue$iv.getValue();
    }

    private static final Unit Content$lambda$1(EmbeddedPaymentElement $tmp1_rcvr, int $$changed, Composer $composer, int $force) {
        $tmp1_rcvr.Content($composer, RecomposeScopeImplKt.updateChangedFlags((int)($$changed | 1)));
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\rJ\u0010\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0011H\u0007J\u0010\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0017H\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\"\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R(\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\f\u001a\u0004\u0018\u00010\u0011@BX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0015\u0010\u0016R(\u0010\u0018\u001a\u0004\u0018\u00010\u00172\b\u0010\f\u001a\u0004\u0018\u00010\u0017@BX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0019\u0010\u0014\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lcom/stripe/android/paymentelement/EmbeddedPaymentElement$Builder;", "", "createIntentCallback", "Lcom/stripe/android/paymentsheet/CreateIntentCallback;", "resultCallback", "Lcom/stripe/android/paymentelement/EmbeddedPaymentElement$ResultCallback;", "<init>", "(Lcom/stripe/android/paymentsheet/CreateIntentCallback;Lcom/stripe/android/paymentelement/EmbeddedPaymentElement$ResultCallback;)V", "getCreateIntentCallback$paymentsheet_release", "()Lcom/stripe/android/paymentsheet/CreateIntentCallback;", "getResultCallback$paymentsheet_release", "()Lcom/stripe/android/paymentelement/EmbeddedPaymentElement$ResultCallback;", "value", "Lcom/stripe/android/paymentsheet/ExternalPaymentMethodConfirmHandler;", "externalPaymentMethodConfirmHandler", "getExternalPaymentMethodConfirmHandler$paymentsheet_release", "()Lcom/stripe/android/paymentsheet/ExternalPaymentMethodConfirmHandler;", "Lcom/stripe/android/paymentelement/ConfirmCustomPaymentMethodCallback;", "confirmCustomPaymentMethodCallback", "getConfirmCustomPaymentMethodCallback$paymentsheet_release$annotations", "()V", "getConfirmCustomPaymentMethodCallback$paymentsheet_release", "()Lcom/stripe/android/paymentelement/ConfirmCustomPaymentMethodCallback;", "Lcom/stripe/android/paymentelement/AnalyticEventCallback;", "analyticEventCallback", "getAnalyticEventCallback$paymentsheet_release$annotations", "getAnalyticEventCallback$paymentsheet_release", "()Lcom/stripe/android/paymentelement/AnalyticEventCallback;", "handler", "callback", "paymentsheet_release"})
    @ExperimentalEmbeddedPaymentElementApi
    @StabilityInferred(parameters=0)
    public static final class Builder {
        @NotNull
        private final CreateIntentCallback createIntentCallback;
        @NotNull
        private final ResultCallback resultCallback;
        @Nullable
        private ExternalPaymentMethodConfirmHandler externalPaymentMethodConfirmHandler;
        @Nullable
        private ConfirmCustomPaymentMethodCallback confirmCustomPaymentMethodCallback;
        @Nullable
        private AnalyticEventCallback analyticEventCallback;
        public static final int $stable = 8;

        public Builder(@NotNull CreateIntentCallback createIntentCallback, @NotNull ResultCallback resultCallback) {
            Intrinsics.checkNotNullParameter((Object)createIntentCallback, (String)"createIntentCallback");
            Intrinsics.checkNotNullParameter((Object)resultCallback, (String)"resultCallback");
            this.createIntentCallback = createIntentCallback;
            this.resultCallback = resultCallback;
        }

        @NotNull
        public final CreateIntentCallback getCreateIntentCallback$paymentsheet_release() {
            return this.createIntentCallback;
        }

        @NotNull
        public final ResultCallback getResultCallback$paymentsheet_release() {
            return this.resultCallback;
        }

        @Nullable
        public final ExternalPaymentMethodConfirmHandler getExternalPaymentMethodConfirmHandler$paymentsheet_release() {
            return this.externalPaymentMethodConfirmHandler;
        }

        @Nullable
        public final ConfirmCustomPaymentMethodCallback getConfirmCustomPaymentMethodCallback$paymentsheet_release() {
            return this.confirmCustomPaymentMethodCallback;
        }

        public static /* synthetic */ void getConfirmCustomPaymentMethodCallback$paymentsheet_release$annotations() {
        }

        @Nullable
        public final AnalyticEventCallback getAnalyticEventCallback$paymentsheet_release() {
            return this.analyticEventCallback;
        }

        public static /* synthetic */ void getAnalyticEventCallback$paymentsheet_release$annotations() {
        }

        @NotNull
        public final Builder externalPaymentMethodConfirmHandler(@NotNull ExternalPaymentMethodConfirmHandler handler) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            Builder $this$externalPaymentMethodConfirmHandler_u24lambda_u240 = builder = this;
            boolean bl = false;
            $this$externalPaymentMethodConfirmHandler_u24lambda_u240.externalPaymentMethodConfirmHandler = handler;
            return builder;
        }

        @ExperimentalCustomPaymentMethodsApi
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NotNull
        public final Builder confirmCustomPaymentMethodCallback(@NotNull ConfirmCustomPaymentMethodCallback callback2) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
            Builder $this$confirmCustomPaymentMethodCallback_u24lambda_u241 = builder = this;
            boolean bl = false;
            $this$confirmCustomPaymentMethodCallback_u24lambda_u241.confirmCustomPaymentMethodCallback = callback2;
            return builder;
        }

        @ExperimentalAnalyticEventCallbackApi
        @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
        @NotNull
        public final Builder analyticEventCallback(@NotNull AnalyticEventCallback callback2) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)callback2, (String)"callback");
            Builder $this$analyticEventCallback_u24lambda_u242 = builder = this;
            boolean bl = false;
            $this$analyticEventCallback_u24lambda_u242.analyticEventCallback = callback2;
            return builder;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007\u00a8\u0006\u0012"}, d2={"Lcom/stripe/android/paymentelement/EmbeddedPaymentElement$Companion;", "", "<init>", "()V", "create", "Lcom/stripe/android/paymentelement/EmbeddedPaymentElement;", "activity", "Landroid/app/Activity;", "activityResultCaller", "Landroidx/activity/result/ActivityResultCaller;", "viewModelStoreOwner", "Landroidx/lifecycle/ViewModelStoreOwner;", "lifecycleOwner", "Landroidx/lifecycle/LifecycleOwner;", "paymentElementCallbackIdentifier", "", "resultCallback", "Lcom/stripe/android/paymentelement/EmbeddedPaymentElement$ResultCallback;", "paymentsheet_release"})
    public static final class Companion {
        private Companion() {
        }

        @ExperimentalEmbeddedPaymentElementApi
        @NotNull
        public final EmbeddedPaymentElement create(@NotNull Activity activity, @NotNull ActivityResultCaller activityResultCaller, @NotNull ViewModelStoreOwner viewModelStoreOwner, @NotNull LifecycleOwner lifecycleOwner, @NotNull String paymentElementCallbackIdentifier, @NotNull ResultCallback resultCallback) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            Intrinsics.checkNotNullParameter((Object)activityResultCaller, (String)"activityResultCaller");
            Intrinsics.checkNotNullParameter((Object)viewModelStoreOwner, (String)"viewModelStoreOwner");
            Intrinsics.checkNotNullParameter((Object)lifecycleOwner, (String)"lifecycleOwner");
            Intrinsics.checkNotNullParameter((Object)paymentElementCallbackIdentifier, (String)"paymentElementCallbackIdentifier");
            Intrinsics.checkNotNullParameter((Object)resultCallback, (String)"resultCallback");
            Window window = activity.getWindow();
            EmbeddedPaymentElementViewModel viewModel = (EmbeddedPaymentElementViewModel)new ViewModelProvider(viewModelStoreOwner, (ViewModelProvider.Factory)new EmbeddedPaymentElementViewModel.Factory(paymentElementCallbackIdentifier, window != null ? Integer.valueOf(window.getStatusBarColor()) : null)).get("EmbeddedPaymentElementViewModel(instance = " + paymentElementCallbackIdentifier + ")", EmbeddedPaymentElementViewModel.class);
            EmbeddedPaymentElementSubcomponent embeddedPaymentElementSubcomponent = viewModel.getEmbeddedPaymentElementSubcomponentFactory().build(activityResultCaller, lifecycleOwner, resultCallback);
            embeddedPaymentElementSubcomponent.getInitializer().initialize(ActivityUtilsKt.applicationIsTaskOwner(activity));
            return embeddedPaymentElementSubcomponent.getEmbeddedPaymentElement();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b \n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001GB\u00bb\u0001\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015\u0012\u0006\u0010\u0017\u001a\u00020\r\u0012\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u0015\u0012\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u0015\u0012\u0006\u0010\u001a\u001a\u00020\u001b\u0012\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0015\u0012\u0006\u0010\u001e\u001a\u00020\r\u0012\u0006\u0010\u001f\u001a\u00020 \u00a2\u0006\u0004\b!\u0010\"J\u0006\u0010@\u001a\u00020AJ\u0016\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020AR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0014\u0010\u000e\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010.R\u0014\u0010\u000f\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u0010$R\u0014\u0010\u0012\u001a\u00020\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0014\u0010\u0017\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010.R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00030\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00106R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u00106R\u0014\u0010\u001a\u001a\u00020\u001bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u00106R\u0014\u0010\u001e\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010.R\u0014\u0010\u001f\u001a\u00020 X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?\u00a8\u0006H"}, d2={"Lcom/stripe/android/paymentelement/EmbeddedPaymentElement$Configuration;", "Landroid/os/Parcelable;", "merchantDisplayName", "", "customer", "Lcom/stripe/android/paymentsheet/PaymentSheet$CustomerConfiguration;", "googlePay", "Lcom/stripe/android/paymentsheet/PaymentSheet$GooglePayConfiguration;", "defaultBillingDetails", "Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetails;", "shippingDetails", "Lcom/stripe/android/paymentsheet/addresselement/AddressDetails;", "allowsDelayedPaymentMethods", "", "allowsPaymentMethodsRequiringShippingAddress", "appearance", "Lcom/stripe/android/paymentsheet/PaymentSheet$Appearance;", "primaryButtonLabel", "billingDetailsCollectionConfiguration", "Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetailsCollectionConfiguration;", "preferredNetworks", "", "Lcom/stripe/android/model/CardBrand;", "allowsRemovalOfLastSavedPaymentMethod", "paymentMethodOrder", "externalPaymentMethods", "cardBrandAcceptance", "Lcom/stripe/android/paymentsheet/PaymentSheet$CardBrandAcceptance;", "customPaymentMethods", "Lcom/stripe/android/paymentsheet/PaymentSheet$CustomPaymentMethod;", "embeddedViewDisplaysMandateText", "link", "Lcom/stripe/android/paymentsheet/PaymentSheet$LinkConfiguration;", "<init>", "(Ljava/lang/String;Lcom/stripe/android/paymentsheet/PaymentSheet$CustomerConfiguration;Lcom/stripe/android/paymentsheet/PaymentSheet$GooglePayConfiguration;Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetails;Lcom/stripe/android/paymentsheet/addresselement/AddressDetails;ZZLcom/stripe/android/paymentsheet/PaymentSheet$Appearance;Ljava/lang/String;Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetailsCollectionConfiguration;Ljava/util/List;ZLjava/util/List;Ljava/util/List;Lcom/stripe/android/paymentsheet/PaymentSheet$CardBrandAcceptance;Ljava/util/List;ZLcom/stripe/android/paymentsheet/PaymentSheet$LinkConfiguration;)V", "getMerchantDisplayName$paymentsheet_release", "()Ljava/lang/String;", "getCustomer$paymentsheet_release", "()Lcom/stripe/android/paymentsheet/PaymentSheet$CustomerConfiguration;", "getGooglePay$paymentsheet_release", "()Lcom/stripe/android/paymentsheet/PaymentSheet$GooglePayConfiguration;", "getDefaultBillingDetails$paymentsheet_release", "()Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetails;", "getShippingDetails$paymentsheet_release", "()Lcom/stripe/android/paymentsheet/addresselement/AddressDetails;", "getAllowsDelayedPaymentMethods$paymentsheet_release", "()Z", "getAllowsPaymentMethodsRequiringShippingAddress$paymentsheet_release", "getAppearance$paymentsheet_release", "()Lcom/stripe/android/paymentsheet/PaymentSheet$Appearance;", "getPrimaryButtonLabel$paymentsheet_release", "getBillingDetailsCollectionConfiguration$paymentsheet_release", "()Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetailsCollectionConfiguration;", "getPreferredNetworks$paymentsheet_release", "()Ljava/util/List;", "getAllowsRemovalOfLastSavedPaymentMethod$paymentsheet_release", "getPaymentMethodOrder$paymentsheet_release", "getExternalPaymentMethods$paymentsheet_release", "getCardBrandAcceptance$paymentsheet_release", "()Lcom/stripe/android/paymentsheet/PaymentSheet$CardBrandAcceptance;", "getCustomPaymentMethods$paymentsheet_release", "getEmbeddedViewDisplaysMandateText$paymentsheet_release", "getLink$paymentsheet_release", "()Lcom/stripe/android/paymentsheet/PaymentSheet$LinkConfiguration;", "describeContents", "", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "Builder", "paymentsheet_release"})
    @Parcelize
    @ExperimentalEmbeddedPaymentElementApi
    @StabilityInferred(parameters=0)
    public static final class Configuration
    implements Parcelable {
        @NotNull
        private final String merchantDisplayName;
        @Nullable
        private final PaymentSheet.CustomerConfiguration customer;
        @Nullable
        private final PaymentSheet.GooglePayConfiguration googlePay;
        @Nullable
        private final PaymentSheet.BillingDetails defaultBillingDetails;
        @Nullable
        private final AddressDetails shippingDetails;
        private final boolean allowsDelayedPaymentMethods;
        private final boolean allowsPaymentMethodsRequiringShippingAddress;
        @NotNull
        private final PaymentSheet.Appearance appearance;
        @Nullable
        private final String primaryButtonLabel;
        @NotNull
        private final PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration;
        @NotNull
        private final List<CardBrand> preferredNetworks;
        private final boolean allowsRemovalOfLastSavedPaymentMethod;
        @NotNull
        private final List<String> paymentMethodOrder;
        @NotNull
        private final List<String> externalPaymentMethods;
        @NotNull
        private final PaymentSheet.CardBrandAcceptance cardBrandAcceptance;
        @NotNull
        private final List<PaymentSheet.CustomPaymentMethod> customPaymentMethods;
        private final boolean embeddedViewDisplaysMandateText;
        @NotNull
        private final PaymentSheet.LinkConfiguration link;
        @NotNull
        public static final Parcelable.Creator<Configuration> CREATOR;
        public static final int $stable;

        public Configuration(@NotNull String merchantDisplayName, @Nullable PaymentSheet.CustomerConfiguration customer2, @Nullable PaymentSheet.GooglePayConfiguration googlePay, @Nullable PaymentSheet.BillingDetails defaultBillingDetails, @Nullable AddressDetails shippingDetails, boolean allowsDelayedPaymentMethods, boolean allowsPaymentMethodsRequiringShippingAddress, @NotNull PaymentSheet.Appearance appearance, @Nullable String primaryButtonLabel, @NotNull PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration, @NotNull List<? extends CardBrand> preferredNetworks, boolean allowsRemovalOfLastSavedPaymentMethod, @NotNull List<String> paymentMethodOrder, @NotNull List<String> externalPaymentMethods, @NotNull PaymentSheet.CardBrandAcceptance cardBrandAcceptance, @NotNull List<PaymentSheet.CustomPaymentMethod> customPaymentMethods, boolean embeddedViewDisplaysMandateText, @NotNull PaymentSheet.LinkConfiguration link) {
            Intrinsics.checkNotNullParameter((Object)merchantDisplayName, (String)"merchantDisplayName");
            Intrinsics.checkNotNullParameter((Object)appearance, (String)"appearance");
            Intrinsics.checkNotNullParameter((Object)billingDetailsCollectionConfiguration, (String)"billingDetailsCollectionConfiguration");
            Intrinsics.checkNotNullParameter(preferredNetworks, (String)"preferredNetworks");
            Intrinsics.checkNotNullParameter(paymentMethodOrder, (String)"paymentMethodOrder");
            Intrinsics.checkNotNullParameter(externalPaymentMethods, (String)"externalPaymentMethods");
            Intrinsics.checkNotNullParameter((Object)cardBrandAcceptance, (String)"cardBrandAcceptance");
            Intrinsics.checkNotNullParameter(customPaymentMethods, (String)"customPaymentMethods");
            Intrinsics.checkNotNullParameter((Object)link, (String)"link");
            this.merchantDisplayName = merchantDisplayName;
            this.customer = customer2;
            this.googlePay = googlePay;
            this.defaultBillingDetails = defaultBillingDetails;
            this.shippingDetails = shippingDetails;
            this.allowsDelayedPaymentMethods = allowsDelayedPaymentMethods;
            this.allowsPaymentMethodsRequiringShippingAddress = allowsPaymentMethodsRequiringShippingAddress;
            this.appearance = appearance;
            this.primaryButtonLabel = primaryButtonLabel;
            this.billingDetailsCollectionConfiguration = billingDetailsCollectionConfiguration;
            this.preferredNetworks = preferredNetworks;
            this.allowsRemovalOfLastSavedPaymentMethod = allowsRemovalOfLastSavedPaymentMethod;
            this.paymentMethodOrder = paymentMethodOrder;
            this.externalPaymentMethods = externalPaymentMethods;
            this.cardBrandAcceptance = cardBrandAcceptance;
            this.customPaymentMethods = customPaymentMethods;
            this.embeddedViewDisplaysMandateText = embeddedViewDisplaysMandateText;
            this.link = link;
        }

        @NotNull
        public final String getMerchantDisplayName$paymentsheet_release() {
            return this.merchantDisplayName;
        }

        @Nullable
        public final PaymentSheet.CustomerConfiguration getCustomer$paymentsheet_release() {
            return this.customer;
        }

        @Nullable
        public final PaymentSheet.GooglePayConfiguration getGooglePay$paymentsheet_release() {
            return this.googlePay;
        }

        @Nullable
        public final PaymentSheet.BillingDetails getDefaultBillingDetails$paymentsheet_release() {
            return this.defaultBillingDetails;
        }

        @Nullable
        public final AddressDetails getShippingDetails$paymentsheet_release() {
            return this.shippingDetails;
        }

        public final boolean getAllowsDelayedPaymentMethods$paymentsheet_release() {
            return this.allowsDelayedPaymentMethods;
        }

        public final boolean getAllowsPaymentMethodsRequiringShippingAddress$paymentsheet_release() {
            return this.allowsPaymentMethodsRequiringShippingAddress;
        }

        @NotNull
        public final PaymentSheet.Appearance getAppearance$paymentsheet_release() {
            return this.appearance;
        }

        @Nullable
        public final String getPrimaryButtonLabel$paymentsheet_release() {
            return this.primaryButtonLabel;
        }

        @NotNull
        public final PaymentSheet.BillingDetailsCollectionConfiguration getBillingDetailsCollectionConfiguration$paymentsheet_release() {
            return this.billingDetailsCollectionConfiguration;
        }

        @NotNull
        public final List<CardBrand> getPreferredNetworks$paymentsheet_release() {
            return this.preferredNetworks;
        }

        public final boolean getAllowsRemovalOfLastSavedPaymentMethod$paymentsheet_release() {
            return this.allowsRemovalOfLastSavedPaymentMethod;
        }

        @NotNull
        public final List<String> getPaymentMethodOrder$paymentsheet_release() {
            return this.paymentMethodOrder;
        }

        @NotNull
        public final List<String> getExternalPaymentMethods$paymentsheet_release() {
            return this.externalPaymentMethods;
        }

        @NotNull
        public final PaymentSheet.CardBrandAcceptance getCardBrandAcceptance$paymentsheet_release() {
            return this.cardBrandAcceptance;
        }

        @NotNull
        public final List<PaymentSheet.CustomPaymentMethod> getCustomPaymentMethods$paymentsheet_release() {
            return this.customPaymentMethods;
        }

        public final boolean getEmbeddedViewDisplaysMandateText$paymentsheet_release() {
            return this.embeddedViewDisplaysMandateText;
        }

        @NotNull
        public final PaymentSheet.LinkConfiguration getLink$paymentsheet_release() {
            return this.link;
        }

        public final void writeToParcel(@NotNull Parcel dest, int flags) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            dest.writeString(this.merchantDisplayName);
            Object object = this.customer;
            if (object == null) {
                dest.writeInt(0);
            } else {
                dest.writeInt(1);
                ((PaymentSheet.CustomerConfiguration)object).writeToParcel(dest, flags);
            }
            object = this.googlePay;
            if (object == null) {
                dest.writeInt(0);
            } else {
                dest.writeInt(1);
                ((PaymentSheet.GooglePayConfiguration)object).writeToParcel(dest, flags);
            }
            object = this.defaultBillingDetails;
            if (object == null) {
                dest.writeInt(0);
            } else {
                dest.writeInt(1);
                ((PaymentSheet.BillingDetails)object).writeToParcel(dest, flags);
            }
            object = this.shippingDetails;
            if (object == null) {
                dest.writeInt(0);
            } else {
                dest.writeInt(1);
                ((AddressDetails)object).writeToParcel(dest, flags);
            }
            dest.writeInt(this.allowsDelayedPaymentMethods ? 1 : 0);
            dest.writeInt(this.allowsPaymentMethodsRequiringShippingAddress ? 1 : 0);
            this.appearance.writeToParcel(dest, flags);
            dest.writeString(this.primaryButtonLabel);
            this.billingDetailsCollectionConfiguration.writeToParcel(dest, flags);
            object = this.preferredNetworks;
            dest.writeInt(object.size());
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                dest.writeString(((CardBrand)iterator.next()).name());
            }
            dest.writeInt(this.allowsRemovalOfLastSavedPaymentMethod ? 1 : 0);
            dest.writeStringList(this.paymentMethodOrder);
            dest.writeStringList(this.externalPaymentMethods);
            dest.writeParcelable((Parcelable)this.cardBrandAcceptance, flags);
            object = this.customPaymentMethods;
            dest.writeInt(object.size());
            iterator = object.iterator();
            while (iterator.hasNext()) {
                ((PaymentSheet.CustomPaymentMethod)iterator.next()).writeToParcel(dest, flags);
            }
            dest.writeInt(this.embeddedViewDisplaysMandateText ? 1 : 0);
            this.link.writeToParcel(dest, flags);
        }

        public final int describeContents() {
            return 0;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Configuration)) {
                return false;
            }
            Configuration configuration = (Configuration)other;
            if (!Intrinsics.areEqual((Object)this.merchantDisplayName, (Object)configuration.merchantDisplayName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.customer, (Object)configuration.customer)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.googlePay, (Object)configuration.googlePay)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.defaultBillingDetails, (Object)configuration.defaultBillingDetails)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.shippingDetails, (Object)configuration.shippingDetails)) {
                return false;
            }
            if (this.allowsDelayedPaymentMethods != configuration.allowsDelayedPaymentMethods) {
                return false;
            }
            if (this.allowsPaymentMethodsRequiringShippingAddress != configuration.allowsPaymentMethodsRequiringShippingAddress) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.appearance, (Object)configuration.appearance)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.primaryButtonLabel, (Object)configuration.primaryButtonLabel)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.billingDetailsCollectionConfiguration, (Object)configuration.billingDetailsCollectionConfiguration)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.preferredNetworks, configuration.preferredNetworks)) {
                return false;
            }
            if (this.allowsRemovalOfLastSavedPaymentMethod != configuration.allowsRemovalOfLastSavedPaymentMethod) {
                return false;
            }
            if (!Intrinsics.areEqual(this.paymentMethodOrder, configuration.paymentMethodOrder)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.externalPaymentMethods, configuration.externalPaymentMethods)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.cardBrandAcceptance, (Object)configuration.cardBrandAcceptance)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.customPaymentMethods, configuration.customPaymentMethods)) {
                return false;
            }
            if (this.embeddedViewDisplaysMandateText != configuration.embeddedViewDisplaysMandateText) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.link, (Object)configuration.link);
        }

        public int hashCode() {
            int result2 = this.merchantDisplayName.hashCode();
            result2 = result2 * 31 + (this.customer == null ? 0 : this.customer.hashCode());
            result2 = result2 * 31 + (this.googlePay == null ? 0 : this.googlePay.hashCode());
            result2 = result2 * 31 + (this.defaultBillingDetails == null ? 0 : this.defaultBillingDetails.hashCode());
            result2 = result2 * 31 + (this.shippingDetails == null ? 0 : this.shippingDetails.hashCode());
            result2 = result2 * 31 + Boolean.hashCode(this.allowsDelayedPaymentMethods);
            result2 = result2 * 31 + Boolean.hashCode(this.allowsPaymentMethodsRequiringShippingAddress);
            result2 = result2 * 31 + this.appearance.hashCode();
            result2 = result2 * 31 + (this.primaryButtonLabel == null ? 0 : this.primaryButtonLabel.hashCode());
            result2 = result2 * 31 + this.billingDetailsCollectionConfiguration.hashCode();
            result2 = result2 * 31 + ((Object)this.preferredNetworks).hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.allowsRemovalOfLastSavedPaymentMethod);
            result2 = result2 * 31 + ((Object)this.paymentMethodOrder).hashCode();
            result2 = result2 * 31 + ((Object)this.externalPaymentMethods).hashCode();
            result2 = result2 * 31 + this.cardBrandAcceptance.hashCode();
            result2 = result2 * 31 + ((Object)this.customPaymentMethods).hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.embeddedViewDisplaysMandateText);
            result2 = result2 * 31 + this.link.hashCode();
            return result2;
        }

        @NotNull
        public String toString() {
            return "Configuration(merchantDisplayName=" + this.merchantDisplayName + ", customer=" + this.customer + ", googlePay=" + this.googlePay + ", defaultBillingDetails=" + this.defaultBillingDetails + ", shippingDetails=" + this.shippingDetails + ", allowsDelayedPaymentMethods=" + this.allowsDelayedPaymentMethods + ", allowsPaymentMethodsRequiringShippingAddress=" + this.allowsPaymentMethodsRequiringShippingAddress + ", appearance=" + this.appearance + ", primaryButtonLabel=" + this.primaryButtonLabel + ", billingDetailsCollectionConfiguration=" + this.billingDetailsCollectionConfiguration + ", preferredNetworks=" + this.preferredNetworks + ", allowsRemovalOfLastSavedPaymentMethod=" + this.allowsRemovalOfLastSavedPaymentMethod + ", paymentMethodOrder=" + this.paymentMethodOrder + ", externalPaymentMethods=" + this.externalPaymentMethods + ", cardBrandAcceptance=" + this.cardBrandAcceptance + ", customPaymentMethods=" + this.customPaymentMethods + ", embeddedViewDisplaysMandateText=" + this.embeddedViewDisplaysMandateText + ", link=" + this.link + ")";
        }

        static {
            @Metadata(mv={2, 1, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<Configuration> {
                public final Configuration[] newArray(int size) {
                    return new Configuration[size];
                }

                public final Configuration createFromParcel(Parcel parcel) {
                    int n;
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    int n2 = parcel.readInt();
                    ArrayList<Object> arrayList = new ArrayList<Object>(n2);
                    PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration = (PaymentSheet.BillingDetailsCollectionConfiguration)PaymentSheet.BillingDetailsCollectionConfiguration.CREATOR.createFromParcel(parcel);
                    String string2 = parcel.readString();
                    PaymentSheet.Appearance appearance = (PaymentSheet.Appearance)PaymentSheet.Appearance.CREATOR.createFromParcel(parcel);
                    boolean bl = parcel.readInt() != 0;
                    boolean bl2 = parcel.readInt() != 0;
                    AddressDetails addressDetails = (AddressDetails)(parcel.readInt() == 0 ? null : AddressDetails.CREATOR.createFromParcel(parcel));
                    PaymentSheet.BillingDetails billingDetails = (PaymentSheet.BillingDetails)(parcel.readInt() == 0 ? null : PaymentSheet.BillingDetails.CREATOR.createFromParcel(parcel));
                    PaymentSheet.GooglePayConfiguration googlePayConfiguration = (PaymentSheet.GooglePayConfiguration)(parcel.readInt() == 0 ? null : PaymentSheet.GooglePayConfiguration.CREATOR.createFromParcel(parcel));
                    PaymentSheet.CustomerConfiguration customerConfiguration = (PaymentSheet.CustomerConfiguration)(parcel.readInt() == 0 ? null : PaymentSheet.CustomerConfiguration.CREATOR.createFromParcel(parcel));
                    String string3 = parcel.readString();
                    for (n = 0; n != n2; ++n) {
                        arrayList.add(CardBrand.valueOf((String)parcel.readString()));
                    }
                    List list = arrayList;
                    n2 = parcel.readInt();
                    arrayList = new ArrayList(n2);
                    PaymentSheet.CardBrandAcceptance cardBrandAcceptance = (PaymentSheet.CardBrandAcceptance)parcel.readParcelable(Configuration.class.getClassLoader());
                    List list2 = parcel.createStringArrayList();
                    List list3 = parcel.createStringArrayList();
                    boolean bl3 = parcel.readInt() != 0;
                    List list4 = list;
                    for (n = 0; n != n2; ++n) {
                        arrayList.add(PaymentSheet.CustomPaymentMethod.CREATOR.createFromParcel(parcel));
                    }
                    PaymentSheet.LinkConfiguration linkConfiguration = (PaymentSheet.LinkConfiguration)PaymentSheet.LinkConfiguration.CREATOR.createFromParcel(parcel);
                    boolean bl4 = parcel.readInt() != 0;
                    List list5 = arrayList;
                    PaymentSheet.CardBrandAcceptance cardBrandAcceptance2 = cardBrandAcceptance;
                    List list6 = list2;
                    List list7 = list3;
                    boolean bl5 = bl3;
                    List list8 = list4;
                    PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration2 = billingDetailsCollectionConfiguration;
                    String string4 = string2;
                    PaymentSheet.Appearance appearance2 = appearance;
                    boolean bl6 = bl;
                    boolean bl7 = bl2;
                    AddressDetails addressDetails2 = addressDetails;
                    PaymentSheet.BillingDetails billingDetails2 = billingDetails;
                    PaymentSheet.GooglePayConfiguration googlePayConfiguration2 = googlePayConfiguration;
                    PaymentSheet.CustomerConfiguration customerConfiguration2 = customerConfiguration;
                    String string5 = string3;
                    return new Configuration(string5, customerConfiguration2, googlePayConfiguration2, billingDetails2, addressDetails2, bl7, bl6, appearance2, string4, billingDetailsCollectionConfiguration2, list8, bl5, list7, list6, cardBrandAcceptance2, list5, bl4, linkConfiguration);
                }
            }
            CREATOR = new Creator();
            $stable = 8;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00002\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\b\u001a\u00020\u00002\b\u0010\b\u001a\u0004\u0018\u00010\tJ\u0010\u0010\n\u001a\u00020\u00002\b\u0010\n\u001a\u0004\u0018\u00010\u000bJ\u0010\u0010\f\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0013\u001a\u00020\u0003J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010\u0016\u001a\u00020\u00002\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017J\u0010\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u000fH\u0007J\u0014\u0010\u001a\u001a\u00020\u00002\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017J\u0014\u0010\u001b\u001a\u00020\u00002\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001f\u001a\u00020\u00002\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0017H\u0007J\u000e\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u000fJ\u000e\u0010!\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"J\u0006\u0010#\u001a\u00020$R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/stripe/android/paymentelement/EmbeddedPaymentElement$Configuration$Builder;", "", "merchantDisplayName", "", "<init>", "(Ljava/lang/String;)V", "customer", "Lcom/stripe/android/paymentsheet/PaymentSheet$CustomerConfiguration;", "googlePay", "Lcom/stripe/android/paymentsheet/PaymentSheet$GooglePayConfiguration;", "defaultBillingDetails", "Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetails;", "shippingDetails", "Lcom/stripe/android/paymentsheet/addresselement/AddressDetails;", "allowsDelayedPaymentMethods", "", "allowsPaymentMethodsRequiringShippingAddress", "appearance", "Lcom/stripe/android/paymentsheet/PaymentSheet$Appearance;", "primaryButtonLabel", "billingDetailsCollectionConfiguration", "Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetailsCollectionConfiguration;", "preferredNetworks", "", "Lcom/stripe/android/model/CardBrand;", "allowsRemovalOfLastSavedPaymentMethod", "paymentMethodOrder", "externalPaymentMethods", "cardBrandAcceptance", "Lcom/stripe/android/paymentsheet/PaymentSheet$CardBrandAcceptance;", "embeddedViewDisplaysMandateText", "customPaymentMethods", "Lcom/stripe/android/paymentsheet/PaymentSheet$CustomPaymentMethod;", "link", "Lcom/stripe/android/paymentsheet/PaymentSheet$LinkConfiguration;", "build", "Lcom/stripe/android/paymentelement/EmbeddedPaymentElement$Configuration;", "paymentsheet_release"})
        @ExperimentalEmbeddedPaymentElementApi
        @StabilityInferred(parameters=0)
        @SourceDebugExtension(value={"SMAP\nEmbeddedPaymentElement.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EmbeddedPaymentElement.kt\ncom/stripe/android/paymentelement/EmbeddedPaymentElement$Configuration$Builder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,570:1\n1#2:571\n*E\n"})
        public static final class Builder {
            @NotNull
            private final String merchantDisplayName;
            @Nullable
            private PaymentSheet.CustomerConfiguration customer;
            @Nullable
            private PaymentSheet.GooglePayConfiguration googlePay;
            @Nullable
            private PaymentSheet.BillingDetails defaultBillingDetails;
            @Nullable
            private AddressDetails shippingDetails;
            private boolean allowsDelayedPaymentMethods;
            private boolean allowsPaymentMethodsRequiringShippingAddress;
            @NotNull
            private PaymentSheet.Appearance appearance;
            @Nullable
            private String primaryButtonLabel;
            @NotNull
            private PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration;
            @NotNull
            private List<? extends CardBrand> preferredNetworks;
            private boolean allowsRemovalOfLastSavedPaymentMethod;
            @NotNull
            private List<String> paymentMethodOrder;
            @NotNull
            private List<String> externalPaymentMethods;
            @NotNull
            private PaymentSheet.CardBrandAcceptance cardBrandAcceptance;
            private boolean embeddedViewDisplaysMandateText;
            @NotNull
            private List<PaymentSheet.CustomPaymentMethod> customPaymentMethods;
            @NotNull
            private PaymentSheet.LinkConfiguration link;
            public static final int $stable = 8;

            public Builder(@NotNull String merchantDisplayName) {
                Intrinsics.checkNotNullParameter((Object)merchantDisplayName, (String)"merchantDisplayName");
                this.merchantDisplayName = merchantDisplayName;
                this.customer = ConfigurationDefaults.INSTANCE.getCustomer();
                this.googlePay = ConfigurationDefaults.INSTANCE.getGooglePay();
                this.defaultBillingDetails = ConfigurationDefaults.INSTANCE.getBillingDetails();
                this.shippingDetails = ConfigurationDefaults.INSTANCE.getShippingDetails();
                this.appearance = ConfigurationDefaults.INSTANCE.getAppearance();
                this.primaryButtonLabel = ConfigurationDefaults.INSTANCE.getPrimaryButtonLabel();
                this.billingDetailsCollectionConfiguration = ConfigurationDefaults.INSTANCE.getBillingDetailsCollectionConfiguration();
                this.preferredNetworks = ConfigurationDefaults.INSTANCE.getPreferredNetworks();
                this.allowsRemovalOfLastSavedPaymentMethod = true;
                this.paymentMethodOrder = ConfigurationDefaults.INSTANCE.getPaymentMethodOrder();
                this.externalPaymentMethods = ConfigurationDefaults.INSTANCE.getExternalPaymentMethods();
                this.cardBrandAcceptance = ConfigurationDefaults.INSTANCE.getCardBrandAcceptance();
                this.embeddedViewDisplaysMandateText = true;
                this.customPaymentMethods = ConfigurationDefaults.INSTANCE.getCustomPaymentMethods();
                this.link = ConfigurationDefaults.INSTANCE.getLink();
            }

            @NotNull
            public final Builder customer(@Nullable PaymentSheet.CustomerConfiguration customer2) {
                Builder builder;
                Builder $this$customer_u24lambda_u240 = builder = this;
                boolean bl = false;
                $this$customer_u24lambda_u240.customer = customer2;
                return builder;
            }

            @NotNull
            public final Builder googlePay(@Nullable PaymentSheet.GooglePayConfiguration googlePay) {
                Builder builder;
                Builder $this$googlePay_u24lambda_u241 = builder = this;
                boolean bl = false;
                $this$googlePay_u24lambda_u241.googlePay = googlePay;
                return builder;
            }

            @NotNull
            public final Builder defaultBillingDetails(@Nullable PaymentSheet.BillingDetails defaultBillingDetails) {
                Builder builder;
                Builder $this$defaultBillingDetails_u24lambda_u242 = builder = this;
                boolean bl = false;
                $this$defaultBillingDetails_u24lambda_u242.defaultBillingDetails = defaultBillingDetails;
                return builder;
            }

            @NotNull
            public final Builder shippingDetails(@Nullable AddressDetails shippingDetails) {
                Builder builder;
                Builder $this$shippingDetails_u24lambda_u243 = builder = this;
                boolean bl = false;
                $this$shippingDetails_u24lambda_u243.shippingDetails = shippingDetails;
                return builder;
            }

            @NotNull
            public final Builder allowsDelayedPaymentMethods(boolean allowsDelayedPaymentMethods) {
                Builder builder;
                Builder $this$allowsDelayedPaymentMethods_u24lambda_u244 = builder = this;
                boolean bl = false;
                $this$allowsDelayedPaymentMethods_u24lambda_u244.allowsDelayedPaymentMethods = allowsDelayedPaymentMethods;
                return builder;
            }

            @NotNull
            public final Builder allowsPaymentMethodsRequiringShippingAddress(boolean allowsPaymentMethodsRequiringShippingAddress) {
                Builder builder;
                Builder $this$allowsPaymentMethodsRequiringShippingAddress_u24lambda_u245 = builder = this;
                boolean bl = false;
                $this$allowsPaymentMethodsRequiringShippingAddress_u24lambda_u245.allowsPaymentMethodsRequiringShippingAddress = allowsPaymentMethodsRequiringShippingAddress;
                return builder;
            }

            @NotNull
            public final Builder appearance(@NotNull PaymentSheet.Appearance appearance) {
                Builder builder;
                Intrinsics.checkNotNullParameter((Object)appearance, (String)"appearance");
                Builder $this$appearance_u24lambda_u246 = builder = this;
                boolean bl = false;
                $this$appearance_u24lambda_u246.appearance = appearance;
                return builder;
            }

            @NotNull
            public final Builder primaryButtonLabel(@NotNull String primaryButtonLabel) {
                Builder builder;
                Intrinsics.checkNotNullParameter((Object)primaryButtonLabel, (String)"primaryButtonLabel");
                Builder $this$primaryButtonLabel_u24lambda_u247 = builder = this;
                boolean bl = false;
                $this$primaryButtonLabel_u24lambda_u247.primaryButtonLabel = primaryButtonLabel;
                return builder;
            }

            @NotNull
            public final Builder billingDetailsCollectionConfiguration(@NotNull PaymentSheet.BillingDetailsCollectionConfiguration billingDetailsCollectionConfiguration) {
                Builder builder;
                Intrinsics.checkNotNullParameter((Object)billingDetailsCollectionConfiguration, (String)"billingDetailsCollectionConfiguration");
                Builder $this$billingDetailsCollectionConfiguration_u24lambda_u248 = builder = this;
                boolean bl = false;
                $this$billingDetailsCollectionConfiguration_u24lambda_u248.billingDetailsCollectionConfiguration = billingDetailsCollectionConfiguration;
                return builder;
            }

            @NotNull
            public final Builder preferredNetworks(@NotNull List<? extends CardBrand> preferredNetworks) {
                Builder builder;
                Intrinsics.checkNotNullParameter(preferredNetworks, (String)"preferredNetworks");
                Builder $this$preferredNetworks_u24lambda_u249 = builder = this;
                boolean bl = false;
                $this$preferredNetworks_u24lambda_u249.preferredNetworks = preferredNetworks;
                return builder;
            }

            @ExperimentalAllowsRemovalOfLastSavedPaymentMethodApi
            @NotNull
            public final Builder allowsRemovalOfLastSavedPaymentMethod(boolean allowsRemovalOfLastSavedPaymentMethod) {
                Builder builder;
                Builder $this$allowsRemovalOfLastSavedPaymentMethod_u24lambda_u2410 = builder = this;
                boolean bl = false;
                $this$allowsRemovalOfLastSavedPaymentMethod_u24lambda_u2410.allowsRemovalOfLastSavedPaymentMethod = allowsRemovalOfLastSavedPaymentMethod;
                return builder;
            }

            @NotNull
            public final Builder paymentMethodOrder(@NotNull List<String> paymentMethodOrder) {
                Builder builder;
                Intrinsics.checkNotNullParameter(paymentMethodOrder, (String)"paymentMethodOrder");
                Builder $this$paymentMethodOrder_u24lambda_u2411 = builder = this;
                boolean bl = false;
                $this$paymentMethodOrder_u24lambda_u2411.paymentMethodOrder = paymentMethodOrder;
                return builder;
            }

            @NotNull
            public final Builder externalPaymentMethods(@NotNull List<String> externalPaymentMethods) {
                Builder builder;
                Intrinsics.checkNotNullParameter(externalPaymentMethods, (String)"externalPaymentMethods");
                Builder $this$externalPaymentMethods_u24lambda_u2412 = builder = this;
                boolean bl = false;
                $this$externalPaymentMethods_u24lambda_u2412.externalPaymentMethods = externalPaymentMethods;
                return builder;
            }

            @NotNull
            public final Builder cardBrandAcceptance(@NotNull PaymentSheet.CardBrandAcceptance cardBrandAcceptance) {
                Builder builder;
                Intrinsics.checkNotNullParameter((Object)cardBrandAcceptance, (String)"cardBrandAcceptance");
                Builder $this$cardBrandAcceptance_u24lambda_u2413 = builder = this;
                boolean bl = false;
                $this$cardBrandAcceptance_u24lambda_u2413.cardBrandAcceptance = cardBrandAcceptance;
                return builder;
            }

            @ExperimentalCustomPaymentMethodsApi
            @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
            @NotNull
            public final Builder customPaymentMethods(@NotNull List<PaymentSheet.CustomPaymentMethod> customPaymentMethods) {
                Builder builder;
                Intrinsics.checkNotNullParameter(customPaymentMethods, (String)"customPaymentMethods");
                Builder $this$customPaymentMethods_u24lambda_u2414 = builder = this;
                boolean bl = false;
                $this$customPaymentMethods_u24lambda_u2414.customPaymentMethods = customPaymentMethods;
                return builder;
            }

            @NotNull
            public final Builder embeddedViewDisplaysMandateText(boolean embeddedViewDisplaysMandateText) {
                Builder builder;
                Builder $this$embeddedViewDisplaysMandateText_u24lambda_u2415 = builder = this;
                boolean bl = false;
                $this$embeddedViewDisplaysMandateText_u24lambda_u2415.embeddedViewDisplaysMandateText = embeddedViewDisplaysMandateText;
                return builder;
            }

            @NotNull
            public final Builder link(@NotNull PaymentSheet.LinkConfiguration link) {
                Builder builder;
                Intrinsics.checkNotNullParameter((Object)link, (String)"link");
                Builder $this$link_u24lambda_u2416 = builder = this;
                boolean bl = false;
                $this$link_u24lambda_u2416.link = link;
                return builder;
            }

            @NotNull
            public final Configuration build() {
                return new Configuration(this.merchantDisplayName, this.customer, this.googlePay, this.defaultBillingDetails, this.shippingDetails, this.allowsDelayedPaymentMethods, this.allowsPaymentMethodsRequiringShippingAddress, this.appearance, this.primaryButtonLabel, this.billingDetailsCollectionConfiguration, this.preferredNetworks, this.allowsRemovalOfLastSavedPaymentMethod, this.paymentMethodOrder, this.externalPaymentMethods, this.cardBrandAcceptance, this.customPaymentMethods, this.embeddedViewDisplaysMandateText, this.link);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bw\u0018\u00002\u00020\u0001:\u0002\u0002\u0003\u0082\u0001\u0002\u0004\u0005\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/paymentelement/EmbeddedPaymentElement$ConfigureResult;", "", "Succeeded", "Failed", "Lcom/stripe/android/paymentelement/EmbeddedPaymentElement$ConfigureResult$Failed;", "Lcom/stripe/android/paymentelement/EmbeddedPaymentElement$ConfigureResult$Succeeded;", "paymentsheet_release"})
    @ExperimentalEmbeddedPaymentElementApi
    public static interface ConfigureResult {

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/stripe/android/paymentelement/EmbeddedPaymentElement$ConfigureResult$Failed;", "Lcom/stripe/android/paymentelement/EmbeddedPaymentElement$ConfigureResult;", "error", "", "<init>", "(Ljava/lang/Throwable;)V", "getError", "()Ljava/lang/Throwable;", "paymentsheet_release"})
        @ExperimentalEmbeddedPaymentElementApi
        @StabilityInferred(parameters=0)
        public static final class Failed
        implements ConfigureResult {
            @NotNull
            private final Throwable error;
            public static final int $stable = 8;

            public Failed(@NotNull Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                this.error = error;
            }

            @NotNull
            public final Throwable getError() {
                return this.error;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Failed)) {
                    return false;
                }
                Failed failed = (Failed)other;
                return Intrinsics.areEqual((Object)this.error, (Object)failed.error);
            }

            public int hashCode() {
                return this.error.hashCode();
            }

            @NotNull
            public String toString() {
                return "Failed(error=" + this.error + ")";
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/stripe/android/paymentelement/EmbeddedPaymentElement$ConfigureResult$Succeeded;", "Lcom/stripe/android/paymentelement/EmbeddedPaymentElement$ConfigureResult;", "<init>", "()V", "paymentsheet_release"})
        @ExperimentalEmbeddedPaymentElementApi
        @StabilityInferred(parameters=1)
        public static final class Succeeded
        implements ConfigureResult {
            public static final int $stable;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001BK\b\u0000\u0012\u001c\u0010\u0002\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eR&\u0010\u0002\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0011R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0017\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001c\u001a\u00020\u001d8G\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006 "}, d2={"Lcom/stripe/android/paymentelement/EmbeddedPaymentElement$PaymentOptionDisplayData;", "", "imageLoader", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "Landroid/graphics/drawable/Drawable;", "label", "", "billingDetails", "Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetails;", "paymentMethodType", "mandateText", "Landroidx/compose/ui/text/AnnotatedString;", "<init>", "(Lkotlin/jvm/functions/Function1;Ljava/lang/String;Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetails;Ljava/lang/String;Landroidx/compose/ui/text/AnnotatedString;)V", "Lkotlin/jvm/functions/Function1;", "getLabel", "()Ljava/lang/String;", "getBillingDetails", "()Lcom/stripe/android/paymentsheet/PaymentSheet$BillingDetails;", "getPaymentMethodType", "getMandateText", "()Landroidx/compose/ui/text/AnnotatedString;", "iconDrawable", "getIconDrawable", "()Landroid/graphics/drawable/Drawable;", "iconDrawable$delegate", "Lkotlin/Lazy;", "iconPainter", "Landroidx/compose/ui/graphics/painter/Painter;", "getIconPainter", "(Landroidx/compose/runtime/Composer;I)Landroidx/compose/ui/graphics/painter/Painter;", "paymentsheet_release"})
    @ExperimentalEmbeddedPaymentElementApi
    @StabilityInferred(parameters=0)
    public static final class PaymentOptionDisplayData {
        @NotNull
        private final Function1<Continuation<? super Drawable>, Object> imageLoader;
        @NotNull
        private final String label;
        @Nullable
        private final PaymentSheet.BillingDetails billingDetails;
        @NotNull
        private final String paymentMethodType;
        @Nullable
        private final AnnotatedString mandateText;
        @NotNull
        private final Lazy iconDrawable$delegate;
        public static final int $stable = 8;

        public PaymentOptionDisplayData(@NotNull Function1<? super Continuation<? super Drawable>, ? extends Object> imageLoader, @NotNull String label, @Nullable PaymentSheet.BillingDetails billingDetails, @NotNull String paymentMethodType, @Nullable AnnotatedString mandateText) {
            Intrinsics.checkNotNullParameter(imageLoader, (String)"imageLoader");
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            Intrinsics.checkNotNullParameter((Object)paymentMethodType, (String)"paymentMethodType");
            this.imageLoader = imageLoader;
            this.label = label;
            this.billingDetails = billingDetails;
            this.paymentMethodType = paymentMethodType;
            this.mandateText = mandateText;
            this.iconDrawable$delegate = LazyKt.lazy(() -> PaymentOptionDisplayData.iconDrawable_delegate$lambda$0(this));
        }

        @NotNull
        public final String getLabel() {
            return this.label;
        }

        @Nullable
        public final PaymentSheet.BillingDetails getBillingDetails() {
            return this.billingDetails;
        }

        @NotNull
        public final String getPaymentMethodType() {
            return this.paymentMethodType;
        }

        @Nullable
        public final AnnotatedString getMandateText() {
            return this.mandateText;
        }

        private final Drawable getIconDrawable() {
            Lazy lazy = this.iconDrawable$delegate;
            return (Drawable)lazy.getValue();
        }

        @Composable
        @JvmName(name="getIconPainter")
        @NotNull
        public final Painter getIconPainter(@Nullable Composer $composer, int $changed) {
            $composer.startReplaceGroup(1668080996);
            if (ComposerKt.isTraceInProgress()) {
                ComposerKt.traceEventStart((int)1668080996, (int)$changed, (int)-1, (String)"com.stripe.android.paymentelement.EmbeddedPaymentElement.PaymentOptionDisplayData.<get-iconPainter> (EmbeddedPaymentElement.kt:480)");
            }
            Painter painter = DrawablePainterKt.rememberDrawablePainter((Drawable)this.getIconDrawable(), (Composer)$composer, (int)0);
            if (ComposerKt.isTraceInProgress()) {
                ComposerKt.traceEventEnd();
            }
            $composer.endReplaceGroup();
            return painter;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PaymentOptionDisplayData)) {
                return false;
            }
            PaymentOptionDisplayData paymentOptionDisplayData = (PaymentOptionDisplayData)other;
            if (!Intrinsics.areEqual(this.imageLoader, paymentOptionDisplayData.imageLoader)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.label, (Object)paymentOptionDisplayData.label)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.billingDetails, (Object)paymentOptionDisplayData.billingDetails)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.paymentMethodType, (Object)paymentOptionDisplayData.paymentMethodType)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.mandateText, (Object)paymentOptionDisplayData.mandateText);
        }

        public int hashCode() {
            int result2 = this.imageLoader.hashCode();
            result2 = result2 * 31 + this.label.hashCode();
            result2 = result2 * 31 + (this.billingDetails == null ? 0 : this.billingDetails.hashCode());
            result2 = result2 * 31 + this.paymentMethodType.hashCode();
            result2 = result2 * 31 + (this.mandateText == null ? 0 : this.mandateText.hashCode());
            return result2;
        }

        @NotNull
        public String toString() {
            return "PaymentOptionDisplayData(imageLoader=" + this.imageLoader + ", label=" + this.label + ", billingDetails=" + this.billingDetails + ", paymentMethodType=" + this.paymentMethodType + ", mandateText=" + this.mandateText + ")";
        }

        private static final DelegateDrawable iconDrawable_delegate$lambda$0(PaymentOptionDisplayData this$0) {
            return new DelegateDrawable(this$0.imageLoader);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bw\u0018\u00002\u00020\u0001:\u0003\u0002\u0003\u0004\u0082\u0001\u0003\u0005\u0006\u0007\u00a8\u0006\b"}, d2={"Lcom/stripe/android/paymentelement/EmbeddedPaymentElement$Result;", "", "Completed", "Canceled", "Failed", "Lcom/stripe/android/paymentelement/EmbeddedPaymentElement$Result$Canceled;", "Lcom/stripe/android/paymentelement/EmbeddedPaymentElement$Result$Completed;", "Lcom/stripe/android/paymentelement/EmbeddedPaymentElement$Result$Failed;", "paymentsheet_release"})
    @ExperimentalEmbeddedPaymentElementApi
    public static interface Result {

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/stripe/android/paymentelement/EmbeddedPaymentElement$Result$Canceled;", "Lcom/stripe/android/paymentelement/EmbeddedPaymentElement$Result;", "<init>", "()V", "paymentsheet_release"})
        @ExperimentalEmbeddedPaymentElementApi
        @StabilityInferred(parameters=1)
        public static final class Canceled
        implements Result {
            public static final int $stable;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lcom/stripe/android/paymentelement/EmbeddedPaymentElement$Result$Completed;", "Lcom/stripe/android/paymentelement/EmbeddedPaymentElement$Result;", "<init>", "()V", "paymentsheet_release"})
        @ExperimentalEmbeddedPaymentElementApi
        @StabilityInferred(parameters=1)
        public static final class Completed
        implements Result {
            public static final int $stable;
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/stripe/android/paymentelement/EmbeddedPaymentElement$Result$Failed;", "Lcom/stripe/android/paymentelement/EmbeddedPaymentElement$Result;", "error", "", "<init>", "(Ljava/lang/Throwable;)V", "getError", "()Ljava/lang/Throwable;", "paymentsheet_release"})
        @ExperimentalEmbeddedPaymentElementApi
        @StabilityInferred(parameters=0)
        public static final class Failed
        implements Result {
            @NotNull
            private final Throwable error;
            public static final int $stable = 8;

            public Failed(@NotNull Throwable error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                this.error = error;
            }

            @NotNull
            public final Throwable getError() {
                return this.error;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Failed)) {
                    return false;
                }
                Failed failed = (Failed)other;
                return Intrinsics.areEqual((Object)this.error, (Object)failed.error);
            }

            public int hashCode() {
                return this.error.hashCode();
            }

            @NotNull
            public String toString() {
                return "Failed(error=" + this.error + ")";
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e7\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/stripe/android/paymentelement/EmbeddedPaymentElement$ResultCallback;", "", "onResult", "", "result", "Lcom/stripe/android/paymentelement/EmbeddedPaymentElement$Result;", "paymentsheet_release"})
    @ExperimentalEmbeddedPaymentElementApi
    public static interface ResultCallback {
        public void onResult(@NotNull Result var1);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u001b\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lcom/stripe/android/paymentelement/EmbeddedPaymentElement$State;", "Landroid/os/Parcelable;", "confirmationState", "Lcom/stripe/android/paymentelement/embedded/content/EmbeddedConfirmationStateHolder$State;", "customer", "Lcom/stripe/android/paymentsheet/state/CustomerState;", "<init>", "(Lcom/stripe/android/paymentelement/embedded/content/EmbeddedConfirmationStateHolder$State;Lcom/stripe/android/paymentsheet/state/CustomerState;)V", "getConfirmationState$paymentsheet_release", "()Lcom/stripe/android/paymentelement/embedded/content/EmbeddedConfirmationStateHolder$State;", "getCustomer$paymentsheet_release", "()Lcom/stripe/android/paymentsheet/state/CustomerState;", "describeContents", "", "writeToParcel", "", "dest", "Landroid/os/Parcel;", "flags", "paymentsheet_release"})
    @ExperimentalEmbeddedPaymentElementApi
    @Parcelize
    @StabilityInferred(parameters=0)
    public static final class State
    implements Parcelable {
        @NotNull
        private final EmbeddedConfirmationStateHolder.State confirmationState;
        @Nullable
        private final CustomerState customer;
        @NotNull
        public static final Parcelable.Creator<State> CREATOR;
        public static final int $stable;

        public State(@NotNull EmbeddedConfirmationStateHolder.State confirmationState, @Nullable CustomerState customer2) {
            Intrinsics.checkNotNullParameter((Object)confirmationState, (String)"confirmationState");
            this.confirmationState = confirmationState;
            this.customer = customer2;
        }

        @NotNull
        public final EmbeddedConfirmationStateHolder.State getConfirmationState$paymentsheet_release() {
            return this.confirmationState;
        }

        @Nullable
        public final CustomerState getCustomer$paymentsheet_release() {
            return this.customer;
        }

        public final void writeToParcel(@NotNull Parcel dest, int flags) {
            Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
            this.confirmationState.writeToParcel(dest, flags);
            CustomerState customerState = this.customer;
            if (customerState == null) {
                dest.writeInt(0);
            } else {
                dest.writeInt(1);
                customerState.writeToParcel(dest, flags);
            }
        }

        public final int describeContents() {
            return 0;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof State)) {
                return false;
            }
            State state2 = (State)other;
            if (!Intrinsics.areEqual((Object)this.confirmationState, (Object)state2.confirmationState)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.customer, (Object)state2.customer);
        }

        public int hashCode() {
            int result2 = this.confirmationState.hashCode();
            result2 = result2 * 31 + (this.customer == null ? 0 : this.customer.hashCode());
            return result2;
        }

        @NotNull
        public String toString() {
            return "State(confirmationState=" + this.confirmationState + ", customer=" + this.customer + ")";
        }

        static {
            @Metadata(mv={2, 1, 0}, k=3, xi=48)
            public final class Creator
            implements Parcelable.Creator<State> {
                public final State[] newArray(int size) {
                    return new State[size];
                }

                public final State createFromParcel(Parcel parcel) {
                    Intrinsics.checkNotNullParameter((Object)parcel, (String)"parcel");
                    return new State((EmbeddedConfirmationStateHolder.State)EmbeddedConfirmationStateHolder.State.CREATOR.createFromParcel(parcel), (CustomerState)(parcel.readInt() == 0 ? null : CustomerState.CREATOR.createFromParcel(parcel)));
                }
            }
            CREATOR = new Creator();
            $stable = 8;
        }
    }
}

